/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.techdev.ant.util;

import com.sap.tc.logging.Location;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;

public class AntLogger
implements BuildLogger {
    Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$techdev$ant$util$AntLogger == null ? (class$com$sap$tc$buildplugin$techdev$ant$util$AntLogger = AntLogger.class$("com.sap.tc.buildplugin.techdev.ant.util.AntLogger")) : class$com$sap$tc$buildplugin$techdev$ant$util$AntLogger));
    private static int LEFT_COLUMN_SIZE = 12;
    private PrintStream outOri = System.out;
    private PrintStream errOri = System.err;
    private String logFile;
    private String pluginVersion;
    protected PrintStream out;
    protected int msgOutputLevel = 0;
    private long startTime;
    private String tDir;
    protected static String lSep = System.getProperty("line.separator");
    protected boolean emacsMode = false;
    static /* synthetic */ Class class$com$sap$tc$buildplugin$techdev$ant$util$AntLogger;

    public void init() {
        try {
            this.out = new PrintStream(new FileOutputStream(this.logFile, true));
            System.setOut(this.out);
            System.setErr(this.out);
        }
        catch (IOException ioe) {
            String msg = "Error: Cannot write on the log file. " + this.logFile + "Make sure the path exists and you have write permissions.";
            this.loc.traceThrowableT(500, msg, (Throwable)ioe);
        }
    }

    public void exit() {
        this.out.flush();
        this.out.close();
        System.setOut(this.outOri);
        System.setErr(this.errOri);
    }

    public void setLog(String file) {
        this.logFile = file;
    }

    public void setTDir(String name) {
        this.tDir = name;
    }

    public PrintStream getStream() {
        return this.out;
    }

    public void setMessageOutputLevel(int level) {
        this.msgOutputLevel = level;
    }

    public void setOutputPrintStream(PrintStream output) {
        this.out = output;
    }

    public void setErrorPrintStream(PrintStream err) {
    }

    public void setEmacsMode(boolean emacsMode) {
        this.emacsMode = emacsMode;
    }

    public void buildStarted(BuildEvent event) {
        this.startTime = System.currentTimeMillis();
        this.out.println(this.pluginVersion);
        this.out.println(lSep + "Start: " + this.getTime());
        this.out.println();
        if (this.tDir.length() > 0) {
            this.out.println("Temp dir: " + this.tDir);
        }
    }

    public void buildFinished(BuildEvent event) {
        Throwable error = event.getException();
        if (error == null) {
            this.out.println(lSep + "Build ok");
        } else {
            this.out.println(lSep + "Build with ERRORS" + lSep);
            if (3 <= this.msgOutputLevel || !(error instanceof BuildException)) {
                error.printStackTrace(this.out);
            } else if (error instanceof BuildException) {
                this.out.println(error.toString());
            } else {
                this.out.println(error.getMessage());
            }
        }
        this.out.println(lSep + "End: " + this.getTime() + " (Duration: " + AntLogger.formatTime(System.currentTimeMillis() - this.startTime) + ")");
    }

    public void targetStarted(BuildEvent event) {
        if (2 <= this.msgOutputLevel) {
            this.out.println(lSep + event.getTarget().getName() + ":");
        }
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
        if (event.getPriority() <= this.msgOutputLevel) {
            if (event.getTask() != null) {
                String name = event.getTask().getTaskName();
                String msg = "[" + name + "] ";
                int i = 0;
                while (i < LEFT_COLUMN_SIZE - msg.length()) {
                    this.out.print(" ");
                    ++i;
                }
                this.out.print(msg);
            }
            this.out.println(event.getMessage());
        }
    }

    protected static String formatTime(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        if (minutes > 0L) {
            return Long.toString(minutes) + " minute" + (minutes == 1L ? " " : "s ") + Long.toString(seconds % 60L) + " second" + (seconds % 60L == 1L ? "" : "s");
        }
        return Long.toString(seconds) + " second" + (seconds % 60L == 1L ? "" : "s");
    }

    private String getTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
        Date curTime = new Date();
        return sdf.format(curTime);
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

