/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.pputil;

import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildplugin.pputil.EntityData;
import com.sap.tc.buildplugin.pputil.EntityRefData;
import com.sap.tc.buildplugin.pputil.PPData;
import com.sap.tc.buildtool.BuildResult;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.EntityReference;
import com.sap.tc.complib.FileSet;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PPCollector {
    private final Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$pputil$PPCollector == null ? (class$com$sap$tc$buildplugin$pputil$PPCollector = PPCollector.class$("com.sap.tc.buildplugin.pputil.PPCollector")) : class$com$sap$tc$buildplugin$pputil$PPCollector));
    private final List m_ppDataList = new ArrayList();
    private int m_br;
    private String m_errMsg = "";
    private final IDevelopmentComponentInfo m_devCompInfo;
    static /* synthetic */ Class class$com$sap$tc$buildplugin$pputil$PPCollector;

    public PPCollector(IDevelopmentComponentInfo devCompInfo) {
        this.m_devCompInfo = devCompInfo;
    }

    public int addData(Map ppMap) {
        Iterator it = ppMap.keySet().iterator();
        while (it.hasNext()) {
            PublicPart ppart = (PublicPart)ppMap.get(it.next());
            this.addEntry(ppart);
        }
        return this.m_br;
    }

    public List getList() {
        return this.m_ppDataList;
    }

    private void addEntry(PublicPart ppart) {
        PPData ppData = new PPData();
        ppData.setName(ppart.getName());
        ppData.setPurpose(ppart.getPurpose().toString());
        ArrayList<EntityData> entityDataList = new ArrayList<EntityData>();
        List entityList = ppart.getEntities();
        if (entityList != null) {
            Iterator it = entityList.iterator();
            while (it.hasNext()) {
                String packageName;
                Entity entity = (Entity)it.next();
                String name = entity.getName();
                String packageDir = packageName = entity.getPackageName();
                String entityType = entity.getType();
                String entitySubType = entity.getSubType();
                if (!(entitySubType != null || entityType.equalsIgnoreCase("WAR") || entityType.equalsIgnoreCase("EJB-JAR") || entityType.equalsIgnoreCase("EJB-Client-JAR") || entityType.equalsIgnoreCase("SERVER_COMPONENTS") || entityType.equalsIgnoreCase("File") || entityType.equalsIgnoreCase("Folder") || entityType.equalsIgnoreCase("Folder Tree") || entityType.equalsIgnoreCase("Absolute File") || entityType.equalsIgnoreCase("Absolute Folder") || entityType.equalsIgnoreCase("Absolute Folder Tree") || entityType.equalsIgnoreCase("Portal API") || entityType.equalsIgnoreCase("PAR"))) {
                    String errMsg = "subtype of entity '" + name + "' is not specified";
                    this.loc.infoT(errMsg);
                    this.setErrorMsg(errMsg);
                    this.m_br = new BuildResult(2).getResultCode();
                    return;
                }
                EntityData entityData = new EntityData();
                FileSet fileSet = entity.getFileSet();
                if (fileSet != null) {
                    entityData.setExcludes(fileSet.getExcludes());
                    entityData.setIncludes(fileSet.getIncludes());
                }
                entityData.setEntityName(name);
                entityData.setEntityType(entityType);
                entityData.setEntitySubType(entitySubType);
                if (packageName != null) {
                    entityData.setPackageName(packageName);
                    entityData.setPackageDir(packageDir.replace('.', File.separatorChar));
                } else {
                    entityData.setPackageName("");
                    entityData.setPackageDir("");
                }
                entityDataList.add(entityData);
            }
        }
        List importedEntityList = ppart.getImportedEntities();
        ArrayList<EntityRefData> entityRefDataList = new ArrayList<EntityRefData>();
        HashMap<String, EntityRefData> entityRefDataMap = new HashMap<String, EntityRefData>();
        if (importedEntityList != null) {
            Iterator it = importedEntityList.iterator();
            int no = 1;
            while (it.hasNext()) {
                EntityReference entityRef = (EntityReference)it.next();
                String refDCName = entityRef.getComponent().getName().replace('/', '~');
                String refPPName = entityRef.getPublicPart();
                String refEntName = entityRef.getName();
                String refEntType = entityRef.getType();
                String refEntSubType = "";
                String refEntPackageName = "";
                try {
                    refEntSubType = entityRef.getSubType();
                    refEntPackageName = entityRef.getPackageName();
                }
                catch (NoSuchMethodError nsm) {
                    this.loc.infoT("Package name and SubType don't exist - old pp schema");
                }
                PPReference ppRef = new PPReference(entityRef.getPublicPart(), entityRef.getComponent());
                String ppDir = this.m_devCompInfo.getUsedPublicPartGenFolder(ppRef);
                String entRefPurpose = this.m_devCompInfo.getUsedPublicPartPurpose(ppRef).toString();
                String ppPurpose = ppart.getPurpose().toString();
                if (ppPurpose.equalsIgnoreCase(entRefPurpose)) {
                    EntityRefData entityRefData = new EntityRefData();
                    entityRefData.setRefDCName(refDCName);
                    entityRefData.setRefPPName(refPPName);
                    if (refEntName != null && refEntType != null) {
                        entityRefData.setRefEntName(refEntName);
                        entityRefData.setRefEntType(refEntType);
                    } else {
                        entityRefData.setRefEntName("");
                        entityRefData.setRefEntType("");
                    }
                    if (refEntSubType != null) {
                        entityRefData.setRefEntSubType(refEntSubType);
                    } else {
                        refEntSubType = "";
                        entityRefData.setRefEntSubType("");
                    }
                    if (refEntPackageName != null) {
                        entityRefData.setRefEntPackageName(refEntPackageName);
                    } else {
                        refEntPackageName = "";
                        entityRefData.setRefEntPackageName("");
                    }
                    entityRefDataList.add(entityRefData);
                    entityRefData.setRefPPDir(ppDir);
                    entityRefDataMap.put(ppDir + "_" + no, entityRefData);
                } else {
                    this.loc.infoT("the purpose of the referenced public part don't match");
                }
                ++no;
            }
        }
        ppData.setEntityList(entityDataList);
        ppData.setEntityRefList(entityRefDataList);
        ppData.setEntityRefMap(entityRefDataMap);
        this.m_ppDataList.add(ppData);
    }

    public ArrayList getEntityData(String entityType, String entitySubType) {
        Iterator itPP = this.m_ppDataList.iterator();
        ArrayList<PPData> retList = new ArrayList<PPData>();
        while (itPP.hasNext()) {
            PPData ppData = (PPData)itPP.next();
            Iterator itEnt = ((AbstractList)ppData.getEntityList()).iterator();
            ArrayList<EntityData> entList = new ArrayList<EntityData>();
            while (itEnt.hasNext()) {
                EntityData ed = (EntityData)itEnt.next();
                String type = ed.getEntityType();
                String subType = ed.getEntitySubType();
                if (!type.equalsIgnoreCase(entityType) || !subType.equalsIgnoreCase(entitySubType)) continue;
                entList.add(ed);
            }
            if (entList.isEmpty()) continue;
            PPData retPPData = new PPData();
            retPPData.setEntityList(entList);
            retPPData.setName(ppData.getName());
            retList.add(retPPData);
        }
        return retList;
    }

    public String getErrorMsg() {
        return this.m_errMsg;
    }

    private void setErrorMsg(String errMsg) {
        this.m_errMsg = errMsg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

