/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.pputil;

import com.sap.tc.buildtool.BuildToolException;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.logging.Location;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class CreateEntityXML {
    static final String SAP_BUILDER = "com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl";
    static final String SAP_TRANSFORMER = "com.sap.engine.lib.jaxp.TransformerFactoryImpl";
    static final String ELEMENT_PUBLICPARTS = "public-parts";
    static final String ELEMENT_PUBLICPART = "public-part";
    static final String ELEMENT_PUBLICPART_NAME = "name";
    static final String ELEMENT_PUBLICPART_PURPOSE = "purpose";
    static final String ELEMENT_PUBLICPART_ENTITIES = "entities";
    static final String ELEMENT_ENTITY = "entity";
    static final String ELEMENT_ENTITY_NAME = "name";
    static final String ELEMENT_ENTITY_PACKAGE = "package";
    static final String ELEMENT_ENTITY_TYPE = "entity-type";
    static final String ELEMENT_ENTITY_SUB_TYPE = "entity-sub-type";
    static final String[] RELEVANT_ENTITY_TYPES = new String[]{"Web Dynpro Component", "Dictionary Simple Type", "Common Model", "Web Dynpro Component Interface Definition", "Dictionary Structure"};
    private Map myMap;
    private String filePath;
    private static Location loc = Location.getLocation((String)(class$com$sap$tc$buildplugin$pputil$CreateEntityXML == null ? (class$com$sap$tc$buildplugin$pputil$CreateEntityXML = CreateEntityXML.class$("com.sap.tc.buildplugin.pputil.CreateEntityXML")) : class$com$sap$tc$buildplugin$pputil$CreateEntityXML).getName());
    static /* synthetic */ Class class$com$sap$tc$buildplugin$pputil$CreateEntityXML;

    public CreateEntityXML(Map PPMap, String filePath) {
        this.myMap = PPMap;
        this.filePath = filePath;
    }

    public void saveAsXML() throws BuildToolException {
        String thisMethod = "saveAsXML";
        Document doc = CreateEntityXML.createDOMDocument();
        Element rootElem = doc.createElement(ELEMENT_PUBLICPARTS);
        doc.appendChild(rootElem);
        if (this.myMap != null) {
            Iterator iter = this.myMap.values().iterator();
            while (iter.hasNext()) {
                PublicPart ppart = (PublicPart)iter.next();
                if (loc.beDebug()) {
                    String msg = "processing \n    public part :" + ppart.getName();
                    loc.infoT(thisMethod, msg);
                }
                Element ppElem = doc.createElement(ELEMENT_PUBLICPART);
                rootElem.appendChild(ppElem);
                Element ppName = doc.createElement("name");
                Text ppPartName = doc.createTextNode(ppart.getName());
                ppName.appendChild(ppPartName);
                ppElem.appendChild(ppName);
                Element ppPurpose = doc.createElement(ELEMENT_PUBLICPART_PURPOSE);
                ppElem.appendChild(ppPurpose);
                Text ppPartPurpose = doc.createTextNode(ppart.getPurpose().toString());
                ppPurpose.appendChild(ppPartPurpose);
                Element entitiesElem = doc.createElement(ELEMENT_PUBLICPART_ENTITIES);
                ppElem.appendChild(entitiesElem);
                this.saveEntities(doc, entitiesElem, ppart.getEntities());
            }
        }
        if (loc.beDebug()) {
            String msg = "saving to \n    filePath   \t\t\t  :" + this.filePath;
            loc.infoT(thisMethod, msg);
        }
        FileOutputStream fo = null;
        try {
            fo = new FileOutputStream(this.filePath);
        }
        catch (FileNotFoundException fe) {
            loc.throwing((Throwable)fe);
            throw new BuildToolException(fe.getMessage());
        }
        CreateEntityXML.DomSerialize(doc, fo);
    }

    private void saveEntities(Document doc, Element entitiesElem, List entities) {
        if (entities == null) {
            return;
        }
        Iterator iterEntities = entities.iterator();
        String thisMethod = "saveEntities";
        while (iterEntities.hasNext()) {
            Entity ent = (Entity)iterEntities.next();
            if (loc.beDebug()) {
                String msg = "processing \n    entityPackage :" + (ent.getPackageName() == null ? "null" : ent.getPackageName()) + "\n    entityType    :" + (ent.getType() == null ? "null" : ent.getType());
                loc.infoT("saveEntities", msg);
            }
            Element entityElement = doc.createElement(ELEMENT_ENTITY);
            entitiesElem.appendChild(entityElement);
            Element entityName = doc.createElement("name");
            entityElement.appendChild(entityName);
            Element entityPackage = doc.createElement(ELEMENT_ENTITY_PACKAGE);
            entityElement.appendChild(entityPackage);
            Element entityType = doc.createElement(ELEMENT_ENTITY_TYPE);
            entityElement.appendChild(entityType);
            Element entitySubType = doc.createElement(ELEMENT_ENTITY_SUB_TYPE);
            entityElement.appendChild(entitySubType);
            if (ent.getName() != null) {
                Text entName = doc.createTextNode(ent.getName());
                entityName.appendChild(entName);
            }
            if (ent.getPackageName() != null) {
                Text packageText = doc.createTextNode(ent.getPackageName());
                entityPackage.appendChild(packageText);
            }
            if (ent.getType() != null) {
                Text typeText = doc.createTextNode(ent.getType());
                entityType.appendChild(typeText);
            }
            if (ent.getSubType() == null) continue;
            Text subTypeText = doc.createTextNode(ent.getSubType());
            entitySubType.appendChild(subTypeText);
        }
    }

    private boolean isRelevant(String entityType) {
        int i = 0;
        while (i < RELEVANT_ENTITY_TYPES.length) {
            if (entityType.equals(RELEVANT_ENTITY_TYPES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Document createDOMDocument() throws BuildToolException {
        String method = "createDOMDocument";
        try {
            DocumentBuilderFactory fact = null;
            DocumentBuilder builder = null;
            try {
                loc.infoT("createDOMDocument", "trying com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl");
                fact = (DocumentBuilderFactory)Class.forName(SAP_BUILDER).newInstance();
            }
            catch (Exception e1) {
                loc.throwing((Throwable)e1);
                throw new BuildToolException(e1.getMessage());
            }
            loc.infoT("createDOMDocument", "document builder factory class " + fact.getClass().getName());
            builder = fact.newDocumentBuilder();
            Document doc = builder.newDocument();
            return doc;
        }
        catch (ParserConfigurationException e) {
            loc.throwing((Throwable)e);
            throw new BuildToolException(e.getMessage());
        }
    }

    private static void DomSerialize(Document doc, OutputStream os) throws BuildToolException {
        String thisMethod = "DomSerialize";
        TransformerFactory tf = null;
        Transformer t = null;
        try {
            tf = (TransformerFactory)Class.forName(SAP_TRANSFORMER).newInstance();
        }
        catch (Throwable ttt) {
            loc.throwing(ttt);
            throw new BuildToolException(ttt.getMessage());
        }
        loc.infoT(thisMethod, "transformer factory class " + tf.getClass().getName());
        try {
            t = tf.newTransformer();
            t.setOutputProperty("indent", "true");
            t.transform(new DOMSource(doc), new StreamResult(os));
        }
        catch (Exception e) {
            loc.throwing((Throwable)e);
            throw new BuildToolException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

