/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin;

import com.sap.tc.buildplugin.AbstractBuildAction;
import com.sap.tc.buildplugin.PluginBuildInfo;
import com.sap.tc.buildplugin.api.BuildActionResult;
import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildplugin.pputil.PPCollector;
import com.sap.tc.buildplugin.techdev.ant.util.DirsAndFiles;
import com.sap.tc.buildplugin.techdev.ant.util.FileCreator;
import com.sap.tc.buildplugin.util.ComponentDependencies;
import com.sap.tc.buildplugin.util.JlinUtils;
import com.sap.tc.buildtool.LogFile;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.PublicPart;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public abstract class AbstractVeloBuildFileAction
extends AbstractBuildAction {
    private BuildActionResult result;
    private FileCreator fCreator;
    private DirsAndFiles daf;
    private int buildResult = 0;
    private String errMsg = "";
    private int currentStep;
    private IBuildInfo buildInfo;
    private PluginBuildInfo pbi;

    protected AbstractVeloBuildFileAction(PluginBuildInfo pbi, int step) {
        this.pbi = pbi;
        this.fCreator = pbi.getFileCreator();
        this.daf = this.fCreator.getDaf();
        this.currentStep = step;
        this.buildInfo = pbi.getBuildInfo();
        this.result = new BuildActionResult();
    }

    public PluginBuildInfo getPluginBuildInfo() {
        return this.pbi;
    }

    protected final void setBuildResult(int buildResult) {
        if (buildResult > this.buildResult) {
            this.buildResult = buildResult;
        }
    }

    protected final void setErrorMessage(String message) {
        this.errMsg = this.errMsg == null || this.errMsg.length() == 0 ? message : this.errMsg + '\n' + message;
    }

    public final BuildActionResult getBuildActionResult() {
        return this.result;
    }

    public String getCaption() {
        return "generate build script";
    }

    public BuildActionResult execute() {
        String name = this.pbi.getBuildplugin().getName();
        this.getLocation().infoT("Plugin " + name + " starts creating the build file");
        this.setErrorMessage("Preparing Ant build...\n");
        try {
            this.prepareFileCreator();
            int assemblyDirCount = this.prepareAssemblyDirs();
            if (assemblyDirCount == 0) {
                this.handleNoAvailableAssemblyDirs();
            }
            this.createBuildFile();
        }
        catch (RuntimeException ex) {
            this.setErrorMessage("error: a runtime error occured in the build plugin; see trace log for details");
            this.getLocation().traceThrowableT(600, "a runtime error occured in the build plugin", (Throwable)ex);
            this.setBuildResult(2);
        }
        catch (Exception ex) {
            this.setBuildResult(2);
        }
        LogFile log = new LogFile();
        log.setErrorMessage(this.errMsg + "\n\n\n");
        log.writeLogFile(this.daf.getLogFile(), true);
        this.result.setBuildLogPath(this.daf.getLogFile());
        this.result.setBuildActionRC(this.buildResult);
        return this.result;
    }

    protected void handleNoAvailableAssemblyDirs() {
    }

    protected void prepareFileCreator() throws Exception {
        this.prepareBuildFiles();
        this.preparePrebuildDir();
        this.preparePublicParts();
        this.prepareDAFInfos();
        this.prepareSqlSupport();
        this.prepareJarSAP();
        this.prepareJLin();
    }

    protected final void prepareJarSAP() {
        this.fCreator.setStrContext("dc_jarSAP_location", this.daf.getCBSLocation());
        this.fCreator.setStrContext("dc_jarSAP_counter", this.daf.getCBSCounter());
        this.fCreator.setStrContext("dc_jarSAP_vendor", this.daf.getDCVendor());
        this.fCreator.setStrContext("dc_jarSAP_name", this.daf.getDCName());
        this.fCreator.setStrContext("dc_jarSAP_caption", this.daf.getDCCaption());
        IDevelopmentComponentInfo componentInfo = this.buildInfo.getDevelopmentComponentInfo();
        if (componentInfo != null) {
            Compartment comp = componentInfo.getCompartment();
            if (comp != null) {
                this.fCreator.setStrContext("dc_jarSAP_scvendor", comp.getScVendor());
                this.fCreator.setStrContext("dc_jarSAP_scname", comp.getScName());
            } else {
                this.setBuildResult(2);
                this.setErrorMessage("No Compartment available for " + this.daf.getDCName());
            }
        } else {
            this.setBuildResult(2);
            this.setErrorMessage("No componentInfo available for " + this.daf.getDCName());
        }
    }

    protected final void createBuildFile() throws Exception {
        if (this.buildResult != 2 && this.buildResult != 3) {
            this.fCreator.createBuildFile();
        } else {
            if (!this.daf.checkAssDependencies()) {
                this.setErrorMessage(this.daf.getErrorMsgAss());
                throw new Exception();
            }
            if (!this.daf.checkCompDependencies()) {
                this.setErrorMessage(this.daf.getErrorMsgCompile());
                throw new Exception();
            }
        }
    }

    protected final void prepareDAFInfos() {
        this.fCreator.setStrContext("dc_root_Dir", this.daf.getRootDir());
        this.fCreator.setListContext("dc_source_dirs", this.daf.getSourceDirs());
        this.fCreator.setListContext("dc_sourceDirs", this.daf.getSourceDirs());
        this.fCreator.setListContext("dc_packageDirs", this.daf.getPackageDirs());
        this.fCreator.setStrContext("dc_gen_classesDir", this.daf.getClassesDir());
        this.fCreator.setStrContext("dc_gen_publicDir", this.daf.getGenDirPublic());
        this.fCreator.setStrContext("dc_gen_public_dir", this.daf.getGenDirPublic());
        this.fCreator.setStrContext("dc_gen_variantDir", this.daf.getGenVariantDir());
        this.fCreator.setStrContext("dc_gen_tempDir", this.daf.getTempDir());
        this.fCreator.setStrContext("dc_gen_temp_dir", this.daf.getTempDir());
        this.fCreator.setStrContext("dc_gen_logDir", this.daf.getLogDir());
        this.fCreator.setStrContext("dc_type", this.daf.getDCType());
        this.fCreator.setStrContext("dc_subtype", this.daf.getDcSubtype());
        this.fCreator.setListContext("dc_properties", this.daf.getDCProperties());
        List dependDirs = this.daf.getDependDirs();
        HashMap<String, String> antPropsDependDirs = new HashMap<String, String>();
        ArrayList<String> antPropsDependJars = new ArrayList<String>();
        if (dependDirs != null) {
            Iterator it = dependDirs.iterator();
            int no = 0;
            while (it.hasNext()) {
                String dir = (String)it.next();
                antPropsDependDirs.put("dependDir_" + ++no, dir);
                File dirFile = new File(dir);
                if (!dirFile.exists()) continue;
                String[] allFilesInFolder = dirFile.list();
                int i = 0;
                while (i < allFilesInFolder.length) {
                    String curFileName = dir + File.separator + allFilesInFolder[i];
                    if (curFileName.endsWith(".jar") || curFileName.endsWith(".zip")) {
                        antPropsDependJars.add(curFileName);
                    }
                    ++i;
                }
            }
        }
        this.fCreator.setHashMapContext("dc_depend_compileDirs", antPropsDependDirs);
        this.fCreator.setHashMapContext("dc_depend_compile_dirs", antPropsDependDirs);
        this.fCreator.setListContext("dc_depend_compileArchives", antPropsDependJars);
        this.fCreator.setListContext("dc_depend_compilePPs", this.daf.getCompilationDirs());
        this.fCreator.setStrContext("dc_deployDir", this.daf.getGenDirDeploy());
        this.fCreator.setStrContext("dc_deploy_Dir", this.daf.getGenDirDeploy());
        this.fCreator.setStrContext("dc_deploy_dir", this.daf.getGenDirDeploy());
        this.fCreator.setStrContext("dc_deployFile", this.daf.getDcFile());
        this.fCreator.setStrContext("dc_deploy_File", this.daf.getDcFile());
        this.fCreator.setStrContext("dc_deploy_file", this.daf.getGenDirDeploy());
        this.fCreator.setHashMapContext("dc_build_options", this.daf.getBuildOptions());
        try {
            this.fCreator.setStrContext("compiler_executable_path", this.buildInfo.getCompilerExecutable());
        }
        catch (NoSuchMethodError ex) {
            String msg = "pluginhandler does not supply getCompilerExecutable";
            this.getLocation().traceThrowableT(300, msg, (Throwable)ex);
        }
    }

    protected final void prepareNativeLibs() {
        List assDep = this.daf.getAssemblyDirs();
        HashMap<String, String> nativeAssDep = new HashMap<String, String>();
        int i = 0;
        while (i < assDep.size()) {
            String currentDep = (String)assDep.get(i);
            File currAssDepNative = new File(currentDep + "lib" + File.separator + "native");
            if (currAssDepNative.exists()) {
                nativeAssDep.put(currentDep, "true");
            }
            ++i;
        }
        this.fCreator.setHashMapContext("dc_depend_assemblyNativeDirs", nativeAssDep);
    }

    protected final List getAllDependencies() {
        List compDep = this.daf.getDependencies();
        ArrayList<ComponentDependencies> allDep = new ArrayList<ComponentDependencies>();
        if (compDep != null) {
            Iterator it = compDep.iterator();
            while (it.hasNext()) {
                Dependency dep = (Dependency)it.next();
                DCReference component = dep.getComponent();
                String name = component.getName();
                String vendor = component.getVendor();
                ComponentType type = null;
                DevelopmentComponent dc = this.daf.getReferencedComponent(dep);
                if (dc != null) {
                    type = dc.getComponentType();
                }
                ComponentDependencies compdep = type == null ? new ComponentDependencies(name, vendor, dep.isAtDeployTime(), dep.isAtRunTime(), dep.getRuntimeQuialifier(), "", "", "") : new ComponentDependencies(name, vendor, dep.isAtDeployTime(), dep.isAtRunTime(), dep.getRuntimeQuialifier(), type.getVendor(), type.getType(), type.getSubType());
                compdep.setAtBuild(dep.isAtBuildTime());
                compdep.setBuildtimeQualifier(dep.getBuildTimeQualifier());
                compdep.setDeploytimeQualifier(dep.getDeployTimeQualifier());
                if (dc != null) {
                    PPReference ppRef = dep.getPublicPartDependency();
                    Map pps = dc.getPublicParts();
                    if (ppRef != null) {
                        String ppName = ppRef.getName();
                        PublicPart pp = (PublicPart)pps.get(ppName);
                        PublicPart.Purpose aPurpose = pp.getPurpose();
                        String rootPath = this.daf.getUsedPublicPartGenFolder(ppRef);
                        compdep.addPublicPart(ppName, aPurpose.toString(), rootPath);
                    } else if (pps != null) {
                        Iterator ppNames = pps.keySet().iterator();
                        while (ppNames.hasNext()) {
                            String ppName = (String)ppNames.next();
                            PublicPart pp = (PublicPart)pps.get(ppName);
                            PublicPart.Purpose aPurpose = pp.getPurpose();
                            ppRef = new PPReference(ppName, component);
                            String rootPath = this.daf.getUsedPublicPartGenFolder(ppRef);
                            compdep.addPublicPart(ppName, aPurpose.toString(), rootPath);
                        }
                    }
                }
                allDep.add(compdep);
            }
        }
        return allDep;
    }

    protected final void prepareSqlSupport() {
        this.fCreator.setHashMapContext("dc_jdo_files", this.daf.getJdoMap());
        if (this.daf.hasSQLJ()) {
            this.fCreator.setStrContext("sqlj_exist", "true");
        } else {
            this.fCreator.setStrContext("sqlj_exist", "false");
        }
    }

    protected final void prepareJLin() {
        JlinUtils jlinUtils = new JlinUtils(this.buildInfo);
        jlinUtils.insertJlinContext(this.fCreator);
    }

    protected final int prepareAssemblyDirs() {
        List assDep = this.daf.getAssemblyDirs();
        if (assDep != null) {
            this.fCreator.setListContext("dc_depend_assemblyDirs", assDep);
            this.fCreator.setListContext("dc_assembly_dirs", assDep);
            return assDep.size();
        }
        return 0;
    }

    protected final void preparePublicParts() {
        IDevelopmentComponentInfo componentInfo = this.buildInfo.getDevelopmentComponentInfo();
        Map ppMap = this.daf.getPublicParts();
        if (ppMap != null) {
            PPCollector pp = new PPCollector(componentInfo);
            this.setBuildResult(pp.addData(ppMap));
            this.setErrorMessage(pp.getErrorMsg());
            this.fCreator.setListContext("dc_public_parts", pp.getList());
        }
    }

    protected final void preparePrebuildDir() {
        String prebuildDir = this.daf.getTempDir() + File.separator + "pre";
        this.fCreator.setStrContext("dc_prebuild_Dir", prebuildDir);
        File prebuildDirF = new File(prebuildDir);
        if (prebuildDirF.exists()) {
            this.fCreator.setStrContext("dc_prebuild_Dir_exist", "true");
        }
    }

    protected final void prepareBuildFiles() {
        switch (this.currentStep) {
            case 1: {
                this.daf.setBuildFile("prebuild.xml");
                this.fCreator.setMacroName("prebuild.vm");
                break;
            }
            case 3: {
                this.daf.setBuildFile("postbuild.xml");
                this.fCreator.setMacroName("postbuild.vm");
                break;
            }
            default: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void createManifestFile() throws Exception {
        String DEST_FILE = "MANIFEST.MF";
        try {
            File manifestFile;
            block16: {
                Attributes mainAttributes;
                Manifest manifest = new Manifest();
                String CUSTOM_FILE_NAME = "MANIFEST.MF";
                File cfgDir = new File(this.daf.getRootDir(), "cfg");
                File customManifestFile = new File(cfgDir, "MANIFEST.MF");
                if (customManifestFile.isFile() && customManifestFile.getName().equals("MANIFEST.MF")) {
                    block15: {
                        this.setErrorMessage("info: using custom manifest file \"cfg/MANIFEST.MF\"");
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(customManifestFile);
                            manifest.read(fis);
                            Object var8_9 = null;
                            if (fis == null) break block15;
                        }
                        catch (Throwable throwable) {
                            Object var8_10 = null;
                            if (fis == null) throw throwable;
                            try {
                                fis.close();
                                throw throwable;
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {}
                        catch (IOException ex) {}
                        fis.close();
                    }
                    if (!manifest.getEntries().isEmpty()) {
                        manifest.getEntries().clear();
                        this.setErrorMessage("warning: per-entry attributes in custom manifest file \"cfg/MANIFEST.MF\" will be ignored");
                        this.setBuildResult(1);
                    }
                }
                if (!(mainAttributes = manifest.getMainAttributes()).containsKey(Attributes.Name.MANIFEST_VERSION)) {
                    mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
                }
                mainAttributes.putValue("Created-By", "DC BuildTool");
                long curTime = System.currentTimeMillis();
                mainAttributes.putValue("Build-Date", this.formatGMTDate(curTime));
                mainAttributes.putValue("Build-Time", this.formatGMTTime(curTime));
                mainAttributes.putValue("Build-Location", this.daf.getCBSLocation());
                mainAttributes.putValue("Build-Counter", this.daf.getCBSCounter());
                mainAttributes.putValue("DC-Name", this.daf.getDCName());
                mainAttributes.putValue("DC-Vendor", this.daf.getDCVendor());
                mainAttributes.putValue("DC-Type", this.daf.getDCType());
                mainAttributes.putValue("PP-Type", this.daf.getDCType());
                mainAttributes.put(Attributes.Name.IMPLEMENTATION_TITLE, this.daf.getDCName());
                mainAttributes.put(Attributes.Name.IMPLEMENTATION_VENDOR, this.daf.getDCVendor());
                mainAttributes.put(Attributes.Name.IMPLEMENTATION_VERSION, this.daf.getCBSLocation() + " " + this.daf.getCBSCounter());
                this.addCustomMainAttributes(mainAttributes);
                manifestFile = new File(this.daf.getTempDir(), "MANIFEST.MF");
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(manifestFile);
                    manifest.write(fos);
                    Object var12_16 = null;
                    if (fos == null) break block16;
                }
                catch (Throwable throwable) {
                    Object var12_17 = null;
                    if (fos == null) throw throwable;
                    try {
                        fos.close();
                        throw throwable;
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException ex) {}
                fos.close();
            }
            this.fCreator.setStrContext("bi_manifest_Name", manifestFile.getAbsolutePath());
            return;
        }
        catch (IOException ex) {
            String msg = "could not create manifest file: " + ex.getMessage();
            this.getLocation().errorT(msg);
            this.setErrorMessage("error: " + msg);
            this.setBuildResult(2);
        }
    }

    protected void addCustomMainAttributes(Attributes attr) {
    }

    protected List collectBuildTimeCompilationPPs() {
        PluginBuildInfo pbi = this.getPluginBuildInfo();
        DirsAndFiles daf = pbi.getFileCreator().getDaf();
        ArrayList externalCompPP = new ArrayList();
        List compDep = daf.getDependencies();
        if (compDep != null) {
            Iterator it = compDep.iterator();
            while (it.hasNext()) {
                Dependency dep = (Dependency)it.next();
                DevelopmentComponent dc = daf.getReferencedComponent(dep);
                boolean isAtBuildTimeDep = dep.isAtBuildTime();
                if (!isAtBuildTimeDep || dc == null) continue;
                boolean isCurrentDepDCExternal = dc.isExternal();
                String currentDepDcType = dc.getComponentType().getType();
                boolean isCurrentDepDCJava = currentDepDcType.equalsIgnoreCase("Java");
                if (!isCurrentDepDCExternal || !isCurrentDepDCJava) continue;
                externalCompPP.addAll(this.collectCompilationPPs(dep));
            }
        }
        return externalCompPP;
    }

    protected List collectCompilationPPs(Dependency dep) {
        ArrayList<String> result = new ArrayList<String>();
        PluginBuildInfo pbi = this.getPluginBuildInfo();
        IBuildInfo buildInfo = pbi.getBuildInfo();
        DirsAndFiles daf = pbi.getFileCreator().getDaf();
        DevelopmentComponent dc = daf.getReferencedComponent(dep);
        DCReference dcRef = dep.getComponent();
        Map pps = dc.getPublicParts();
        if (pps != null) {
            Iterator iter = pps.values().iterator();
            while (iter.hasNext()) {
                PublicPart pp = (PublicPart)iter.next();
                if (pp == null || !PublicPart.Purpose.ASSEMBLY.equals(pp.getPurpose())) continue;
                return result;
            }
            IDevelopmentComponentInfo dcInfo = buildInfo.getDevelopmentComponentInfo();
            PPReference ppRef = dep.getPublicPartDependency();
            if (ppRef != null && ppRef.getName() != null) {
                PublicPart pp = (PublicPart)pps.get(ppRef.getName());
                if (pp != null && PublicPart.Purpose.COMPILATION.equals(pp.getPurpose())) {
                    String externalPPRef = dcInfo.getUsedPublicPartGenFolder(ppRef);
                    result.add(externalPPRef);
                }
            } else {
                Iterator ppiter = pps.values().iterator();
                while (ppiter.hasNext()) {
                    PublicPart pp = (PublicPart)ppiter.next();
                    if (pp == null || !PublicPart.Purpose.COMPILATION.equals(pp.getPurpose())) continue;
                    ppRef = new PPReference(pp.getName(), dcRef);
                    String externalPPRef = dcInfo.getUsedPublicPartGenFolder(ppRef);
                    result.add(externalPPRef);
                }
            }
        }
        return result;
    }

    protected final File createTempDir(String pathName) throws Exception {
        if (pathName == null) {
            throw new NullPointerException();
        }
        File relPathName = new File(pathName);
        if (relPathName.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        FileCreator fc = this.getPluginBuildInfo().getFileCreator();
        String baseDir = fc.getDaf().getTempDir();
        File tempDir = new File(baseDir, pathName.toString());
        tempDir.mkdirs();
        if (!tempDir.isDirectory()) {
            StringBuffer msg = new StringBuffer();
            msg.append("error: could not create temporary directory: ");
            if (tempDir.isFile()) {
                msg.append("a file with same name exists: ");
            }
            msg.append(tempDir.getAbsolutePath());
            throw new Exception();
        }
        return tempDir;
    }
}

