/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin;

import com.sap.tc.buildplugin.BuildSessionManager;
import com.sap.tc.buildplugin.IBuildSession;
import com.sap.tc.buildplugin.PluginBuildInfo;
import com.sap.tc.buildplugin.api.BuildActionSequence;
import com.sap.tc.buildplugin.api.IBuildAction;
import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.buildplugin.api.IBuildPlugin;
import com.sap.tc.buildplugin.techdev.ant.util.DirsAndFiles;
import com.sap.tc.buildplugin.techdev.ant.util.FileCreator;
import com.sap.tc.logging.Location;
import java.io.File;

public abstract class AbstractPlugin
implements IBuildPlugin {
    private boolean isBuildSessionCreated;
    private Location logLocation;

    protected Location getLocation() {
        if (this.logLocation == null) {
            this.logLocation = Location.getLocation((Object)this);
        }
        return this.logLocation;
    }

    public String[] getSupportedBuildTargets() {
        return new String[]{"build"};
    }

    public BuildActionSequence getBuildActions(IBuildInfo buildInfo) {
        this.createBuildSession(buildInfo);
        BuildActionSequence sequence = new BuildActionSequence();
        String target = buildInfo.getTarget();
        this.getLocation().infoT("Creating build action sequence, target: " + target);
        PluginBuildInfo pbi = new PluginBuildInfo(this);
        FileCreator fCreator = this.createFileCreator(buildInfo);
        pbi.setFileCreator(fCreator);
        pbi.setBuildInfo(buildInfo);
        if ("default_central_target".equals(target) || "default_local_target".equals(target) || "build".equals(target)) {
            target = "build";
            buildInfo.setTarget(target);
            sequence = this.createBuildSequence(pbi);
        } else if ("clean".equals(target)) {
            sequence = this.createCleanSequence(pbi);
        } else {
            this.getLocation().infoT("Build plugin " + this.getName() + " is called with unknown target " + target);
        }
        return sequence;
    }

    protected BuildActionSequence createCleanSequence(PluginBuildInfo pbi) {
        return new BuildActionSequence();
    }

    protected BuildActionSequence createBuildSequence(PluginBuildInfo pbi) {
        IBuildAction action;
        boolean postBuildExist;
        BuildActionSequence sequence = new BuildActionSequence();
        String rootDir = pbi.getFileCreator().getDaf().getRootDir();
        String preBuildTemplateFile = rootDir + "cfg" + File.separator + "prebuild.vm";
        String postBuildTemplateFile = rootDir + "cfg" + File.separator + "postbuild.vm";
        File preBuildFile = new File(preBuildTemplateFile);
        File postBuildFile = new File(postBuildTemplateFile);
        File absolutePluginRoot = pbi.getBuildInfo().getAbsolutePluginRoot();
        String preBuildTemplatePlugin = absolutePluginRoot + File.separator + "macros" + File.separator + "prebuild.vm";
        String postBuildTemplatePlugin = absolutePluginRoot + File.separator + "macros" + File.separator + "postbuild.vm";
        File preBuildFilePlugin = new File(preBuildTemplatePlugin);
        File postBuildFilePlugin = new File(postBuildTemplatePlugin);
        boolean preBuildExist = preBuildFile.exists() || preBuildFilePlugin.exists();
        boolean bl = postBuildExist = postBuildFile.exists() || postBuildFilePlugin.exists();
        if (preBuildExist) {
            action = this.createBuildFileAction(pbi, 1);
            if (action != null) {
                sequence.add(action);
            }
            if ((action = this.createBuildAction(pbi, 1)) != null) {
                sequence.add(action);
            }
        }
        if ((action = this.createBuildFileAction(pbi, 2)) != null) {
            sequence.add(action);
        }
        if ((action = this.createBuildAction(pbi, 2)) != null) {
            sequence.add(action);
        }
        if (postBuildExist) {
            action = this.createBuildFileAction(pbi, 3);
            if (action != null) {
                sequence.add(action);
            }
            if ((action = this.createBuildAction(pbi, 3)) != null) {
                sequence.add(action);
            }
        }
        return sequence;
    }

    protected FileCreator createFileCreator(IBuildInfo buildInfo) {
        DirsAndFiles daf = new DirsAndFiles(buildInfo);
        FileCreator fCreator = new FileCreator();
        fCreator.setDaf(daf);
        fCreator.setPluginRoot(buildInfo.getAbsolutePluginRoot());
        return fCreator;
    }

    protected abstract IBuildAction createBuildFileAction(PluginBuildInfo var1, int var2);

    protected abstract IBuildAction createBuildAction(PluginBuildInfo var1, int var2);

    private void createBuildSession(IBuildInfo buildInfo) {
        if (!this.isBuildSessionCreated) {
            IBuildSession buildSession = BuildSessionManager.createSession();
            buildSession.set("BuildInfo", buildInfo);
            this.isBuildSessionCreated = true;
        }
    }

    public abstract String getPluginComponentName();

    public abstract String getVersion();

    public abstract String getName();
}

