/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin;

import com.sap.tc.buildplugin.api.BuildActionResult;
import com.sap.tc.buildplugin.api.BuildActionSeverity;
import com.sap.tc.buildplugin.api.IBuildAction;
import com.sap.tc.logging.Location;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public abstract class AbstractBuildAction
implements IBuildAction {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private Location logLocation;
    private BuildActionSeverity severity = new BuildActionSeverity();

    protected AbstractBuildAction() {
        this.severity.setStopOnError();
    }

    protected Location getLocation() {
        if (this.logLocation == null) {
            this.logLocation = Location.getLocation((Object)this);
        }
        return this.logLocation;
    }

    public final BuildActionSeverity getBuildActionSeverity() {
        return this.severity;
    }

    public final void setBuildActionSeverity(BuildActionSeverity severity) {
        this.severity = severity;
    }

    protected String formatGMTDate(long millis) {
        return dateFormat.format(new Date(millis));
    }

    protected String formatGMTTime(long millis) {
        Date curTime = new Date(millis);
        TimeZone currZone = TimeZone.getDefault();
        int diff = currZone.getRawOffset();
        StringBuffer gmtDiff = new StringBuffer(64);
        if (diff != 0) {
            String sign = "+";
            if (diff < 0) {
                sign = "-";
                diff = -diff;
            }
            gmtDiff.append("GMT");
            gmtDiff.append(sign);
            gmtDiff.append(this.formatTime(diff));
            gmtDiff.append(" (");
            gmtDiff.append(currZone.getDisplayName());
            gmtDiff.append(")");
        } else {
            gmtDiff.append(currZone.getID());
        }
        return timeFormat.format(curTime) + " " + gmtDiff;
    }

    protected String formatTime(long millis) {
        long minutes = millis / 1000L / 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        StringBuffer sb = new StringBuffer(6);
        if (hours < 10L) {
            sb.append('0');
        }
        sb.append(Long.toString(hours));
        sb.append(':');
        if (minutes < 10L) {
            sb.append('0');
        }
        sb.append(Long.toString(minutes));
        return sb.toString();
    }

    public abstract String getCaption();

    public abstract BuildActionResult getBuildActionResult();

    public abstract BuildActionResult execute();
}

