/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin;

import com.sap.tc.buildplugin.AbstractBuildAction;
import com.sap.tc.buildplugin.PluginBuildInfo;
import com.sap.tc.buildplugin.api.BuildActionResult;
import com.sap.tc.buildplugin.techdev.ant.util.AntRunner;
import com.sap.tc.buildplugin.techdev.ant.util.DirsAndFiles;
import java.io.File;

public abstract class AbstractAntBuildAction
extends AbstractBuildAction {
    private BuildActionResult result;
    private DirsAndFiles daf;
    private int currentStep;
    private String target;

    protected AbstractAntBuildAction(PluginBuildInfo pbi, int step) {
        this.daf = pbi.getFileCreator().getDaf();
        this.result = new BuildActionResult();
        this.result.setBuildLogPath(this.daf.getLogFile());
        this.currentStep = step;
        this.target = pbi.getBuildInfo().getTarget();
    }

    public BuildActionResult execute() {
        AntRunner ar = new AntRunner();
        String buildFileName = this.daf.getBuildFile();
        File buildFile = new File(buildFileName);
        ar.setBuildFile(buildFileName);
        ar.setTarget(this.target);
        ar.setLogfile(this.daf.getLogFile());
        ar.setTDir(this.daf.getTempDir());
        ar.setPluginVersion(this.daf.getPluginVersion());
        if (buildFile.exists()) {
            int rc = ar.run();
            this.getLocation().infoT("Ant started with build file " + buildFileName + ", target " + this.target);
            if (rc == 0) {
                this.result.setBuildActionRC(0);
            } else {
                this.result.setBuildActionRC(2);
            }
        } else {
            this.getLocation().infoT("buildfile " + buildFileName + " doesn't exist");
            this.result.setBuildActionRC(0);
        }
        return this.result;
    }

    public BuildActionResult getBuildActionResult() {
        return this.result;
    }

    public String getCaption() {
        return "Executing Ant build file with target " + this.target;
    }
}

