/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.deployment.ep50;

import com.sapportals.portal.prt.deployment.ep50.HelperEP50;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class ServiceConfigEP50 {
    private static final String EP50_SERVICENAME_ATTRIBUTE = "name";
    private static final String EP50_SYSTEM_ATTRIBUTE = "system";
    Document mm_document = null;

    public ServiceConfigEP50(InputStream is) {
        this.mm_document = this.load(is);
    }

    private Document load(InputStream is) {
        try {
            DocumentBuilderFactory docBuilderFactory = ServiceConfigEP50.getDocumentBuilderFactory();
            DocumentBuilder docBuilder = null;
            docBuilderFactory.setValidating(false);
            docBuilder = docBuilderFactory.newDocumentBuilder();
            this.mm_document = docBuilder.parse(is);
            return this.mm_document;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void toEP60(Document document, Element parentNode, Element applicationConfigNode) {
        Element element;
        if (this.mm_document != null && (element = this.mm_document.getDocumentElement()).getNodeName().equals("services")) {
            NamedNodeMap list = element.getAttributes();
            int i = 0;
            while (i < list.getLength()) {
                Attr attribute = (Attr)list.item(i);
                String name = attribute.getNodeName();
                String value = attribute.getNodeValue();
                if (name.equals(EP50_SERVICENAME_ATTRIBUTE)) {
                    ((Element)parentNode.getParentNode()).setAttribute(EP50_SERVICENAME_ATTRIBUTE, "default");
                    ((Element)parentNode.getParentNode()).setAttribute("alias", value);
                    ((Element)applicationConfigNode.getParentNode()).setAttribute("alias", value);
                } else {
                    Element propertyNode = document.createElement("property");
                    propertyNode.setAttribute(EP50_SERVICENAME_ATTRIBUTE, name);
                    propertyNode.setAttribute("value", value);
                    if (HelperEP50.isGroupProperty(name)) {
                        applicationConfigNode.appendChild(propertyNode);
                    } else {
                        parentNode.appendChild(propertyNode);
                    }
                }
                ++i;
            }
        }
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory;
        try {
            documentBuilderFactory = (DocumentBuilderFactory)Class.forName("com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl").newInstance();
        }
        catch (Exception e) {
            System.err.println(e);
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return documentBuilderFactory;
    }
}

