/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.deployment.ep50;

import com.sapportals.portal.prt.deployment.ep50.HelperEP50;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProfileEP50 {
    private static final String PROFILE_ATTRIBUTE_VALUE = "value";
    private Hashtable mm_properties = null;

    public ProfileEP50(InputStream is) {
        Properties original = new Properties();
        this.mm_properties = new Hashtable();
        try {
            original.load(is);
            Enumeration<?> enumeration = original.propertyNames();
            if (enumeration != null && enumeration.hasMoreElements()) {
                while (enumeration.hasMoreElements()) {
                    String attrName;
                    String propName = (String)enumeration.nextElement();
                    String value = original.getProperty(propName);
                    int p = propName.lastIndexOf(46);
                    if (p >= 0) {
                        attrName = propName.substring(p + 1);
                        propName = propName.substring(0, p);
                    } else {
                        attrName = null;
                    }
                    this.setPropertyAttribute(propName, attrName, value);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setPropertyAttribute(String propertyName, String attributeName, String attributeValue) {
        Hashtable<String, String> attributes = (Hashtable<String, String>)this.mm_properties.get(propertyName);
        if (attributes == null) {
            attributes = new Hashtable<String, String>();
            attributes.put(PROFILE_ATTRIBUTE_VALUE, "");
            this.mm_properties.put(propertyName, attributes);
        }
        if (attributeName == null) {
            attributes.put(PROFILE_ATTRIBUTE_VALUE, attributeValue);
        } else {
            attributes.put(attributeName, attributeValue);
        }
    }

    public Enumeration getPropertyAttributes(String propertyName) {
        Hashtable atts = (Hashtable)this.mm_properties.get(propertyName);
        if (atts != null) {
            return atts.keys();
        }
        return null;
    }

    public String getPropertyAttribute(String propertyName, String attributeName) {
        Hashtable atts = (Hashtable)this.mm_properties.get(propertyName);
        if (atts != null) {
            return (String)atts.get(attributeName);
        }
        return null;
    }

    public Enumeration getProperties() {
        return this.mm_properties.keys();
    }

    public String getProperty(String key) {
        if (this.mm_properties.containsKey(key)) {
            return (String)((Hashtable)this.mm_properties.get(key)).get(PROFILE_ATTRIBUTE_VALUE);
        }
        return null;
    }

    public void setAttributeValue(String key, String value) {
        this.setPropertyAttribute(key, PROFILE_ATTRIBUTE_VALUE, value);
    }

    public void toEP60Profile(Document document, Element parentNode) {
        Enumeration enumeration = this.getProperties();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            if (HelperEP50.isGroupProperty(propertyName) || HelperEP50.isConfigProperty(propertyName)) continue;
            this.importProperty(document, parentNode, propertyName, false);
        }
    }

    public void toEP60Config(Document document, Element parentNode) {
        Enumeration enumeration = this.getProperties();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            if (!HelperEP50.isConfigProperty(propertyName)) continue;
            this.importProperty(document, parentNode, propertyName, false);
        }
    }

    public void toEP60ApplicationConfig(Document document, Element parentNode) {
        Enumeration enumeration = this.getProperties();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            if (!HelperEP50.isGroupProperty(propertyName)) continue;
            this.importProperty(document, parentNode, propertyName, false);
        }
    }

    private void importProperty(Document document, Element parentNode, String propertyName, boolean configMode) {
        String propertyValue = this.getProperty(propertyName);
        if (propertyValue != null) {
            propertyValue = propertyValue.trim();
        }
        Element propertyNode = document.createElement("property");
        propertyNode.setAttribute("name", propertyName);
        propertyNode.setAttribute(PROFILE_ATTRIBUTE_VALUE, propertyValue);
        parentNode.appendChild(propertyNode);
        if (!configMode) {
            this.importSubproperties(document, propertyNode, propertyName);
        }
    }

    private void importSubproperties(Document document, Element propertyNode, String propertyName) {
        Enumeration enumeration = this.getPropertyAttributes(propertyName);
        while (enumeration.hasMoreElements()) {
            String attributeName = (String)enumeration.nextElement();
            if (attributeName.equals(PROFILE_ATTRIBUTE_VALUE)) continue;
            String attributeValue = this.getPropertyAttribute(propertyName, attributeName);
            if (attributeValue != null) {
                attributeValue = attributeValue.trim();
            }
            Element attributeNode = document.createElement("property");
            attributeNode.setAttribute("name", attributeName);
            attributeNode.setAttribute(PROFILE_ATTRIBUTE_VALUE, attributeValue);
            propertyNode.appendChild(attributeNode);
        }
    }
}

