/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.deployment.descriptor;

import com.sapportals.portal.prt.deployment.descriptor.HybridConfiguration;
import com.sapportals.portal.prt.deployment.descriptor.IProperty;
import com.sapportals.portal.prt.deployment.descriptor.IPropertyList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class HybridPropertyList
implements IPropertyList {
    HybridConfiguration mm_hybridConfiguration;
    HashMap mm_hybridPropertiesMap;
    ArrayList mm_hybridProperties;
    boolean mm_ready;

    public HybridPropertyList(HybridConfiguration hybridConfiguration) {
        this.mm_hybridConfiguration = hybridConfiguration;
        this.setDefault();
    }

    private void setDefault() {
        this.mm_hybridPropertiesMap = null;
        this.mm_hybridProperties = null;
        this.mm_ready = false;
    }

    private void load() {
        if (!this.mm_ready) {
            this.mm_hybridPropertiesMap = new HashMap();
            IPropertyList propertyList = this.mm_hybridConfiguration.getOriginalConfiguration().getProperties();
            int i = 0;
            while (i < propertyList.getLength()) {
                IProperty property = propertyList.item(i);
                this.mm_hybridPropertiesMap.put(property.getName(), property);
                ++i;
            }
            propertyList = this.mm_hybridConfiguration.getCustomConfiguration().getProperties();
            int i2 = 0;
            while (i2 < propertyList.getLength()) {
                IProperty property = propertyList.item(i2);
                this.mm_hybridPropertiesMap.put(property.getName(), property);
                ++i2;
            }
            this.mm_hybridProperties = new ArrayList(this.mm_hybridPropertiesMap.size());
            Iterator iterator = this.mm_hybridPropertiesMap.values().iterator();
            while (iterator.hasNext()) {
                this.mm_hybridProperties.add(iterator.next());
            }
            this.mm_ready = true;
        }
    }

    public int getLength() {
        this.load();
        return this.mm_hybridProperties.size();
    }

    public IProperty item(int pos) {
        this.load();
        return (IProperty)this.mm_hybridProperties.get(pos);
    }

    public IProperty getProperty(String name) {
        this.load();
        return (IProperty)this.mm_hybridPropertiesMap.get(name);
    }
}

