/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.deployment.descriptor;

import com.sapportals.portal.prt.deployment.descriptor.HybridProperty;
import com.sapportals.portal.prt.deployment.descriptor.HybridPropertyList;
import com.sapportals.portal.prt.deployment.descriptor.IConfiguration;
import com.sapportals.portal.prt.deployment.descriptor.IProperty;
import com.sapportals.portal.prt.deployment.descriptor.IPropertyList;

public class HybridConfiguration
implements IConfiguration {
    IConfiguration mm_originalConfiguration;
    IConfiguration mm_customConfiguration;
    HybridPropertyList mm_hybridPropertyList = null;

    public HybridConfiguration(IConfiguration originalConfiguration, IConfiguration customConfiguration) {
        this.mm_originalConfiguration = originalConfiguration;
        this.mm_customConfiguration = customConfiguration;
    }

    public IProperty getProperty(String propertyName) {
        if (this.mm_originalConfiguration.getProperty(propertyName) != null) {
            return new HybridProperty(propertyName, this);
        }
        if (this.mm_customConfiguration.getProperty(propertyName) != null) {
            return new HybridProperty(propertyName, this);
        }
        return null;
    }

    public String getPropertyValue(String propertyName) {
        IProperty property = this.getProperty(propertyName);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    public IPropertyList getProperties() {
        if (this.mm_hybridPropertyList == null) {
            this.mm_hybridPropertyList = new HybridPropertyList(this);
        }
        return this.mm_hybridPropertyList;
    }

    public void setPropertyValue(String key, String value) {
        IProperty property = this.getProperty(key);
        if (property == null) {
            if (value != null) {
                property = new HybridProperty(key, this);
                property.setValue(value);
            }
        } else {
            property.setValue(value);
        }
    }

    protected IConfiguration getCustomConfiguration() {
        return this.mm_customConfiguration;
    }

    protected IConfiguration getOriginalConfiguration() {
        return this.mm_originalConfiguration;
    }

    protected void refresh() {
        this.mm_hybridPropertyList = null;
    }
}

