/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.deployment.descriptor;

import com.sapportals.portal.prt.deployment.DeploymentException;
import com.sapportals.portal.prt.deployment.descriptor.Application;
import com.sapportals.portal.prt.deployment.descriptor.Configuration;
import com.sapportals.portal.prt.deployment.descriptor.FilteredNodeList;
import com.sapportals.portal.prt.deployment.descriptor.IApplication;
import com.sapportals.portal.prt.deployment.descriptor.IComponent;
import com.sapportals.portal.prt.deployment.descriptor.IComponentList;
import com.sapportals.portal.prt.deployment.descriptor.IConfiguration;
import com.sapportals.portal.prt.deployment.descriptor.IDescriptor;
import com.sapportals.portal.prt.deployment.descriptor.IService;
import com.sapportals.portal.prt.deployment.descriptor.IServiceList;
import com.sapportals.portal.prt.deployment.descriptor.Service;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class Descriptor
implements IDescriptor,
EntityResolver {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String LATIN1_ENCODING = "ISO-8859-1";
    private String mm_applicationName;
    private Document mm_document = null;
    Application mm_application = null;
    private String mm_dtd = null;
    private int mm_originalFormat = 0;

    public Descriptor(String applicationName) {
        this.mm_applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.mm_applicationName;
    }

    public void setDTD(String dtd) {
        this.mm_dtd = dtd;
    }

    protected void setDocument(Document document) {
        if (this.mm_document != null) {
            throw new UnsupportedOperationException("[Descriptor.setDocument] Can't reset the document");
        }
        this.mm_document = document;
    }

    protected Document getDocument() {
        return this.mm_document;
    }

    public InputSource resolveEntity(String xPublicId, String xSystemId) {
        try {
            if (xSystemId.toLowerCase().endsWith("portalapp.dtd")) {
                return new InputSource(new FileInputStream(this.mm_dtd));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Document load(File file) throws DeploymentException {
        try {
            FileInputStream fis = new FileInputStream(file);
            return this.load(fis);
        }
        catch (IOException e) {
            throw new DeploymentException("Operation failed - application name: " + this.mm_applicationName, (Throwable)e);
        }
    }

    public Document load(InputStream is) throws DeploymentException {
        try {
            DocumentBuilderFactory docBuilderFactory = Descriptor.getDocumentBuilderFactory();
            DocumentBuilder docBuilder = null;
            if (this.mm_dtd != null) {
                docBuilderFactory.setValidating(true);
                docBuilder = docBuilderFactory.newDocumentBuilder();
                docBuilder.setEntityResolver(this);
            } else {
                docBuilderFactory.setValidating(false);
                docBuilder = docBuilderFactory.newDocumentBuilder();
            }
            this.mm_document = docBuilder.parse(is);
            return this.mm_document;
        }
        catch (Exception e) {
            throw new DeploymentException("Operation failed - application name: " + this.mm_applicationName, (Throwable)e);
        }
    }

    public IApplication getApplication() {
        Element element;
        if (this.mm_application == null && this.mm_document != null && (element = this.mm_document.getDocumentElement()).getNodeName().equals("application")) {
            this.mm_application = new Application(this, element);
        }
        return this.mm_application;
    }

    public void saveAs(OutputStream os) {
        this.saveAs(os, null);
    }

    public void saveAs(OutputStream os, String encoding) {
        this.cleanServiceNames();
        if (this.mm_document != null) {
            try {
                TransformerFactory factory = Descriptor.getTransformerFactory();
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                if (encoding != null) {
                    transformer.setOutputProperty("encoding", encoding);
                }
                DOMSource domSource = new DOMSource(this.mm_document);
                StreamResult streamResult = new StreamResult(os);
                transformer.transform(domSource, streamResult);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public IConfiguration _getConfiguration(String tagName, Element element) {
        if (element != null) {
            FilteredNodeList list = new FilteredNodeList(element.getChildNodes(), tagName);
            Element config = (Element)list.item(0);
            if (config != null) {
                return new Configuration(this, config);
            }
            Document document = this.mm_document;
            synchronized (document) {
                Element childNode = this.mm_document.createElement(tagName);
                element.appendChild(childNode);
                Configuration configuration = new Configuration(this, childNode);
                return configuration;
            }
        }
        return null;
    }

    public void setOriginalFormat(int format) {
        this.mm_originalFormat = format;
    }

    public int getOriginalFormat() {
        return this.mm_originalFormat;
    }

    private void cleanServiceNames() {
        try {
            IServiceList list = this.getApplication().getServices();
            int i = 0;
            while (i < list.getLength()) {
                IService service = list.item(i);
                if (service != null) {
                    ((Service)service).checkConsistency();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addWarning() {
        try {
            if (this.mm_document != null) {
                Element element = this.mm_document.getDocumentElement();
                Comment comment = this.mm_document.createComment("THIS FILE IS A COPY OF THE ORIGINAL VERSION STORED IN THE PCD. PLEASE DO NOT CHANGE IT!");
                Node node = element.getFirstChild();
                element.insertBefore(comment, node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Set getDeclaredResourceBundles() {
        HashMap<String, String> result = new HashMap<String, String>(1);
        IApplication application = this.getApplication();
        if (application != null) {
            IComponentList list = application.getComponents();
            int i = 0;
            while (i < list.getLength()) {
                String value;
                IComponent component = list.item(i);
                if (component != null && (value = component.getConfiguration().getPropertyValue("ResourceBundleName")) != null) {
                    result.put(value, value);
                }
                ++i;
            }
        }
        return result.keySet();
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory;
        try {
            documentBuilderFactory = (DocumentBuilderFactory)Class.forName("com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl").newInstance();
        }
        catch (Exception e) {
            System.err.println(e);
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return documentBuilderFactory;
    }

    public static TransformerFactory getTransformerFactory() {
        TransformerFactory transformerFactory;
        try {
            transformerFactory = (TransformerFactory)Class.forName("com.sap.engine.lib.jaxp.TransformerFactoryImpl").newInstance();
        }
        catch (Exception e) {
            System.err.println(e);
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    protected void refresh() {
        if (this.mm_application != null) {
            this.mm_application.refresh();
        }
    }
}

