/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.deployment.descriptor;

import com.sapportals.portal.prt.deployment.descriptor.ComponentList;
import com.sapportals.portal.prt.deployment.descriptor.Descriptor;
import com.sapportals.portal.prt.deployment.descriptor.EntryList;
import com.sapportals.portal.prt.deployment.descriptor.FilteredNodeList;
import com.sapportals.portal.prt.deployment.descriptor.IApplication;
import com.sapportals.portal.prt.deployment.descriptor.IComponent;
import com.sapportals.portal.prt.deployment.descriptor.IComponentList;
import com.sapportals.portal.prt.deployment.descriptor.IConfiguration;
import com.sapportals.portal.prt.deployment.descriptor.IEntryList;
import com.sapportals.portal.prt.deployment.descriptor.IService;
import com.sapportals.portal.prt.deployment.descriptor.IServiceList;
import com.sapportals.portal.prt.deployment.descriptor.ServiceList;
import java.util.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Application
implements IApplication {
    Descriptor mm_descriptor;
    Element mm_element = null;
    ComponentList mm_componentList = null;
    ServiceList mm_serviceList = null;
    EntryList mm_entryList = null;
    HashMap mm_subNodes = new HashMap();

    public Application(Descriptor d, Element e) {
        this.mm_descriptor = d;
        this.mm_element = e;
    }

    public String getName() {
        return this.mm_descriptor.getApplicationName();
    }

    public String getAlias() {
        Attr attr = this.mm_element.getAttributeNode("alias");
        if (attr != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    public IEntryList getEntries() {
        Element registryNode;
        if (this.mm_entryList == null && this.mm_element != null && (registryNode = this.getSubElement("registry")) != null) {
            NodeList list = this.getSubElements(registryNode, "entry");
            this.mm_entryList = new EntryList(this.mm_descriptor, list);
        }
        return this.mm_entryList;
    }

    public IComponent getComponent(String name) {
        if (this.mm_element != null) {
            return this.getComponents().getComponent(name);
        }
        return null;
    }

    public IComponentList getComponents() {
        if (this.mm_componentList == null && this.mm_element != null) {
            NodeList list = null;
            Element componentsNode = this.getSubElement("components");
            if (componentsNode != null) {
                list = this.getSubElements(componentsNode, "component");
            }
            this.mm_componentList = new ComponentList(this.mm_descriptor, list);
        }
        return this.mm_componentList;
    }

    public IService getService(String name) {
        if (this.mm_element != null) {
            return this.getServices().getService(name);
        }
        return null;
    }

    public IServiceList getServices() {
        if (this.mm_serviceList == null && this.mm_element != null) {
            NodeList list = null;
            Element servicesNode = this.getSubElement("services");
            if (servicesNode != null) {
                list = this.getSubElements(servicesNode, "service");
            }
            this.mm_serviceList = new ServiceList(this.mm_descriptor, list);
        }
        return this.mm_serviceList;
    }

    public IConfiguration getConfiguration() {
        if (this.mm_element != null) {
            return this.mm_descriptor._getConfiguration("application-config", this.mm_element);
        }
        return null;
    }

    private Element getSubElement(String tagName) {
        FilteredNodeList list;
        Element element = (Element)this.mm_subNodes.get(tagName);
        if (element == null && (list = new FilteredNodeList(this.mm_element.getChildNodes(), tagName)).getLength() > 0) {
            element = (Element)list.item(0);
            this.mm_subNodes.put(tagName, element);
        }
        return element;
    }

    private NodeList getSubElements(Node node, String tagName) {
        return new FilteredNodeList(node.getChildNodes(), tagName);
    }

    protected void refresh() {
        this.mm_entryList = null;
        this.mm_subNodes = new HashMap();
        this.mm_componentList = null;
        this.mm_serviceList = null;
    }
}

