/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.deployment;

import com.sapportals.portal.prt.deployment.ArchiveExtractor;
import com.sapportals.portal.prt.deployment.ArchiveIterator;
import com.sapportals.portal.prt.deployment.DeploymentPolicy;
import com.sapportals.portal.prt.deployment.IArchiveExtractor;
import com.sapportals.portal.prt.deployment.descriptor.IDescriptor;
import java.io.File;
import java.util.HashSet;
import java.util.zip.ZipEntry;

public class ArchiveExtractorEP50
extends ArchiveExtractor
implements IArchiveExtractor {
    private static final HashSet mm_private = new HashSet();

    public ArchiveExtractorEP50(File sourceFile, File publicPath, File privatePath, IDescriptor descriptor, DeploymentPolicy policy) {
        super(sourceFile, publicPath, privatePath, descriptor, policy);
    }

    protected boolean isAPrivateResource(String entryName) {
        String folder;
        int pos = entryName.indexOf("/");
        return pos != -1 && mm_private.contains((folder = entryName.substring(0, pos)).toLowerCase());
    }

    protected File getTarget(String internalName) {
        File target = null;
        String fileName = null;
        if (this.startsWithIgnoreCase(internalName, "private/")) {
            fileName = internalName.substring(ArchiveIterator.PRIVATE_LENGTH + 1);
            if ((fileName = this.getTargetName(fileName, true)) != null) {
                target = new File(this.mm_privatePath, fileName);
            }
        } else if (this.startsWithIgnoreCase(internalName, "public/")) {
            fileName = internalName.substring(ArchiveIterator.PUBLIC_LENGTH + 1);
            if ((fileName = this.getTargetName(fileName, false)) != null) {
                target = new File(this.mm_publicPath, fileName);
            }
        }
        return target;
    }

    protected String getInternalEntryName(String entryName) {
        if (this.startsWithIgnoreCase(entryName, "private/") || this.startsWithIgnoreCase(entryName, "public/")) {
            return entryName;
        }
        if (this.isAPrivateResource(entryName)) {
            return "private/" + entryName;
        }
        return "public/" + entryName;
    }

    public String getNormalizedEntryName(ZipEntry entry) {
        String entryName = entry.getName();
        if (this.startsWithIgnoreCase(entryName, "private/")) {
            return "PORTAL-INF" + entryName.substring(ArchiveIterator.PRIVATE_LENGTH);
        }
        if (this.startsWithIgnoreCase(entryName, "public/")) {
            return entryName.substring(ArchiveIterator.PUBLIC_LENGTH + 1);
        }
        if (this.isAPrivateResource(entryName)) {
            return "PORTAL-INF/" + entryName;
        }
        return entryName;
    }

    static {
        mm_private.add("meta-inf");
        mm_private.add("xml");
        mm_private.add("properties");
        mm_private.add("pagelet");
        mm_private.add("jsp");
        mm_private.add("logger");
        mm_private.add("lib");
        mm_private.add("classes");
        mm_private.add("config");
        mm_private.add("profiles");
    }
}

