/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.deployment;

import com.sapportals.portal.prt.deployment.ArchiveIterator;
import com.sapportals.portal.prt.deployment.DeploymentException;
import com.sapportals.portal.prt.deployment.DeploymentPolicy;
import com.sapportals.portal.prt.deployment.IArchiveExtractor;
import com.sapportals.portal.prt.deployment.IArchiveExtractorHook;
import com.sapportals.portal.prt.deployment.descriptor.IDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ArchiveExtractor
extends ArchiveIterator
implements IArchiveExtractor {
    protected File mm_sourceFile;
    protected DeploymentPolicy mm_deploymentPolicy;
    protected IDescriptor mm_deploymentDescriptor;
    protected File mm_publicPath;
    protected File mm_privatePath;
    protected IArchiveExtractorHook mm_hook;

    public ArchiveExtractor(File sourceFile, File publicPath, File privatePath, IDescriptor descriptor, DeploymentPolicy policy) {
        this.mm_sourceFile = sourceFile;
        this.mm_publicPath = publicPath;
        this.mm_privatePath = privatePath;
        this.mm_deploymentDescriptor = descriptor;
        this.mm_deploymentPolicy = policy;
        this.mm_hook = null;
    }

    public void setArchiveExtractorHook(IArchiveExtractorHook hook) {
        this.mm_hook = hook;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deploy() throws IOException, DeploymentException {
        Object fis = null;
        this.iterate(this.mm_sourceFile);
        OutputStream os = null;
        try {
            if (this.mm_deploymentDescriptor != null) {
                File folder = this.mm_privatePath;
                folder.mkdirs();
                os = new FileOutputStream(new File(folder, "portalapp.xml"));
                this.mm_deploymentDescriptor.saveAs(os);
            }
            Object var5_4 = null;
            if (os == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (os == null) throw throwable;
            os.close();
            throw throwable;
        }
        os.close();
    }

    protected boolean handleEntry(ZipFile zip, ZipEntry ze) throws IOException {
        File target = this.doBeforeEntryDeployment(zip, ze);
        if (target != null && !this.isPreservedPath(ze.getName(), target)) {
            this.unzip(zip, ze, target);
            this.doAfterEntryDeployment(zip, ze, target);
        }
        return false;
    }

    protected void unzip(ZipFile zip, ZipEntry ze, File target) throws IOException {
        if (!ze.isDirectory()) {
            target.getParentFile().mkdirs();
            InputStream is = zip.getInputStream(ze);
            BufferedInputStream bis = new BufferedInputStream(is, 16384);
            byte[] buffer = new byte[16384];
            int length = 0;
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(target);
            }
            catch (IOException e) {
                String fullName = target.getAbsolutePath();
                if (fullName.length() > 255 && fullName.indexOf("\\") != -1) {
                    throw new IOException("The file name lenght exceeds OS limits: " + target.getAbsolutePath());
                }
                throw e;
            }
            BufferedOutputStream bos = new BufferedOutputStream(fos, 16384);
            while ((length = bis.read(buffer)) >= 0) {
                bos.write(buffer, 0, length);
            }
            bos.flush();
            fos.close();
        }
    }

    protected boolean isAPrivateResource(String entryName) {
        String folder = entryName.substring(0, entryName.indexOf("/"));
        return folder.equals("PORTAL-INF") || folder.equals("META-INF");
    }

    protected boolean startsWithIgnoreCase(String s, String p) {
        if (p != null && s != null) {
            return s.regionMatches(true, 0, p, 0, p.length());
        }
        return false;
    }

    public boolean isPreservedPath(String zipEntryName, File target) {
        boolean preservedPath = false;
        if (this.mm_deploymentPolicy != null && this.mm_deploymentPolicy.isPreservedPath(zipEntryName) && target.exists()) {
            preservedPath = true;
        }
        return preservedPath;
    }

    protected File doBeforeEntryDeployment(ZipFile zip, ZipEntry ze) throws IOException {
        String normalizedName = this.getInternalEntryName(ze.getName());
        File target = normalizedName.equals("PORTAL-INF/portalapp.xml") ? null : this.getTarget(normalizedName);
        if (this.mm_hook != null) {
            target = this.mm_hook.doBeforeEntryDeployment(this, zip, ze, target);
        }
        return target;
    }

    protected void doAfterEntryDeployment(ZipFile zip, ZipEntry ze, File target) throws IOException {
        if (this.mm_hook != null) {
            this.mm_hook.doAfterEntryDeployment(this, zip, ze, target);
        }
    }

    protected File getTarget(String internalName) {
        File target = null;
        String fileName = null;
        if (internalName.startsWith("PORTAL-INF/")) {
            fileName = internalName.substring(ArchiveIterator.PORTAL_INF_FOLDER_LENGTH + 1);
            if (!fileName.equals("META-INF/MANIFEST.MF") && (fileName = this.getTargetName(fileName, true)) != null) {
                target = new File(this.mm_privatePath, fileName);
            }
        } else if (internalName.startsWith("META-INF/")) {
            fileName = this.getTargetName(internalName, true);
            if (fileName != null) {
                target = new File(this.mm_privatePath, fileName);
            }
        } else {
            fileName = this.getTargetName(internalName, false);
            if (fileName != null) {
                target = new File(this.mm_publicPath, fileName);
            }
        }
        return target;
    }

    protected String getTargetName(String fileName, boolean isPrivate) {
        return fileName;
    }

    protected String getInternalEntryName(String entryName) {
        return entryName;
    }

    public String getNormalizedEntryName(ZipEntry entry) {
        return entry.getName();
    }
}

