/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.xsl.xpath.ETObject;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLNode;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import org.w3c.dom.Element;

public final class XSLSort
extends XSLNode {
    private ETObject select = null;
    private String lang = null;
    private String order = null;
    private String dataType = null;
    private String caseOrder = null;
    private int iOrder = 1;
    private int iCase = 1;
    private int iType = 1;
    public static final int ORD_ASC = 1;
    public static final int ORD_DESC = -1;
    public static final int CASE_UP = 1;
    public static final int CASE_DOWN = 2;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_NUMBER = 2;
    public static final String[] REQPAR = new String[]{"select"};
    public static final String[] OPTPAR = new String[]{"select", "lang", "data-type", "order", "case-order"};

    public int getOrder() {
        return this.iOrder;
    }

    public int getDataType() {
        return this.iType;
    }

    public int getCaseOrder() {
        return this.iCase;
    }

    public ETObject getSelect() {
        return this.select;
    }

    public String getLang() {
        return this.lang;
    }

    public XSLSort(XSLStylesheet owner, XSLNode parent) throws XSLException {
        super(owner, parent);
    }

    public XSLSort(XSLStylesheet owner, XSLNode parent, Element el) throws XSLException {
        super(owner, parent);
        this.select = owner.etBuilder.process(el.getAttribute("select").length() == 0 ? "." : el.getAttribute("select"));
        this.lang = el.getAttribute("lang");
        this.order = el.getAttribute("order");
        this.caseOrder = el.getAttribute("case-order");
        this.dataType = el.getAttribute("data-type");
        if (this.order != null && this.order.equals("ascending")) {
            this.iOrder = 1;
        } else if (this.order != null && this.order.equals("descending")) {
            this.iOrder = -1;
        }
        if (this.caseOrder != null && this.caseOrder.equals("upper-first")) {
            this.iCase = 1;
        } else if (this.caseOrder != null && this.caseOrder.equals("lower-first")) {
            this.iCase = 2;
        }
        if (this.dataType != null && this.dataType.equals("text")) {
            this.iType = 1;
        } else if (this.dataType != null && this.dataType.equals("number")) {
            this.iType = 2;
        }
    }

    public void process(XPathContext xcont, int node) throws XSLException, XPathException {
    }

    public void print(String ind) {
        System.out.println(ind + "#XSLSort: select=" + this.select + ", lang=" + this.lang + ", order=" + this.order + ", case-order=" + this.caseOrder);
        if (this.getNext() != null) {
            this.getNext().print(ind);
        }
    }

    public String[] getRequiredParams() {
        return REQPAR;
    }

    public String[] getOptionalParams() {
        return OPTPAR;
    }
}

