/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.tokenizer;

import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.binary.BinaryXmlReader;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xsl.xslt.InternalAttributeList;
import java.io.InputStream;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.helpers.AttributesImpl;

public class XMLBinaryReader
implements XMLTokenReader {
    protected BinaryXmlReader reader;
    protected int currentState = -1;
    private CharArray charData = new CharArray();
    private CharArray prevParent = null;
    private Stack parentNodes = new Stack();
    private boolean skipNext = false;

    public XMLBinaryReader() {
    }

    public XMLBinaryReader(InputStream input) {
        this();
        this.reader = new BinaryXmlReader(input);
        this.reader.init();
    }

    public int begin() throws ParserException {
        this.currentState = 0;
        this.charData.clear();
        this.parentNodes.clear();
        this.prevParent = null;
        this.skipNext = false;
        return this.currentState;
    }

    public void end() throws ParserException {
    }

    public void init(InputStream input) {
        if (this.reader == null) {
            this.reader = new BinaryXmlReader(input);
            this.reader.init();
        } else {
            this.reader.reuse(input);
        }
    }

    public int next() throws ParserException {
        try {
            boolean reserved = true;
            while (reserved) {
                if (this.skipNext || this.reader.read()) {
                    this.skipNext = false;
                    switch (this.reader.getNodeType()) {
                        case 1: {
                            if (this.reader.isStartElement) {
                                this.charData.setSize(0);
                                this.currentState = 1;
                                this.parentNodes.push(this.prevParent);
                                this.prevParent = this.reader.getQName0();
                            } else {
                                this.currentState = 2;
                                this.parentNodes.pop();
                            }
                            reserved = false;
                            break;
                        }
                        case 3: {
                            this.currentState = 3;
                            reserved = false;
                            break;
                        }
                        case 8: {
                            this.currentState = 5;
                            reserved = false;
                        }
                    }
                    continue;
                }
                this.currentState = 6;
                break;
            }
        }
        catch (Exception ex) {
            throw new ParserException(ex);
        }
        return this.currentState;
    }

    public String getPrefixMapping(String prefix) {
        return this.reader.lookupPrefix(prefix);
    }

    public String getValue() {
        return this.reader.getNodeValue();
    }

    public InternalAttributeList getInternalAttributeList() {
        return null;
    }

    public Attributes getAttributes() {
        AttributesImpl result = null;
        if (this.currentState != 1) {
            return result;
        }
        try {
            result = new AttributesImpl();
            while (this.reader.read()) {
                if (this.reader.getNodeType() == 2) {
                    result.addAttribute(this.reader.getNamespaceURI(), this.reader.getLocalName(), this.reader.getQName(), null, this.reader.getNodeValue());
                    continue;
                }
                if (!this.checkSkipNext()) {
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public String getURI() {
        return this.reader.getNamespaceURI();
    }

    public String getLocalName() {
        return this.reader.getLocalName();
    }

    public String getQName() {
        return this.reader.getQName();
    }

    public CharArray getURICharArray() {
        return this.reader.getNamespaceURI0();
    }

    public CharArray getLocalNameCharArray() {
        return this.reader.getLocalName0();
    }

    public CharArray getQNameCharArray() {
        return this.reader.getQName0();
    }

    public CharArray getValueCharArray() {
        return this.reader.getNodeValue0();
    }

    public int getState() {
        return this.currentState;
    }

    public boolean isWhitespace() {
        return this.reader.getNodeValue0().isWhitespace();
    }

    public Element getDOMRepresentation(Document document) throws ParserException {
        if (this.getState() != 1) {
            return null;
        }
        return this.fillElement(document.createElementNS(this.getURI(), this.getQName()));
    }

    protected Element fillElement(Element element) throws ParserException {
        Attributes attributes = this.getAttributes();
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String attribUri = attributes.getURI(i);
            String attribQName = attributes.getQName(i);
            String attribValue = attributes.getValue(i);
            if (attribQName.indexOf(58) != -1) {
                element.setAttributeNS(attribUri, attribQName, attribValue);
            } else {
                element.setAttribute(attribQName, attribValue);
            }
            ++i;
        }
        while (true) {
            int state = this.next();
            switch (state) {
                case 5: {
                    element.appendChild(element.getOwnerDocument().createComment(this.getValue()));
                    break;
                }
                case 3: {
                    element.appendChild(element.getOwnerDocument().createTextNode(this.getValue()));
                    break;
                }
                case 1: {
                    Element child = element.getOwnerDocument().createElementNS(this.getURI(), this.getQName());
                    element.appendChild(this.fillElement(child));
                    break;
                }
                case 2: {
                    return element;
                }
                case 6: {
                    throw new ParserException("Unexpexted EOF.", 0, 0);
                }
            }
        }
    }

    public int moveToNextElementStart() throws ParserException {
        do {
            this.next();
        } while (this.currentState != 1 && this.currentState != 6);
        return this.currentState;
    }

    public void passChars() throws ParserException {
        while (this.currentState == 3) {
            this.next();
            this.checkSkipNext();
        }
    }

    public CharArray getValuePassCharsCA() throws ParserException {
        while (this.currentState == 3) {
            this.charData.append(this.reader.getNodeValue0());
            this.next();
            this.checkSkipNext();
        }
        return this.charData;
    }

    public String getValuePassChars() throws ParserException {
        return this.getValuePassCharsCA().getString();
    }

    public String getParentElement() {
        String result = null;
        if (!this.parentNodes.isEmpty()) {
            result = ((CharArray)this.parentNodes.peek()).getStringFast();
        }
        return result;
    }

    private boolean checkSkipNext() {
        this.skipNext = false;
        switch (this.reader.getNodeType()) {
            case 1: 
            case 3: 
            case 8: {
                this.skipNext = true;
            }
        }
        return this.skipNext;
    }

    public int getCurrentLevel() {
        return 0;
    }

    public void setEntityResolver(EntityResolver resolver) {
    }
}

