/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.readers;

import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.handlers.EncodingHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Encoding;
import com.sap.engine.lib.xml.parser.helpers.Entity;
import com.sap.engine.lib.xml.parser.helpers.IXMLStream;
import com.sap.engine.lib.xml.parser.helpers.UTF8Encoding;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.xml.sax.InputSource;

public final class SOAPXMLStream
implements IXMLStream {
    protected int pos = 0;
    protected int ext = 0;
    public boolean eos = false;
    protected int a1;
    protected int a2;
    protected int restBytes = 0;
    protected int totalRead = 0;
    protected CharArray id = null;
    protected CharArray name = null;
    protected int iRow = 1;
    protected int iCol = 1;
    protected boolean bLiteral = false;
    protected char lastchar;
    private int sid = -1;
    protected boolean bReadRaw = false;
    protected InputStream in = null;
    protected byte[] bytebuf = null;
    protected char[] buf = null;
    protected int idx = 0;
    protected int DEFAULT_EXT = 8192;
    int x1;
    XMLParser xmlparser = null;
    private static EncodingHandler encodingHandler = new EncodingHandler();
    protected static Encoding encoding = encodingHandler.getEncoding(UTF8Encoding.NAME);
    int cds1;

    public SOAPXMLStream() {
    }

    public SOAPXMLStream(XMLParser parent) {
        this.xmlparser = parent;
    }

    public void reuse() {
        this.pos = 0;
        this.ext = this.DEFAULT_EXT;
        this.eos = false;
        this.restBytes = 0;
        this.totalRead = 0;
        this.iRow = 1;
        this.iCol = 1;
        this.bLiteral = false;
        this.bReadRaw = false;
    }

    public char read() throws Exception {
        if (this.pos == this.restBytes) {
            this.fetchData();
        }
        if (this.eos) {
            if (this.xmlparser != null) {
                this.xmlparser.onDocumentEOF();
            }
            return '\u0000';
        }
        this.lastchar = this.buf[this.pos];
        ++this.pos;
        return this.lastchar;
    }

    /*
     * Unable to fully structure code
     */
    public int readData(int off, int len) throws IOException {
        bb = this.in.read(this.bytebuf, off, len - 6);
        if (bb == -1) {
            return -1;
        }
        i = 0;
        j = 0;
        ch = '\u0000';
        x = 0;
        while (i < bb) {
            block4: {
                x = this.bytebuf[i] & 255;
                if ((x & 128) != 0) ** GOTO lbl16
                this.buf[j] = (char)x;
                break block4;
lbl-1000:
                // 1 sources

                {
                    if (i != bb) continue;
                    this.bytebuf[i] = (byte)this.in.read();
                    ++bb;
lbl16:
                    // 3 sources

                    ** while ((ch = (char)SOAPXMLStream.encoding.process((byte)this.bytebuf[i++])) == '\ufffe')
                }
lbl17:
                // 1 sources

                --i;
                if (ch == '\uffffffff') {
                    throw new UnsupportedEncodingException("XMLParser: Unsupported Character");
                }
                this.buf[j] = ch;
            }
            ++j;
            ++i;
        }
        return j;
    }

    protected int getBufLen() {
        return this.buf.length;
    }

    public void setLastChar(int value) {
        this.lastchar = (char)value;
    }

    public char getLastChar() {
        return this.lastchar;
    }

    protected void fetchData() throws Exception {
        this.pos = 0;
        this.a1 = this.getBufLen() - this.pos;
        this.a2 = this.readData(this.pos, this.a1);
        if (this.a2 == -1) {
            this.eos = true;
            this.restBytes = 0;
        } else {
            this.restBytes = this.a2;
        }
    }

    public int getRow() {
        return this.iRow;
    }

    public int getCol() {
        return this.iCol;
    }

    public CharArray getID() {
        return this.id;
    }

    public int getRestBytes() {
        return this.restBytes;
    }

    public boolean getLiteral() {
        return this.bLiteral;
    }

    public void setLiteral(boolean value) {
        this.bLiteral = value;
    }

    public boolean isFinished() {
        return this.eos && this.restBytes <= 0;
    }

    public InputStream getInputStream() {
        return null;
    }

    public int getSID() {
        return this.sid;
    }

    public void setSID(int i) {
        this.sid = i;
    }

    public void setReadRaw(boolean b) {
        this.bReadRaw = b;
    }

    public void setName(CharArray name) {
        this.name = name.copy();
    }

    public CharArray getName() {
        return this.name;
    }

    public void setEncoding(CharArray enc) {
    }

    public boolean scanByte(char b) throws Exception {
        if (this.lastchar == b) {
            this.read();
            return true;
        }
        return false;
    }

    public boolean scanChars(char[] b) throws Exception {
        int l = b.length;
        if (l > 0 && b[0] != this.getLastChar()) {
            return false;
        }
        int i = 1;
        while (i < l) {
            if (b[i] != this.read()) {
                return false;
            }
            ++i;
        }
        this.read();
        return true;
    }

    public boolean scanString(String b) throws Exception {
        int l = b.length();
        if (l > 0 && b.charAt(0) != this.getLastChar()) {
            return false;
        }
        int i = 1;
        while (i < l) {
            if (b.charAt(i) != this.read()) {
                return false;
            }
            ++i;
        }
        this.read();
        return true;
    }

    public void addInputFromInputStream(InputStream in, CharArray id) throws Exception {
        this.reuse();
        this.in = in;
        if (this.buf == null) {
            this.buf = new char[this.DEFAULT_EXT];
            this.bytebuf = new byte[this.DEFAULT_EXT];
        }
        this.ext = this.DEFAULT_EXT;
        this.id = id;
        this.eos = false;
        this.read();
    }

    public void addInputSource(InputSource src) throws Exception {
        throw new Exception("not Supported");
    }

    public void addInputSource(InputSource src, CharArray id) throws Exception {
        throw new Exception("not Supported");
    }

    public void addInputFromCharArray(CharArray src, CharArray id) throws Exception {
        throw new Exception("not Supported");
    }

    public void addInputFromReader(Reader reader, CharArray id) throws Exception {
        throw new Exception("not Supported");
    }

    public void addInputFromEntity(Entity ent) throws Exception {
        throw new Exception("not Supported");
    }

    public int getSourceID() {
        return 1;
    }

    public boolean isFinished(int a) {
        return false;
    }

    public void clearFinished(int a) {
    }

    public void scanCharData(CharArray carr) throws Exception {
        char cs = this.getLastChar();
        carr.clear();
        carr.append(cs);
        int startPos = this.pos;
        switch (cs) {
            case '&': 
            case '<': {
                return;
            }
        }
        carr.fastAppend(cs);
        boolean i = false;
        do {
            if (this.pos != this.restBytes) continue;
            carr.append(this.buf, startPos, this.pos - startPos);
            this.fetchData();
            startPos = this.pos;
            if (!this.eos) continue;
            if (this.xmlparser != null) {
                this.xmlparser.onDocumentEOF();
            }
            return;
        } while ((cs = this.buf[this.pos++]) != '<' && cs != '&');
        this.lastchar = cs;
        carr.append(this.buf, startPos, this.pos - startPos - 1);
    }

    /*
     * Unable to fully structure code
     */
    public int checkName(CharArray chr) throws Exception {
        block8: {
            cn_data = chr.getData();
            cn_off = chr.getOffset();
            cn_i = cn_off + 1;
            cn_len = chr.length() + cn_off;
            colonChar = -1;
            if (cn_data[cn_off] != this.getLastChar()) {
                throw new ParserException("Document is not well-formed: Expected End-tag '" + chr + "', received:" + this.getLastChar() + ", on position: 0", this.getID(), this.getRow(), this.getCol());
            }
            if (this.restBytes - this.pos - 1 <= chr.length()) ** GOTO lbl24
            while (cn_i < cn_len) {
                if (cn_data[cn_i] != this.buf[this.pos++]) {
                    throw new ParserException("Document is not well-formed: Expected End-tag '" + chr + "', received:" + this.buf[this.pos - 1] + ", on position:" + cn_i, this.getID(), this.getRow(), this.getCol());
                }
                if (cn_data[cn_i] == ':') {
                    colonChar = cn_i;
                }
                ++cn_i;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                if (this.pos == this.restBytes) {
                    this.fetchData();
                    if (this.eos) {
                        throw new ParserException("Document EOF, while reading end tag: " + chr, this.getID(), this.getRow(), this.getCol());
                    }
                }
                if (cn_data[cn_i] != this.buf[this.pos++]) {
                    throw new ParserException("Document is not well-formed: Expected End-tag '" + chr + "', received:" + this.buf[this.pos - 1] + ", on position:" + cn_i, this.getID(), this.getRow(), this.getCol());
                }
                ++cn_i;
lbl24:
                // 2 sources

                ** while (cn_i < cn_len)
            }
        }
        this.lastchar = this.read();
        return colonChar;
    }

    public int scanName(CharArray chr) throws Exception {
        char ch;
        int colonChar = -1;
        boolean notdone = true;
        int startPos = this.pos;
        if (!Character.isLetter(this.lastchar) && this.lastchar != '_' && this.lastchar != ':') {
            throw new Exception("Bad start character of name");
        }
        chr.append(this.lastchar);
        block5: do {
            if (this.pos == this.restBytes) {
                chr.append(this.buf, startPos, this.pos - startPos);
                this.fetchData();
                startPos = this.pos;
                if (this.eos) {
                    return colonChar;
                }
            }
            if ((ch = this.buf[this.pos++]) >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') continue;
            switch (ch) {
                case ' ': 
                case '\"': 
                case '\'': 
                case '=': 
                case '>': {
                    notdone = false;
                    break;
                }
                case ':': {
                    colonChar = chr.length() + this.pos - startPos - 1;
                }
                case '-': 
                case '.': 
                case '_': 
                case '|': {
                    break;
                }
                default: {
                    if (Symbols.isLetterOrDigit(ch)) continue block5;
                    notdone = false;
                }
            }
        } while (notdone);
        this.lastchar = ch;
        chr.append(this.buf, startPos, this.pos - startPos - 1);
        return colonChar;
    }

    public boolean scanS() throws Exception {
        char ch_scans;
        if (!Symbols.isWhitespace(this.lastchar)) {
            return false;
        }
        while ((ch_scans = this.read()) == ' ' || ch_scans == '\r' || ch_scans == '\n' || ch_scans == '\t') {
        }
        return true;
    }

    public CharArray getEncoding() {
        return encoding.getName();
    }
}

