/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.helpers;

import com.sap.engine.lib.xml.parser.URLLoaderBase;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public final class Entity {
    private CharArray name = null;
    private CharArray publicId = null;
    private CharArray systemId = null;
    private CharArray value = null;
    private boolean pe;
    private CharArray note = null;
    private String urlString = null;
    private URLLoaderBase urlLoader = null;

    public Entity(CharArray name, CharArray value, boolean pe, URLLoaderBase urlLoader) {
        this.name = name.copy();
        this.value = value.copy();
        this.pe = pe;
        this.urlLoader = urlLoader;
    }

    public Entity(CharArray name, CharArray entvalue, boolean pe, CharArray publicId, CharArray systemId, CharArray note, URL baseURL, URLLoaderBase urlLoader) throws FileNotFoundException, IOException {
        this.name = name.copy();
        this.value = entvalue.copy();
        this.pe = pe;
        this.systemId = systemId.copy();
        this.publicId = publicId.copy();
        this.note = note.copy();
        this.urlString = this.isInternal() ? null : systemId.toString();
        this.urlLoader = urlLoader;
    }

    public CharArray getName() {
        return this.name;
    }

    public CharArray getPub() {
        return this.publicId == null ? CharArray.EMPTY : this.publicId;
    }

    public CharArray getSys() {
        return this.systemId == null ? CharArray.EMPTY : this.systemId;
    }

    public CharArray getValue() throws Exception {
        int a;
        if (this.isInternal()) {
            if (this.urlLoader != null) {
                this.urlLoader.pushTheSame();
            }
            return this.value;
        }
        InputStream in = this.urlLoader.loadAndPush(this.urlString).openStream();
        this.value.clear();
        while ((a = in.read()) != -1) {
            this.value.append((char)a);
        }
        in.close();
        return this.value;
    }

    public CharArray getNote() {
        return this.note;
    }

    public boolean isUnparsed() {
        return this.note != null && this.note.length() != 0;
    }

    public boolean isPE() {
        return this.pe;
    }

    public boolean isInternal() {
        return this.getSys().getSize() == 0;
    }

    public boolean isPredefined() {
        if (this.value.getSize() != 1) {
            return false;
        }
        return this.value.charAt(0) == '>' || this.value.charAt(0) == '<' || this.value.charAt(0) == '\'' || this.value.charAt(0) == '\"' || this.value.charAt(0) == '&';
    }
}

