/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.handlers;

import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.XMLParserConstants;
import com.sap.engine.lib.xml.parser.handlers.INamespaceHandler;
import com.sap.engine.lib.xml.parser.handlers.NamespaceEntry;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xslt.NamespaceManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class NamespaceHandler
implements INamespaceHandler {
    protected Vector ns = null;
    protected Hashtable hashns = null;
    public static final CharArray defaultPrefixName = new CharArray("<<<>>>");
    protected XMLParser parent = null;
    private NamespaceEntry neXML = new NamespaceEntry(XMLParserConstants.crXML, XMLParserConstants.caXMLNamespace);
    private NamespaceEntry neXMLNS = new NamespaceEntry(XMLParserConstants.caXMLNS, XMLParserConstants.crXMLNSNamespace);
    private NamespaceEntry neIsMappedRes = null;

    public NamespaceHandler(XMLParser parent) {
        this.ns = new Vector();
        this.hashns = new Hashtable();
        this.reuse(parent);
    }

    public INamespaceHandler reuse(XMLParser parent) {
        this.ns.clear();
        this.hashns.clear();
        this.parent = parent;
        this.hashns.put(XMLParserConstants.crXML, this.neXML);
        this.ns.add(this.neXML);
        this.hashns.put(XMLParserConstants.caXMLNS, this.neXMLNS);
        this.ns.add(this.neXMLNS);
        this.levelUp();
        this.levelUp();
        return this;
    }

    public void print() {
        ((NamespaceEntry)this.hashns.get(defaultPrefixName)).print();
    }

    public void addDefault(CharArray uri) {
        this.add(defaultPrefixName, uri.copy());
    }

    public CharArray getDefault() {
        return this.get(defaultPrefixName);
    }

    public CharArray get(CharArray prefix) {
        if (prefix == null || prefix.length() == 0) {
            return this.getDefault();
        }
        NamespaceEntry ne = (NamespaceEntry)this.hashns.get(prefix);
        return ne != null ? ne.getUri() : CharArray.EMPTY;
    }

    public CharArray getAttr(CharArray prefix) {
        NamespaceEntry ne = (NamespaceEntry)this.hashns.get(prefix);
        return ne != null ? ne.getUri() : CharArray.EMPTY;
    }

    public void add(CharArray prefix, CharArray uri) {
        NamespaceEntry ne;
        NamespaceEntry neout;
        if (!prefix.getStatic()) {
            prefix = prefix.copy();
        }
        if (!uri.getStatic()) {
            uri = uri.copy();
        }
        if ((neout = this.hashns.put(prefix, ne = new NamespaceEntry(prefix, uri))) != null) {
            // empty if block
        }
        if (neout != null) {
            ne.setPrevNamespace(neout);
            this.ns.removeElement(neout);
        }
        this.ns.add(ne);
    }

    public void levelUp() {
        int i = 0;
        while (i < this.ns.size()) {
            ((NamespaceEntry)this.ns.get(i)).levelUp();
            ++i;
        }
    }

    public void levelDown() throws Exception {
        int i = 0;
        while (i < this.ns.size()) {
            NamespaceEntry nsent = (NamespaceEntry)this.ns.get(i);
            boolean changedMapping = nsent.levelDown();
            if (this.parent != null && changedMapping) {
                this.parent.changingMapping(nsent.getPrefix(), nsent.getUri());
            }
            if (!((NamespaceEntry)this.ns.get(i)).isValid()) {
                CharArray pref;
                CharArray pref2 = pref = ((NamespaceEntry)this.ns.get(i)).getPrefix();
                if (pref == defaultPrefixName) {
                    pref2 = CharArray.EMPTY;
                }
                if (this.parent != null) {
                    this.parent.endPrefixMapping(pref2);
                }
                this.hashns.remove(pref);
                this.ns.removeElementAt(i);
                --i;
            }
            ++i;
        }
    }

    public void findNamespaceNodes(Element el, NamespaceManager nsmanager) {
        NamedNodeMap nm = el.getAttributes();
        int i = 0;
        while (i < nm.getLength()) {
            Attr attr = (Attr)nm.item(i);
            String prefix = attr.getPrefix();
            if (prefix == null) {
                prefix = "";
            }
            if (prefix.equals("xmlns")) {
                this.add(new CharArray(attr.getLocalName()), new CharArray(attr.getValue()));
                if (nsmanager != null) {
                    nsmanager.put(attr.getValue());
                }
            } else if (prefix.length() == 0 && attr.getLocalName().equals("xmlns")) {
                this.addDefault(new CharArray(attr.getValue()));
                if (nsmanager != null) {
                    nsmanager.put(attr.getValue());
                }
            }
            ++i;
        }
    }

    public CharArray isMapped(CharArray prefix) throws Exception {
        if (prefix != null && prefix.length() > 0 && !prefix.equals("xmlns")) {
            this.neIsMappedRes = (NamespaceEntry)this.hashns.get(prefix);
            if (this.neIsMappedRes != null) {
                return this.neIsMappedRes.getUri();
            }
            throw new Exception("XMLParser: Prefix '" + prefix + "' is not mapped to a namespace");
        }
        return this.getDefault();
    }

    public CharArray isMappedAttr(CharArray prefix) throws Exception {
        if (prefix != null && prefix.length() > 0) {
            this.neIsMappedRes = (NamespaceEntry)this.hashns.get(prefix);
            if (this.neIsMappedRes != null) {
                return this.neIsMappedRes.getUri();
            }
            throw new Exception("XMLParser: Prefix '" + prefix + "' is not mapped to a namespace");
        }
        return CharArray.EMPTY;
    }

    public Hashtable getNamespaceMappings() {
        Hashtable<String, String> mappings = new Hashtable<String, String>();
        Enumeration prefixesEnum = this.hashns.keys();
        while (prefixesEnum.hasMoreElements()) {
            Object prefix = prefixesEnum.nextElement();
            NamespaceEntry nsEntry = (NamespaceEntry)this.hashns.get(prefix);
            mappings.put(prefix.equals(defaultPrefixName.getString()) ? "" : prefix, nsEntry.uri.getString());
        }
        return mappings;
    }
}

