/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.binary.transformers;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.xml.parser.binary.BinaryXmlWriter;
import com.sap.engine.lib.xml.parser.binary.exceptions.XmlBinaryException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomToBinTransformer {
    public static PrintStream out;

    public static void main(String[] args) {
        new DomToBinTransformer().transform(args[0], args[1]);
    }

    public void transform(String path, String target) {
        try {
            BinaryXmlWriter writer = new BinaryXmlWriter(new FileOutputStream(target));
            DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
            Document doc = builder.parse(path);
            Element root = doc.getDocumentElement();
            this.browseElement(writer, root);
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void browseElement(BinaryXmlWriter writer, Node node) throws XmlBinaryException, IOException {
        String localName = node.getLocalName();
        String ns = node.getNamespaceURI();
        String prefix = node.getPrefix();
        short type = node.getNodeType();
        if (type == 1 || type == 9) {
            if (ns != null && !ns.equals("") && prefix != null && !prefix.equals("")) {
                writer.writeStartElement(localName, ns);
            } else {
                writer.writeStartElement(localName);
            }
        } else {
            if (type == 3) {
                writer.writeString(node.getNodeValue());
                return;
            }
            if (type == 8) {
                writer.writeComment(node.getNodeValue());
                return;
            }
        }
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            localName = attribute.getLocalName();
            ns = attribute.getNamespaceURI();
            String value = attribute.getNodeValue();
            if (ns != null && !ns.equals("")) {
                writer.writeAttribute(localName, ns, value);
            } else {
                writer.writeAttribute(localName, value);
            }
            ++i;
        }
        NodeList childs = node.getChildNodes();
        int i2 = 0;
        while (i2 < childs.getLength()) {
            Node child = childs.item(i2);
            this.browseElement(writer, child);
            ++i2;
        }
        writer.writeEndElement();
    }
}

