/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.identity;

import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.validator.ValidationContext;
import com.sap.engine.lib.schema.validator.identity.AbstractIdentityConstraintDefinitionValidator;
import com.sap.engine.lib.schema.validator.identity.FieldsStructure;

class KeyIdentityConstraintDefinitionValidator
extends AbstractIdentityConstraintDefinitionValidator {
    KeyIdentityConstraintDefinitionValidator(IdentityConstraintDefinition identityConstrDef, ValidationContext context) {
        super(identityConstrDef, context);
    }

    public boolean validate() {
        int structuresCount = this.fieldsStructuresCollector.size();
        int i = 0;
        while (i < structuresCount - 1) {
            FieldsStructure structure = (FieldsStructure)this.fieldsStructuresCollector.get(i);
            if (structure.isInitialized()) {
                int j = i + 1;
                while (j < structuresCount) {
                    FieldsStructure structureToMatch = (FieldsStructure)this.fieldsStructuresCollector.get(j);
                    if (structureToMatch.isInitialized()) {
                        if (structure.match(structureToMatch)) {
                            this.context.addError_Identity("the combination of the element information items " + structureToMatch.getRepresentation() + " has to be unique accordng to the key identity constraint definition {" + this.identityConstrDef.getTargetNamespace() + "}:" + this.identityConstrDef.getName() + ".");
                            return false;
                        }
                    } else {
                        this.context.addError_Identity("the combination of the element information items " + structureToMatch.getRepresentation() + " which are represented by the key identity constraint definition with {" + this.identityConstrDef.getTargetNamespace() + "}:" + this.identityConstrDef.getName() + " has to be present.");
                        return false;
                    }
                    ++j;
                }
            } else {
                this.context.addError_Identity("the combination of the element information items " + structure.getRepresentation() + " which are represented by the key identity constraint definition with {" + this.identityConstrDef.getTargetNamespace() + "}:" + this.identityConstrDef.getName() + " has to be present.");
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean contains(FieldsStructure structure) {
        if (!structure.isInitialized()) {
            return false;
        }
        int i = 0;
        while (i < this.fieldsStructuresCollector.size()) {
            FieldsStructure ownStructure = (FieldsStructure)this.fieldsStructuresCollector.get(i);
            if (ownStructure.isInitialized() && ownStructure.match(structure)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

