/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.components.AttributeDeclaration;
import com.sap.engine.lib.schema.components.AttributeUse;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.FundamentalFacets;
import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.components.Loader;
import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.ModelGroupDefinition;
import com.sap.engine.lib.schema.components.Particle;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.schema.components.impl.LoaderImpl;
import com.sap.engine.lib.schema.components.impl.ffacets.Value;
import com.sap.engine.lib.schema.components.impl.ffacets.ValueComparator;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.exception.SchemaException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.schema.validator.SimpleTypeValidator;
import com.sap.engine.lib.schema.validator.ValidationContext;
import com.sap.engine.lib.schema.validator.automat.ContentAutomat;
import com.sap.engine.lib.schema.validator.automat.DescendentMappingStructure;
import com.sap.engine.lib.schema.validator.tokenizer.AttributeStructure;
import com.sap.engine.lib.schema.validator.tokenizer.XMLDOMTokenizer;
import com.sap.engine.lib.schema.validator.tokenizer.XMLSAXTokenizer;
import com.sap.engine.lib.schema.validator.tokenizer.XMLToken;
import com.sap.engine.lib.schema.validator.tokenizer.XMLTokenizer;
import com.sap.engine.lib.xml.dom.Base;
import com.sap.engine.lib.xml.dom.NodeImpl;
import com.sap.engine.lib.xml.parser.ActiveXMLParser;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class Validator
implements Constants {
    private Loader loader;
    private SchemaImpl externalSchema;
    private EntityResolver resolver;
    private String errorsRepresentation;
    private boolean canonicalizationProcessing;

    public Validator(Loader loader) {
        this.loader = loader;
    }

    public Validator() throws SchemaException {
        this.loader = new LoaderImpl();
    }

    public void setCanonicalizationProcessing(boolean canonicalizationProcessing) {
        this.canonicalizationProcessing = canonicalizationProcessing;
    }

    public boolean getCanonicalizationProcessing() {
        return this.canonicalizationProcessing;
    }

    public void setLoader(Loader loader) {
        this.loader = loader;
    }

    public Loader getLoader() {
        return this.loader;
    }

    public String getErrorsRepresentation() {
        return this.errorsRepresentation;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.resolver = resolver;
        this.loader.setEntityResolver(resolver);
    }

    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    public void setExternalSchema(String[] targetNamespaces, String[] schemaLocations) throws SchemaException {
        this.externalSchema = (SchemaImpl)this.loader.load(targetNamespaces, schemaLocations);
    }

    public void setExternalNoNamespaceSchema(String schemaLocation) throws SchemaException {
        this.externalSchema = (SchemaImpl)this.loader.load(schemaLocation);
    }

    public void setExternalSchema(Object schemaSource) throws SchemaException {
        this.externalSchema = (SchemaImpl)this.loader.load(schemaSource);
    }

    public void setExternalSchema(Schema externalSchema) {
        this.externalSchema = (SchemaImpl)externalSchema;
    }

    public Schema getExternalSchema() {
        return this.externalSchema;
    }

    public boolean validate(String xmlFile, String xsdFile) throws SchemaException {
        return this.validate(this.createTokenizer(this.retriveInputSource(xmlFile)), this.loader.load(xsdFile));
    }

    public boolean validate(String xmlFile, String[] xsdFiles) throws SchemaException {
        return this.validate(this.createTokenizer(this.retriveInputSource(xmlFile)), this.loader.load(xsdFiles));
    }

    public boolean validate(String xmlFile, Schema schema) throws SchemaException {
        return this.validate(this.createTokenizer(this.retriveInputSource(xmlFile)), schema);
    }

    public boolean validate(String xmlFile, Schema[] schemas) throws SchemaException {
        return this.validate(this.createTokenizer(this.retriveInputSource(xmlFile)), this.loader.load(schemas));
    }

    public boolean validate(String xmlFile, InputSource xsdSource) throws SchemaException {
        return this.validate(this.createTokenizer(this.retriveInputSource(xmlFile)), this.loader.load(xsdSource));
    }

    public boolean validate(String xmlFile, InputSource[] xsdSources) throws SchemaException {
        return this.validate(this.createTokenizer(this.retriveInputSource(xmlFile)), this.loader.load(xsdSources));
    }

    public boolean validate(String xmlFile, Node xsdDomTree) throws SchemaException {
        return this.validate(this.createTokenizer(this.retriveInputSource(xmlFile)), this.loader.load(xsdDomTree));
    }

    public boolean validate(String xmlFile, Node[] xsdDomTrees) throws SchemaException {
        return this.validate(this.createTokenizer(this.retriveInputSource(xmlFile)), this.loader.load(xsdDomTrees));
    }

    public boolean validate(String xmlFile) throws SchemaException {
        return this.validate(this.createTokenizer(this.retriveInputSource(xmlFile)));
    }

    public boolean validate(InputStream xmlInputStream, String xsdFile) throws SchemaException {
        return this.validate(new XMLSAXTokenizer(new ActiveXMLParser(xmlInputStream)), this.loader.load(xsdFile));
    }

    public boolean validate(InputStream xmlInputStream, String[] xsdFiles) throws SchemaException {
        return this.validate(new XMLSAXTokenizer(xmlInputStream), this.loader.load(xsdFiles));
    }

    public boolean validate(InputStream xmlInputStream, Schema schema) throws SchemaException {
        return this.validate(new XMLSAXTokenizer(xmlInputStream), schema);
    }

    public boolean validate(InputStream xmlInputStream, Schema[] schemas) throws SchemaException {
        return this.validate(new XMLSAXTokenizer(xmlInputStream), this.loader.load(schemas));
    }

    public boolean validate(InputStream xmlInputStream, InputSource xsdSource) throws SchemaException {
        return this.validate(new XMLSAXTokenizer(xmlInputStream), this.loader.load(xsdSource));
    }

    public boolean validate(InputStream xmlInputStream, InputSource[] xsdSources) throws SchemaException {
        return this.validate(new XMLSAXTokenizer(xmlInputStream), this.loader.load(xsdSources));
    }

    public boolean validate(InputStream xmlInputStream, Node xsdDomTree) throws SchemaException {
        return this.validate(new XMLSAXTokenizer(xmlInputStream), this.loader.load(xsdDomTree));
    }

    public boolean validate(InputStream xmlInputStream, Node[] xsdDomTrees) throws SchemaException {
        return this.validate(new XMLSAXTokenizer(xmlInputStream), this.loader.load(xsdDomTrees));
    }

    public boolean validate(InputStream xmlInputStream) throws SchemaException {
        return this.validate(new XMLSAXTokenizer(xmlInputStream));
    }

    public boolean validate(Node xmlNode, String xsdFile) throws SchemaException {
        return this.validate(new XMLDOMTokenizer(xmlNode), this.loader.load(xsdFile));
    }

    public boolean validate(Node xmlNode, String[] xsdFiles) throws SchemaException {
        return this.validate(new XMLDOMTokenizer(xmlNode), this.loader.load(xsdFiles));
    }

    public boolean validate(Node xmlNode, Schema schema) throws SchemaException {
        return this.validate(new XMLDOMTokenizer(xmlNode), schema);
    }

    public boolean validate(Node xmlNode, Schema[] schemas) throws SchemaException {
        return this.validate(new XMLDOMTokenizer(xmlNode), this.loader.load(schemas));
    }

    public boolean validate(Node xmlNode, InputSource xsdSource) throws SchemaException {
        return this.validate(new XMLDOMTokenizer(xmlNode), this.loader.load(xsdSource));
    }

    public boolean validate(Node xmlNode, InputSource[] xsdSources) throws SchemaException {
        return this.validate(new XMLDOMTokenizer(xmlNode), this.loader.load(xsdSources));
    }

    public boolean validate(Node xmlNode, Node xsdDomTree) throws SchemaException {
        return this.validate(new XMLDOMTokenizer(xmlNode), this.loader.load(xsdDomTree));
    }

    public boolean validate(Node xmlNode, Node[] xsdDomTrees) throws SchemaException {
        return this.validate(new XMLDOMTokenizer(xmlNode), this.loader.load(xsdDomTrees));
    }

    public boolean validate(Node xmlNode) throws SchemaException {
        return this.validate(new XMLDOMTokenizer(xmlNode));
    }

    public boolean validate(InputSource xmlSource, String xsdFile) throws SchemaException {
        return this.validate(this.createTokenizer(xmlSource), this.loader.load(xsdFile));
    }

    public boolean validate(InputSource xmlSource, String[] xsdFiles) throws SchemaException {
        return this.validate(this.createTokenizer(xmlSource), this.loader.load(xsdFiles));
    }

    public boolean validate(InputSource xmlSource, Schema schema) throws SchemaException {
        return this.validate(this.createTokenizer(xmlSource), schema);
    }

    public boolean validate(InputSource xmlSource, Schema[] schemas) throws SchemaException {
        return this.validate(this.createTokenizer(xmlSource), this.loader.load(schemas));
    }

    public boolean validate(InputSource xmlSource, InputSource xsdSource) throws SchemaException {
        return this.validate(this.createTokenizer(xmlSource), this.loader.load(xsdSource));
    }

    public boolean validate(InputSource xmlSource, InputSource[] xsdSources) throws SchemaException {
        return this.validate(this.createTokenizer(xmlSource), this.loader.load(xsdSources));
    }

    public boolean validate(InputSource xmlSource, Node xsdDomTree) throws SchemaException {
        return this.validate(this.createTokenizer(xmlSource), this.loader.load(xsdDomTree));
    }

    public boolean validate(InputSource xmlSource, Node[] xsdDomTrees) throws SchemaException {
        return this.validate(this.createTokenizer(xmlSource), this.loader.load(xsdDomTrees));
    }

    public boolean validate(InputSource xmlSource) throws SchemaException {
        return this.validate(this.createTokenizer(xmlSource));
    }

    public boolean validate(XMLTokenizer tokenizer, Schema schema) throws SchemaException {
        XMLToken token = tokenizer.next();
        ValidationContext context = new ValidationContext(schema, tokenizer);
        ElementDeclaration elemDeclaration = schema.getTopLevelElementDeclaration(token.getUri(), token.getLocalName());
        this.errorsRepresentation = null;
        boolean result = this.validateElementDeclaration(elemDeclaration, token, false, context, null) && context.validateRegisteredValuesForIdentityValidation_ID_IDREF_IDREFS();
        this.errorsRepresentation = context.getErrorsRepresentation();
        return result;
    }

    private boolean validateElementDeclaration(ElementDeclaration elemDeclaration, XMLToken start, boolean isSubstitution, ValidationContext context, ModelGroup modelGroup_All) throws SchemaException {
        String valueConstraint;
        String qName = start.getQName();
        String uri = start.getUri();
        String localName = start.getLocalName();
        String xsiNil = start.getXsiNill();
        boolean isNillable = xsiNil != null && xsiNil.equals("true");
        Vector attribStrucsCollector = start.getAttribsCollector();
        String xsiTypeName = start.getXsiTypeName();
        String xsiTypeUri = start.getXsiTypeUri();
        boolean hasChildren = context.peekXMLToken().isStratingMark();
        NodeImpl node = start.getNode();
        context.updateXPath_Start(qName, localName, uri);
        TypeDefinitionBase typeDefBase = null;
        boolean isNillableElemDeclaration = false;
        String valueConstraintFixed = null;
        String valueConstraintDefault = null;
        IdentityConstraintDefinition[] identConstrDefinitions = null;
        if (elemDeclaration != null) {
            boolean disallowedExtension;
            if (isSubstitution) {
                ElementDeclaration headElemDeclaration = elemDeclaration.getSubstitutionGroupAffiliation();
                boolean disallowedRestriction = headElemDeclaration.isDisallowedSubstitutionRestriction();
                disallowedExtension = headElemDeclaration.isDisallowedSubstitutionExtension();
                TypeDefinitionBase headElemDeclrTypeDef = headElemDeclaration.getTypeDefinition();
                if (headElemDeclrTypeDef instanceof ComplexTypeDefinition) {
                    disallowedRestriction = disallowedRestriction || ((ComplexTypeDefinition)headElemDeclrTypeDef).isProhibitedSubstitutionRestriction();
                    boolean bl = disallowedExtension = disallowedExtension || ((ComplexTypeDefinition)headElemDeclrTypeDef).isProhibitedSubstitutionExtension();
                }
                if (!elemDeclaration.getTypeDefinition().isDerivedFrom(headElemDeclrTypeDef, disallowedRestriction, disallowedExtension)) {
                    this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' is associated with element declaration which is a substitution, but the head element declaration type definition is not validly derived from it's type definition according to the (dissawoled substitution) property of the head element declaration.", null, qName, uri);
                    return false;
                }
                if (headElemDeclaration.isDisallowedSubstitutionSubstitution()) {
                    this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' is associated with element declaration which is a substitution, but the head element declaration has a 'substitution' blocking constraint.", null, qName, uri);
                    return false;
                }
            }
            if (elemDeclaration.isAbstract()) {
                this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' is associated with element declaration whose {abstract} property is set to'true'.", null, qName, uri);
                return false;
            }
            identConstrDefinitions = elemDeclaration.getIdentityConstraintDefinitionsArray();
            typeDefBase = elemDeclaration.getTypeDefinition();
            isNillableElemDeclaration = elemDeclaration.isNillable();
            valueConstraintFixed = elemDeclaration.getValueConstraintFixed();
            valueConstraintDefault = elemDeclaration.getValueConstraintDefault();
            if (xsiTypeName != null) {
                TypeDefinitionBase xsiTypeDefBase = context.getSchema().getTopLevelTypeDefinition(xsiTypeUri, xsiTypeName);
                if (xsiTypeDefBase == null) {
                    this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' has an attribute information item among the element information item's [attributes] whose [namespace name] is identical to http://www.w3.org/2001/XMLSchema-instance and whose [local name] is type, and the \u00b7local name\u00b7 and \u00b7namespace name\u00b7 of the \u00b7actual value\u00b7 of that attribute information item must resolve to a type definition.", null, qName, uri);
                    return false;
                }
                boolean disalloedRestriction = elemDeclaration.isDisallowedSubstitutionRestriction();
                disallowedExtension = elemDeclaration.isDisallowedSubstitutionExtension();
                if (typeDefBase instanceof ComplexTypeDefinition) {
                    disalloedRestriction = disalloedRestriction || ((ComplexTypeDefinition)typeDefBase).isProhibitedSubstitutionRestriction();
                    boolean bl = disallowedExtension = disallowedExtension || ((ComplexTypeDefinition)typeDefBase).isProhibitedSubstitutionExtension();
                }
                if (!xsiTypeDefBase.isDerivedFrom(typeDefBase, disalloedRestriction, disallowedExtension)) {
                    this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' has an attribute information item among the element information item's [attributes] whose [namespace name] is identical to http://www.w3.org/2001/XMLSchema-instance and whose [local name] is type, and the \u00b7local type definition\u00b7 must be validly derived from the {type definition} given the union of the {disallowed substitutions}.", null, qName, uri);
                    return false;
                }
                typeDefBase = xsiTypeDefBase;
            }
        } else if (xsiTypeName != null && (typeDefBase = context.getSchema().getTopLevelTypeDefinition(xsiTypeUri, xsiTypeName)) == null) {
            this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' has an attribute information item among the element information item's [attributes] whose [namespace name] is identical to http://www.w3.org/2001/XMLSchema-instance and whose [local name] is type, and the \u00b7local name\u00b7 and \u00b7namespace name\u00b7 of the \u00b7actual value\u00b7 of that attribute information item must resolve to a type definition.", null, qName, uri);
            return false;
        }
        if (typeDefBase == null) {
            this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' is not associated with element declaration and do not has an attribute information item among the element information item's [attributes] whose [namespace name] is identical to http://www.w3.org/2001/XMLSchema-instance and whose [local name] is type.", identConstrDefinitions, qName, uri);
            return false;
        }
        if (isNillableElemDeclaration) {
            if (isNillable && hasChildren) {
                this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' has an attribute information item among the element information item's [attributes] whose [namespace name] is identical to http://www.w3.org/2001/XMLSchema-instance and whose [local name] is nil, and whose value is true, and that element information item is associated with element declaration, whose {nillable} is true, the element information item must have no character or element information item [children].", identConstrDefinitions, qName, uri);
                return false;
            }
        } else if (xsiNil != null) {
            this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' has an attribute information item is is associated with element declaration, whose {nillable} is false, among the element information item's [attributes] must not be one whose [namespace name] is identical to http://www.w3.org/2001/XMLSchema-instance and whose [local name] is nil.", identConstrDefinitions, qName, uri);
            return false;
        }
        ComplexTypeDefinition complTypeDef = null;
        SimpleTypeDefinition simpleTypeDef = null;
        if (typeDefBase instanceof ComplexTypeDefinition) {
            complTypeDef = (ComplexTypeDefinition)typeDefBase;
            if (!isNillable) {
                if (identConstrDefinitions != null) {
                    context.activateIdentConstrDefinitionsProcessing(identConstrDefinitions);
                }
                if (!this.validateComplexTypeDefinition(complTypeDef, context, attribStrucsCollector)) {
                    this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' is not valid with respect to it's complex type definition..", identConstrDefinitions, qName, uri);
                    return false;
                }
            }
            simpleTypeDef = complTypeDef.getContentTypeSimpleTypeDefinition();
        } else {
            if (attribStrucsCollector != null && attribStrucsCollector.size() != 0) {
                this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' is not valid, because it is declared to be with simple type definition and it's [attributes] must be empty, excepting those whose [namespace name] is identical to http://www.w3.org/2001/XMLSchema-instance and whose [local name] is one of type, nil, schemaLocation or noNamespaceSchemaLocation.", identConstrDefinitions, qName, uri);
                return false;
            }
            simpleTypeDef = (SimpleTypeDefinition)typeDefBase;
        }
        XMLToken end = context.peekXMLToken();
        String value = end.getValue();
        if (isNillable && !value.equals("")) {
            this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' has an attribute information item among the element information item's [attributes] whose [namespace name] is identical to http://www.w3.org/2001/XMLSchema-instance and whose [local name] is nil, and whose value is true, and that element information item is associated with element declaration, whose {nillable} is true, the element information item must have no character or element information item [children].", identConstrDefinitions, qName, uri);
            return false;
        }
        String string = valueConstraint = (valueConstraintFixed != null || valueConstraintDefault != null) && valueConstraintFixed == null ? valueConstraintDefault : valueConstraintFixed;
        if (complTypeDef != null) {
            if (simpleTypeDef != null) {
                if (hasChildren) {
                    this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' is associated with element declaration, whose {content type} is a simple type definition and then this element information item must not has any element information item [children].", identConstrDefinitions, qName, uri);
                    return false;
                }
            } else if (complTypeDef.isMixed()) {
                if (valueConstraintFixed != null) {
                    if (!valueConstraintFixed.equals(value)) {
                        this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' is associated with element declaration which has fixed {value constraint} and mixed content is detected, the fixed constraint value must be identical to the value of the item.", identConstrDefinitions, qName, uri);
                        return false;
                    }
                    if (hasChildren) {
                        this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' is associated with element declaration which has fixed {value constraint} and simple content is detected, that item must not have ant [children] element information items.", identConstrDefinitions, qName, uri);
                        return false;
                    }
                }
                if (!context.registerValueForIdentityValidation(null, Tools.normalizeValue(value, "replace"), isNillable)) {
                    context.addError_Data("information item '" + context.getXPath() + "' is not valid with respect to the identity constraints.");
                    return false;
                }
            } else if (!value.trim().equals("")) {
                this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' is associated with element declaration, whose {content type} is element-only and then this element information item must not has any character information item [children] other than those whose [character code] is defined as a white space.", identConstrDefinitions, qName, uri);
                return false;
            }
        }
        if (simpleTypeDef != null) {
            if (valueConstraint != null && value.equals("")) {
                Value ffactesValue = null;
                FundamentalFacets ffacets = simpleTypeDef.getFundamentalFacets();
                if (ffacets != null) {
                    ffactesValue = ffacets.parse(valueConstraint);
                }
                if (!this.validateSimpleTypeDefinition(simpleTypeDef, context, ffactesValue, valueConstraint, false, null)) {
                    this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' is associated element declaration has a {value constraint} and it's {nillable} is set to 'false', the item has neither element nor character [children] and element does not contain an attribute information item whose [namespace name] is identical to http://www.w3.org/2001/XMLSchema-instance and whose [local name] is nil and the type definition is complex with simple content or simple, the value constraint must be valid with respect to the correspondig simple type definition.", identConstrDefinitions, qName, uri);
                    return false;
                }
            } else if (!isNillable && !this.validateData(value, simpleTypeDef, valueConstraintFixed, context, isNillableElemDeclaration, node)) {
                this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' is associated with invalid data.", identConstrDefinitions, qName, uri);
                return false;
            }
        }
        if (identConstrDefinitions != null && identConstrDefinitions.length != 0) {
            if (!context.validateRegisteredValuesForIdentityValidation_IdentityConstraintDefinitions(identConstrDefinitions)) {
                this.process_ElementDeclaration_Error(context, "element information item '" + context.getXPath() + "' is is not valid with respect to it's identity constraint definitions", identConstrDefinitions, qName, uri);
                return false;
            }
            context.inactivateIdentConstrDefinitionsProcessing(identConstrDefinitions);
        }
        context.updateXPath_End();
        if (this.canonicalizationProcessing) {
            node.setAugmentation("[type definition]", typeDefBase);
            node.setAugmentation("[element declaration]", elemDeclaration);
            node.setAugmentation("[annotation]", elemDeclaration != null ? elemDeclaration.getAnnotation() : null);
            node.setAugmentation("[validating model group all]", modelGroup_All);
            NamedNodeMap namedNodeMap = node.getAttributes();
            int i = 0;
            while (i < namedNodeMap.getLength()) {
                NodeImpl attr = (NodeImpl)namedNodeMap.item(i);
                if (attr.getAugmentation("[validation attempted]") == null) {
                    node.setAugmentation("[validation attempted]", "partial");
                    break;
                }
                ++i;
            }
            if (node.getAugmentation("[validation attempted]") == null) {
                NodeList nodeList = node.getChildNodes();
                int i2 = 0;
                while (i2 < nodeList.getLength()) {
                    Base childNode = (Base)nodeList.item(i2);
                    if (childNode instanceof Element && childNode.getAugmentation("[validation attempted]") == null) {
                        node.setAugmentation("[validation attempted]", "partial");
                        break;
                    }
                    ++i2;
                }
            }
            if (node.getAugmentation("[validation attempted]") == null) {
                node.setAugmentation("[validation attempted]", "full");
            }
        }
        return true;
    }

    private boolean validateData(String value, SimpleTypeDefinition simpleTypeDef, String fixedValueContsraint, ValidationContext context, boolean isNillable, NodeImpl node) throws SchemaException {
        String normalizedValue = !simpleTypeDef.isVarietyUnion() ? Tools.normalizeValue(value, simpleTypeDef.getWhiteSpaceNormalizationValue()) : value;
        Value ffacetsValue = null;
        FundamentalFacets ffacets = simpleTypeDef.getFundamentalFacets();
        if (ffacets != null) {
            ffacetsValue = ffacets.parse(normalizedValue);
        }
        if (!this.validateSimpleTypeDefinition(simpleTypeDef, context, ffacetsValue, normalizedValue, false, node)) {
            context.addError_Data("information item '" + context.getXPath() + "' is is not valid with respoct to the corresponding simple type definition.");
            return false;
        }
        if (fixedValueContsraint != null && ffacets != null && ValueComparator.compare(ffacetsValue, ffacets.parse(fixedValueContsraint)) != 1) {
            context.addError_Data("information item '" + context.getXPath() + "' is associated with declaration with non absent fixed {value constraint}, and if the {content type} of the type definition is a simple type definition, then the actual value of the item must match the canonical representation of the {value constraint} value.");
            return false;
        }
        if (!context.registerValueForIdentityValidation(simpleTypeDef, normalizedValue, isNillable)) {
            context.addError_Data("information item '" + context.getXPath() + "' is not valid with respect to the identity constraints.");
            return false;
        }
        if (this.canonicalizationProcessing) {
            node.setAugmentation("[normalized value]", value);
            node.setAugmentation("[schema normalized value]", normalizedValue);
        }
        return true;
    }

    private void process_ElementDeclaration_Error(ValidationContext context, String errorMessage, IdentityConstraintDefinition[] identConstrDefinitions, String qName, String uri) {
        context.addError_Element(errorMessage);
        if (identConstrDefinitions != null) {
            context.inactivateIdentConstrDefinitionsProcessing(identConstrDefinitions);
        }
        context.updateXPath_Error(qName, uri);
    }

    private boolean validateComplexTypeDefinition(ComplexTypeDefinition complTypeDef, ValidationContext context, Vector attribStrucsCollector) throws SchemaException {
        ContentAutomat contentAutomat = context.useContentAutomat(complTypeDef);
        int startsCounter = 0;
        while (true) {
            XMLToken token;
            if ((token = context.peekXMLToken()).isStratingMark()) {
                com.sap.engine.lib.schema.components.Base base;
                String localName;
                context.nextXMLToken();
                ++startsCounter;
                String uri = token.getUri();
                DescendentMappingStructure structure = contentAutomat.switchState(uri, localName = token.getLocalName());
                if (!(structure == null ? !this.validateElementDeclaration(null, token, false, context, null) : ((base = structure.getBase()) instanceof Wildcard ? !this.validateWildcard((Wildcard)base, token, context) : !this.validateElementDeclaration((ElementDeclaration)base, token, structure.isSubstitution(), context, structure.getScopeModelGroupAll())))) continue;
                return false;
            }
            if (startsCounter <= 0) break;
            context.nextXMLToken();
            --startsCounter;
        }
        if (!contentAutomat.isInFinalState()) {
            context.addError_ComplexType("complex content is not satisfied.");
            return false;
        }
        context.reuseContentAutomat(contentAutomat, complTypeDef);
        Wildcard wildcard = complTypeDef.getAttributeWildcard();
        Vector attribUsesCollector = new Vector();
        complTypeDef.getAttributeUses(attribUsesCollector);
        int i = 0;
        while (i < attribStrucsCollector.size()) {
            AttributeStructure attribStructure = (AttributeStructure)attribStrucsCollector.get(i);
            String attribUri = attribStructure.getUri();
            String attribName = attribStructure.getLocalName();
            AttributeDeclaration validationAttribDeclaration = null;
            String attribUseFixedValueConstraint = null;
            int j = 0;
            while (j < attribUsesCollector.size()) {
                AttributeUse attribUse = (AttributeUse)attribUsesCollector.get(j);
                AttributeDeclaration attribDeclaration = attribUse.getAttributeDeclaration();
                if (attribUri.equals(attribDeclaration.getTargetNamespace()) && attribName.equals(attribDeclaration.getName())) {
                    validationAttribDeclaration = attribDeclaration;
                    attribUseFixedValueConstraint = attribUse.getValueConstraintFixed();
                    attribUsesCollector.remove(j);
                    break;
                }
                ++j;
            }
            context.addStep("@" + attribName, attribUri);
            if (validationAttribDeclaration != null) {
                if (!this.validateAttributeDeclaration(validationAttribDeclaration, context, attribStructure, attribUseFixedValueConstraint)) {
                    context.addError_ComplexType("attribute '" + context.getXPath() + "' is not valid with respect to it's attribute declaration.");
                    context.removeStep();
                    return false;
                }
            } else if (wildcard != null) {
                if (!this.validateAttributeWildcard(wildcard, context, attribStructure)) {
                    context.addError_ComplexType("attribute '" + context.getXPath() + "' is not valid according to the wildcard constraints.");
                    context.removeStep();
                    return false;
                }
            } else {
                context.addError_ComplexType("attribute '" + context.getXPath() + "' is not declared in the schema.");
                context.removeStep();
                return false;
            }
            context.removeStep();
            ++i;
        }
        boolean hasRequiredAttribUses = false;
        int i2 = 0;
        while (i2 < attribUsesCollector.size()) {
            AttributeUse attribUse = (AttributeUse)attribUsesCollector.get(i2);
            if (attribUse.isRequired()) {
                hasRequiredAttribUses = true;
                context.addError_ComplexType("attribute use, wich is associated with attribute declaration {" + attribUse.getAttributeDeclaration().getTargetNamespace() + "}:" + attribUse.getAttributeDeclaration().getName() + ", is defined as required but no attribute information item is detected.");
            }
            ++i2;
        }
        return !hasRequiredAttribUses;
    }

    private boolean validateAttributeWildcard(Wildcard wildcard, ValidationContext context, AttributeStructure attribStructure) throws SchemaException {
        AttributeDeclaration attribDeclaration;
        String attribUri = attribStructure.getUri();
        String attribName = attribStructure.getLocalName();
        boolean result = this.validateWildcardAllowanceNamespace(wildcard, context, attribUri);
        if (!result) {
            context.addError_Wildcard_Attribute("attribute information item '" + context.getXPath() + "' is not valid according to the wildcard namespace allowance.");
            return false;
        }
        if (wildcard.isProcessContentsStrict()) {
            AttributeDeclaration attribDeclaration2 = context.getSchema().getTopLevelAttributeDeclaration(attribUri, attribName);
            if (attribDeclaration2 == null) {
                context.addError_Wildcard_Attribute("attribute information item '" + context.getXPath() + "' is not valid according to the wildcard strict process contents, because no top level attribute declaration {" + attribUri + "}:" + attribName + " is declared in the corresponding schema.");
                return false;
            }
            if (!this.validateAttributeDeclaration(attribDeclaration2, context, attribStructure, null)) {
                context.addError_Wildcard_Attribute("attribute information item '" + context.getXPath() + "' is not valid according to the wildcard strict process contents.");
                return false;
            }
        } else if (wildcard.isProcessContentsLax() && (attribDeclaration = context.getSchema().getTopLevelAttributeDeclaration(attribUri, attribName)) != null && !this.validateAttributeDeclaration(attribDeclaration, context, attribStructure, null)) {
            context.addError_Wildcard_Attribute("attribute information item '" + context.getXPath() + "' is not valid according to the wildcard strict process contents.");
            return false;
        }
        return result;
    }

    private boolean validateWildcard(Wildcard wildcard, XMLToken start, ValidationContext context) throws SchemaException {
        String uri = start.getUri();
        String qName = start.getQName();
        String localName = start.getLocalName();
        if (!this.validateWildcardAllowanceNamespace(wildcard, context, uri)) {
            context.updateXPath_Start(qName, localName, uri);
            context.addError_Wildcard("element information item '" + context.getXPath() + "' is not valid according to the wildcard namespace allowance.");
            context.updateXPath_End();
            return false;
        }
        if (wildcard.isProcessContentsSkip()) {
            int startsCounter = 0;
            while (true) {
                XMLToken token;
                if ((token = context.peekXMLToken()).isStratingMark()) {
                    context.nextXMLToken();
                    ++startsCounter;
                    continue;
                }
                if (startsCounter > 0) {
                    context.nextXMLToken();
                    --startsCounter;
                    continue;
                }
                break;
            }
        } else if (wildcard.isProcessContentsStrict()) {
            ElementDeclaration elemDeclaration = context.getSchema().getTopLevelElementDeclaration(uri, localName);
            if (elemDeclaration == null) {
                context.updateXPath_Start(qName, localName, uri);
                context.addError_Wildcard("element information item '" + context.getXPath() + "' is associated with wildcard with {process contens} set to 'strict', but no top level element declaration {" + uri + "}:" + localName + " is available.");
                context.updateXPath_End();
                return false;
            }
            if (!this.validateElementDeclaration(elemDeclaration, start, false, context, null)) {
                context.updateXPath_Start(qName, localName, uri);
                context.addError_Wildcard("element information item '" + context.getXPath() + "' is associated with wildcard with {process contens} set to 'strict', but it is not valid with respect to the top level element declaration {" + uri + "}:" + localName + " is not valid.");
                context.updateXPath_End();
                return false;
            }
        } else {
            ElementDeclaration elemDeclaration = context.getSchema().getTopLevelElementDeclaration(uri, localName);
            if (elemDeclaration != null) {
                if (!this.validateElementDeclaration(elemDeclaration, start, false, context, null)) {
                    context.updateXPath_Start(qName, localName, uri);
                    context.addError_Wildcard("element information item '" + context.getXPath() + "' is associated with wildcard with {process contens} set to 'lax', but it is not valid with respect to the top level element declaration {" + uri + "}:" + localName + " is not valid.");
                    context.updateXPath_End();
                    return false;
                }
            } else {
                int startsCounter = 0;
                while (true) {
                    XMLToken token;
                    if ((token = context.peekXMLToken()).isStratingMark()) {
                        context.nextXMLToken();
                        ++startsCounter;
                        String tokenUri = token.getUri();
                        String tokenLocalName = token.getLocalName();
                        String xsiTypeName = token.getXsiTypeName();
                        elemDeclaration = context.getSchema().getTopLevelElementDeclaration(tokenUri, tokenLocalName);
                        if (elemDeclaration == null && xsiTypeName == null || this.validateElementDeclaration(elemDeclaration, token, false, context, null)) continue;
                        context.updateXPath_Start(qName, localName, uri);
                        context.addError_Wildcard("element information item '" + context.getXPath() + "' is associated with wildcard with {process contens} set to 'lax', but it is not valid with respect to the top level element declaration {" + uri + "}:" + localName + " is not valid.");
                        context.updateXPath_End();
                        return false;
                    }
                    if (startsCounter <= 0) break;
                    context.nextXMLToken();
                    --startsCounter;
                }
            }
        }
        return true;
    }

    private boolean validateWildcardAllowanceNamespace(Wildcard wildcard, ValidationContext context, String uri) {
        if (wildcard.isNamespaceConstraintAny()) {
            return true;
        }
        String constraintNegated = wildcard.getNamespaceConstraintNegated();
        if (constraintNegated != null) {
            if (uri.equals(constraintNegated)) {
                context.addError_Wildcard_Allowance("validation of information item '" + context.getXPath() + "' is associated with validation of wildcard but it's namespace does not satisfy the wildcard allowance. If the constraint is a pair of not and a namespace name or absent then the namespace must not be equal to that namespace value.");
                return false;
            }
            return true;
        }
        String[] namespaceCostrMembers = wildcard.getNamespaceConstraintMembersAsArray();
        if (namespaceCostrMembers != null) {
            int i = 0;
            while (i < namespaceCostrMembers.length) {
                if (uri.equals(namespaceCostrMembers[i])) {
                    return true;
                }
                ++i;
            }
        }
        context.addError_Wildcard_Allowance("validation of information item '" + context.getXPath() + "' is associated with validation of wildcard but it's namespace does not satisfy the wildcard allowance. If the constraint is a set, the item's namespace must be identical to one of the set's members, or the constraint must be 'any'.");
        return false;
    }

    private boolean validateAttributeDeclaration(AttributeDeclaration attribDeclaration, ValidationContext context, AttributeStructure attribStructure, String attribUseFixedValueConstraint) throws SchemaException {
        String fixedValueConstraint;
        String uri = attribStructure.getUri();
        String localName = attribStructure.getLocalName();
        if (!uri.equals(attribDeclaration.getTargetNamespace()) || !localName.equals(attribDeclaration.getName())) {
            context.addError_Attribute("attribute information item '" + context.getXPath() + "' is not valid because the qualified resulotion is not caried out.");
            return false;
        }
        String value = attribStructure.getValue();
        SimpleTypeDefinition simpleTypeDef = (SimpleTypeDefinition)attribDeclaration.getTypeDefinition();
        String string = fixedValueConstraint = attribUseFixedValueConstraint == null ? attribDeclaration.getValueConstraintFixed() : attribUseFixedValueConstraint;
        if (!this.validateData(value, simpleTypeDef, fixedValueConstraint, context, false, attribStructure.getNode())) {
            context.addError_Attribute("attribute information item '" + context.getXPath() + "' is associated with invalid data.");
            return false;
        }
        if (this.canonicalizationProcessing) {
            NodeImpl attr = attribStructure.getNode();
            attr.setAugmentation("[attribute declaration]", attribDeclaration);
            attr.setAugmentation("[type definition]", simpleTypeDef);
            attr.setAugmentation("[annotation]", attribDeclaration.getAnnotation());
            attr.setAugmentation("[validation attempted]", "full");
        }
        return true;
    }

    private boolean validateSimpleTypeDefinition(SimpleTypeDefinition simpleTypeDef, ValidationContext context, Value ffactesValue, String value, boolean normalize, NodeImpl node) throws SchemaException {
        return SimpleTypeValidator.validateSimpleTypeDefinition(simpleTypeDef, context, ffactesValue, value, normalize, node);
    }

    private boolean isParticleEmptiable(Particle particle) {
        int minOccurs = particle.getMinOccurs();
        if (minOccurs == 0) {
            return true;
        }
        com.sap.engine.lib.schema.components.Base term = particle.getTerm();
        ModelGroup modelGroup = null;
        if (term instanceof ModelGroup) {
            modelGroup = (ModelGroup)term;
        } else if (term instanceof ModelGroupDefinition) {
            modelGroup = ((ModelGroupDefinition)term).getModelGroup();
        }
        if (modelGroup != null) {
            return this.getEffectiveTotalRange_Minimum(minOccurs, modelGroup) == 0;
        }
        return false;
    }

    private int getEffectiveTotalRange_Minimum(int minOccurs, ModelGroup modelGroup) {
        Vector particlesCollector = new Vector();
        modelGroup.getParticles(particlesCollector);
        int sum = 0;
        int i = 0;
        while (i < particlesCollector.size()) {
            Particle particle = (Particle)particlesCollector.get(i);
            com.sap.engine.lib.schema.components.Base term = particle.getTerm();
            if (term instanceof Wildcard || term instanceof ElementDeclaration) {
                sum += particle.getMinOccurs();
            } else {
                ModelGroup termModelGroup = null;
                termModelGroup = term instanceof ModelGroupDefinition ? ((ModelGroupDefinition)term).getModelGroup() : (ModelGroup)term;
                sum += this.getEffectiveTotalRange_Minimum(minOccurs, termModelGroup);
            }
            ++i;
        }
        return minOccurs * sum;
    }

    private XMLTokenizer createTokenizer(InputSource source) throws SchemaException {
        InputStream inputStream = source.getByteStream();
        if (inputStream != null) {
            return new XMLSAXTokenizer(inputStream);
        }
        Reader reader = source.getCharacterStream();
        if (reader != null) {
            return new XMLSAXTokenizer(reader);
        }
        String systemId = source.getSystemId();
        if (systemId == null) {
            throw new SchemaException("Stream source with no input stream, nor reader nor system id.");
        }
        XMLSAXTokenizer result = null;
        try {
            result = new XMLSAXTokenizer(new FileInputStream(systemId));
        }
        catch (Exception exc) {
            throw new SchemaException("An error occured." + exc.getMessage());
        }
        return result;
    }

    public boolean validate(XMLTokenizer tokenizer) throws SchemaException {
        SchemaImpl schema = null;
        schema = this.externalSchema != null ? this.externalSchema : this.retriveSchema(tokenizer);
        if (schema == null) {
            throw new SchemaException("Validation of xml instance document failed. No external schema is detected.");
        }
        boolean result = this.validate(tokenizer, (Schema)schema);
        return result;
    }

    private InputSource retriveInputSource(String streamSrcLocation) throws SchemaException {
        InputSource result = null;
        if (this.resolver != null) {
            try {
                result = this.resolver.resolveEntity("", streamSrcLocation);
            }
            catch (Exception exc) {
                throw new SchemaException(exc);
            }
            if (result == null) {
                result = new InputSource(streamSrcLocation);
            } else if (result.getSystemId() == null && result.getByteStream() == null && result.getCharacterStream() == null) {
                throw new SchemaException("Resolve input source from location '" + streamSrcLocation + "' with no system id, input stream and reader.");
            }
        } else {
            result = new InputSource(streamSrcLocation);
        }
        return result;
    }

    private InputSource retrieveInputSource(StreamSource strSource) throws SchemaException {
        InputStream inputStream = strSource.getInputStream();
        if (inputStream != null) {
            InputSource result = new InputSource();
            result.setByteStream(inputStream);
            return result;
        }
        Reader reader = strSource.getReader();
        if (reader != null) {
            InputSource result = new InputSource();
            result.setCharacterStream(reader);
            return result;
        }
        String systemId = strSource.getSystemId();
        if (systemId == null) {
            throw new SchemaException("Stream source with no input stream, nor reader nor system id.");
        }
        return this.retriveInputSource(systemId);
    }

    private SchemaImpl retriveSchema(XMLTokenizer tokenizer) throws SchemaException {
        SchemaImpl result = null;
        XMLToken token = tokenizer.peek();
        String xsiSchemaLocation = token.getXsiSchemaLocation();
        String xsiNoNamespaceSchemaLocation = token.getXsiNoNamespaceSchemaLocation();
        if (xsiSchemaLocation != null) {
            StringTokenizer strTokenizer = new StringTokenizer(xsiSchemaLocation);
            int countTokens = strTokenizer.countTokens() / 2;
            if (strTokenizer.countTokens() % 2 != 0) {
                throw new SchemaException("Incorrect initializig of external schema locations. The count of the relevant target namespaces must be equal to the count of the schema locations.");
            }
            String[] namespaces = new String[countTokens];
            String[] locations = new String[countTokens];
            int index = 0;
            while (strTokenizer.hasMoreTokens()) {
                namespaces[index] = strTokenizer.nextToken();
                locations[index] = strTokenizer.nextToken();
                ++index;
            }
            result = (SchemaImpl)this.loader.load(namespaces, locations);
        } else if (xsiNoNamespaceSchemaLocation != null) {
            result = (SchemaImpl)this.loader.load("", xsiNoNamespaceSchemaLocation);
        }
        return result;
    }

    public void setValidateSchemaDOM(boolean validate) {
        this.loader.setValidateSchemaDOM(validate);
    }
}

