/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.canonicalizator;

import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.canonicalizator.helpers.NSAttribStructure;
import com.sap.engine.lib.schema.canonicalizator.helpers.SSCAnnotation;
import com.sap.engine.lib.schema.canonicalizator.helpers.Triple;
import com.sap.engine.lib.schema.components.Annotation;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.InfoItemDeclarationBase;
import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.exception.CanonicalizationException;
import com.sap.engine.lib.schema.util.LexicalParser;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.dom.ElementImpl;
import com.sap.engine.lib.xml.dom.NodeImpl;
import com.sap.engine.lib.xml.dom.TextImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CanonicalizationProcessor
implements Constants {
    private int normalizedNamespaceAttribIndex;
    private OutputStream xmlOutput;
    private Writer xmlWriter;
    private Element docElement;
    private static int COMPARE_LESS = 0;
    private static int COMPARE_EQUAL = 1;
    private static int COMPARE_GREATER = 2;

    protected CanonicalizationProcessor(Element docElement, OutputStream xmlOutput) {
        this(docElement);
        this.xmlOutput = xmlOutput;
    }

    protected CanonicalizationProcessor(Element docElement, Writer xmlWriter) {
        this(docElement);
        this.xmlWriter = xmlWriter;
    }

    private CanonicalizationProcessor(Element docElement) {
        this.docElement = docElement;
        this.normalizedNamespaceAttribIndex = 0;
    }

    protected void process() throws CanonicalizationException {
        this.process((ElementImpl)this.docElement, new Hashtable(), new Hashtable());
    }

    private void process(ElementImpl element, Hashtable parentInScopeNSesCollector, Hashtable parentInScopeNormNSAttribsCollector) throws CanonicalizationException {
        InfoItemDeclarationBase attributeDeclaration;
        InfoItemDeclarationBase elementDeclaration = (InfoItemDeclarationBase)element.getAugmentation("[element declaration]");
        TypeDefinitionBase elementTypeDefBase = null;
        TypeDefinitionBase elementMemberTypeDefBase = null;
        SSCAnnotation elementSscAnnotation = null;
        String embededLanguage = null;
        Hashtable<String, NodeImpl> inScopeNSesCollector = new Hashtable<String, NodeImpl>();
        inScopeNSesCollector.putAll(parentInScopeNSesCollector);
        Vector attribsCollector = new Vector();
        Vector nsAttribsCollector = new Vector();
        Vector<SSCAnnotation> attribsSSCAnnotationsCollector = new Vector<SSCAnnotation>();
        Hashtable normNSAttribsCollector = null;
        Hashtable inScopeNormNSAttribsCollector = null;
        if (elementDeclaration != null) {
            elementSscAnnotation = new SSCAnnotation();
            elementTypeDefBase = (TypeDefinitionBase)element.getAugmentation("[type definition]");
            elementMemberTypeDefBase = (TypeDefinitionBase)element.getAugmentation("[member type definition]");
            this.initSSCAnnotation_InfoItemDeclarationBase(elementSscAnnotation, elementDeclaration, elementTypeDefBase, elementMemberTypeDefBase);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        int i = 0;
        while (i < namedNodeMap.getLength()) {
            NodeImpl attrib = (NodeImpl)namedNodeMap.item(i);
            String namespace = this.determineUri(attrib);
            String value = attrib.getNodeValue();
            String name = attrib.getLocalName();
            if (!namespace.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                if (this.isNamespaceAttribute(attrib)) {
                    this.add_Sorted(nsAttribsCollector, attrib);
                    String localName = attrib.getLocalName();
                    inScopeNSesCollector.put(localName.equals("xmlns") ? "" : localName, attrib);
                } else {
                    attributeDeclaration = (InfoItemDeclarationBase)attrib.getAugmentation("[attribute declaration]");
                    if (attributeDeclaration != null) {
                        SSCAnnotation attributeSscAnnotation = new SSCAnnotation();
                        TypeDefinitionBase attributeTypeDefBase = (TypeDefinitionBase)attrib.getAugmentation("[type definition]");
                        TypeDefinitionBase attributeMemberTypeDefBase = (TypeDefinitionBase)attrib.getAugmentation("[member type definition]");
                        this.initSSCAnnotation_InfoItemDeclarationBase(attributeSscAnnotation, attributeDeclaration, attributeTypeDefBase, attributeMemberTypeDefBase);
                        String attribEmbeddedLang = attributeSscAnnotation.getEmbededLang();
                        if (attribEmbeddedLang == null && this.isQNameEmbeddedLang(attributeTypeDefBase)) {
                            attribEmbeddedLang = "http://www.w3.org/2001/XMLSchema";
                        }
                        this.namespacePrefixDesensitization(attrib, attribEmbeddedLang);
                        attribsSSCAnnotationsCollector.add(attributeSscAnnotation);
                    }
                    this.add_Sorted(attribsCollector, attrib);
                    if (namespace.equals("urn:uddi-org:schemaCentricC14N:2002-07-10") && name.equals("embeddedLang")) {
                        embededLanguage = value;
                    }
                }
            }
            ++i;
        }
        if (elementDeclaration != null) {
            if (embededLanguage == null) {
                if (elementSscAnnotation.getEmbededLangAttributeName() != null) {
                    String attribUri = elementSscAnnotation.getEmbededLangAttributeUri();
                    String attribName = elementSscAnnotation.getEmbededLangAttributeName();
                    if (LexicalParser.parseNCName(attribName) == null) {
                        throw new CanonicalizationException("Attribute name '" + attribName + "' must be a valid ncname.");
                    }
                    Attr embeddedLangAttr = element.getAttributeNode(attribName);
                    if (embeddedLangAttr == null || !this.determineUri((NodeImpl)((Object)embeddedLangAttr)).equals(attribUri)) {
                        throw new CanonicalizationException("Missing embeded language attribute {" + attribUri + "}:" + attribName + ".");
                    }
                    embededLanguage = embeddedLangAttr.getValue();
                } else if (elementSscAnnotation.getEmbededLang() != null) {
                    embededLanguage = elementSscAnnotation.getEmbededLang();
                } else if (this.isQNameEmbeddedLang(elementTypeDefBase)) {
                    embededLanguage = "http://www.w3.org/2001/XMLSchema";
                }
            }
            this.namespacePrefixDesensitization(element, embededLanguage);
            normNSAttribsCollector = new Hashtable();
            this.namespaceAttributeNormalization(element, attribsCollector, inScopeNSesCollector, parentInScopeNormNSAttribsCollector, normNSAttribsCollector);
            inScopeNormNSAttribsCollector = new Hashtable();
            inScopeNormNSAttribsCollector.putAll(parentInScopeNormNSAttribsCollector);
            inScopeNormNSAttribsCollector.putAll(normNSAttribsCollector);
            this.dataTypeCanonicalization(element, elementSscAnnotation, elementTypeDefBase);
        }
        this.serializeElement_Start(element, false);
        boolean wildcardOutputRoot = this.wildcardOutputRoot(element, attribsCollector);
        boolean wildcarded = this.wildcarded(element);
        if (elementDeclaration != null) {
            Vector normNSAttribsVectorCollector = this.createSortedVector(normNSAttribsCollector);
            int i2 = 0;
            while (i2 < normNSAttribsVectorCollector.size()) {
                this.serializeNormNSAttribStructure((NSAttribStructure)normNSAttribsVectorCollector.get(i2));
                ++i2;
            }
        }
        if (wildcardOutputRoot) {
            Vector inScopeNsAttribsCollector = this.createSortedVector(inScopeNSesCollector);
            int i3 = 0;
            while (i3 < inScopeNsAttribsCollector.size()) {
                this.serializeNSAttrib((NodeImpl)inScopeNsAttribsCollector.get(i3));
                ++i3;
            }
        } else if (wildcarded) {
            int i4 = 0;
            while (i4 < nsAttribsCollector.size()) {
                this.serializeNSAttrib((NodeImpl)nsAttribsCollector.get(i4));
                ++i4;
            }
        }
        int i5 = 0;
        while (i5 < attribsCollector.size()) {
            NodeImpl attrib = (NodeImpl)attribsCollector.get(i5);
            attributeDeclaration = (InfoItemDeclarationBase)attrib.getAugmentation("[attribute declaration]");
            TypeDefinitionBase attributeTypeDefBase = (TypeDefinitionBase)attrib.getAugmentation("[type definition]");
            if (attributeDeclaration != null) {
                this.namespaceAttributeNormalization(attrib, null, inScopeNSesCollector, inScopeNormNSAttribsCollector, new Hashtable());
                this.dataTypeCanonicalization(attrib, (SSCAnnotation)attribsSSCAnnotationsCollector.get(i5), attributeTypeDefBase);
            }
            this.serializeAttribute(attrib);
            ++i5;
        }
        this.serializeElement_Start(element, true);
        NodeList nodeList = element.getChildNodes();
        ModelGroup processingModelGroup = null;
        Vector processingModelGropuElemsCollector = null;
        int i6 = 0;
        while (i6 < nodeList.getLength()) {
            Node childNode = nodeList.item(i6);
            if (childNode instanceof Element) {
                ElementImpl childElement = (ElementImpl)childNode;
                ModelGroup modelGroup = (ModelGroup)childElement.getAugmentation("[validating model group all]");
                if (modelGroup == null) {
                    if (processingModelGropuElemsCollector != null) {
                        this.processProcessingModelGroupElements(processingModelGropuElemsCollector, inScopeNSesCollector, inScopeNormNSAttribsCollector);
                        processingModelGropuElemsCollector = null;
                    }
                    this.process(childElement, inScopeNSesCollector, inScopeNormNSAttribsCollector);
                } else {
                    if (processingModelGroup == null) {
                        processingModelGroup = modelGroup;
                        processingModelGropuElemsCollector = new Vector();
                    } else if (processingModelGroup != modelGroup) {
                        if (processingModelGropuElemsCollector != null) {
                            this.processProcessingModelGroupElements(processingModelGropuElemsCollector, inScopeNSesCollector, inScopeNormNSAttribsCollector);
                        }
                        processingModelGropuElemsCollector = new Vector();
                    }
                    this.add_Sorted(processingModelGropuElemsCollector, childElement);
                }
            } else if (childNode instanceof TextImpl) {
                String value = childNode.getNodeValue();
                if (elementTypeDefBase instanceof ComplexTypeDefinition) {
                    ComplexTypeDefinition elementComplTypeDef = (ComplexTypeDefinition)elementTypeDefBase;
                    SimpleTypeDefinition contentSimpleTypeDef = elementComplTypeDef.getContentTypeSimpleTypeDefinition();
                    if (elementComplTypeDef.isMixed() && contentSimpleTypeDef == null) {
                        String mixContentValue = this.createMixContentValue(value);
                        if (mixContentValue != null) {
                            this.write(mixContentValue);
                        }
                    } else if (contentSimpleTypeDef != null && !this.isWhiteSpace(value)) {
                        this.serializeValue(element);
                    }
                } else if (!this.isWhiteSpace(value)) {
                    this.serializeValue(element);
                }
            }
            ++i6;
        }
        if (processingModelGropuElemsCollector != null) {
            this.processProcessingModelGroupElements(processingModelGropuElemsCollector, inScopeNSesCollector, inScopeNormNSAttribsCollector);
            processingModelGropuElemsCollector = null;
        }
        this.serializeElement_End(element);
    }

    private boolean isWhiteSpace(String value) {
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (ch != '\n' && ch != '\t' && ch != '\r') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String createMixContentValue(String value) {
        StringBuffer buffer = new StringBuffer();
        int index1 = 0;
        while (index1 < value.length()) {
            char ch = value.charAt(index1);
            if (ch != '\n' && ch != '\t' && ch != '\r') break;
            ++index1;
        }
        int index2 = value.length() - 1;
        while (index2 >= index1) {
            char ch;
            if ((ch = value.charAt(index2--)) == '\n' || ch == '\t' || ch == '\r') continue;
            buffer.insert(0, ch);
        }
        return buffer.length() == 0 ? null : buffer.toString();
    }

    private void processProcessingModelGroupElements(Vector processingModelGropuElemsCollector, Hashtable inScopeNSesCollector, Hashtable inScopeNormNSAttribsCollector) throws CanonicalizationException {
        int i = 0;
        while (i < processingModelGropuElemsCollector.size()) {
            this.process((ElementImpl)processingModelGropuElemsCollector.get(i), inScopeNSesCollector, inScopeNormNSAttribsCollector);
            ++i;
        }
    }

    private void serializeNSAttrib(NodeImpl attrib) throws CanonicalizationException {
        String localName = attrib.getLocalName();
        this.write(localName.equals("xmlns") ? " xmlns=\"" + attrib.getNodeValue() + "\"" : " xmlns:" + localName + "=\"" + attrib.getNodeValue() + "\"");
    }

    private void serializeNormNSAttribStructure(NSAttribStructure nsAttribStructure) throws CanonicalizationException {
        this.write(" xmlns:" + nsAttribStructure.getPrefix() + "=\"" + nsAttribStructure.getValue() + "\"");
    }

    private boolean isNamespaceAttribute(NodeImpl node) {
        return this.determineUri(node).equals("http://www.w3.org/2000/xmlns/") || this.determinePrefix(node).equals("xmlns");
    }

    private Vector createSortedVector(Hashtable collector) {
        Vector result = new Vector();
        Enumeration enumeration = collector.elements();
        while (enumeration.hasMoreElements()) {
            this.add_Sorted(result, enumeration.nextElement());
        }
        return result;
    }

    private void add_Sorted(Vector collector, Object obj) {
        int index;
        for (index = 0; index < collector.size(); ++index) {
            Object baseObj = collector.get(index);
            int compareResult = this.compare(baseObj, obj);
            if (compareResult == COMPARE_GREATER) {
                continue;
            }
            collector.add(index, obj);
            break;
        }
        if (index >= collector.size()) {
            collector.add(obj);
        }
    }

    private int compare(Object baseObj, Object obj) {
        int compareResult = -1;
        if (baseObj instanceof Element) {
            NodeImpl baseNode = (NodeImpl)baseObj;
            NodeImpl node = (NodeImpl)obj;
            compareResult = this.compare(this.determineUri(baseNode), this.determineUri(node));
            if (compareResult == COMPARE_EQUAL) {
                compareResult = this.compare(baseNode.getLocalName(), node.getLocalName());
            }
        } else if (baseObj instanceof Attr) {
            NodeImpl baseNode = (NodeImpl)baseObj;
            NodeImpl node = (NodeImpl)obj;
            if (this.isNamespaceAttribute(baseNode)) {
                compareResult = this.compare(baseNode.getNodeValue(), node.getNodeValue());
                if (compareResult == COMPARE_EQUAL) {
                    compareResult = this.compare(this.determinePrefix(baseNode), this.determinePrefix(node));
                }
            } else {
                compareResult = this.compare(this.determineUri(baseNode), this.determineUri(node));
                if (compareResult == COMPARE_EQUAL) {
                    compareResult = this.compare(baseNode.getLocalName(), node.getLocalName());
                }
            }
        } else if (baseObj instanceof NSAttribStructure) {
            NSAttribStructure baseNsAttribStruc = (NSAttribStructure)baseObj;
            NSAttribStructure nsAttribStruc = (NSAttribStructure)obj;
            compareResult = this.compare(baseNsAttribStruc.getValue(), nsAttribStruc.getValue());
            if (compareResult == COMPARE_EQUAL) {
                compareResult = this.compare(baseNsAttribStruc.getPrefix(), nsAttribStruc.getPrefix());
            }
        }
        return compareResult;
    }

    private String determineUri(NodeImpl node) {
        return this.determineUri(node.getNamespaceURI());
    }

    private String determineUri(String uri) {
        return uri == null ? "" : uri;
    }

    private int compare(String baseStr, String str) {
        int i = 0;
        while (i < baseStr.length()) {
            char ch;
            if (i >= str.length()) {
                return COMPARE_GREATER;
            }
            char baseCh = baseStr.charAt(i);
            if (baseCh < (ch = str.charAt(i))) {
                return COMPARE_GREATER;
            }
            if (baseCh > ch) {
                return COMPARE_LESS;
            }
            ++i;
        }
        return COMPARE_EQUAL;
    }

    private void serializeElement_End(ElementImpl element) throws CanonicalizationException {
        String prefix = this.wildcarded(element) ? this.determinePrefix(element) : this.determineNormalizedPrefix(element);
        this.write("</" + prefix + (prefix.equals("") ? "" : ":") + element.getLocalName() + ">");
    }

    private void serializeAttribute(NodeImpl attr) throws CanonicalizationException {
        this.write(" ");
        String prefix = null;
        String attrUri = attr.getNamespaceURI();
        prefix = attrUri != null && attrUri.equals("http://www.w3.org/XML/1998/namespace") ? "xml" : (!this.wildcarded(attr) ? this.determineNormalizedPrefix(attr) : this.determinePrefix(attr));
        this.write(prefix + (prefix.equals("") ? "" : ":"));
        this.write(attr.getLocalName() + "=\"");
        this.serializeValue(attr);
        this.write("\"");
    }

    private void serializeElement_Start(ElementImpl element, boolean attribsAreSerialized) throws CanonicalizationException {
        if (!attribsAreSerialized) {
            boolean isWildcarded = this.wildcarded(element);
            String prefix = isWildcarded ? this.determinePrefix(element) : this.determineNormalizedPrefix(element);
            String localName = element.getLocalName();
            this.write("<");
            this.write(prefix + (prefix.equals("") ? "" : ":") + localName);
        } else {
            this.write(">");
        }
    }

    private void serializeValue(NodeImpl node) throws CanonicalizationException {
        String prefixAndSchemaNormalizedValue = (String)node.getAugmentation("[prefix & schema normalized value]");
        if (prefixAndSchemaNormalizedValue != null) {
            this.write(this.escape(prefixAndSchemaNormalizedValue));
        } else {
            String schemaNormalizedValue = (String)node.getAugmentation("[schema normalized value]");
            if (schemaNormalizedValue != null) {
                this.write(this.escape(schemaNormalizedValue));
            } else {
                String normalizedValue = (String)node.getAugmentation("[normalized value]");
                if (normalizedValue != null) {
                    this.write(this.escape(normalizedValue));
                } else {
                    String nodeValue = DOM.getNodeValue(node);
                    if (nodeValue != null) {
                        this.write(nodeValue);
                    }
                }
            }
        }
    }

    private String determineNormalizedPrefix(NodeImpl node) {
        String normalizedPrefix = (String)node.getAugmentation("[normalized prefix]");
        return normalizedPrefix == null ? "" : normalizedPrefix;
    }

    private String determinePrefix(NodeImpl node) {
        return this.determinePrefix(node.getPrefix());
    }

    private String determinePrefix(String prefix) {
        return prefix == null ? "" : prefix;
    }

    private boolean wildcarded(NodeImpl node) {
        return node.getAugmentation("[validation attempted]") == null;
    }

    private boolean wildcardOutputRoot(NodeImpl node, Vector attribsCollector) {
        if (!this.wildcarded(node)) {
            int i = 0;
            while (i < attribsCollector.size()) {
                NodeImpl attr = (NodeImpl)attribsCollector.get(i);
                if (this.wildcarded(attr)) {
                    node.setAugmentation("[wildcarded]", new Boolean(true));
                    return true;
                }
                ++i;
            }
        } else {
            NodeImpl parent = (NodeImpl)node.getParentNode();
            node.setAugmentation("[wildcarded]", new Boolean(true));
            if (parent instanceof Document || parent.getAugmentation("[wildcarded]") == null) {
                return true;
            }
        }
        return false;
    }

    private void namespaceAttributeNormalization(NodeImpl node, Vector attribsCollector, Hashtable inScopeNSAttribsCollector, Hashtable parentNormNSAttribsCollector, Hashtable normNSAttribsCollector) throws CanonicalizationException {
        Vector triplesCollector;
        String schemaNormValue;
        Enumeration enumeration = inScopeNSAttribsCollector.elements();
        String namespace = this.determineUri(node);
        while (enumeration.hasMoreElements()) {
            Attr nsAttr = (Attr)enumeration.nextElement();
            String inScopeNS = nsAttr.getNodeValue();
            if (!this.isVisiblyUtilized(inScopeNS, node, attribsCollector) || parentNormNSAttribsCollector.containsKey(inScopeNS) || normNSAttribsCollector.containsKey(inScopeNS)) continue;
            String normalizedPrefix = "n" + this.normalizedNamespaceAttribIndex++;
            normNSAttribsCollector.put(inScopeNS, new NSAttribStructure(normalizedPrefix, inScopeNS));
        }
        NSAttribStructure nsAttribStructure = this.getNSAttribStructure(parentNormNSAttribsCollector, normNSAttribsCollector, namespace);
        if (nsAttribStructure != null) {
            node.setAugmentation("[normalized prefix]", nsAttribStructure.getPrefix());
        }
        if ((schemaNormValue = (String)node.getAugmentation("[schema normalized value]")) != null && (triplesCollector = (Vector)node.getAugmentation("[prefix usage locations]")) != null) {
            StringBuffer buffer = new StringBuffer(schemaNormValue);
            int additionalOffset = 0;
            int i = 0;
            while (i < triplesCollector.size()) {
                Triple triple = (Triple)triplesCollector.get(i);
                String prefix = triple.getPrefix();
                String uri = triple.getUri();
                int offset = triple.getOffset() + additionalOffset;
                NSAttribStructure nsAttribStruc = this.getNSAttribStructure(parentNormNSAttribsCollector, normNSAttribsCollector, uri);
                String normalizedPrefix = nsAttribStruc.getPrefix();
                int prefixLength = prefix.length();
                String replacement = null;
                if (prefixLength == 0) {
                    replacement = normalizedPrefix + ":";
                    ++additionalOffset;
                } else {
                    replacement = normalizedPrefix;
                }
                buffer.replace(offset, offset + prefixLength, replacement);
                additionalOffset += normalizedPrefix.length() - prefixLength;
                ++i;
            }
            node.setAugmentation("[prefix & schema normalized value]", buffer.toString());
        }
    }

    private NSAttribStructure getNSAttribStructure(Hashtable parentNormNSAttribsCollector, Hashtable normNSAttribsCollector, String uri) {
        NSAttribStructure nsAttribStructure = (NSAttribStructure)normNSAttribsCollector.get(uri);
        if (nsAttribStructure == null) {
            nsAttribStructure = (NSAttribStructure)parentNormNSAttribsCollector.get(uri);
        }
        return nsAttribStructure;
    }

    private boolean isVisiblyUtilized(String ns, NodeImpl node, Vector attribsCollector) {
        if (ns.equals(node.getNamespaceURI())) {
            return true;
        }
        Vector triplesCollector = (Vector)node.getAugmentation("[prefix usage locations]");
        if (triplesCollector != null && this.isVisiblyUtilized(ns, triplesCollector)) {
            return true;
        }
        if (attribsCollector != null) {
            int i = 0;
            while (i < attribsCollector.size()) {
                if (this.isVisiblyUtilized(ns, (NodeImpl)attribsCollector.get(i), null)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isVisiblyUtilized(String ns, Vector prefixUsageLocationsCollector) {
        int i = 0;
        while (i < prefixUsageLocationsCollector.size()) {
            Triple triple = (Triple)prefixUsageLocationsCollector.get(i);
            if (ns.equals(triple.getUri())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void dataTypeCanonicalization(NodeImpl node, SSCAnnotation sscAnnotation, TypeDefinitionBase typeDef) {
        String normalizedValue = (String)node.getAugmentation("[schema normalized value]");
        if (normalizedValue != null) {
            StringBuffer buffer = new StringBuffer(normalizedValue);
            if (typeDef.isDerivedFrom(SchemaImpl.getBuiltInTypeDefnition("dateTime"), false, false)) {
                int end;
                String hours;
                int start = normalizedValue.indexOf("T");
                if (start >= 0 && (hours = normalizedValue.substring(++start, end = normalizedValue.indexOf(":", start))).equals("24")) {
                    buffer.replace(start, end, "00");
                }
                node.setAugmentation("[schema normalized value]", buffer.toString());
            } else if (typeDef.isDerivedFrom(SchemaImpl.getBuiltInTypeDefnition("float"), false, false) || typeDef.isDerivedFrom(SchemaImpl.getBuiltInTypeDefnition("double"), false, false)) {
                int index = 0;
                int delIndex = -1;
                int decimalPointIndex = -1;
                while (index < buffer.length()) {
                    char ch = buffer.charAt(index);
                    if (ch == '+') {
                        buffer.deleteCharAt(index);
                        continue;
                    }
                    if (ch == 'e') {
                        buffer.setCharAt(index, 'E');
                        delIndex = index++;
                        continue;
                    }
                    if (ch == 'E') {
                        delIndex = index++;
                        continue;
                    }
                    if (ch == '.') {
                        decimalPointIndex = index++;
                        continue;
                    }
                    if (ch == '0' && (index == 0 || buffer.charAt(index - 1) == '-' || buffer.charAt(index - 1) == 'E')) {
                        buffer.deleteCharAt(index);
                        continue;
                    }
                    ++index;
                }
                if (delIndex == -1) {
                    buffer.append("E0");
                    delIndex = buffer.length() - 2;
                }
                if (decimalPointIndex == -1) {
                    buffer.insert(delIndex - 1, ".0");
                } else {
                    char ch;
                    int hlpIndex = delIndex - 1;
                    while ((ch = buffer.charAt(hlpIndex)) == '0' && buffer.charAt(hlpIndex - 1) != '.') {
                        buffer.deleteCharAt(hlpIndex);
                        --hlpIndex;
                    }
                }
                node.setAugmentation("[schema normalized value]", buffer.toString());
            } else if (typeDef.isDerivedFrom(SchemaImpl.getBuiltInTypeDefnition("language"), false, false)) {
                node.setAugmentation("[schema normalized value]", normalizedValue.toUpperCase());
            } else if (typeDef.isDerivedFrom(SchemaImpl.getBuiltInTypeDefnition("string"), false, false) || typeDef.isDerivedFrom(SchemaImpl.getBuiltInTypeDefnition("anyURI"), false, false)) {
                String caseMapKind = sscAnnotation.getCaseMapKind();
                if (caseMapKind == null) {
                    if (sscAnnotation.getCaseMap() != null || sscAnnotation.getCaseMapAttributeName() != null) {
                        node.setAugmentation("[schema normalized value]", normalizedValue.toUpperCase());
                    }
                } else if (caseMapKind.equals("upper")) {
                    node.setAugmentation("[schema normalized value]", normalizedValue.toUpperCase());
                } else if (caseMapKind.equals("lower")) {
                    node.setAugmentation("[schema normalized value]", normalizedValue.toLowerCase());
                }
            }
        }
    }

    private boolean isQNameEmbeddedLang(TypeDefinitionBase typeDefBase) {
        SimpleTypeDefinition simpleTypeDef;
        SimpleTypeDefinition qNameTypeDef = (SimpleTypeDefinition)SchemaImpl.getBuiltInTypeDefnition("QName");
        if (typeDefBase.isDerivedFrom(qNameTypeDef, false, false)) {
            return true;
        }
        return typeDefBase instanceof SimpleTypeDefinition && (simpleTypeDef = (SimpleTypeDefinition)typeDefBase).isVarietyList() && simpleTypeDef.getItemTypeDefinition().isDerivedFrom(qNameTypeDef, false, false);
    }

    private void namespacePrefixDesensitization(NodeImpl node, String embededLanguage) throws CanonicalizationException {
        if (embededLanguage != null) {
            if (!embededLanguage.equals("http://www.w3.org/TR/1999/REC-xpath-19991116") && !embededLanguage.equals("http://www.w3.org/2001/XMLSchema")) {
                throw new CanonicalizationException("Embedded language '" + embededLanguage + "' is not supported.");
            }
            String normalizedValue = (String)node.getAugmentation("[schema normalized value]");
            if (normalizedValue != null) {
                Vector<Triple> triplesCollector = new Vector<Triple>();
                node.setAugmentation("[prefix usage locations]", triplesCollector);
                StringTokenizer tokenizer = new StringTokenizer(normalizedValue, embededLanguage.equals("http://www.w3.org/TR/1999/REC-xpath-19991116") ? "/" : " ");
                int offset = 0;
                while (tokenizer.hasMoreElements()) {
                    String qName = tokenizer.nextToken();
                    String[] prefixAndName = Tools.parseQName(qName);
                    String prefix = this.determinePrefix(prefixAndName[0]);
                    String uri = Tools.getUri(this.determineNamespaceMappings(node), prefix);
                    if (uri == null) {
                        throw new CanonicalizationException("Prefix '" + prefix + "' is not mapped to any uri.");
                    }
                    offset = normalizedValue.indexOf(qName, offset);
                    triplesCollector.add(new Triple(offset, prefix, uri));
                    offset += qName.length();
                }
            }
        }
    }

    private Hashtable determineNamespaceMappings(Node node) {
        if (node instanceof Element) {
            return DOM.getNamespaceMappingsInScope(node);
        }
        return DOM.getNamespaceMappingsInScope(((Attr)node).getOwnerElement());
    }

    private void initSSCAnnotation_InfoItemDeclarationBase(SSCAnnotation sscAnnotation, InfoItemDeclarationBase infoItemDeclrBase, TypeDefinitionBase typeDefBase, TypeDefinitionBase memberTypeDefBase) throws CanonicalizationException {
        if (infoItemDeclrBase != null) {
            this.initSSCAnnotation(infoItemDeclrBase, sscAnnotation);
        }
        if (sscAnnotation.getEmbededLang() == null || sscAnnotation.getEmbededLangAttributeName() == null || sscAnnotation.getCaseMap() == null || sscAnnotation.getCaseMapAttributeName() == null || sscAnnotation.getCaseMapKind() == null) {
            this.scan_TypeDefinitionBase(sscAnnotation, memberTypeDefBase == null ? typeDefBase : memberTypeDefBase);
        }
    }

    private void scan_TypeDefinitionBase(SSCAnnotation sscAnnotation, TypeDefinitionBase typeDefBase) throws CanonicalizationException {
        this.initSSCAnnotation(typeDefBase, sscAnnotation);
        if (sscAnnotation.getEmbededLang() == null || sscAnnotation.getEmbededLangAttributeName() == null || sscAnnotation.getCaseMap() == null || sscAnnotation.getCaseMapAttributeName() == null || sscAnnotation.getCaseMapKind() == null) {
            if (typeDefBase instanceof ComplexTypeDefinition) {
                TypeDefinitionBase baseTypeDef = typeDefBase.getBaseTypeDefinition();
                if (!baseTypeDef.isBuiltIn()) {
                    this.scan_TypeDefinitionBase(sscAnnotation, baseTypeDef);
                }
            } else {
                SimpleTypeDefinition itemTypeDef;
                SimpleTypeDefinition simpleTypeDef = (SimpleTypeDefinition)typeDefBase;
                if (simpleTypeDef.isVarietyAtomic()) {
                    TypeDefinitionBase baseTypeDef = typeDefBase.getBaseTypeDefinition();
                    if (!baseTypeDef.isBuiltIn()) {
                        this.scan_TypeDefinitionBase(sscAnnotation, baseTypeDef);
                    }
                } else if (simpleTypeDef.isVarietyList() && !(itemTypeDef = simpleTypeDef.getItemTypeDefinition()).isBuiltIn()) {
                    this.scan_TypeDefinitionBase(sscAnnotation, itemTypeDef);
                }
            }
        }
    }

    private void initSSCAnnotation(Base base, SSCAnnotation sscAnnotation) throws CanonicalizationException {
        Annotation infoItemDeclrBaseAnnotation = base.getAnnotation();
        if (infoItemDeclrBaseAnnotation != null) {
            Vector attributesCollector = new Vector();
            infoItemDeclrBaseAnnotation.getAttributes(attributesCollector);
            int i = 0;
            while (i < attributesCollector.size()) {
                NodeImpl node = (NodeImpl)attributesCollector.get(i);
                String name = node.getLocalName();
                String value = node.getNodeValue();
                if (this.determineUri(node).equals("urn:uddi-org:schemaCentricC14N:2002-07-10")) {
                    String attribName;
                    String prefix;
                    String[] prefixAndName;
                    if (name.equals("embeddedLang") && sscAnnotation.getEmbededLang() == null) {
                        sscAnnotation.setEmbededLang(value);
                    } else if (name.equals("embeddedLangAttribute") && sscAnnotation.getEmbededLangAttributeName() == null) {
                        prefixAndName = Tools.parseQName(value);
                        prefix = this.determinePrefix(prefixAndName[0]);
                        attribName = prefixAndName[1];
                        sscAnnotation.setEmbededLangAttributeUri(this.determineUri(Tools.getUri(this.determinePrefixesMapping(base), prefix)));
                        sscAnnotation.setEmbededLangAttributeName(attribName);
                    } else if (name.equals("caseMap") && sscAnnotation.getCaseMap() == null) {
                        sscAnnotation.setCaseMap(value);
                    } else if (name.equals("caseMapAttribute") && sscAnnotation.getCaseMapAttributeName() == null) {
                        prefixAndName = Tools.parseQName(value);
                        prefix = this.determinePrefix(prefixAndName[0]);
                        attribName = prefixAndName[1];
                        sscAnnotation.setCaseMapAttributeUri(this.determineUri(Tools.getUri(this.determinePrefixesMapping(base), prefix)));
                        sscAnnotation.setCaseMapAttributeName(attribName);
                    } else if (name.equals("caseMapKind") && sscAnnotation.getCaseMapKind() == null) {
                        sscAnnotation.setCaseMapKind(value);
                    }
                }
                ++i;
            }
        }
    }

    private Hashtable determinePrefixesMapping(Base base) {
        Node associatedNode = base.getAssociatedDOMNode();
        if (associatedNode != null) {
            return DOM.getNamespaceMappingsInScope(associatedNode);
        }
        return new Hashtable();
    }

    private String escape(String value) {
        StringBuffer buffer = new StringBuffer(value);
        int index = 0;
        while (index < buffer.length()) {
            char ch = buffer.charAt(index);
            String replacement = null;
            switch (ch) {
                case '<': {
                    replacement = "&lt";
                    break;
                }
                case '>': {
                    replacement = "&gt";
                    break;
                }
                case '&': {
                    replacement = "&amp";
                    break;
                }
                case '\'': {
                    replacement = "&apos";
                    break;
                }
                case '\"': {
                    replacement = "&quot";
                }
            }
            if (replacement != null) {
                buffer.replace(index, index + 1, replacement);
                index += replacement.length();
                continue;
            }
            ++index;
        }
        return buffer.toString();
    }

    private void write(String str) throws CanonicalizationException {
        try {
            if (this.xmlOutput != null) {
                this.xmlOutput.write(str.getBytes());
                this.xmlOutput.flush();
            } else {
                this.xmlWriter.write(str);
                this.xmlWriter.flush();
            }
        }
        catch (IOException ioExc) {
            throw new CanonicalizationException(ioExc.getMessage());
        }
    }
}

