/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xsl.xslt;

import com.inqmy.lib.xml.SystemProperties;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class CommandLine {
    public static void printUsage() {
        System.out.println("InQMy XSLT engine.");
        System.out.println();
        System.out.println("Usage: xslt (<parameter> | <option>)*");
        System.out.println("");
        System.out.println("Parameters:");
        System.out.println("        [-xml] <filename_or_url>                      (required)");
        System.out.println("        [-xsl] <filename_or_url>                      (optional)");
        System.out.println("        [-out] <filename_or_url>                      (optional)");
        System.out.println("        If you do not specify the -xml -xsl or -out prefixes then this order is assumed");
        System.out.println("");
        System.out.println("Options:");
        System.out.println("        -indent");
        System.out.println("        -omitxmldecl");
        System.out.println("        -encoding <name_of_encoding>");
        System.out.println("        -version <name_of_version>");
        System.out.println("        -method  ( xml | text | html | dump )");
        System.out.println("        -cdata   ( <name_of_element> )*  [ -endcdata ]");
        System.out.println("        -P<name>=<value>                              (set the specified <value> to the <name> parameter )");
        System.out.println("        -apache                                       (run with Apache's Xalan transformer)");
        System.out.println("        -other   <TransformerFactory_class_name>      (run with other implementations)");
    }

    public static void main(String[] args) throws TransformerException, IOException, ClassNotFoundException {
        StreamResult result;
        String xml = null;
        String xsl = null;
        String out = null;
        boolean defaulted = false;
        Properties p = new Properties();
        Properties params = new Properties();
        boolean useApache = false;
        String other = null;
        try {
            int i = 0;
            while (i < args.length) {
                String s = args[i];
                if (s.equals("-xml")) {
                    xml = args[++i];
                } else if (s.equals("-xsl")) {
                    xsl = args[++i];
                } else if (s.equals("-out")) {
                    out = args[++i];
                } else if (s.equals("-indent")) {
                    p.setProperty("indent", "yes");
                } else if (s.equals("-omitxmldecl")) {
                    p.setProperty("omit-xml-declaration", "yes");
                } else if (s.equals("-version")) {
                    p.setProperty("version", args[++i]);
                } else if (s.equals("-encoding")) {
                    p.setProperty("encoding", args[++i]);
                } else if (s.equals("-method")) {
                    p.setProperty("method", args[++i]);
                } else if (s.equals("-cdata")) {
                    ++i;
                    String u = "";
                    while (i < args.length) {
                        if (args[i].equals("-endcdata")) break;
                        u = u + args[i] + ' ';
                        ++i;
                    }
                    p.setProperty("cdata-section-elements", u);
                } else if (s.equals("-other")) {
                    other = args[++i];
                } else if (s.equals("-apache")) {
                    useApache = true;
                } else if (s.startsWith("-P")) {
                    int equalsIndex = s.indexOf("=");
                    String name = s.substring(2, equalsIndex);
                    String value = s.substring(equalsIndex + 1);
                    params.setProperty(name, value);
                } else {
                    defaulted = true;
                    if (xml == null) {
                        xml = s;
                    } else if (xsl == null) {
                        xsl = s;
                    } else if (out == null) {
                        out = s;
                    } else {
                        CommandLine.printUsage();
                        return;
                    }
                }
                ++i;
            }
        }
        catch (RuntimeException e) {
            CommandLine.printUsage();
            return;
        }
        if (other != null) {
            SystemProperties.setProperty("javax.xml.transform.TransformerFactory", other);
        } else if (!useApache) {
            SystemProperties.setProperty("javax.xml.transform.TransformerFactory", "com.inqmy.lib.jaxp.TransformerFactoryImpl");
        } else {
            SystemProperties.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        }
        StreamResult streamResult = result = out == null ? new StreamResult(System.out) : new StreamResult(out);
        if (xml == null) {
            CommandLine.printUsage();
            return;
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = xsl == null ? tf.newTransformer() : tf.newTransformer(new StreamSource(xsl));
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            t.setOutputProperty(s, p.getProperty(s));
        }
        Enumeration<?> e2 = params.propertyNames();
        while (e2.hasMoreElements()) {
            String s = (String)e2.nextElement();
            t.setParameter(s, params.getProperty(s));
        }
        try {
            t.transform(new StreamSource(xml), result);
        }
        catch (StackOverflowError e3) {
            System.out.flush();
            System.out.println(e3);
        }
    }

    private static String nonNull(String s) {
        return s == null ? "NONE" : s;
    }
}

