/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml.parser.dtd;

import com.inqmy.lib.xml.Symbols;
import com.inqmy.lib.xml.parser.helpers.CharArray;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public final class ElementContentValidator {
    private static final char[] S_ANY = "ANY".toCharArray();
    private static final char[] S_EMPTY = "EMPTY".toCharArray();
    private static final char[] S_PCDATA = "#PCDATA".toCharArray();
    private static final char[] S_BRACKET_ASTERISK = ")*".toCharArray();
    private static final String E_OK = "Ok";
    private static final String E_STROKE_OR_BRACKET = "'|' or ')' expected";
    private static final String E_STROKE_OR_COMMA_OR_BRACKET = "'|' or ',' or ')' expected";
    private static final String E_GROUP_NOT_UNIFORM = "Group should either contain only ','s or only '|'s";
    private static final String E_END = "End of model expected";
    private static final String E_NAME = "Name expected";
    private static final String E_ASTERISK = "'*' expected";
    private static final String E_START = "Content model should be 'ANY', 'EMPTY', or start with '('";
    char[] s = new char[30];
    private int ps;
    private int ls;
    private String errorMessage;

    public boolean check(CharArray ca) {
        ca.trim();
        this.ls = ca.length();
        if (this.s.length <= this.ls) {
            this.s = new char[this.ls + 1];
        }
        ca.getChars(this.s);
        this.s[this.ls] = '\u0000';
        this.errorMessage = E_OK;
        this.ps = 0;
        this.skipS();
        if (this.confirm(S_ANY) || this.confirm(S_EMPTY)) {
            return this.confirmEnd();
        }
        if (!this.confirm('(')) {
            this.errorMessage = E_START;
            return false;
        }
        this.skipS();
        if (this.confirm(S_PCDATA)) {
            this.skipS();
            if (this.confirm(')')) {
                this.confirm('*');
                return this.confirmEnd();
            }
            do {
                this.skipS();
                char ch = this.s[this.ps];
                if (ch != '|' && ch != ')') {
                    this.errorMessage = E_STROKE_OR_BRACKET;
                    return false;
                }
                ++this.ps;
                if (ch == ')') {
                    if (!this.confirm('*')) {
                        this.errorMessage = E_ASTERISK;
                        return false;
                    }
                    return this.confirmEnd();
                }
                this.skipS();
            } while (this.skipName());
            return false;
        }
        if (!this.scanGroupWithoutOpeningBracket()) {
            return false;
        }
        this.scanQuantifiers();
        return this.confirmEnd();
    }

    private boolean confirm(char[] t) {
        if (t.length > this.ls - this.ps) {
            return false;
        }
        int i = 0;
        while (i < t.length) {
            if (t[i] != this.s[this.ps + i]) {
                return false;
            }
            ++i;
        }
        this.ps += t.length;
        return true;
    }

    private boolean confirm(char ch) {
        if (this.s[this.ps] != ch) {
            return false;
        }
        ++this.ps;
        return true;
    }

    private boolean skipName() {
        char ch = this.s[this.ps];
        if (!Symbols.isInitialNameChar(ch)) {
            this.errorMessage = E_NAME;
            return false;
        }
        do {
            ++this.ps;
        } while (Symbols.isNameChar(ch = this.s[this.ps]));
        return true;
    }

    private void skipS() {
        while (Symbols.isWhitespace(this.s[this.ps])) {
            ++this.ps;
        }
    }

    private boolean scanGroupWithoutOpeningBracket() {
        char ch;
        this.skipS();
        if (!this.scanGroupOrName()) {
            return false;
        }
        this.skipS();
        char op = this.s[this.ps];
        ++this.ps;
        if (op == ')') {
            this.scanQuantifiers();
            return true;
        }
        if (op != '|' && op != ',') {
            this.errorMessage = E_STROKE_OR_COMMA_OR_BRACKET;
            return false;
        }
        do {
            this.skipS();
            if (!this.scanGroupOrName()) {
                return false;
            }
            this.skipS();
            ch = this.s[this.ps];
            ++this.ps;
            if (ch == ')') {
                this.scanQuantifiers();
                return true;
            }
            if (ch == '|' || ch == ',') continue;
            this.errorMessage = E_STROKE_OR_COMMA_OR_BRACKET;
            return false;
        } while (ch == op);
        this.errorMessage = E_GROUP_NOT_UNIFORM;
        return false;
    }

    private boolean scanGroupOrName() {
        char ch = this.s[this.ps];
        if (ch == '(') {
            ++this.ps;
            if (!this.scanGroupWithoutOpeningBracket()) {
                return false;
            }
        } else {
            if (!this.skipName()) {
                return false;
            }
            this.scanQuantifiers();
        }
        return true;
    }

    private void scanQuantifiers() {
        char ch = this.s[this.ps];
        while (ch == '?' || ch == '*' || ch == '+') {
            ++this.ps;
            ch = this.s[this.ps];
        }
    }

    private boolean confirmEnd() {
        this.skipS();
        if (this.s[this.ps] != '\u0000') {
            this.errorMessage = E_END;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.errorMessage).append(" at (zero-based) position ").append(this.ps).append(" in content model '").append(this.s, 0, this.ls).append("'");
        try {
            b.append(" -> ").append(this.s, 0, this.ps).append(" << ").append(this.s[this.ps]).append(" >> ").append(this.s, this.ps + 1, this.ls - this.ps - 1);
        }
        catch (Exception e) {
            b.append("[EXCEPTION]");
        }
        return b.toString();
    }

    public static void testFromKeyboard() throws Exception {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        ElementContentValidator v = new ElementContentValidator();
        while (true) {
            System.out.print(" Model : ");
            String s = in.readLine();
            boolean r = v.check(new CharArray(s));
            System.out.println(" Result : " + v);
            System.out.println(" Result : " + r);
        }
    }

    public static void testAutomatic() throws Exception {
        CharArray[] right = new CharArray[]{new CharArray("(a)"), new CharArray("(a,b,c)"), new CharArray("(a|b|c)"), new CharArray("(a|(b,c))"), new CharArray("((a|b),c)"), new CharArray("(a+)"), new CharArray("(a)+"), new CharArray("(a?+*)*?+"), new CharArray("(a?,(a|b),c)"), new CharArray("(a|b|c|(d|e)|f)"), new CharArray("(a*,b,c?)"), new CharArray("(a?,a)"), new CharArray("(((((a)))))"), new CharArray("((a))"), new CharArray("((a)+)")};
        CharArray[] wrong = new CharArray[]{new CharArray("(a"), new CharArray("a)"), new CharArray("a*"), new CharArray("()"), new CharArray("(a|b,c)"), new CharArray("(?a)")};
        ElementContentValidator v = new ElementContentValidator();
        int i = 0;
        while (i < right.length) {
            if (v.check(right[i])) {
                System.out.print("OK '");
                System.out.print(right[i]);
                System.out.print("'  ->  RECOGNIZED");
            } else {
                System.out.print("ERROR '");
                System.out.print(right[i]);
                System.out.print("'  ->  ");
                System.out.print(v);
            }
            System.out.println();
            ++i;
        }
        int i2 = 0;
        while (i2 < wrong.length) {
            if (v.check(wrong[i2])) {
                System.out.print("ERROR '");
                System.out.print(wrong[i2]);
                System.out.print("'  ->  RECOGNIZED");
            } else {
                System.out.print("OK '");
                System.out.print(wrong[i2]);
                System.out.print("'  ->  ");
                System.out.print(v);
            }
            System.out.println();
            ++i2;
        }
    }

    public static void main(String[] args) throws Exception {
        ElementContentValidator.testAutomatic();
    }
}

