/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.generator;

import com.inqmy.lib.schema.SchemaException;
import com.inqmy.lib.schema.builtin.BuiltInManager;
import com.inqmy.lib.schema.generator.Codes;
import com.inqmy.lib.schema.generator.Generator;
import com.inqmy.lib.schema.generator.TreeWalker;
import java.io.File;
import java.io.PrintStream;

public final class GeneratorSimpleType {
    private Generator owner;
    private char[] code;
    protected boolean b0Declared;
    protected boolean b1Declared;
    protected TreeWalker walker;
    protected BuiltInManager manager;
    private String base;

    protected GeneratorSimpleType(Generator owner) {
        this.owner = owner;
        this.code = owner.code;
    }

    protected void update() {
        this.code = this.owner.code;
        this.walker = this.owner.walker;
        this.manager = this.owner.manager;
    }

    protected void generate(int t, File dir) {
        PrintStream out = this.owner.openPrintStreamForType(t, dir);
        String packageName = this.walker.getPackageOf(t);
        String className = this.walker.getNameOfType(t);
        int temp = className.lastIndexOf(46);
        if (temp != -1) {
            className = className.substring(temp + 1);
        }
        this.update();
        boolean hasPackage = packageName != null && !packageName.equals("");
        boolean isRestriction = this.walker.getPTRTo(t, '4') != -1;
        boolean isUnion = this.walker.getPTRTo(t, '!') != -1;
        boolean isList = this.walker.getPTRTo(t, '3') != -1;
        out.println(Generator.HEADER);
        out.println("// Location in compiled schema: @" + t);
        out.println();
        if (hasPackage) {
            out.println();
            out.print("package ");
            out.print(packageName);
            out.println(";");
        }
        out.println();
        this.owner.generateDoc(t, out);
        out.print("public final class ");
        out.print(className);
        out.println(" extends com.inqmy.lib.schema.generator.SimpleType {");
        out.println();
        int id = this.walker.getBIDOf(t);
        String jt = BuiltInManager.getJavaType(id);
        String jt1 = BuiltInManager.getJavaType1(id);
        this.owner.generateOriginals(out, t, className);
        out.println("  public void check(" + jt + " _x) {");
        this.generateCheckingCodeForSimpleType(t, id, out, "_x", "    ");
        out.println("  }");
        out.println();
        out.println("  public void checkString(java.lang.String _x) {");
        out.println("    check(_parse_" + jt1 + "(_x));");
        out.println("  }");
        out.println();
        out.println("  public " + BuiltInManager.getJavaType(id) + " unmarshal(java.lang.String _x) {");
        out.println("    return _parse_" + jt1 + "(_x);");
        out.println("  }");
        out.println();
        out.println("  public void marshal(" + jt + " _x, org.w3c.dom.Element _root) {");
        out.println("    set_xsi_type(_root," + id + ");");
        out.println("    java.lang.String _s = _toString_" + jt1 + "(_x, " + id + ");");
        out.println("    set_element_content(_s,_root);");
        out.println("  }");
        out.println();
        out.println("  public boolean isDerivedByRestriction() {");
        out.println("    return " + isRestriction + ";");
        out.println("  }");
        out.println();
        out.println("  public boolean isDerivedByUnion() {");
        out.println("    return " + isUnion + ";");
        out.println("  }");
        out.println();
        out.println("  public boolean isDerivedByList() {");
        out.println("    return " + isList + ";");
        out.println("  }");
        out.println();
        out.println("  public java.lang.String itemType() {");
        if (isList) {
            int it = this.walker.getItemTypeOfList(t);
            out.println("    return \"" + this.walker.getNameOfType(it) + "\";");
        } else {
            out.println("    return null;");
        }
        out.println("  }");
        out.println();
        out.println("  public java.lang.String baseType() {");
        if (isRestriction) {
            int bt = this.owner.owner.getWalker().getBaseOf(t);
            out.println("    return \"" + this.owner.owner.getWalker().getNameOfType(bt) + "\";");
        } else {
            out.println("    return null;");
        }
        out.println("  }");
        out.println("}");
    }

    protected void generateCheckingCodeForSimpleType(int t, int id, PrintStream out, String arg, String indent) {
        if (t == 1) {
            return;
        }
        if (t <= 0 || this.walker.getPTRTo(t, '4') != -1) {
            this.generateCheckingCodeForAtomicSimpleType(t, id, out, arg, indent);
            return;
        }
        if (this.walker.getPTRTo(t, '3') != -1) {
            this.generateCheckingCodeForListSimpleType(t, id, out, arg, indent);
            return;
        }
        if (this.walker.getPTRTo(t, '!') != -1) {
            this.generateCheckingCodeForUnionSimpleType(t, id, out, arg, indent);
            return;
        }
        throw new SchemaException("Neither RESTRICTION, nor LIST, nor UNION. @" + t);
    }

    private void generateCheckingCodeForListSimpleType(int t, int id, PrintStream out, String arg, String indent) {
    }

    private void generateCheckingCodeForUnionSimpleType(int t, int id, PrintStream out, String arg, String indent) {
    }

    private void generateCheckingCodeForAtomicSimpleType(int t, int id, PrintStream out, String arg, String indent) {
        this.b1Declared = false;
        this.b0Declared = false;
        if (Generator.OPTION_INLINE) {
            this.generateCheckingCodeForAtomicSimpleType0(t, id, out, arg, indent);
        } else {
            out.println(indent + "(new " + this.owner.owner.getWalker().getNameOfType(t) + "()).check(" + arg + ");");
        }
    }

    private void generateCheckingCodeForBuiltIn(int id, PrintStream out, String arg, String indent) {
        switch (-id) {
            case 0: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 34: 
            case 37: 
            case 40: 
            case 42: {
                break;
            }
            case 1: {
                out.println(indent + "_check_duration(" + arg + ");");
                break;
            }
            case 2: {
                out.println(indent + "_check_dateTime(" + arg + ");");
                break;
            }
            case 3: {
                out.println(indent + "_check_time(" + arg + ");");
                break;
            }
            case 4: {
                out.println(indent + "_check_date(" + arg + ");");
                break;
            }
            case 5: {
                out.println(indent + "_check_gYearMonth(" + arg + ");");
                break;
            }
            case 6: {
                out.println(indent + "_check_gYear(" + arg + ");");
                break;
            }
            case 7: {
                out.println(indent + "_check_gMonthDay(" + arg + ");");
                break;
            }
            case 8: {
                out.println(indent + "_check_gDay(" + arg + ");");
                break;
            }
            case 9: {
                out.println(indent + "_check_gMonth(" + arg + ");");
                break;
            }
            case 11: {
                out.println(indent + "_check_base64Binary(" + arg + ");");
                break;
            }
            case 12: {
                out.println(indent + "_check_hexBinary(" + arg + ");");
                break;
            }
            case 15: {
                out.println(indent + "_check_anyURI(" + arg + ");");
                break;
            }
            case 16: {
                out.println(indent + "_check_QName(" + arg + ");");
                break;
            }
            case 17: {
                out.println(indent + "_check_NOTATION(" + arg + ");");
                break;
            }
            case 19: {
                out.println(indent + "_check_normalizedString(" + arg + ");");
                break;
            }
            case 20: {
                out.println(indent + "_check_token(" + arg + ");");
                break;
            }
            case 21: {
                out.println(indent + "boolean __b2 = false;");
                out.println(indent + "for (int __i = 0; __i < _ISO_LANGUAGES.length; __i++) {");
                out.println(indent + "  if (" + arg + ".equals(_ISO_LANGUAGES[__i])) {");
                out.println(indent + "    __b2 = true;");
                out.println(indent + "  }");
                out.println(indent + "}");
                out.println(indent + "if (!__b2) {");
                out.println(indent + "  throw new com.inqmy.lib.schema.SchemaException(\"Built-in type check failed, 'xs:language'\");");
                out.println(indent + "}");
                break;
            }
            case 22: {
                out.println(indent + "_check_Name(" + arg + ");");
                break;
            }
            case 23: {
                out.println(indent + "_check_NMTOKEN(" + arg + ");");
                break;
            }
            case 24: {
                out.println(indent + "_check_NCName(" + arg + ");");
                break;
            }
            case 25: {
                out.println(indent + "_check_NMTOKENS(" + arg + ");");
                break;
            }
            case 26: {
                out.println(indent + "_check_ID(" + arg + ");");
                break;
            }
            case 27: {
                out.println(indent + "_check_IDREF(" + arg + ");");
                break;
            }
            case 28: {
                out.println(indent + "_check_ENTITY(" + arg + ");");
                break;
            }
            case 29: {
                out.println(indent + "_check_IDREFS(" + arg + ");");
                break;
            }
            case 30: {
                out.println(indent + "_check_ENTITIES(" + arg + ");");
                break;
            }
            case 31: {
                out.println(indent + "_check_decimal(" + arg + ");");
                break;
            }
            case 32: {
                out.println(indent + "_check_integer(" + arg + ");");
                break;
            }
            case 33: {
                out.println(indent + "_check_nonPositiveInteger(" + arg + ");");
                break;
            }
            case 35: {
                out.println(indent + "_check_nonNegativeInteger(" + arg + ");");
                break;
            }
            case 36: {
                out.println(indent + "_check_negativeInteger(" + arg + ");");
                break;
            }
            case 38: {
                out.println(indent + "_check_unsignedLong(" + arg + ");");
                break;
            }
            case 39: {
                out.println(indent + "_check_positiveInteger(" + arg + ");");
                break;
            }
            case 41: {
                out.println(indent + "_check_unsignedInt(" + arg + ");");
                break;
            }
            case 43: {
                out.println(indent + "_check_unsignedShort(" + arg + ");");
                break;
            }
            case 44: {
                out.println(indent + "_check_unsignedByte(" + arg + ");");
                break;
            }
            default: {
                throw new SchemaException("Built-in id not recognized, " + id);
            }
        }
    }

    private void generateCheckingCodeForAtomicSimpleType0(int t, int id, PrintStream out, String arg, String indent) {
        if (t <= 0) {
            this.generateCheckingCodeForBuiltIn(id, out, arg, indent);
            return;
        }
        if (this.code[t] != '\u000e') {
            throw new SchemaException("Not a built-in and not a SIMPLE_TYPE");
        }
        int b = this.walker.getBaseOf(t);
        if (b <= 0) {
            this.generateCheckingCodeForBuiltIn(b, out, arg, indent);
        } else if (b > 1) {
            this.generateCheckingCodeForAtomicSimpleType0(b, id, out, arg, indent);
        }
        int r = this.walker.getProperty(t, '4');
        if (r != -1) {
            this.generateFacets(r, id, out, arg, indent);
        }
    }

    private void generateFacets(int c, int id, PrintStream out, String arg, String indent) {
        boolean hasEnumeration = false;
        boolean hasPattern = false;
        int y = c + 1;
        while (this.code[y] != '\u0001') {
            char f;
            if (this.code[y] == '\u00c8' && this.code[f = this.code[y + 1]] != 'F') {
                if (!Codes.isFacetHeader(this.code[f])) {
                    throw new SchemaException("A child of a RESTRICTION is not a facet. ");
                }
                int v = this.walker.getProperty(f, '\u00d3');
                String ca0 = v == -1 ? "" : this.walker.getString(v);
                switch (this.code[f]) {
                    case 'o': {
                        out.println(indent + "_facet_minExclusive(" + arg + ", " + ca0 + "L);");
                        break;
                    }
                    case 'm': {
                        out.println(indent + "_facet_minInclusive(" + arg + ", " + ca0 + "L);");
                        break;
                    }
                    case 'l': {
                        out.println(indent + "_facet_maxExclusive(" + arg + ", " + ca0 + "L);");
                        break;
                    }
                    case 'k': {
                        out.println(indent + "_facet_maxInclusive(" + arg + ", " + ca0 + "L);");
                        break;
                    }
                    case 'u': {
                        out.println(indent + "_facet_totalDigits(" + arg + ", " + ca0 + ");");
                        break;
                    }
                    case 'v': {
                        out.println(indent + "_facet_fractionDigits(" + arg + ", " + ca0 + ");");
                        break;
                    }
                    case 'e': {
                        out.println(indent + "_facet_length(" + arg + ", " + ca0 + ");");
                        break;
                    }
                    case 'f': {
                        out.println(indent + "_facet_minLength(" + arg + ", " + ca0 + ");");
                        break;
                    }
                    case 'g': {
                        out.println(indent + "_facet_maxLength(" + arg + ", " + ca0 + ");");
                        break;
                    }
                    case 'i': {
                        if (!hasEnumeration) {
                            out.print(indent + "");
                            if (!this.b0Declared) {
                                out.print("boolean ");
                                this.b0Declared = true;
                            }
                            out.print("_b0 = false;");
                            out.println();
                            hasEnumeration = true;
                        }
                        String ca1 = GeneratorSimpleType.escape(ca0);
                        out.print(indent + "_b0 = _b0 || _facet_enumeration(" + arg + ", \"");
                        out.println(ca1 + "\");");
                        break;
                    }
                    case 'j': {
                        if (!BuiltInManager.getJavaType1(id).equals("String") || ca0.equals("preserve")) break;
                        out.println(indent + arg + " = _ws_" + ca0 + "(" + arg + ");");
                        break;
                    }
                    case 'h': {
                        if (!hasPattern) {
                            out.print(indent);
                            if (!this.b1Declared) {
                                out.print("boolean ");
                                this.b1Declared = true;
                            }
                            out.print("_b1 = false;");
                            out.println();
                            hasPattern = true;
                        }
                        out.print(indent + "_b1 = _b1 || _facet_pattern(" + arg + ", \"");
                        out.print(GeneratorSimpleType.escape(ca0));
                        out.print("\");");
                        out.println();
                        break;
                    }
                    default: {
                        throw new SchemaException("Facet not recognized.");
                    }
                }
            }
            y += 2;
        }
        if (hasEnumeration) {
            out.println("    if (!_b0) {");
            out.println("      throw new com.inqmy.lib.schema.SchemaException(\"Facet failed.\");");
            out.println("    }");
        }
        if (hasPattern) {
            out.println("    if (!_b1) {");
            out.println("      throw new com.inqmy.lib.schema.SchemaException(\"Facet failed.\");");
            out.println("    }");
        }
    }

    public static String escape(String s) {
        return Generator.escape(s);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(GeneratorSimpleType.escape("\t"));
    }
}

