/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.components.impl0;

import com.inqmy.lib.schema.components.AttributeDeclaration;
import com.inqmy.lib.schema.components.AttributeGroupDefinition;
import com.inqmy.lib.schema.components.AttributeUse;
import com.inqmy.lib.schema.components.Base;
import com.inqmy.lib.schema.components.ComplexTypeDefinition;
import com.inqmy.lib.schema.components.ElementDeclaration;
import com.inqmy.lib.schema.components.Facet;
import com.inqmy.lib.schema.components.FundamentalFacets;
import com.inqmy.lib.schema.components.IdentityConstraintDefinition;
import com.inqmy.lib.schema.components.ModelGroup;
import com.inqmy.lib.schema.components.ModelGroupDefinition;
import com.inqmy.lib.schema.components.NotationDeclaration;
import com.inqmy.lib.schema.components.Particle;
import com.inqmy.lib.schema.components.QualifiedBase;
import com.inqmy.lib.schema.components.Schema;
import com.inqmy.lib.schema.components.SimpleTypeDefinition;
import com.inqmy.lib.schema.components.TypeDefinitionBase;
import com.inqmy.lib.schema.components.Wildcard;
import com.inqmy.lib.schema.validator.CommandLine;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class ComponentPrinterToHTML {
    private static final String SPEC_BASE = CommandLine.getSpecBaseForJavaScript();
    private static final String ABSENT = "<i>\u00b7absent\u00b7</i>";
    private static final String CSS = "";
    private static final Hashtable HREFS_TO_W3C = new Hashtable();
    private static int[] COMPONENTS;
    private PrintStream out;
    private int counter;
    private Vector indexer = new Vector();
    private Vector temp = new Vector();
    private boolean printBuiltIn;
    private static String[] COLOURS_OF_COMPONENTS;

    private String getColourOf(Base x) {
        return this.getColourOf(x.getTypeOfComponent());
    }

    private String getColourOf(int t) {
        switch (t) {
            case 4: {
                return "#FFFF99";
            }
            case 5: {
                return "#CCFF99";
            }
            case 6: {
                return "#FF9999";
            }
            case 1: {
                return "blue";
            }
            case 3: {
                return "white";
            }
            case 11: {
                return "gray";
            }
            case 13: {
                return "gray";
            }
            case 7: {
                return "red";
            }
            case 8: {
                return "magenta";
            }
            case 14: {
                return "gray";
            }
            case 9: {
                return "brown";
            }
            case 2: {
                return "#0088FF";
            }
            case 10: {
                return "#FF99FF";
            }
        }
        return "gray";
    }

    public void print(Schema schema, OutputStream out0, boolean printBuiltIn) {
        this.out = out0 instanceof PrintStream ? (PrintStream)out0 : new PrintStream(out0);
        this.printBuiltIn = printBuiltIn;
        this.indexer.clear();
        this.getIndex(schema);
        this.counter = 0;
        this.out.println("<html>");
        this.out.println("  <head>");
        this.out.println("    <style></style>");
        this.out.println("  </head>");
        this.out.println("  <body>");
        this.out.println("    <center>");
        this.out.println("      <h3>This is what the components of the schema look like</h3><br>");
        this.out.println("      <table border='0' id='legend'><caption><b>Legend</b></caption>");
        int i = 0;
        while (i < COMPONENTS.length) {
            this.out.println("        <tr>");
            this.out.println("          <td width='15'><a class='C_" + Base.SHORT_NAMES_OF_COMPONENTS[i] + "'>#</td>");
            this.out.println("          <td>" + Base.NAMES_OF_COMPONENTS[COMPONENTS[i]] + "</td>");
            this.out.println("        </tr>");
            ++i;
        }
        this.out.println("      </table>");
        this.out.println("    </center>");
        while (this.counter < this.indexer.size()) {
            this.p((Base)this.indexer.get(this.counter));
        }
        this.out.println("    <p align='right'><i>Nick Nickolov</i></p>");
        this.out.println("    <table height='1000' border='0'><tr><td>&nbsp;</td></tr></table><!-- to ensure some space at the end for scrolling -->");
        this.out.println("  </body>");
        this.out.println("</html>");
        this.out.flush();
    }

    private void p(Base x) {
        if (!this.printBuiltIn && x.isBuiltIn()) {
            return;
        }
        int tx = x.getTypeOfComponent();
        int index = this.getIndex(x);
        String hrefToW3C = (String)HREFS_TO_W3C.get(new Integer(tx));
        this.out.println("            <br><br>");
        this.out.println("            <table id='c" + index + "' bordercolor='#444444' width='100%' border='1'>");
        this.out.println("              <tr>");
        this.out.println("                <td colspan='2'>");
        this.out.println("                  <table border='0' cellspacing='0' cellpadding='0' width='100%'>");
        this.out.println("                    <tr>");
        this.out.println("                      <td>");
        this.out.println("                        <button onClick='document.location=\"" + (index == 0 ? "#c0" : "#c" + (index - 1)) + "\";'>prev</button>");
        this.out.println("                      </td>");
        this.out.println("                      <td>");
        this.out.println("                        <button onClick='document.location=\"" + "#c" + (index + 1) + "\";'>next</button>");
        this.out.println("                      </td>");
        this.out.println("                      <td>");
        this.out.println("                        &nbsp;<button onClick='history.back(1);'>back</button>");
        this.out.println("                      </td>");
        this.out.println("                      <td width='100%' align='center'>");
        this.out.println("                        <big><b><font color='" + this.getColourOf(x) + "'>#c" + index + ": " + x.getNameOfComponent() + "</font></b></big>");
        this.out.println("                      </td>");
        this.out.println("                      <td>");
        this.out.println("                        <button onClick='document.location=\"" + (hrefToW3C != null ? SPEC_BASE + hrefToW3C : CSS) + "\"'>spec</button>");
        this.out.println("                      </td>");
        this.out.println("                    </tr>");
        this.out.println("                  </table>");
        this.out.println("                </td>");
        this.out.println("              </tr>");
        ++this.counter;
        switch (tx) {
            case 4: {
                AttributeDeclaration y = (AttributeDeclaration)x;
                this.qQualified(y);
                this.q("type definition", y.getTypeDefinition());
                this.q("scope", y.getScope());
                this.qValueConstraint(y.getValueConstraintDefault(), y.getValueConstraintFixed());
                break;
            }
            case 5: {
                AttributeGroupDefinition y = (AttributeGroupDefinition)x;
                this.qQualified(y);
                this.temp.clear();
                y.getAttributeUses(this.temp);
                this.qVector("attribute uses", this.temp);
                this.q("attribute wildcard", y.getAttributeWildcard());
                break;
            }
            case 6: {
                AttributeUse y = (AttributeUse)x;
                this.q("required", String.valueOf(y.isRequired()));
                this.q("attribute declaration", y.getAttributeDeclaration());
                this.qValueConstraint(y.getValueConstraintDefault(), y.getValueConstraintFixed());
                break;
            }
            case 1: {
                ComplexTypeDefinition y = (ComplexTypeDefinition)x;
                this.qQualified(y);
                this.q("base type definition", y.getBaseTypeDefinition());
                this.q("derivation method", y.isDerivationMethodExtension() ? "extension" : "restriction");
                this.q("final", "{ " + (y.isFinalExtension() ? "extension " : CSS) + (y.isFinalRestriction() ? "restriction " : CSS) + "}");
                this.q("abstract", String.valueOf(y.isAbstract()));
                this.temp.clear();
                y.getAttributeUses(this.temp);
                y.getAttributeUses(this.temp);
                this.qVector("attribute uses", this.temp);
                this.q("attribute wildcard", y.getAttributeWildcard());
                SimpleTypeDefinition ctst = y.getContentTypeSimpleTypeDefinition();
                Particle ctcm = y.getContentTypeContentModel();
                if (ctst != null) {
                    this.q("content type", ctst);
                } else if (ctcm != null) {
                    this.q("content type", "&lt;" + this.formatRef(ctcm) + ", " + (y.isMixed() ? "mixed&gt;" : "element-only&gt;"));
                } else {
                    this.q("content type", ABSENT);
                }
                this.q("prohibited substitutions", "{ " + (y.isProhibitedSubstitutionExtension() ? "extension " : CSS) + (y.isProhibitedSubstitutionRestriction() ? "restriction " : CSS) + "}");
                break;
            }
            case 3: {
                ElementDeclaration y = (ElementDeclaration)x;
                this.qQualified(y);
                this.q("type definition", y.getTypeDefinition());
                this.q("scope", y.getScope());
                this.qValueConstraint(y.getValueConstraintDefault(), y.getValueConstraintFixed());
                this.q("nillable", String.valueOf(y.isNillable()));
                this.temp.clear();
                y.getIdentityConstraintDefinitions(this.temp);
                this.qVector("identity-constraint definitions", this.temp);
                this.q("substitution group affiliation", y.getSubstitutionGroupAffiliation());
                this.q("substitution group exclusions", "{ " + (y.isSubstitutionGroupExclusionExtension() ? "extension " : CSS) + (y.isSubstitutionGroupExclusionRestriction() ? "restriction " : CSS) + "}");
                this.q("disallowed substitutions", "{ " + (y.isDisallowedSubstitutionSubstitution() ? "substitution " : CSS) + (y.isDisallowedSubstitutionExtension() ? "extension " : CSS) + (y.isDisallowedSubstitutionRestriction() ? "restriction " : CSS) + "}");
                this.q("abstract", String.valueOf(y.isAbstract()));
                break;
            }
            case 11: {
                Facet y = (Facet)x;
                this.q("name", y.getName());
                this.q("value", "\"" + y.getValue() + "\"");
                this.q("fixed", String.valueOf(y.isFixed()));
                break;
            }
            case 12: {
                FundamentalFacets y = (FundamentalFacets)x;
                this.q("ordered", String.valueOf(y.isOrdered()));
                this.q("bounded", String.valueOf(y.isBounded()));
                this.q("cardinality", y.isCardinalityCountablyInfinite() ? "countably infinite" : "finite");
                this.q("numeric", String.valueOf(y.isNumeric()));
                break;
            }
            case 13: {
                IdentityConstraintDefinition y = (IdentityConstraintDefinition)x;
                this.qQualified(y);
                this.q("identity-constraint category", y.isIdentityConstraintCategoryKey() ? "key" : (y.isIdentityConstraintCategoryKeyref() ? "keyref" : "unique"));
                this.q("selector", y.getSelector());
                this.q("referenced key", y.getReferencedKey());
                break;
            }
            case 7: {
                ModelGroup y = (ModelGroup)x;
                this.q("compositor", y.isCompositorAll() ? "all" : (y.isCompositorChoice() ? "choice" : "sequence"));
                this.temp.clear();
                y.getParticles(this.temp);
                this.qVector("particles", this.temp);
                break;
            }
            case 8: {
                ModelGroupDefinition y = (ModelGroupDefinition)x;
                this.qQualified(y);
                this.q("model group", y.getModelGroup());
                break;
            }
            case 14: {
                NotationDeclaration y = (NotationDeclaration)x;
                this.qQualified(y);
                this.q("target namespace", y.getTargetNamespace());
                this.q("system identifier", y.getSystemIdentifier());
                this.q("public identifier", y.getPublicIdentifier());
                break;
            }
            case 9: {
                Particle y = (Particle)x;
                int a = y.getMaxOccurs();
                this.q("min occurs", String.valueOf(y.getMinOccurs()));
                this.q("max occurs", a == Integer.MAX_VALUE ? "unbounded" : String.valueOf(a));
                this.q("term", y.getTerm());
                break;
            }
            case 0: {
                Schema y = (Schema)x;
                Vector v_td = new Vector();
                Vector v_ad = new Vector();
                Vector v_ed = new Vector();
                Vector v_agd = new Vector();
                Vector v_mgd = new Vector();
                Vector v_nd = new Vector();
                y.getTopLevelTypeDefinitions(v_td);
                y.getTopLevelAttributeDeclarations(v_ad);
                y.getTopLevelElementDeclarations(v_ed);
                y.getTopLevelAttributeGroupDefinitions(v_agd);
                y.getTopLevelModelGroupDefinitions(v_mgd);
                y.getTopLevelNotationDeclarations(v_nd);
                this.qVector("type definitions", v_td);
                this.qVector("attribute declarations", v_ad);
                this.qVector("element declarations", v_ed);
                this.qVector("attribute group definitions", v_agd);
                this.qVector("model group definitions", v_mgd);
                this.qVector("notation declarations", v_nd);
                break;
            }
            case 2: {
                SimpleTypeDefinition y = (SimpleTypeDefinition)x;
                this.qQualified(y);
                this.q("base type definition", y.getBaseTypeDefinition());
                this.temp.clear();
                y.getFacets(this.temp);
                this.qVector("facets", this.temp);
                this.q("fundamental facets", y.getFundamentalFacets());
                this.q("final", "{ " + (y.isFinalExtension() ? "extension " : CSS) + (y.isFinalList() ? "list " : CSS) + (y.isFinalRestriction() ? "restriction " : CSS) + (y.isFinalUnion() ? "union " : CSS) + "}");
                if (y.isVarietyAtomic()) {
                    this.q("variety", "atomic");
                    this.q("primitive type definition", y.getPrimitiveTypeDefinition());
                    break;
                }
                if (y.isVarietyList()) {
                    this.q("variety", "list");
                    this.q("item type definition", y.getItemTypeDefinition());
                    break;
                }
                if (y.isVarietyUnion()) {
                    this.q("variety", "union");
                    StringBuffer b = new StringBuffer();
                    b.append("{ ");
                    this.temp.clear();
                    y.getMemberTypeDefinitions(this.temp);
                    Enumeration e = this.temp.elements();
                    while (e.hasMoreElements()) {
                        TypeDefinitionBase t = (TypeDefinitionBase)e.nextElement();
                        b.append(this.formatRef(t) + ' ');
                    }
                    b.append("}");
                    this.q("member type definitions", b.toString());
                    break;
                }
                this.q("variety", "???");
                break;
            }
            case 10: {
                Wildcard y = (Wildcard)x;
                if (y.isNamespaceConstraintAny()) {
                    this.q("namespace constraint", "any");
                    break;
                }
                if (y.getNamespaceConstraintNegated() != null) {
                    this.q("namespace constraint", "<not, " + y.getNamespaceConstraintNegated() + ">");
                    break;
                }
                if (y.isNamespaceConstraintAny()) {
                    this.q("namespace constraint", "any");
                    break;
                }
                if (y.getNamespaceConstraintNegated() != null) {
                    this.q("namespace constraint", "<not, \"" + y.getNamespaceConstraintNegated() + "\"");
                    break;
                }
                this.temp.clear();
                y.getNamespaceConstraintMembers(this.temp);
                StringBuffer b = new StringBuffer("{ ");
                int i = 0;
                while (i < this.temp.size()) {
                    b.append("\"");
                    b.append(this.temp.get(i));
                    b.append("\" ");
                    ++i;
                }
                b.append("}");
                this.q("namespace constraint", b.toString());
                break;
            }
        }
        this.out.println("            </table>");
    }

    private void q(String nameOfProperty, String value) {
        this.out.print("                <tr><td width='50%'>{" + nameOfProperty + "}</td><td>");
        this.out.println(this.nn(value) + "</td></tr>");
    }

    private void q(String nameOfProperty, Base value) {
        this.out.print("                <tr><td width='50%'>{" + nameOfProperty + "}</td><td>");
        if (value == null) {
            this.out.print(ABSENT);
        } else {
            this.out.print(this.formatRef(value));
        }
        this.out.println("</td></tr>");
    }

    private void qQualified(QualifiedBase x) {
        String name = x.getName();
        if (name == null || name.length() == 0) {
            this.q("name", ABSENT);
        } else {
            this.q("name", "\"" + name + "\"");
        }
        String tns = x.getTargetNamespace();
        if (tns == null || tns.length() == 0) {
            this.q("target namespace", "<i>the null uri</i>");
        } else {
            this.q("target namespace", "\"" + tns + "\"");
        }
    }

    private void qVector(String nameOfProperty, Vector v) {
        StringBuffer b = new StringBuffer("{ ");
        int nv = v.size();
        boolean first = true;
        int nBuiltIn = 0;
        int i = 0;
        while (i < nv) {
            Base x = (Base)v.get(i);
            if (x.isBuiltIn() && !this.printBuiltIn) {
                ++nBuiltIn;
            } else {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append(this.formatRef(x));
            }
            ++i;
        }
        b.append(" }");
        if (nBuiltIn > 0) {
            b.append("<i> (" + nBuiltIn + " built-in components were not shown)</i>");
        }
        this.q(nameOfProperty, b.toString());
    }

    private void qValueConstraint(String vcd, String vcf) {
        String vc = vcd != null ? "&lt;\"" + vcd + "\", default&gt;" : (vcf != null ? "&lt;\"" + vcf + "\", fixed&gt;" : ABSENT);
        this.q("value constraint", vc);
    }

    private String nn(String s) {
        return s == null ? ABSENT : s;
    }

    private int getIndex(Base x) {
        if (!this.printBuiltIn && x.isBuiltIn()) {
            return -1;
        }
        int r = this.indexer.indexOf(x);
        if (r == -1) {
            r = this.indexer.size();
            this.indexer.add(x);
        }
        return r;
    }

    private String formatRef(Base x) {
        int index = this.getIndex(x);
        if (index == -1) {
            if (x instanceof QualifiedBase) {
                QualifiedBase q = (QualifiedBase)x;
                return "<i>built-in " + x.getNameOfComponent() + " \"" + q.getName() + "\"</i>";
            }
            return "<i>built-in " + x.getNameOfComponent() + "</i>";
        }
        return "<a href='#c" + index + "'>#c" + index + (x instanceof QualifiedBase ? "(\"" + ((QualifiedBase)x).getName() + "\")" : CSS) + "</a>";
    }

    public static void createCSS(PrintStream out) {
        out.println("/*");
        out.println("  Generated SAP's schema component visualizer");
        out.println("  Author: Nick Nickolov, nick_nickolov@abv.bg");
        out.println("*/");
        out.println("body {");
        out.println("  background-color: black;");
        out.println("  color: #449944;");
        out.println("}");
        out.println("button {");
        out.println("  background-color: black;");
        out.println("  color: #449944;");
        out.println("  border: solid green double;");
        out.println("  border-width: thin;");
        out.println("  font-weight: bold;");
        out.println("  font-family: courier new;");
        out.println("  padding:0");
        out.println("}");
        int i = 0;
        while (i < Base.NAMES_OF_COMPONENTS.length) {
            out.println("a.C_" + Base.SHORT_NAMES_OF_COMPONENTS[i] + " {");
            out.println("  color: " + COLOURS_OF_COMPONENTS[i] + ";");
            out.println("}");
            ++i;
        }
    }

    static {
        HREFS_TO_W3C.put(new Integer(4), "Attribute_Declaration_details");
        HREFS_TO_W3C.put(new Integer(3), "Element_Declaration_details");
        HREFS_TO_W3C.put(new Integer(1), "Complex_Type_Definition_details");
        HREFS_TO_W3C.put(new Integer(6), "AU_details");
        HREFS_TO_W3C.put(new Integer(5), "Attribute_Group_Definition_details");
        HREFS_TO_W3C.put(new Integer(8), "Model_Group_Definition_details");
        HREFS_TO_W3C.put(new Integer(7), "Model_Group_details");
        HREFS_TO_W3C.put(new Integer(9), "Particle_details");
        HREFS_TO_W3C.put(new Integer(10), "Wildcard_details");
        HREFS_TO_W3C.put(new Integer(13), "Identity-constraint_Definition_details");
        HREFS_TO_W3C.put(new Integer(14), "Notation_Declaration_details");
        HREFS_TO_W3C.put(new Integer(15), "Annotation_details");
        HREFS_TO_W3C.put(new Integer(2), "Simple_Type_Definition_details");
        HREFS_TO_W3C.put(new Integer(0), "Schema_details");
        COMPONENTS = new int[]{0, 3, 4, 5, 6, 2, 1, 8, 7, 9, 10, 11, 13};
        COLOURS_OF_COMPONENTS = new String[Base.NAMES_OF_COMPONENTS.length];
        ComponentPrinterToHTML.COLOURS_OF_COMPONENTS[4] = "#FFFF99";
        ComponentPrinterToHTML.COLOURS_OF_COMPONENTS[4] = "#FFFF99";
        ComponentPrinterToHTML.COLOURS_OF_COMPONENTS[5] = "#CCFF99";
        ComponentPrinterToHTML.COLOURS_OF_COMPONENTS[6] = "#FF9999";
        ComponentPrinterToHTML.COLOURS_OF_COMPONENTS[1] = "blue";
        ComponentPrinterToHTML.COLOURS_OF_COMPONENTS[3] = "white";
        ComponentPrinterToHTML.COLOURS_OF_COMPONENTS[11] = "gray";
        ComponentPrinterToHTML.COLOURS_OF_COMPONENTS[13] = "gray";
        ComponentPrinterToHTML.COLOURS_OF_COMPONENTS[7] = "red";
        ComponentPrinterToHTML.COLOURS_OF_COMPONENTS[8] = "magenta";
        ComponentPrinterToHTML.COLOURS_OF_COMPONENTS[14] = "gray";
        ComponentPrinterToHTML.COLOURS_OF_COMPONENTS[9] = "brown";
        ComponentPrinterToHTML.COLOURS_OF_COMPONENTS[2] = "#0088FF";
        ComponentPrinterToHTML.COLOURS_OF_COMPONENTS[10] = "#FF99FF";
    }
}

