/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.techdev.addLib;

import com.sap.tc.buildplugin.api.BuildActionResult;
import com.sap.tc.buildplugin.api.BuildActionSeverity;
import com.sap.tc.buildplugin.api.IBuildAction;
import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildplugin.pputil.PPCollector;
import com.sap.tc.buildplugin.techdev.ant.util.DirsAndFiles;
import com.sap.tc.buildplugin.techdev.ant.util.FileCreator;
import com.sap.tc.buildplugin.util.ComponentDependencies;
import com.sap.tc.buildplugin.util.Descriptors;
import com.sap.tc.buildtool.LogFile;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CreateBuildFileAction
implements IBuildAction {
    BuildActionResult result;
    BuildActionSeverity severity;
    File pluginRoot;
    DirsAndFiles daf;
    FileCreator fCreator;
    ArrayList jars = new ArrayList();
    int br = 0;
    String errMsg = "";
    int currentStep;
    Descriptors descriptors = new Descriptors();
    List externalCompPP = new ArrayList();
    IBuildInfo buildInfo;
    Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$techdev$addLib$CreateBuildFileAction == null ? (class$com$sap$tc$buildplugin$techdev$addLib$CreateBuildFileAction = CreateBuildFileAction.class$("com.sap.tc.buildplugin.techdev.addLib.CreateBuildFileAction")) : class$com$sap$tc$buildplugin$techdev$addLib$CreateBuildFileAction));
    static /* synthetic */ Class class$com$sap$tc$buildplugin$techdev$addLib$CreateBuildFileAction;

    CreateBuildFileAction(FileCreator fc, int step, IBuildInfo buildInfo) {
        this.fCreator = fc;
        this.daf = fc.getDaf();
        this.currentStep = step;
        this.buildInfo = buildInfo;
        this.result = new BuildActionResult();
        this.severity = new BuildActionSeverity();
        this.severity.setStopOnError();
    }

    public BuildActionResult execute() {
        String msg;
        File ownProviderXml;
        this.loc.infoT("Additional Library Plugin starts creating the build file");
        IDevelopmentComponentInfo componentInfo = this.buildInfo.getDevelopmentComponentInfo();
        switch (this.currentStep) {
            case 1: {
                this.daf.setBuildFile("prebuild.xml");
                this.fCreator.setMacroName("prebuild.vm");
                break;
            }
            case 2: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
                break;
            }
            case 3: {
                this.daf.setBuildFile("postbuild.xml");
                this.fCreator.setMacroName("postbuild.vm");
                break;
            }
            default: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
            }
        }
        String prebuildDir = this.daf.getTempDir() + File.separator + "pre";
        this.fCreator.setStrContext("dc_prebuild_Dir", prebuildDir);
        File prebuildDirF = new File(prebuildDir);
        if (prebuildDirF.exists()) {
            this.fCreator.setStrContext("dc_prebuild_Dir_exist", "true");
        }
        this.fCreator.setStrContext("dc_root_Dir", this.daf.getRootDir());
        List sourceDirs = this.daf.getSourceDirs();
        this.fCreator.setListContext("dc_source_dirs", sourceDirs);
        Map ppMap = this.daf.getPublicParts();
        if (ppMap != null) {
            PPCollector pp = new PPCollector(componentInfo);
            this.br = pp.addData(ppMap);
            this.errMsg = pp.getErrorMsg();
            this.fCreator.setListContext("dc_public_parts", pp.getList());
        }
        List assDep = this.daf.getAssemblyDirs();
        this.fCreator.setListContext("dc_depend_assemblyDirs", assDep);
        HashMap<String, String> nativeAssDep = new HashMap<String, String>();
        int i = 0;
        while (i < assDep.size()) {
            String currentDep = (String)assDep.get(i);
            File currAssDepNative = new File(currentDep + "lib" + File.separator + "native");
            if (currAssDepNative.exists()) {
                nativeAssDep.put(currentDep, "true");
            }
            ++i;
        }
        this.fCreator.setHashMapContext("dc_depend_assemblyNativeDirs", nativeAssDep);
        List compileDep = this.daf.getDependDirs();
        this.fCreator.setListContext("dc_depend_compileDirs", compileDep);
        this.fCreator.setListContext("dc_depend_compilePPs", this.daf.getCompilationDirs());
        this.fCreator.setStrContext("dc_gen_publicDir", this.daf.getGenDirPublic());
        this.fCreator.setStrContext("dc_gen_tempDir", this.daf.getTempDir());
        this.fCreator.setStrContext("dc_deployDir", this.daf.getGenDirDeploy());
        this.fCreator.setStrContext("dc_deployFile", this.daf.getDcFile());
        String dcName = this.daf.getDCName();
        String vendorName = this.daf.getDCVendor();
        String genMetaInfDir = this.daf.getTempDir() + File.separator + "server";
        File metaInfDir = new File(genMetaInfDir);
        if (!metaInfDir.exists()) {
            metaInfDir.mkdirs();
        }
        String providerXml = genMetaInfDir + File.separator + "provider.xml";
        List compDep = this.daf.getDependencies();
        ArrayList<ComponentDependencies> allDep = new ArrayList<ComponentDependencies>();
        if (compDep != null) {
            Iterator it = compDep.iterator();
            while (it.hasNext()) {
                boolean isCurrentDepDCExternal;
                Dependency dep = (Dependency)it.next();
                String name = dep.getComponent().getName();
                String vendor = dep.getComponent().getVendor();
                ComponentType type = null;
                DevelopmentComponent dc = this.daf.getReferencedComponent(dep);
                if (dc != null) {
                    type = dc.getComponentType();
                }
                if (type == null) {
                    allDep.add(new ComponentDependencies(name, vendor, dep.isAtDeployTime(), dep.isAtRunTime(), dep.getRuntimeQuialifier(), "", "", ""));
                } else {
                    allDep.add(new ComponentDependencies(name, vendor, dep.isAtDeployTime(), dep.isAtRunTime(), dep.getRuntimeQuialifier(), type.getVendor(), type.getType(), type.getSubType()));
                }
                boolean isAtBuildTimeDep = dep.isAtBuildTime();
                if (!isAtBuildTimeDep || dc == null || !(isCurrentDepDCExternal = dc.isExternal())) continue;
                this.externalCompPP = this.collectExternalCompPP(dep);
            }
        }
        if (!(ownProviderXml = new File(this.daf.getRootDir() + File.separator + "server" + File.separator + "provider.xml")).exists()) {
            try {
                this.descriptors.generateProviderXml(providerXml, this.daf, allDep, assDep, this.externalCompPP);
            }
            catch (IOException ioe) {
                msg = "error generating provider.xml";
                this.loc.traceThrowableT(500, msg, (Throwable)ioe);
            }
        }
        try {
            this.fCreator.setStrContext("compiler_executable_path", this.buildInfo.getCompilerExecutable());
        }
        catch (NoSuchMethodError ex) {
            msg = "pluginhandler does not supply getCompilerExecutable";
            this.loc.traceThrowableT(300, msg, (Throwable)ex);
        }
        this.fCreator.setListContext("dc_depend_allDirs", allDep);
        this.fCreator.setListContext("dc_depend_externalCompileDirs", this.externalCompPP);
        this.fCreator.setStrContext("dc_jarSAP_location", this.daf.getCBSLocation());
        this.fCreator.setStrContext("dc_jarSAP_counter", this.daf.getCBSCounter());
        this.fCreator.setStrContext("dc_jarSAP_vendor", this.daf.getDCVendor());
        this.fCreator.setStrContext("dc_jarSAP_name", this.daf.getDCName());
        this.fCreator.setStrContext("dc_jarSAP_scvendor", componentInfo.getCompartment().getScVendor());
        this.fCreator.setStrContext("dc_jarSAP_scname", componentInfo.getCompartment().getScName());
        String mfName = this.daf.getTempDir() + File.separator + "Manifest.mf";
        this.daf.createManifestFile(mfName);
        this.fCreator.setStrContext("bi_manifest_Name", mfName);
        if (this.br != 2 && this.br != 3 && this.daf.checkAssDependencies() && this.daf.checkCompDependencies()) {
            this.fCreator.createBuildFile();
        } else {
            LogFile log = new LogFile();
            if (!this.daf.checkAssDependencies()) {
                this.errMsg = this.daf.getErrorMsgAss();
                this.br = 2;
            } else if (!this.daf.checkCompDependencies()) {
                this.errMsg = this.daf.getErrorMsgCompile();
                this.br = 2;
            }
            log.setErrorMessage(this.errMsg);
            log.writeLogFile(this.daf.getLogFile());
        }
        this.result.setBuildLogPath(this.daf.getLogFile());
        this.result.setBuildActionRC(this.br);
        return this.result;
    }

    public BuildActionResult getBuildActionResult() {
        return this.result;
    }

    public BuildActionSeverity getBuildActionSeverity() {
        return this.severity;
    }

    public void setBuildActionSeverity(BuildActionSeverity _severity) {
        this.severity = _severity;
    }

    public String getCaption() {
        return "Create Build file";
    }

    private List collectExternalCompPP(Dependency dep) {
        DevelopmentComponent dc = this.daf.getReferencedComponent(dep);
        DCReference dcRef = dep.getComponent();
        Map pps = dc.getPublicParts();
        Iterator iter = pps.values().iterator();
        boolean isAssPPAvailable = false;
        while (iter.hasNext()) {
            PublicPart currentPp = (PublicPart)iter.next();
            if (currentPp != null && currentPp.getPurpose().equals(PublicPart.Purpose.ASSEMBLY)) {
                isAssPPAvailable = true;
                break;
            }
            PPReference ppRef = dep.getPublicPartDependency();
            if (pps == null) continue;
            if (ppRef != null && ppRef.getName() != null) {
                PublicPart pp = (PublicPart)pps.get(ppRef.getName());
                if (pp != null && pp.getPurpose().equals(PublicPart.Purpose.ASSEMBLY) || pp == null || !pp.getPurpose().equals(PublicPart.Purpose.COMPILATION) || isAssPPAvailable) continue;
                String externalPPRef = this.buildInfo.getDevelopmentComponentInfo().getUsedPublicPartGenFolder(ppRef);
                this.externalCompPP.add(externalPPRef);
                continue;
            }
            pps = dc.getPublicParts();
            Iterator ppiter = pps.values().iterator();
            while (ppiter.hasNext()) {
                PublicPart pp = (PublicPart)ppiter.next();
                ppRef = new PPReference(pp.getName(), dcRef);
                if (pp == null || !pp.getPurpose().equals(PublicPart.Purpose.COMPILATION) || isAssPPAvailable) continue;
                ppRef = new PPReference(pp.getName(), dcRef);
                String externalPPRef = this.buildInfo.getDevelopmentComponentInfo().getUsedPublicPartGenFolder(ppRef);
                this.externalCompPP.add(externalPPRef);
            }
        }
        return this.externalCompPP;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

