/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.validation;

import com.sap.cms.client.validation.CmsString;
import com.sap.cms.util.exception.misc.CMSBlankPaddedStringException;
import com.sap.cms.util.exception.misc.CMSEmptyStringException;
import com.sap.cms.util.exception.misc.CMSInvalidCharacterException;
import com.sap.cms.util.exception.misc.CMSStringToLongException;
import com.sap.cms.util.exception.misc.CMSValidateException;
import com.tssap.dtr.client.lib.protocol.URL;
import java.net.MalformedURLException;

public abstract class InputValidator {
    public static final String SEPARATOR_ALLOWED_TRUE = "TRUE";
    public static final String SEPARATOR_ALLOWED_FALSE = "FALSE";
    public static final String TYPE_STRING = "STRING";
    public static final String TYPE_URL = "URL";
    public static final int MAX_CAPTION_SIZE = 80;
    public static final int MAX_DESCRIPTION_SIZE = 255;
    public static final int MAX_URL_SIZE = 255;
    public static final int MAX_STRING_LEN = 10000;
    public static final String[] VERSION = new String[]{"STRING", "1", "10", "TRUE"};
    public static final String[] CAPTION = new String[]{"STRING", "1", "80", "TRUE"};
    public static final String[] DESCRIPTION = new String[]{"STRING", "1", "255", "TRUE"};
    public static final String[] URL = new String[]{"URL", "1", "255", "TRUE"};
    public static final String[] TIME = new String[]{"STRING", "1", "14", "TRUE"};
    public static final String[] USER = new String[]{"STRING", "1", "20", "TRUE"};
    public static final String[] PASSWORD = new String[]{"STRING", "1", "20", "TRUE"};
    public static final String[] HOST = new String[]{"STRING", "1", "255", "TRUE"};
    public static final String[] PORT = new String[]{"STRING", "1", "10", "TRUE"};

    public static void validate(String name, String[] boundaries, String value) throws CMSValidateException {
        String type = boundaries[0];
        int minValueSize = Integer.parseInt(boundaries[1]);
        int maxValueSize = Integer.parseInt(boundaries[2]);
        String separatorAllowed = boundaries[3];
        if (value != null) {
            switch (CmsString.check(value)) {
                case 2: {
                    Object[] args = new String[]{name, value};
                    throw new CMSBlankPaddedStringException(args);
                }
                case 1: {
                    Object[] args1 = new String[]{name, value};
                    throw new CMSEmptyStringException(args1);
                }
            }
            if (type.equals(TYPE_STRING)) {
                if (separatorAllowed.equals(SEPARATOR_ALLOWED_FALSE) && value.indexOf("_") != -1) {
                    Object[] args = new String[]{name, value, "' '"};
                    throw new CMSInvalidCharacterException(args);
                }
                if (value.length() > maxValueSize) {
                    Object[] args = new String[]{name, value, "" + maxValueSize};
                    throw new CMSStringToLongException(args);
                }
            } else if (type.equals(TYPE_URL)) {
                if (value.length() > maxValueSize) {
                    Object[] args = new String[]{name, value, "" + maxValueSize};
                    throw new CMSStringToLongException(args);
                }
                try {
                    new URL(value);
                }
                catch (MalformedURLException e) {
                    throw new CMSValidateException((Throwable)e);
                }
            } else if (value.length() > 10000) {
                Object[] args = new String[]{name, value, "10000"};
                throw new CMSStringToLongException(args);
            }
        }
    }

    public static void validate(String value) throws CMSValidateException {
        switch (CmsString.check(value)) {
            case 0: {
                break;
            }
            case 1: {
                Object[] args = new String[]{"Name unknown"};
                throw new CMSEmptyStringException(args);
            }
            case 2: {
                Object[] args1 = new String[]{"Name unknown", value};
                throw new CMSBlankPaddedStringException(args1);
            }
        }
    }

    public static String validateAndConvert(String _value, String[] _boundaries) {
        String value;
        block4: {
            value = null;
            try {
                value = CmsString.convert(_value);
                InputValidator.validate("ChangeList Caption", _boundaries, value);
            }
            catch (CMSValidateException cve) {
                int maxLength = Integer.parseInt(_boundaries[2]);
                if (value.length() > maxLength && maxLength > 3) {
                    value = CmsString.convert(value.substring(0, maxLength / 2 - 2) + "..." + value.substring(value.length() - maxLength / 2 + 1));
                }
                if (value.length() == 0) {
                    value = "Generated value";
                }
                if (value.length() <= maxLength) break block4;
                value = value.substring(0, maxLength);
            }
        }
        return value;
    }
}

