/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.types.config;

import com.sap.cms.client.validation.config.ParameterValidator;
import com.sap.cms.util.exception.conf.CMSCExtValidateException;
import com.sap.cms.util.exception.conf.CMSCValidateException;
import com.sap.cms.util.exception.conf.CMSConfigurationException;
import com.sap.cms.util.logging.CmsLogger;
import com.sap.tc.complib.namecheck.NameCheckException;
import com.sap.tc.complib.namecheck.NameChecker;
import java.io.Serializable;
import java.util.Vector;

public class TrackObject
implements Serializable {
    public static final String TRACK_TYPE_DEFAULT = "DEFAULT";
    public static final String TRACK_TYPE_REPAIR_INT = "REP_INT";
    public static final String TRACK_TYPE_REPAIR_EXT = "REP_EXT";
    public static final String TRACK_TYPE_REPAIR_INT_EXT = "REP_I_E";
    public static final String TRACK_TYPE_XI = "XI";
    public static final boolean FORCE_MODE_OFF = false;
    public static final boolean FORCE_MODE_ON = true;
    public static final String STATUS_INCONS_1 = "INCONS_1";
    public static final String STATUS_INCONS_2 = "INCONS_2";
    public static final String STATUS_INCONS_3 = "INCONS_3";
    public static final String STATUS_INCONS = "INCONS";
    public static final String STATUS_OK = "OK";
    private String name = null;
    private String caption = null;
    private String description = null;
    private String type = "DEFAULT";
    private String state = null;
    private String modificationResponsible = null;
    private String modificationDate = null;
    private boolean forceMode = false;
    private boolean finalAssemblyFlag = false;
    private Vector preRepairTrackVector = new Vector();

    public void toLog(CmsLogger log) {
        log.debug("Track Name: " + this.name);
        log.debug("Track Caption: " + this.caption);
        log.debug("Track Description: " + this.description);
        log.debug("Track Type: " + this.type);
        log.debug("Track State: " + this.state);
        log.debug("Modification Responsible: " + this.modificationResponsible);
        log.debug("Modification Date: " + this.modificationDate);
        int i = 0;
        while (i < this.preRepairTrackVector.size()) {
            log.debug("Pre. Repair Track " + (i + 1) + ":");
            log.debug("Name: " + this.preRepairTrackVector.get(i));
            ++i;
        }
        log.debug("Force Mode on: " + this.forceMode);
        log.debug("Final Assembly Flag on: " + this.finalAssemblyFlag);
    }

    public void toInfo(CmsLogger log) {
        log.info("Track Name: " + this.name);
        log.info("Track Caption: " + this.caption);
        log.info("Track Description: " + this.description);
        log.info("Track Type: " + this.type);
        log.info("Track State: " + this.state);
        log.info("Modification Responsible: " + this.modificationResponsible);
        log.info("Modification Date: " + this.modificationDate);
        int i = 0;
        while (i < this.preRepairTrackVector.size()) {
            log.info("Pre. Repair Track " + (i + 1) + ":");
            log.info("Name: " + this.preRepairTrackVector.get(i));
            ++i;
        }
        log.info("Force Mode on: " + this.forceMode);
        log.info("Final Assembly Flag on: " + this.finalAssemblyFlag);
    }

    public void validateParameter() throws CMSConfigurationException {
    }

    public boolean equals(Object obj, CmsLogger log) {
        TrackObject trackObject = (TrackObject)obj;
        if (this.getName() == null ^ trackObject.getName() == null || trackObject.getName() != null && !this.getName().equals(trackObject.getName())) {
            log.debug("TrackObject: Name not equal");
            return false;
        }
        if (this.getCaption() == null ^ trackObject.getCaption() == null || trackObject.getCaption() != null && !this.getCaption().equals(trackObject.getCaption())) {
            log.debug("TrackObject: Caption not equal");
            return false;
        }
        if (this.getDescription() == null ^ trackObject.getDescription() == null || trackObject.getDescription() != null && !this.getDescription().equals(trackObject.getDescription())) {
            log.debug("TrackObject: Description not equal");
            return false;
        }
        if (this.getType() == null ^ trackObject.getType() == null || trackObject.getType() != null && !this.getType().equals(trackObject.getType())) {
            log.debug("TrackObject: Type not equal");
            return false;
        }
        if (this.getState() == null ^ trackObject.getState() == null || trackObject.getState() != null && !this.getState().equals(trackObject.getState())) {
            log.debug("TrackObject: State not equal");
            return false;
        }
        if (this.isFinalAssemblyFlag() != trackObject.isFinalAssemblyFlag()) {
            log.debug("TrackObject: Final Assembly Flag not equal");
            return false;
        }
        if (this.getPreRepairTrackVector().size() != trackObject.getPreRepairTrackVector().size()) {
            log.debug("TrackObject: Repair track vector size not equal");
            return false;
        }
        int i = 0;
        while (i < this.getPreRepairTrackVector().size()) {
            if (!((TrackObject)this.getPreRepairTrackVector().get(i)).equals((TrackObject)trackObject.getPreRepairTrackVector().get(i), log)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public void setCaption(String caption) throws CMSCValidateException, CMSCExtValidateException {
        ParameterValidator.validateParam("Track Name", ParameterValidator.CTRACK_CAPTION, caption);
        this.caption = caption;
    }

    public void setDescription(String description) throws CMSCValidateException {
        ParameterValidator.validateParam("Track Description", ParameterValidator.CTRACK_DESCRIPTION, description);
        this.description = description;
    }

    public void setName(String name) throws CMSCValidateException, CMSCExtValidateException {
        ParameterValidator.validateParam("Track ID", ParameterValidator.CTRACK_NAME, name);
        try {
            NameChecker.checkDevelopmentConfigurationName((String)name);
        }
        catch (NameCheckException e) {
            String[] args = new String[]{"Track Name", name, e.getMessage()};
            CMSCValidateException ex = new CMSCValidateException((Throwable)e);
            throw new CMSCExtValidateException((Throwable)ex);
        }
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) throws CMSCValidateException {
        ParameterValidator.validateParam("Track Type", ParameterValidator.CTRACK_TYPE, this.type);
        this.type = string;
    }

    public Vector getPreRepairTrackVector() {
        return this.preRepairTrackVector;
    }

    public void setPreRepairTrackVector(Vector vector) {
        this.preRepairTrackVector = vector;
    }

    public boolean isForceMode() {
        return this.forceMode;
    }

    public void setForceMode(boolean b) {
        this.forceMode = b;
    }

    public boolean isFinalAssemblyFlag() {
        return this.finalAssemblyFlag;
    }

    public void setFinalAssemblyFlag(boolean b) {
        this.finalAssemblyFlag = b;
    }

    public String getState() {
        if (this.state == null) {
            return STATUS_OK;
        }
        if (!this.state.equals(STATUS_OK)) {
            return STATUS_INCONS;
        }
        return this.state;
    }

    public void setState(String string) {
        this.state = string;
    }

    public String getModificationResponsible() {
        return this.modificationResponsible;
    }

    public void setModificationResponsible(String string) {
        this.modificationResponsible = string;
    }

    public String getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(String string) {
        this.modificationDate = string;
    }
}

