/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.types.config;

import com.sap.cms.client.validation.config.ParameterValidator;
import com.sap.cms.util.exception.conf.CMSCValidateException;
import com.sap.cms.util.exception.conf.CMSConfigurationException;
import com.sap.cms.util.logging.CmsLogger;
import java.io.Serializable;

public class TrackConnectionObject
implements Serializable {
    private String sourceTrackCaption = null;
    private String sourceTrackName = null;
    private String sourceDomainName = null;
    private String targetTrackCaption = null;
    private String targetTrackName = null;
    private String targetDomainName = null;
    private String owner = null;

    public void toLog(CmsLogger log) {
        log.debug("Track Connection Source Track Caption: " + this.sourceTrackCaption);
        log.debug("Track Connection Source Track Name: " + this.sourceTrackName);
        log.debug("Track Connection Source Domain Name: " + this.sourceDomainName);
        log.debug("Track Connection Target Track Caption: " + this.targetTrackCaption);
        log.debug("Track Connection Target Track Name: " + this.targetTrackName);
        log.debug("Track Connection Target Domain Name: " + this.targetDomainName);
        log.debug("Track Connection Owner: " + this.owner);
    }

    public void toInfo(CmsLogger log) {
        log.info("Track Connection Source Track Caption: " + this.sourceTrackCaption);
        log.info("Track Connection Source Track Name: " + this.sourceTrackName);
        log.info("Track Connection Source Domain Name: " + this.sourceDomainName);
        log.info("Track Connection Target Track Caption: " + this.targetTrackCaption);
        log.info("Track Connection Target Track Name: " + this.targetTrackName);
        log.info("Track Connection Target Domain Name: " + this.targetDomainName);
        log.info("Track Connection Owner: " + this.owner);
    }

    public void validateParameter() throws CMSConfigurationException {
    }

    public boolean equals(Object obj, CmsLogger log) {
        TrackConnectionObject trackConnectionObject = (TrackConnectionObject)obj;
        if (this.getSourceTrackName() == null ^ trackConnectionObject.getSourceTrackName() == null || trackConnectionObject.getSourceTrackName() != null && !this.getSourceTrackName().equals(trackConnectionObject.getSourceTrackName())) {
            log.debug("TrackConnectionObject: Source track name not equal");
            return false;
        }
        if (this.getSourceDomainName() == null ^ trackConnectionObject.getSourceDomainName() == null || trackConnectionObject.getSourceDomainName() != null && !this.getSourceDomainName().equals(trackConnectionObject.getSourceDomainName())) {
            log.debug("TrackConnectionObject: Source domain name not equal");
            return false;
        }
        if (this.getTargetTrackName() == null ^ trackConnectionObject.getTargetTrackName() == null || trackConnectionObject.getTargetTrackName() != null && !this.getTargetTrackName().equals(trackConnectionObject.getTargetTrackName())) {
            log.debug("TrackConnectionObject: Target track name not equal");
            return false;
        }
        if (this.getTargetDomainName() == null ^ trackConnectionObject.getTargetDomainName() == null || trackConnectionObject.getTargetDomainName() != null && !this.getTargetDomainName().equals(trackConnectionObject.getTargetDomainName())) {
            log.debug("TrackConnectionObject: Target domain name not equal");
            return false;
        }
        return true;
    }

    public String getSourceDomainName() {
        return this.sourceDomainName;
    }

    public String getSourceTrackName() {
        return this.sourceTrackName;
    }

    public String getTargetDomainName() {
        return this.targetDomainName;
    }

    public String getTargetTrackName() {
        return this.targetTrackName;
    }

    public String getSourceTrackCaption() {
        return this.sourceTrackCaption;
    }

    public String getTargetTrackCaption() {
        return this.targetTrackCaption;
    }

    public void setSourceDomainName(String sourceDomainName) throws CMSCValidateException {
        ParameterValidator.validateParam("Track Connection Source Domain Name", ParameterValidator.CDOM_NAME, sourceDomainName);
        this.sourceDomainName = sourceDomainName;
    }

    public void setSourceTrackName(String sourceTrackName) throws CMSCValidateException {
        ParameterValidator.validateParam("Track Connection Source Track Name", ParameterValidator.CTRACK_NAME, sourceTrackName);
        this.sourceTrackName = sourceTrackName;
    }

    public void setTargetDomainName(String targetDomainName) throws CMSCValidateException {
        ParameterValidator.validateParam("Track Connection Target Domain Name", ParameterValidator.CDOM_NAME, targetDomainName);
        this.targetDomainName = targetDomainName;
    }

    public void setTargetTrackName(String targetTrackName) throws CMSCValidateException {
        ParameterValidator.validateParam("Track Connection Target Track Name", ParameterValidator.CTRACK_NAME, targetTrackName);
        this.targetTrackName = targetTrackName;
    }

    public void setSourceTrackCaption(String string) {
        this.sourceTrackCaption = string;
    }

    public void setTargetTrackCaption(String string) {
        this.targetTrackCaption = string;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        this.owner = string;
    }
}

