/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.types.config;

import com.sap.cms.client.types.config.CompartmentObject;
import com.sap.cms.client.types.config.LandscapeObject;
import com.sap.cms.client.types.config.RTSObject;
import com.sap.cms.util.logging.CmsLogger;
import com.sap.cms.util.warning.CMSReturnObject;
import java.io.Serializable;
import java.util.Vector;

public class TrackConfigurationObject
extends CMSReturnObject
implements Serializable {
    private LandscapeObject landscapeObject = new LandscapeObject();
    private Vector rtsObjectVector = new Vector();
    private String owner = null;
    private boolean configurationSimulationMode = false;

    public void toLog(CmsLogger log) {
        log.debug("Track Configuration Simulation Mode: " + this.configurationSimulationMode);
        this.landscapeObject.toLog(log);
        int i = 0;
        while (i < this.rtsObjectVector.size()) {
            log.debug("RTS Object " + (i + 1) + ":");
            ((RTSObject)this.rtsObjectVector.get(i)).toLog(log);
            ++i;
        }
        log.debug("Owner: " + this.owner);
        super.toLog(log);
    }

    public void toInfo(CmsLogger log) {
        log.info("Track Configuration Simulation Mode: " + this.configurationSimulationMode);
        this.landscapeObject.toInfo(log);
        int i = 0;
        while (i < this.rtsObjectVector.size()) {
            log.info("RTS Object " + (i + 1) + ":");
            ((RTSObject)this.rtsObjectVector.get(i)).toInfo(log);
            ++i;
        }
        log.info("Owner: " + this.owner);
        super.toInfo(log);
    }

    public boolean equals(Object obj, CmsLogger log) {
        TrackConfigurationObject trackConfigurationObject = (TrackConfigurationObject)obj;
        if (!this.getLandscapeObject().equals(trackConfigurationObject.getLandscapeObject(), log)) {
            log.debug("TrackConfigurationObject: LandscapeObject not equal");
            return false;
        }
        if (this.getRtsObjectVector().size() != trackConfigurationObject.getRtsObjectVector().size()) {
            log.debug("TrackConfigurationObject: RTSObjectVector size not equal");
            return false;
        }
        int i = 0;
        while (i < this.getRtsObjectVector().size()) {
            if (!((RTSObject)this.getRtsObjectVector().get(i)).equals((RTSObject)trackConfigurationObject.getRtsObjectVector().get(i), log)) {
                log.debug("TrackConfigurationObject: RTSObject not equal");
                log.debug("RTSObject 1: ");
                ((RTSObject)this.getRtsObjectVector().get(i)).toLog(log);
                log.debug("RTSObject 2: ");
                ((RTSObject)trackConfigurationObject.getRtsObjectVector().get(i)).toLog(log);
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean checkCompartmentPreConditions() {
        boolean checkOk = true;
        Vector devCompartmentVector = this.getLandscapeObject().getDevComponentVector();
        Vector depCompartmentVector = this.getLandscapeObject().getDepComponentVector();
        int i = 0;
        while (i < devCompartmentVector.size()) {
            if (((CompartmentObject)devCompartmentVector.get(i)).getXmlStatus().equals("RED")) {
                checkOk = false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < depCompartmentVector.size()) {
            if (((CompartmentObject)depCompartmentVector.get(i2)).getXmlStatus().equals("RED")) {
                checkOk = false;
            }
            ++i2;
        }
        return checkOk;
    }

    public LandscapeObject getLandscapeObject() {
        return this.landscapeObject;
    }

    public Vector getRtsObjectVector() {
        return this.rtsObjectVector;
    }

    public void setLandscapeObject(LandscapeObject landscapeObject) {
        this.landscapeObject = landscapeObject;
    }

    public void setRtsObjectVector(Vector rtsObjectVector) {
        this.rtsObjectVector = rtsObjectVector;
    }

    public boolean isConfigurationSimulationMode() {
        return this.configurationSimulationMode;
    }

    public void setConfigurationSimulationMode(boolean b) {
        this.configurationSimulationMode = b;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        this.owner = string;
    }
}

