/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.types.config;

import com.sap.cms.client.validation.config.ParameterValidator;
import com.sap.cms.util.exception.conf.CMSCValidateException;
import com.sap.cms.util.exception.conf.CMSConfigurationException;
import com.sap.cms.util.logging.CmsLogger;
import java.io.Serializable;

public class SDMServerParameterObject
implements Serializable {
    private String name = null;
    private String value = null;
    private String type = null;
    private String hidden = null;

    public void toLog(CmsLogger log) {
        log.debug("Subst.Par.: " + this.name + "/" + this.value + "/" + this.type + "/" + this.hidden);
    }

    public void toInfo(CmsLogger log) {
        log.info("Subst.Par.: " + this.name + "/" + this.value + "/" + this.type + "/" + this.hidden);
    }

    public void validateParameter() throws CMSConfigurationException {
    }

    public boolean equals(Object obj, CmsLogger log) {
        SDMServerParameterObject sdmServerParameterObject = (SDMServerParameterObject)obj;
        if (this.getName() == null ^ sdmServerParameterObject.getName() == null || sdmServerParameterObject.getName() != null && !this.getName().equals(sdmServerParameterObject.getName())) {
            log.debug("SDMServerParameterObject: Name not equal");
            return false;
        }
        if (this.getValue() == null ^ sdmServerParameterObject.getValue() == null || sdmServerParameterObject.getValue() != null && !this.getValue().equals(sdmServerParameterObject.getValue())) {
            log.debug("SDMServerParameterObject: Value not equal");
            return false;
        }
        if (this.getType() == null ^ sdmServerParameterObject.getType() == null || sdmServerParameterObject.getType() != null && !this.getType().equals(sdmServerParameterObject.getType())) {
            log.debug("SDMServerParameterObject: Type not equal");
            return false;
        }
        if (this.getHidden() == null ^ sdmServerParameterObject.getHidden() == null || sdmServerParameterObject.getHidden() != null && !this.getHidden().equals(sdmServerParameterObject.getHidden())) {
            log.debug("SDMServerParameterObject: Hidden not equal");
            return false;
        }
        return true;
    }

    public String getHidden() {
        return this.hidden;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public void setHidden(String hidden) throws CMSCValidateException {
        ParameterValidator.validateParam("Subst.Par. hidden", ParameterValidator.CSDMVAR_HIDDEN, hidden);
        this.hidden = hidden;
    }

    public void setName(String name) throws CMSCValidateException {
        ParameterValidator.validateParam("Subst.Par. name", ParameterValidator.CSDMVAR_NAME, name);
        this.name = name;
    }

    public void setType(String type) throws CMSCValidateException {
        ParameterValidator.validateParam("Subst.Par. type", ParameterValidator.CSDMVAR_VARTYPE, type);
        this.type = type;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

