/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.types.config;

import com.sap.cms.client.validation.InputValidator;
import com.sap.cms.client.validation.config.ParameterValidator;
import com.sap.cms.util.exception.conf.CMSCValidateException;
import com.sap.cms.util.exception.conf.CMSConfigurationException;
import com.sap.cms.util.logging.CmsLogger;
import java.io.Serializable;

public class SDMServerObject
implements Serializable {
    private String name = null;
    private String host = null;
    private String port = null;
    private String password = null;
    private String engineURL = null;
    private String engineUser = null;
    private String enginePassword = null;
    private String caption = null;
    private String description = null;
    private boolean isAutodeploymentScheduled = false;
    private String owner = null;

    public void toLog(CmsLogger log) {
        log.debug("SDM Name: " + this.name);
        log.debug("SDM Host: " + this.host);
        log.debug("SDM Port: " + this.port);
        log.debug("SDM Caption: " + this.caption);
        log.debug("SDM Description: " + this.description);
        log.debug("SDM Is Autodeployment Scheduled: " + this.isAutodeploymentScheduled);
        log.debug("Engine URL: " + this.engineURL);
        log.debug("Engine User: " + this.engineUser);
        log.debug("SDM Owner: " + this.owner);
    }

    public void toInfo(CmsLogger log) {
        log.info("SDM Name: " + this.name);
        log.info("SDM Host: " + this.host);
        log.info("SDM Port: " + this.port);
        log.info("SDM Caption: " + this.caption);
        log.info("SDM Description: " + this.description);
        log.info("SDM Is Autodeployment Scheduled: " + this.isAutodeploymentScheduled);
        log.info("Engine URL: " + this.engineURL);
        log.info("Engine User: " + this.engineUser);
        log.info("SDM Owner: " + this.owner);
    }

    public void validateParameter() throws CMSConfigurationException {
    }

    public boolean equals(Object obj, CmsLogger log) {
        SDMServerObject sdmServerObject = (SDMServerObject)obj;
        if (this.getName() == null ^ sdmServerObject.getName() == null || sdmServerObject.getName() != null && !this.getName().equals(sdmServerObject.getName())) {
            log.debug("SDMServerObject: Name not equal");
            return false;
        }
        if (this.getHost() == null ^ sdmServerObject.getHost() == null || sdmServerObject.getHost() != null && !this.getHost().equals(sdmServerObject.getHost())) {
            log.debug("SDMServerObject: Host not equal");
            return false;
        }
        if (this.getPort() == null ^ sdmServerObject.getPort() == null || sdmServerObject.getPort() != null && !this.getPort().equals(sdmServerObject.getPort())) {
            log.debug("SDMServerObject: Port not equal");
            return false;
        }
        if (this.getPassword() == null ^ sdmServerObject.getPassword() == null || sdmServerObject.getPassword() != null && !this.getPassword().equals(sdmServerObject.getPassword())) {
            log.debug("SDMServerObject: Password not equal");
            return false;
        }
        if (this.getCaption() == null ^ sdmServerObject.getCaption() == null || sdmServerObject.getCaption() != null && !this.getCaption().equals(sdmServerObject.getCaption())) {
            log.debug("SDMServerObject: Caption not equal");
            return false;
        }
        if (this.getDescription() == null ^ sdmServerObject.getDescription() == null || sdmServerObject.getDescription() != null && !this.getDescription().equals(sdmServerObject.getDescription())) {
            log.debug("SDMServerObject: Description not equal");
            return false;
        }
        if (this.isAutodeploymentScheduled() == sdmServerObject.isAutodeploymentScheduled()) {
            log.debug("SDMServerObject: Is Autodeployment Scheduled not equal");
            return false;
        }
        return true;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHost() {
        return this.host;
    }

    public String getName() {
        return this.name;
    }

    public String getPort() {
        return this.port;
    }

    public void setCaption(String caption) throws CMSCValidateException {
        ParameterValidator.validateParam("SDM Caption", ParameterValidator.CSDM_CAPTION, caption);
        this.caption = caption;
    }

    public void setDescription(String description) throws CMSCValidateException {
        ParameterValidator.validateParam("SDM Description", ParameterValidator.CSDM_DESCRIPTION, description);
        this.description = description;
    }

    public void setHost(String host) throws CMSCValidateException {
        if (host != null) {
            ParameterValidator.validateParam("SDM Host", InputValidator.HOST, host);
            ParameterValidator.validateParam("SDM Host", InputValidator.URL, "http://" + host + ":" + "7000");
        }
        this.host = host;
    }

    public void setName(String name) throws CMSCValidateException {
        ParameterValidator.validateParam("SDM Name", ParameterValidator.CSDM_NAME, name);
        this.name = name;
    }

    public void setPort(String port) throws CMSCValidateException {
        if (this.host != null && port != null) {
            ParameterValidator.validateParam("SDM Port", InputValidator.PORT, port);
            ParameterValidator.validateParam("SDM Port", InputValidator.URL, "http://" + this.host + ":" + port);
        }
        this.port = port;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public boolean isAutodeploymentScheduled() {
        return this.isAutodeploymentScheduled;
    }

    public void setAutodeploymentScheduled(boolean b) {
        this.isAutodeploymentScheduled = b;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public String getEnginePassword() {
        return this.enginePassword;
    }

    public String getEngineUser() {
        return this.engineUser;
    }

    public void setEnginePassword(String string) {
        this.enginePassword = string;
    }

    public void setEngineUser(String string) {
        this.engineUser = string;
    }

    public String getEngineURL() {
        return this.engineURL;
    }

    public void setEngineURL(String string) {
        this.engineURL = string;
    }
}

