/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.types.config;

import com.sap.cms.client.types.config.CBSServerObject;
import com.sap.cms.client.types.config.CMSDomainObject;
import com.sap.cms.client.types.config.CompartmentObject;
import com.sap.cms.client.types.config.DTRServerObject;
import com.sap.cms.client.types.config.DesignTimeConfObject;
import com.sap.cms.client.types.config.TrackObject;
import com.sap.cms.util.logging.CmsLogger;
import java.io.Serializable;
import java.util.Vector;

public class LandscapeObject
implements Serializable {
    private TrackObject trackObject = new TrackObject();
    private CMSDomainObject cmsDomainObject = new CMSDomainObject();
    private DesignTimeConfObject designTimeConfObject = new DesignTimeConfObject();
    private DTRServerObject dtrServerObject = new DTRServerObject();
    private DTRServerObject consDTRServerObject = new DTRServerObject();
    private DTRServerObject finalDTRServerObject = new DTRServerObject();
    private CBSServerObject cbsServerObject = new CBSServerObject();
    private Vector devComponentVector = new Vector();
    private Vector depComponentVector = new Vector();

    public void toLog(CmsLogger log) {
        this.cmsDomainObject.toLog(log);
        this.trackObject.toLog(log);
        this.designTimeConfObject.toLog(log);
        log.debug("Dev. DTR Server Object: ");
        this.dtrServerObject.toLog(log);
        log.debug("Cons. DTR Server Object: ");
        this.consDTRServerObject.toLog(log);
        log.debug("Final DTR Server Object: ");
        this.finalDTRServerObject.toLog(log);
        this.cbsServerObject.toLog(log);
        int i = 0;
        while (i < this.devComponentVector.size()) {
            log.debug("Used Comp. " + (i + 1) + ":");
            ((CompartmentObject)this.devComponentVector.get(i)).toLog(log);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.depComponentVector.size()) {
            log.debug("Mod. Comp. " + (i2 + 1) + ":");
            ((CompartmentObject)this.depComponentVector.get(i2)).toLog(log);
            ++i2;
        }
    }

    public void toInfo(CmsLogger log) {
        this.cmsDomainObject.toInfo(log);
        this.trackObject.toInfo(log);
        this.designTimeConfObject.toInfo(log);
        log.info("Dev. DTR Server Object: ");
        this.dtrServerObject.toInfo(log);
        log.info("Cons. DTR Server Object: ");
        this.consDTRServerObject.toInfo(log);
        log.info("Final DTR Server Object: ");
        this.finalDTRServerObject.toInfo(log);
        this.cbsServerObject.toInfo(log);
        int i = 0;
        while (i < this.devComponentVector.size()) {
            log.info("Used Comp. " + (i + 1) + ":");
            ((CompartmentObject)this.devComponentVector.get(i)).toInfo(log);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.depComponentVector.size()) {
            log.info("Mod. Comp. " + (i2 + 1) + ":");
            ((CompartmentObject)this.depComponentVector.get(i2)).toInfo(log);
            ++i2;
        }
    }

    public boolean equals(Object obj, CmsLogger log) {
        LandscapeObject landscapeObject = (LandscapeObject)obj;
        if (!this.getTrackObject().equals(landscapeObject.getTrackObject(), log)) {
            log.debug("LandscapeObject: TrackObject not equal");
            return false;
        }
        if (!this.getCmsDomainObject().equals(landscapeObject.getCmsDomainObject(), log)) {
            log.debug("LandscapeObject: CMSDomainObject not equal");
            return false;
        }
        if (!this.getDesignTimeConfObject().equals(landscapeObject.getDesignTimeConfObject(), log)) {
            log.debug("LandscapeObject: DesignTimeConfObject not equal");
            return false;
        }
        if (!this.getDtrServerObject().equals(landscapeObject.getDtrServerObject(), log)) {
            log.debug("LandscapeObject: DTRServerObject not equal");
            return false;
        }
        if (!this.getConsDTRServerObject().equals(landscapeObject.getConsDTRServerObject(), log)) {
            log.debug("LandscapeObject: ConsDTRServerObject not equal");
            return false;
        }
        if (!this.getFinalDTRServerObject().equals(landscapeObject.getFinalDTRServerObject(), log)) {
            log.debug("LandscapeObject: FinalDTRServerObject not equal");
            return false;
        }
        if (!this.getCbsServerObject().equals(landscapeObject.getCbsServerObject(), log)) {
            log.debug("LandscapeObject: CBSServerObject not equal");
            return false;
        }
        if (this.getDevComponentVector().size() != landscapeObject.getDevComponentVector().size()) {
            log.debug("LandscapeObject: Dev. Component size not equal");
            return false;
        }
        int i = 0;
        while (i < this.getDevComponentVector().size()) {
            if (!((CompartmentObject)this.getDevComponentVector().get(i)).equals((CompartmentObject)landscapeObject.getDevComponentVector().get(i), log)) {
                log.debug("LandscapeObject: CompartmentObject not equal");
                log.debug("Compartment 1: ");
                ((CompartmentObject)this.getDevComponentVector().get(i)).toLog(log);
                log.debug("Compartment 2: ");
                ((CompartmentObject)landscapeObject.getDevComponentVector().get(i)).toLog(log);
                return false;
            }
            ++i;
        }
        if (this.getDepComponentVector().size() != landscapeObject.getDepComponentVector().size()) {
            log.debug("LandscapeObject: Dep. Component size not equal");
            return false;
        }
        int i2 = 0;
        while (i2 < this.getDepComponentVector().size()) {
            if (!((CompartmentObject)this.getDepComponentVector().get(i2)).equals((CompartmentObject)landscapeObject.getDepComponentVector().get(i2), log)) {
                log.debug("LandscapeObject: CompartmentObject not equal");
                log.debug("Compartment 1: ");
                ((CompartmentObject)this.getDepComponentVector().get(i2)).toLog(log);
                log.debug("Compartment 2: ");
                ((CompartmentObject)landscapeObject.getDepComponentVector().get(i2)).toLog(log);
                return false;
            }
            ++i2;
        }
        return true;
    }

    public CBSServerObject getCbsServerObject() {
        return this.cbsServerObject;
    }

    public Vector getDepComponentVector() {
        return this.depComponentVector;
    }

    public DesignTimeConfObject getDesignTimeConfObject() {
        return this.designTimeConfObject;
    }

    public Vector getDevComponentVector() {
        return this.devComponentVector;
    }

    public DTRServerObject getDtrServerObject() {
        return this.dtrServerObject;
    }

    public TrackObject getTrackObject() {
        return this.trackObject;
    }

    public void setCbsServerObject(CBSServerObject cbsServerObject) {
        this.cbsServerObject = cbsServerObject;
    }

    public void setDepComponentVector(Vector depComponentVector) {
        this.depComponentVector = depComponentVector;
    }

    public void setDesignTimeConfObject(DesignTimeConfObject designTimeConfObject) {
        this.designTimeConfObject = designTimeConfObject;
    }

    public void setDevComponentVector(Vector devComponentVector) {
        this.devComponentVector = devComponentVector;
    }

    public void setDtrServerObject(DTRServerObject dtrServerObject) {
        this.dtrServerObject = dtrServerObject;
    }

    public void setTrackObject(TrackObject trackObject) {
        this.trackObject = trackObject;
    }

    public CMSDomainObject getCmsDomainObject() {
        return this.cmsDomainObject;
    }

    public void setCmsDomainObject(CMSDomainObject cmsDomainObject) {
        this.cmsDomainObject = cmsDomainObject;
    }

    public DTRServerObject getConsDTRServerObject() {
        return this.consDTRServerObject;
    }

    public DTRServerObject getFinalDTRServerObject() {
        return this.finalDTRServerObject;
    }

    public void setConsDTRServerObject(DTRServerObject object) {
        this.consDTRServerObject = object;
    }

    public void setFinalDTRServerObject(DTRServerObject object) {
        this.finalDTRServerObject = object;
    }
}

