/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.types.config;

import com.sap.cms.client.validation.config.ParameterValidator;
import com.sap.cms.util.exception.conf.CMSCValidateException;
import com.sap.cms.util.exception.conf.CMSConfigurationException;
import com.sap.cms.util.logging.CmsLogger;
import java.io.Serializable;

public class DesignTimeConfObject
implements Serializable {
    private String nameSpacePartition = null;
    private String caption = null;
    private String description = null;
    private String path = null;

    public void toLog(CmsLogger log) {
        log.debug("DTC Name Space Partition: " + this.nameSpacePartition);
        log.debug("DTC Caption: " + this.caption);
        log.debug("DTC Description: " + this.description);
        log.debug("DTC Path: " + this.path);
    }

    public void toInfo(CmsLogger log) {
        log.info("DTC Name Space Partition: " + this.nameSpacePartition);
        log.info("DTC Caption: " + this.caption);
        log.info("DTC Description: " + this.description);
        log.info("DTC Path: " + this.path);
    }

    public void validateParameter() throws CMSConfigurationException {
    }

    public boolean equals(Object obj, CmsLogger log) {
        DesignTimeConfObject designTimeConfObject = (DesignTimeConfObject)obj;
        if (this.getNameSpacePartition() == null ^ designTimeConfObject.getNameSpacePartition() == null || designTimeConfObject.getNameSpacePartition() != null && !this.getNameSpacePartition().equals(designTimeConfObject.getNameSpacePartition())) {
            log.debug("DesignTimeConfObject: Name space partition not equal");
            return false;
        }
        if (this.getCaption() == null ^ designTimeConfObject.getCaption() == null || designTimeConfObject.getCaption() != null && !this.getCaption().equals(designTimeConfObject.getCaption())) {
            log.debug("DesignTimeConfObject: Caption not equal");
            return false;
        }
        if (this.getDescription() == null ^ designTimeConfObject.getDescription() == null || designTimeConfObject.getDescription() != null && !this.getDescription().equals(designTimeConfObject.getDescription())) {
            log.debug("DesignTimeConfObject: Description not equal");
            return false;
        }
        if (this.getPath() == null ^ designTimeConfObject.getPath() == null || designTimeConfObject.getPath() != null && !this.getPath().equals(designTimeConfObject.getPath())) {
            log.debug("DesignTimeConfObject: Path not equal");
            return false;
        }
        return true;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNameSpacePartition() {
        return this.nameSpacePartition;
    }

    public String getPath() {
        return this.path;
    }

    public void setCaption(String caption) throws CMSCValidateException {
        ParameterValidator.validateParam("DTC Caption", ParameterValidator.CDEVCONF_CAPTION, caption);
        this.caption = caption;
    }

    public void setDescription(String description) throws CMSCValidateException {
        ParameterValidator.validateParam("DTC Description", ParameterValidator.CDEVCONF_DESCRIPTION, description);
        this.description = description;
    }

    public void setNameSpacePartition(String nameSpacePartition) throws CMSCValidateException {
        ParameterValidator.validateParam("DTC Name Space Partition", ParameterValidator.CDEVCONF_NAREGPART, nameSpacePartition);
        this.nameSpacePartition = nameSpacePartition;
    }

    public void setPath(String path) throws CMSCValidateException {
        ParameterValidator.validateParam("DTC Path", ParameterValidator.CDEVCONF_DESCRIPTION, path);
        this.path = path;
    }
}

