/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.types.config;

import com.sap.cms.client.validation.config.ParameterValidator;
import com.sap.cms.util.exception.conf.CMSCValidateException;
import com.sap.cms.util.exception.conf.CMSConfigurationException;
import com.sap.cms.util.logging.CmsLogger;
import java.io.Serializable;

public class DTRServerObject
implements Serializable {
    public static final String REPOSITORY_TYPE_DTR = "DTR";
    public static final String REPOSITORY_TYPE_XI = "XI";
    private String url = null;
    private String repType = "DTR";

    public void toLog(CmsLogger log) {
        log.debug("DTR Server URL: " + this.url);
        log.debug("DTR Server Type: " + this.repType);
    }

    public void toInfo(CmsLogger log) {
        log.info("DTR Server URL: " + this.url);
        log.info("DTR Server Type: " + this.repType);
    }

    public void validateParameter() throws CMSConfigurationException {
    }

    public boolean equals(Object obj, CmsLogger log) {
        DTRServerObject dtrServerObject = (DTRServerObject)obj;
        if (this.getUrl() == null ^ dtrServerObject.getUrl() == null || dtrServerObject.getUrl() != null && !this.getUrl().equals(dtrServerObject.getUrl())) {
            log.debug("DTRServerObject: URL not equal");
            return false;
        }
        if (this.getUrl() != null && (this.getRepType() == null ^ dtrServerObject.getRepType() == null || dtrServerObject.getRepType() != null && !this.getRepType().equals(dtrServerObject.getRepType()))) {
            log.debug("DTRServerObject: Repository type not equal");
            return false;
        }
        return true;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) throws CMSCValidateException {
        ParameterValidator.validateParam("DTR Server URL", ParameterValidator.CDTR_URL, url);
        this.url = url;
    }

    public String getRepType() {
        return this.repType;
    }

    public void setRepType(String string) {
        this.repType = string;
    }
}

