/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.types.config;

import com.sap.cms.client.types.config.CompartmentObject;
import com.sap.cms.client.types.config.DTCCompartmentObject;
import com.sap.cms.util.logging.CmsLogger;
import java.util.Vector;

public class DTCHeaderObject {
    private String dtcName = null;
    private String dtcCaption = null;
    private String dtcDescription = null;
    private String dtcVersion = null;
    private String nameServerURL = null;
    private String cbsURL = null;
    private String cmsURL = null;
    private String domName = null;
    private String systemName = null;
    private Vector dtcCompartmentVector = new Vector();
    private Vector dtcPropertyVector = new Vector();

    public void toLog(CmsLogger log) {
        log.debug("DTC Name: " + this.dtcName);
        log.debug("DTC Caption: " + this.dtcCaption);
        log.debug("DTC Description: " + this.dtcDescription);
        log.debug("DTC Name Server URL: " + this.nameServerURL);
        log.debug("DTC CBS URL: " + this.cbsURL);
        log.debug("DTC CMS URL: " + this.cmsURL);
        log.debug("DTC Domain Name: " + this.domName);
        log.debug("DTC System Name: " + this.systemName);
        int i = 0;
        while (i < this.dtcCompartmentVector.size()) {
            log.debug("DTC Compartment " + (i + 1) + ":");
            ((DTCCompartmentObject)this.dtcCompartmentVector.get(i)).toLog(log);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.dtcPropertyVector.size()) {
            log.debug("DTC Property " + (i2 + 1) + ":");
            int j = 0;
            while (j < ((String[])this.dtcPropertyVector.get(i2)).length) {
                log.debug(((String[])this.dtcPropertyVector.get(i2))[j]);
                ++j;
            }
            ++i2;
        }
    }

    public void toInfo(CmsLogger log) {
        log.info("DTC Name: " + this.dtcName);
        log.info("DTC Caption: " + this.dtcCaption);
        log.info("DTC Description: " + this.dtcDescription);
        log.info("DTC Name Server URL: " + this.nameServerURL);
        log.info("DTC CBS URL: " + this.cbsURL);
        log.info("DTC CMS URL: " + this.cmsURL);
        log.info("DTC Domain Name: " + this.domName);
        log.info("DTC System Name: " + this.systemName);
        int i = 0;
        while (i < this.dtcCompartmentVector.size()) {
            log.info("DTC Compartment " + (i + 1) + ":");
            ((DTCCompartmentObject)this.dtcCompartmentVector.get(i)).toInfo(log);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.dtcPropertyVector.size()) {
            log.info("DTC Property " + (i2 + 1) + ":");
            int j = 0;
            while (j < ((String[])this.dtcPropertyVector.get(i2)).length) {
                log.info(((String[])this.dtcPropertyVector.get(i2))[j]);
                ++j;
            }
            ++i2;
        }
    }

    public boolean equals(Object obj, CmsLogger log) {
        DTCHeaderObject dtcHeaderObject = (DTCHeaderObject)obj;
        if (this.getDtcName() == null ^ dtcHeaderObject.getDtcName() == null || dtcHeaderObject.getDtcName() != null && !this.getDtcName().equals(dtcHeaderObject.getDtcName())) {
            log.debug("DTCHeaderObject: Name not equal");
            return false;
        }
        if (this.getDtcCaption() == null ^ dtcHeaderObject.getDtcCaption() == null || dtcHeaderObject.getDtcCaption() != null && !this.getDtcCaption().equals(dtcHeaderObject.getDtcCaption())) {
            log.debug("DTCHeaderObject: Caption not equal");
            return false;
        }
        if (this.getDtcDescription() == null ^ dtcHeaderObject.getDtcDescription() == null || dtcHeaderObject.getDtcDescription() != null && !this.getDtcDescription().equals(dtcHeaderObject.getDtcDescription())) {
            log.debug("DTCHeaderObject: Description not equal");
            return false;
        }
        if (this.getNameServerURL() == null ^ dtcHeaderObject.getNameServerURL() == null || dtcHeaderObject.getNameServerURL() != null && !this.getNameServerURL().equals(dtcHeaderObject.getNameServerURL())) {
            log.debug("DTCHeaderObject: Name server URL not equal");
            return false;
        }
        if (this.getCbsURL() == null ^ dtcHeaderObject.getCbsURL() == null || dtcHeaderObject.getCbsURL() != null && !this.getCbsURL().equals(dtcHeaderObject.getCbsURL())) {
            log.debug("DTCHeaderObject: Build server URL not equal");
            return false;
        }
        if (this.getCmsURL() == null ^ dtcHeaderObject.getCmsURL() == null || dtcHeaderObject.getCmsURL() != null && !this.getCmsURL().equals(dtcHeaderObject.getCmsURL())) {
            log.debug("DTCHeaderObject: CMS server URL not equal");
            return false;
        }
        if (this.getDomName() == null ^ dtcHeaderObject.getDomName() == null || dtcHeaderObject.getDomName() != null && !this.getDomName().equals(dtcHeaderObject.getDomName())) {
            log.debug("DTCHeaderObject: Domain name not equal");
            return false;
        }
        if (this.getSystemName() == null ^ dtcHeaderObject.getSystemName() == null || dtcHeaderObject.getSystemName() != null && !this.getSystemName().equals(dtcHeaderObject.getSystemName())) {
            log.debug("DTCHeaderObject: System name not equal");
            return false;
        }
        if (this.getDtcCompartmentVector().size() != dtcHeaderObject.getDtcCompartmentVector().size()) {
            log.debug("DTCHeaderObject: Compartment vector size not equal");
            return false;
        }
        int i = 0;
        while (i < this.getDtcCompartmentVector().size()) {
            if (!((CompartmentObject)this.getDtcCompartmentVector().get(i)).equals((CompartmentObject)dtcHeaderObject.getDtcCompartmentVector().get(i), log)) {
                log.debug("DTCHeaderObject: Compartment object not equal");
                log.debug("Compartment 1: ");
                ((CompartmentObject)this.getDtcCompartmentVector().get(i)).toLog(log);
                log.debug("Compartment 2: ");
                ((CompartmentObject)dtcHeaderObject.getDtcCompartmentVector().get(i)).toLog(log);
                return false;
            }
            ++i;
        }
        if (this.getDtcPropertyVector().size() != dtcHeaderObject.getDtcPropertyVector().size()) {
            log.debug("DTCHeaderObject: Property vector size not equal");
            return false;
        }
        int i2 = 0;
        while (i2 < this.getDtcPropertyVector().size()) {
            if (!this.getDtcPropertyVector().get(i2).equals(dtcHeaderObject.getDtcPropertyVector().get(i2))) {
                log.debug("DTCHeaderObject: Property object not equal");
                return false;
            }
            ++i2;
        }
        return true;
    }

    public String getCbsURL() {
        return this.cbsURL;
    }

    public String getDomName() {
        return this.domName;
    }

    public String getDtcCaption() {
        return this.dtcCaption;
    }

    public Vector getDtcCompartmentVector() {
        return this.dtcCompartmentVector;
    }

    public String getDtcDescription() {
        return this.dtcDescription;
    }

    public String getDtcName() {
        return this.dtcName;
    }

    public String getDtcVersion() {
        return this.dtcVersion;
    }

    public String getNameServerURL() {
        return this.nameServerURL;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setCbsURL(String cbsURL) {
        this.cbsURL = cbsURL;
    }

    public void setDomName(String domName) {
        this.domName = domName;
    }

    public void setDtcCaption(String dtcCaption) {
        this.dtcCaption = dtcCaption;
    }

    public void setDtcCompartmentVector(Vector dtcCompartmentVector) {
        this.dtcCompartmentVector = dtcCompartmentVector;
    }

    public void setDtcDescription(String dtcDescription) {
        this.dtcDescription = dtcDescription;
    }

    public void setDtcName(String dtcName) {
        this.dtcName = dtcName;
    }

    public void setDtcVersion(String dtcVersion) {
        this.dtcVersion = dtcVersion;
    }

    public void setNameServerURL(String nameServerURL) {
        this.nameServerURL = nameServerURL;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public String getCmsURL() {
        return this.cmsURL;
    }

    public void setCmsURL(String cmsURL) {
        this.cmsURL = cmsURL;
    }

    public Vector getDtcPropertyVector() {
        return this.dtcPropertyVector;
    }

    public void setDtcPropertyVector(Vector vector) {
        this.dtcPropertyVector = vector;
    }
}

