/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.types.config;

import com.sap.cms.client.validation.config.ParameterValidator;
import com.sap.cms.util.exception.conf.CMSCValidateException;
import com.sap.cms.util.exception.conf.CMSConfigurationException;
import com.sap.cms.util.logging.CmsLogger;
import java.io.Serializable;

public class CompartmentObject
implements Serializable {
    private String vendor = null;
    private String name = null;
    private String componentID = null;
    private String lineName = null;
    private String releaseName = null;
    private String xmlContent = null;
    private String genXMLContent = null;
    private String oldGenXMLContent = null;
    private String inputXMLContent = null;
    private String caption = null;
    private String description = null;
    private String scGUID = null;
    private String packageType = null;
    private String compAction = null;
    private String terminologyDomain = null;
    private String originalLanguage = null;
    private String owner = null;
    private String xmlStatus = "GREY";
    public static final String PACKAGETYPE_SOURCE = "SOURCE";
    public static final String PACKAGETYPE_ARCHIVE = "ARCHIVE";
    public static final String PACKAGETYPE_SOURCE_ARCHIVE = "SRC_ARC";
    public static final String COMP_SET = "SET";
    public static final String COMP_ADD = "ADD";
    public static final String COMP_REMOVE = "REMOVE";
    public static final String COMP_DEFAULT = "DEFAULT";
    public static final String XML_STATUS_GREY = "GREY";
    public static final String XML_STATUS_RED = "RED";
    public static final String XML_STATUS_YELLOW = "YELLOW";
    public static final String XML_STATUS_GREEN = "GREEN";

    public void toLog(CmsLogger log) {
        log.debug("Compartment Vendor: " + this.vendor);
        log.debug("Compartment Name: " + this.name);
        log.debug("Compartment Component ID: " + this.componentID);
        log.debug("Compartment Line Name: " + this.lineName);
        log.debug("Compartment Release Name: " + this.releaseName);
        log.debug("Compartment XML Content: " + this.xmlContent);
        log.debug("Compartment Generated XML Content: " + this.genXMLContent);
        log.debug("Compartment Old Generated XML Content: " + this.oldGenXMLContent);
        log.debug("Compartment Input XML Content: " + this.inputXMLContent);
        log.debug("Compartment Caption: " + this.caption);
        log.debug("Compartment Description: " + this.description);
        log.debug("Compartment GUID: " + this.scGUID);
        log.debug("Compartment Assembly Package Type: " + this.packageType);
        log.debug("Compartment Action: " + this.compAction);
        log.debug("Compartment Terminology Domain: " + this.terminologyDomain);
        log.debug("Compartment Original Language: " + this.originalLanguage);
        log.debug("Compartment XML Content Status: " + this.xmlStatus);
        log.debug("Owner: " + this.owner);
    }

    public void toInfo(CmsLogger log) {
        log.info("Compartment Vendor: " + this.vendor);
        log.info("Compartment Name: " + this.name);
        log.info("Compartment Component ID: " + this.componentID);
        log.info("Compartment Line Name: " + this.lineName);
        log.info("Compartment Release Name: " + this.releaseName);
        log.info("Compartment XML Content: " + this.xmlContent);
        log.info("Compartment Genrated XML Content: " + this.genXMLContent);
        log.info("Compartment Old Generated XML Content: " + this.oldGenXMLContent);
        log.info("Compartment Input XML Content: " + this.inputXMLContent);
        log.info("Compartment Caption: " + this.caption);
        log.info("Compartment Description: " + this.description);
        log.info("Compartment GUID: " + this.scGUID);
        log.info("Compartment Assembly Package Type: " + this.packageType);
        log.info("Compartment Action: " + this.compAction);
        log.info("Compartment Terminology Domain: " + this.terminologyDomain);
        log.info("Compartment Original Language: " + this.originalLanguage);
        log.info("Compartment XML Content Status: " + this.xmlStatus);
        log.info("Owner: " + this.owner);
    }

    public void validateParameter() throws CMSConfigurationException {
    }

    public boolean equals(Object obj, CmsLogger log) {
        CompartmentObject compartmentObject = (CompartmentObject)obj;
        if (this.getVendor() == null ^ compartmentObject.getVendor() == null || compartmentObject.getVendor() != null && !this.getVendor().equals(compartmentObject.getVendor())) {
            log.debug("CompartmentObject: Vendor not equal");
            return false;
        }
        if (this.getName() == null ^ compartmentObject.getName() == null || compartmentObject.getName() != null && !this.getName().equals(compartmentObject.getName())) {
            log.debug("CompartmentObject: Name not equal");
            return false;
        }
        if (this.getComponentID() == null ^ compartmentObject.getComponentID() == null || compartmentObject.getComponentID() != null && !this.getComponentID().equals(compartmentObject.getComponentID())) {
            log.debug("CompartmentObject: Component ID not equal");
        }
        if (this.getLineName() == null ^ compartmentObject.getLineName() == null || compartmentObject.getLineName() != null && !this.getLineName().equals(compartmentObject.getLineName())) {
            log.debug("CompartmentObject: Component line not equal");
            return false;
        }
        if (this.getReleaseName() == null ^ compartmentObject.getReleaseName() == null || compartmentObject.getReleaseName() != null && !this.getReleaseName().equals(compartmentObject.getReleaseName())) {
            log.debug("CompartmentObject: Release name not equal");
            return false;
        }
        if (this.getXmlContent() == null ^ compartmentObject.getXmlContent() == null || compartmentObject.getXmlContent() != null && !this.getXmlContent().equals(compartmentObject.getXmlContent())) {
            log.debug("CompartmentObject: XML content not equal");
            return false;
        }
        if (this.getCaption() == null ^ compartmentObject.getCaption() == null || compartmentObject.getCaption() != null && !this.getCaption().equals(compartmentObject.getCaption())) {
            log.debug("CompartmentObject: Caption not equal");
        }
        if (this.getDescription() == null ^ compartmentObject.getDescription() == null || compartmentObject.getDescription() != null && !this.getDescription().equals(compartmentObject.getDescription())) {
            log.debug("CompartmentObject: Description not equal");
            return false;
        }
        if (this.getScGUID() == null ^ compartmentObject.getScGUID() == null || compartmentObject.getScGUID() != null && !this.getScGUID().equals(compartmentObject.getScGUID())) {
            log.debug("CompartmentObject: GUID not equal");
            return false;
        }
        if (this.getPackageType() == null ^ compartmentObject.getPackageType() == null || compartmentObject.getScGUID() != null && !this.getPackageType().equals(compartmentObject.getPackageType())) {
            log.debug("CompartmentObject: Package Type not equal");
            return false;
        }
        return true;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public String getLineName() {
        return this.lineName;
    }

    public String getXmlContent() {
        return this.xmlContent;
    }

    public void setCaption(String caption) throws CMSCValidateException {
        ParameterValidator.validateParam("Compartment Caption", ParameterValidator.CSCOMP_CAPTION, caption);
        this.caption = caption;
    }

    public void setDescription(String description) throws CMSCValidateException {
        ParameterValidator.validateParam("Compartment Description", ParameterValidator.CSCOMP_DESCRIPTION, description);
        this.description = description;
    }

    public void setName(String name) throws CMSCValidateException {
        ParameterValidator.validateParam("Compartment Name", ParameterValidator.CSCOMP_NAME, name);
        this.name = name;
    }

    public void setVendor(String vendor) throws CMSCValidateException {
        ParameterValidator.validateParam("Compartment Vendor", ParameterValidator.CSCOMP_VENDOR, vendor);
        this.vendor = vendor;
    }

    public void setReleaseName(String releaseName) throws CMSCValidateException {
        ParameterValidator.validateParam("Compartment Release Name", ParameterValidator.CSYSCOMP_SCRELEASE, releaseName);
        this.releaseName = releaseName;
    }

    public void setLineName(String lineName) throws CMSCValidateException {
        ParameterValidator.validateParam("Compartment Line Name", ParameterValidator.CSCOMP_LINE, lineName);
        this.lineName = lineName;
    }

    public void setXmlContent(String xmlContent) throws CMSCValidateException {
        ParameterValidator.validateParam("Compartment XML Content", ParameterValidator.CSYSCOMP_XMLCONTENT, xmlContent);
        this.xmlContent = xmlContent;
    }

    public String getScGUID() {
        return this.scGUID;
    }

    public void setScGUID(String string) {
        this.scGUID = string;
    }

    public String getPackageType() {
        return this.packageType;
    }

    public void setPackageType(String string) throws CMSCValidateException {
        ParameterValidator.validateParam("Compartment Assembly Package Type", ParameterValidator.CSYSCOMP_PACKAGETYPE, string);
        this.packageType = string;
    }

    public String getComponentID() {
        return this.componentID;
    }

    public void setComponentID(String string) {
        this.componentID = string;
    }

    public String getCompAction() {
        return this.compAction;
    }

    public void setCompAction(String string) {
        this.compAction = string;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public String getOriginalLanguage() {
        return this.originalLanguage;
    }

    public String getTerminologyDomain() {
        return this.terminologyDomain;
    }

    public void setOriginalLanguage(String string) {
        this.originalLanguage = string;
    }

    public void setTerminologyDomain(String string) {
        this.terminologyDomain = string;
    }

    public String getGenXMLContent() {
        return this.genXMLContent;
    }

    public void setGenXMLContent(String string) {
        this.genXMLContent = string;
    }

    public String getXmlStatus() {
        return this.xmlStatus;
    }

    public void setXmlStatus(String string) {
        this.xmlStatus = string;
    }

    public String getInputXMLContent() {
        return this.inputXMLContent;
    }

    public void setInputXMLContent(String string) {
        this.inputXMLContent = string;
    }

    public String getOldGenXMLContent() {
        return this.oldGenXMLContent;
    }

    public void setOldGenXMLContent(String string) {
        this.oldGenXMLContent = string;
    }
}

