/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.types.config;

import com.sap.cms.client.types.CMSClientObject;
import com.sap.cms.client.types.config.CMSSoftwareComponentVersion;
import com.sap.cms.client.types.config.CMSSystem;
import com.sap.cms.client.types.config.CMSTrack;
import com.sap.cms.util.logging.CmsLogger;
import java.io.Serializable;

public class CMSTrackConfiguration
extends CMSClientObject
implements Serializable,
Cloneable {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$client$types$config$CMSTrackConfiguration == null ? (class$com$sap$cms$client$types$config$CMSTrackConfiguration = CMSTrackConfiguration.class$("com.sap.cms.client.types.config.CMSTrackConfiguration")) : class$com$sap$cms$client$types$config$CMSTrackConfiguration).getName());
    private static final long serialVersionUID = 1L;
    private CMSTrack track;
    private String cbsURL;
    private String dtrURL;
    private CMSSystem[] systems;
    private CMSSoftwareComponentVersion[] developedSoftwareComponentVersions;
    private CMSSoftwareComponentVersion[] usedSoftwareComponentVersions;
    static /* synthetic */ Class class$com$sap$cms$client$types$config$CMSTrackConfiguration;

    public CMSTrackConfiguration() {
    }

    public CMSTrackConfiguration(CMSTrack track, String cbsURL, String dtrURL, CMSSystem[] systems) {
        this.setTrack(track);
        this.setCbsURL(cbsURL);
        this.setDtrURL(dtrURL);
        this.setSystems(systems);
    }

    public CMSTrackConfiguration(CMSTrack track, String cbsURL, String dtrURL, CMSSystem[] systems, CMSSoftwareComponentVersion[] developedCompartments, CMSSoftwareComponentVersion[] usedCompartments) {
        this.setTrack(track);
        this.setCbsURL(cbsURL);
        this.setDtrURL(dtrURL);
        this.setSystems(systems);
        this.setDevelopedSoftwareComponentVersions(developedCompartments);
        this.setUsedSoftwareComponentVersions(usedCompartments);
    }

    public String getCbsURL() {
        return this.cbsURL;
    }

    public String getDtrURL() {
        return this.dtrURL;
    }

    public CMSSystem[] getSystems() {
        if (this.systems == null) {
            return null;
        }
        return this.cloneCMSSystemArray(this.systems);
    }

    public CMSTrack getTrack() {
        if (this.track == null) {
            return null;
        }
        return (CMSTrack)this.track.clone();
    }

    public void setCbsURL(String cbsURL) {
        this.cbsURL = cbsURL;
    }

    public void setDtrURL(String url) {
        this.dtrURL = url;
    }

    public void setSystems(CMSSystem[] systems) {
        this.systems = systems == null ? null : this.cloneCMSSystemArray(systems);
    }

    public void setTrack(CMSTrack track) {
        this.track = track == null ? null : (CMSTrack)track.clone();
    }

    public CMSSoftwareComponentVersion[] getDevelopedSoftwareComponentVersions() {
        return this.cloneCMSSoftwareComponentVersionArray(this.developedSoftwareComponentVersions);
    }

    public void setDevelopedSoftwareComponentVersions(CMSSoftwareComponentVersion[] developedSoftwareComponentVersions) {
        this.developedSoftwareComponentVersions = this.cloneCMSSoftwareComponentVersionArray(developedSoftwareComponentVersions);
    }

    public CMSSoftwareComponentVersion[] getUsedSoftwareComponentVersions() {
        return this.cloneCMSSoftwareComponentVersionArray(this.usedSoftwareComponentVersions);
    }

    public void setUsedSoftwareComponentVersions(CMSSoftwareComponentVersion[] usedSoftwareComponentVersions) {
        this.usedSoftwareComponentVersions = this.cloneCMSSoftwareComponentVersionArray(usedSoftwareComponentVersions);
    }

    public String toString() {
        return "Track=(" + this.track + ")" + " CBS='" + this.cbsURL + "'" + " DTR='" + this.dtrURL + "'" + " Systems=" + this.createStringRepresentationOfObjectArray(this.systems) + " Developed compartments=" + this.createStringRepresentationOfObjectArray(this.developedSoftwareComponentVersions) + " Used compartments=" + this.createStringRepresentationOfObjectArray(this.usedSoftwareComponentVersions);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CMSTrackConfiguration)) {
            return false;
        }
        CMSTrackConfiguration config = (CMSTrackConfiguration)obj;
        return this.nullCompare(this.track, config.getTrack()) && this.nullCompare(this.cbsURL, config.getCbsURL()) && this.nullCompare(this.dtrURL, config.getDtrURL()) && this.nullCompare(this.developedSoftwareComponentVersions, config.getDevelopedSoftwareComponentVersions()) && this.nullCompare(this.usedSoftwareComponentVersions, config.getUsedSoftwareComponentVersions()) && this.nullCompare(this.systems, config.getSystems());
    }

    public int hashCode() {
        if (this.track == null) {
            return 0;
        }
        return this.track.hashCode();
    }

    public Object clone() {
        try {
            CMSTrackConfiguration myClone = (CMSTrackConfiguration)super.clone();
            myClone.track = myClone.getTrack();
            myClone.developedSoftwareComponentVersions = myClone.getDevelopedSoftwareComponentVersions();
            myClone.usedSoftwareComponentVersions = myClone.getUsedSoftwareComponentVersions();
            myClone.systems = myClone.getSystems();
            return myClone;
        }
        catch (CloneNotSupportedException ex) {
            log.error("Clone not supported");
            return null;
        }
    }

    protected CMSSoftwareComponentVersion[] cloneCMSSoftwareComponentVersionArray(CMSSoftwareComponentVersion[] comps) {
        if (comps == null) {
            return null;
        }
        CMSSoftwareComponentVersion[] clone = new CMSSoftwareComponentVersion[comps.length];
        int i = 0;
        while (i < comps.length) {
            clone[i] = comps[i] == null ? null : (CMSSoftwareComponentVersion)comps[i].clone();
            ++i;
        }
        return clone;
    }

    protected CMSSystem[] cloneCMSSystemArray(CMSSystem[] systems) {
        if (systems == null) {
            return null;
        }
        CMSSystem[] clone = new CMSSystem[systems.length];
        int i = 0;
        while (i < systems.length) {
            clone[i] = systems[i] == null ? null : (CMSSystem)systems[i].clone();
            ++i;
        }
        return clone;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

