/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.types.config;

import com.sap.cms.util.logging.CmsLogger;
import java.io.Serializable;

public class CMSSystemObject
implements Serializable {
    private String name = null;
    private String domname = null;
    private String trackName = null;
    private String cbsbsname = null;
    private String typename = null;
    private String role = null;
    private boolean qainQueue = false;
    private boolean importQueue = false;
    private boolean qaoutQueue = false;
    private boolean assemblyQueue = false;
    private String caption = null;
    private String description = null;

    public void toLog(CmsLogger log) {
        log.debug("CMS System Name: " + this.name);
        log.debug("CMS System Domain Name: " + this.domname);
        log.debug("CMS System Track Name: " + this.trackName);
        log.debug("CMS System CBS BS Name: " + this.cbsbsname);
        log.debug("CMS System Type Name: " + this.typename);
        log.debug("CMS System Role: " + this.role);
        log.debug("CMS System QA In Queue: " + this.qainQueue);
        log.debug("CMS System Import Queue: " + this.importQueue);
        log.debug("CMS System QA Out Queue: " + this.qaoutQueue);
        log.debug("CMS System Assembly Queue: " + this.assemblyQueue);
        log.debug("CMS System Caption: " + this.caption);
        log.debug("CMS System Description: " + this.description);
    }

    public void toInfo(CmsLogger log) {
        log.info("CMS System Name: " + this.name);
        log.info("CMS System Domain Name: " + this.domname);
        log.debug("CMS System Track Name: " + this.trackName);
        log.info("CMS System CBS BS Name: " + this.cbsbsname);
        log.info("CMS System Type Name: " + this.typename);
        log.info("CMS System Role: " + this.role);
        log.info("CMS System QA In Queue: " + this.qainQueue);
        log.info("CMS System Import Queue: " + this.importQueue);
        log.info("CMS System QA Out Queue: " + this.qaoutQueue);
        log.info("CMS System Assembly Queue: " + this.assemblyQueue);
        log.info("CMS System Caption: " + this.caption);
        log.info("CMS System Description: " + this.description);
    }

    public boolean equals(Object obj, CmsLogger log) {
        CMSSystemObject cmsSystemObject = (CMSSystemObject)obj;
        if (this.getName() == null ^ cmsSystemObject.getName() == null || cmsSystemObject.getName() != null && !this.getName().equals(cmsSystemObject.getName())) {
            log.debug("CMSSystemObject: Name not equal");
            return false;
        }
        if (this.getDomname() == null ^ cmsSystemObject.getDomname() == null || cmsSystemObject.getDomname() != null && !this.getDomname().equals(cmsSystemObject.getDomname())) {
            log.debug("CMSSystemObject: Domain name not equal");
            return false;
        }
        if (this.getCbsbsname() == null ^ cmsSystemObject.getCbsbsname() == null || cmsSystemObject.getCbsbsname() != null && !this.getCbsbsname().equals(cmsSystemObject.getCbsbsname())) {
            log.debug("CMSSystemObject: Build space not equal");
            return false;
        }
        if (this.getTypename() == null ^ cmsSystemObject.getTypename() == null || cmsSystemObject.getTypename() != null && !this.getTypename().equals(cmsSystemObject.getTypename())) {
            log.debug("CMSSystemObject: Type not equal");
            return false;
        }
        if (this.getRole() == null ^ cmsSystemObject.getRole() == null || cmsSystemObject.getRole() != null && !this.getRole().equals(cmsSystemObject.getRole())) {
            log.debug("CMSSystemObject: Role not equal");
            return false;
        }
        if (!this.isQainQueue() == cmsSystemObject.isQainQueue()) {
            log.debug("CMSSystemObject: QAIN queue not equal");
            return false;
        }
        if (!this.isImportQueue() == cmsSystemObject.isImportQueue()) {
            log.debug("CMSSystemObject: Import queue not equal");
            return false;
        }
        if (!this.isQaoutQueue() == cmsSystemObject.isQaoutQueue()) {
            log.debug("CMSSystemObject: QAOUT queue not equal");
            return false;
        }
        if (!this.isAssemblyQueue() == cmsSystemObject.isAssemblyQueue()) {
            log.debug("CMSSystemObject: Assembly queue not equal");
            return false;
        }
        if (this.getCaption() == null ^ cmsSystemObject.getCaption() == null || cmsSystemObject.getCaption() != null && !this.getCaption().equals(cmsSystemObject.getCaption())) {
            log.debug("CMSSystemObject: Caption not equal");
            return false;
        }
        if (this.getDescription() == null ^ cmsSystemObject.getDescription() == null || cmsSystemObject.getDescription() != null && !this.getDescription().equals(cmsSystemObject.getDescription())) {
            log.debug("CMSSystemObject: Description not equal");
            return false;
        }
        return true;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getCbsbsname() {
        return this.cbsbsname;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDomname() {
        return this.domname;
    }

    public String getName() {
        return this.name;
    }

    public String getRole() {
        return this.role;
    }

    public String getTypename() {
        return this.typename;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setCbsbsname(String cbsbsname) {
        this.cbsbsname = cbsbsname;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDomname(String domname) {
        this.domname = domname;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setTypename(String typename) {
        this.typename = typename;
    }

    public boolean isAssemblyQueue() {
        return this.assemblyQueue;
    }

    public boolean isImportQueue() {
        return this.importQueue;
    }

    public boolean isQainQueue() {
        return this.qainQueue;
    }

    public boolean isQaoutQueue() {
        return this.qaoutQueue;
    }

    public void setAssemblyQueue(boolean assemblyQueue) {
        this.assemblyQueue = assemblyQueue;
    }

    public void setImportQueue(boolean importQueue) {
        this.importQueue = importQueue;
    }

    public void setQainQueue(boolean qainQueue) {
        this.qainQueue = qainQueue;
    }

    public void setQaoutQueue(boolean qaoutQueue) {
        this.qaoutQueue = qaoutQueue;
    }

    public String getTrackName() {
        return this.trackName;
    }

    public void setTrackName(String string) {
        this.trackName = string;
    }
}

