/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.types.config;

import com.sap.cms.client.types.config.CMSDomainObject;
import com.sap.cms.client.validation.config.ParameterValidator;
import com.sap.cms.util.exception.conf.CMSCValidateException;
import com.sap.cms.util.logging.CmsLogger;
import java.io.Serializable;
import java.util.Vector;

public class CMSServerObject
implements Serializable {
    private String cmsName = null;
    private String cmsCaption = null;
    private String cmsDescription = null;
    private String cmsURL = null;
    private String cmsAdminUser = null;
    private String cmsAdminPassword = null;
    private String sldURL = null;
    private Vector domainVector = new Vector();
    private String owner = null;

    public void toLog(CmsLogger log) {
        log.debug("CMS Server Name: " + this.cmsName);
        log.debug("CMS Server URL: " + this.cmsURL);
        log.debug("CMS Server Admin User: " + this.cmsAdminUser);
        int i = 0;
        while (i < this.domainVector.size()) {
            log.debug("Domain " + (i + 1) + ":");
            ((CMSDomainObject)this.domainVector.get(i)).toLog(log);
            ++i;
        }
        log.debug("CMS Server Caption: " + this.cmsCaption);
        log.debug("CMS Server Description: " + this.cmsDescription);
        log.debug("CMS Server SLD URL: " + this.sldURL);
        log.debug("CMS Owner: " + this.owner);
    }

    public void toInfo(CmsLogger log) {
        log.info("CMS Server Name: " + this.cmsName);
        log.info("CMS Server URL: " + this.cmsURL);
        log.info("CMS Server Admin User: " + this.cmsAdminUser);
        int i = 0;
        while (i < this.domainVector.size()) {
            log.info("Domain " + (i + 1) + ":");
            ((CMSDomainObject)this.domainVector.get(i)).toInfo(log);
            ++i;
        }
        log.info("CMS Server Caption: " + this.cmsCaption);
        log.info("CMS Server Description: " + this.cmsDescription);
        log.info("CMS Server SLD URL: " + this.sldURL);
        log.info("CMS Owner: " + this.owner);
    }

    public boolean equals(Object obj, CmsLogger log) {
        CMSServerObject cmsServerObject = (CMSServerObject)obj;
        if (this.getCmsName() == null ^ cmsServerObject.getCmsName() == null || cmsServerObject.getCmsName() != null && !this.getCmsName().equals(cmsServerObject.getCmsName())) {
            log.debug("CMSServerObject: Name not equal");
            return false;
        }
        if (this.getCmsURL() == null ^ cmsServerObject.getCmsURL() == null || cmsServerObject.getCmsURL() != null && !this.getCmsURL().equals(cmsServerObject.getCmsURL())) {
            log.debug("CMSServerObject: URL not equal");
            return false;
        }
        if (this.getCmsAdminUser() == null ^ cmsServerObject.getCmsAdminUser() == null || cmsServerObject.getCmsAdminUser() != null && !this.getCmsAdminUser().equals(cmsServerObject.getCmsAdminUser())) {
            log.debug("CMSServerObject: Admin User not equal");
            return false;
        }
        if (this.getSldURL() == null ^ cmsServerObject.getSldURL() == null || cmsServerObject.getSldURL() != null && !this.getSldURL().equals(cmsServerObject.getSldURL())) {
            log.debug("CMSServerObject: SLD URL not equal");
            return false;
        }
        if (this.cmsAdminPassword == null ^ cmsServerObject.getCmsAdminPassword() == null || cmsServerObject.getCmsAdminPassword() != null && !this.getCmsAdminPassword().equals(cmsServerObject.getCmsAdminPassword())) {
            log.debug("CMSServerObject: Admin Password not equal");
            return false;
        }
        if (this.getDomainVector().size() != cmsServerObject.getDomainVector().size()) {
            log.debug("CMSServerObject: Domain Vector size not equal");
            return false;
        }
        int i = 0;
        while (i < this.getDomainVector().size()) {
            if (!((CMSDomainObject)this.getDomainVector().get(i)).equals((CMSDomainObject)cmsServerObject.getDomainVector().get(i), log)) {
                log.debug("CMSServerObject: Domain Object not equal");
                log.debug("Domain Object 1: ");
                ((CMSDomainObject)this.getDomainVector().get(i)).toLog(log);
                log.debug("Domain Object 2: ");
                ((CMSDomainObject)cmsServerObject.getDomainVector().get(i)).toLog(log);
                return false;
            }
            ++i;
        }
        if (this.getCmsCaption() == null ^ cmsServerObject.getCmsCaption() == null || cmsServerObject.getCmsCaption() != null && !this.getCmsCaption().equals(cmsServerObject.getCmsCaption())) {
            log.debug("CMSServerObject: Caption not equal");
            return false;
        }
        if (this.getCmsDescription() == null ^ cmsServerObject.getCmsDescription() == null || cmsServerObject.getCmsDescription() != null && !this.getCmsDescription().equals(cmsServerObject.getCmsDescription())) {
            log.debug("CMSServerObject: Description not equal");
            return false;
        }
        if (this.getSldURL() == null ^ cmsServerObject.getSldURL() == null || cmsServerObject.getSldURL() != null && !this.getSldURL().equals(cmsServerObject.getSldURL())) {
            log.debug("CMSServerObject: SLD URL not equal");
            return false;
        }
        return true;
    }

    public String getCmsDescription() {
        return this.cmsDescription;
    }

    public String getCmsName() {
        return this.cmsName;
    }

    public String getCmsURL() {
        return this.cmsURL;
    }

    public void setCmsDescription(String cmsDescription) {
        this.cmsDescription = cmsDescription;
    }

    public void setCmsName(String cmsName) throws CMSCValidateException {
        ParameterValidator.validateParam("CMS Name", ParameterValidator.CSERVER_NAME, cmsName);
        this.cmsName = cmsName;
    }

    public void setCmsURL(String cmsURL) {
        this.cmsURL = cmsURL;
    }

    public String getCmsCaption() {
        return this.cmsCaption;
    }

    public void setCmsCaption(String cmsCaption) {
        this.cmsCaption = cmsCaption;
    }

    public Vector getDomainVector() {
        return this.domainVector;
    }

    public void setDomainVector(Vector domainVector) {
        this.domainVector = domainVector;
    }

    public String getCmsAdminPassword() {
        return this.cmsAdminPassword;
    }

    public String getCmsAdminUser() {
        return this.cmsAdminUser;
    }

    public void setCmsAdminPassword(String cmsAdminPassword) {
        this.cmsAdminPassword = cmsAdminPassword;
    }

    public void setCmsAdminUser(String cmsAdminUser) {
        this.cmsAdminUser = cmsAdminUser;
    }

    public String getSldURL() {
        return this.sldURL;
    }

    public void setSldURL(String string) {
        this.sldURL = string;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        this.owner = string;
    }
}

