/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.types.config;

import com.sap.cms.client.validation.config.ParameterValidator;
import com.sap.cms.util.exception.conf.CMSCExtValidateException;
import com.sap.cms.util.exception.conf.CMSCValidateException;
import com.sap.cms.util.exception.conf.CMSConfigurationException;
import com.sap.cms.util.logging.CmsLogger;
import com.sap.tc.complib.namecheck.NameCheckException;
import com.sap.tc.complib.namecheck.NameChecker;
import java.io.Serializable;

public class CMSDomainObject
implements Serializable {
    public static final String SIMULATION_ACTIVE = "Y";
    public static final String SIMULATION_PCS_ACTIVE = "P";
    public static final String SIMULATION_INACTIVE = "N";
    public static final String NAME_DEFAULT = "D0";
    public static final String USER_GROUP_SAP = "SAP";
    public static final String USER_GROUP_CUSTOMER = "CUSTOMER";
    public static final String USER_GROUP_PARTNER = "PARTNER";
    private String name = null;
    private String cmsservname = null;
    private String transfolder = null;
    private String sldURL = null;
    private String translationURL = null;
    private String caption = null;
    private String description = null;
    private String userGroup = null;

    public void validateParameter() throws CMSConfigurationException {
    }

    public boolean equals(Object obj, CmsLogger log) {
        CMSDomainObject cmsDomainObject = (CMSDomainObject)obj;
        if (this.getName() == null ^ cmsDomainObject.getName() == null || cmsDomainObject.getName() != null && !this.getName().equals(cmsDomainObject.getName())) {
            log.debug("CMSDomainObject: Name not equal");
            return false;
        }
        if (this.getCmsservname() == null ^ cmsDomainObject.getCmsservname() == null || this.getCmsservname() != null && !this.getCmsservname().equals(cmsDomainObject.getCmsservname())) {
            log.debug("CMSDomainObject: CMS server name not equal");
            return false;
        }
        if (this.getTransfolder() == null ^ cmsDomainObject.getTransfolder() == null || cmsDomainObject.getTransfolder() != null && !this.getTransfolder().equals(cmsDomainObject.getTransfolder())) {
            log.debug("CMSDomainObject: Transport folder not equal");
            return false;
        }
        if (this.getSldURL() == null ^ cmsDomainObject.getSldURL() == null || cmsDomainObject.getSldURL() != null && !this.getSldURL().equals(cmsDomainObject.getSldURL())) {
            log.debug("CMSDomainObject: SLD URL not equal");
            return false;
        }
        if (this.getTranslationURL() == null ^ cmsDomainObject.getTranslationURL() == null || cmsDomainObject.getTranslationURL() != null && !this.getTranslationURL().equals(cmsDomainObject.getTranslationURL())) {
            log.debug("CMSDomainObject: Translation URL not equal");
            return false;
        }
        if (this.getCaption() == null ^ cmsDomainObject.getCaption() == null || cmsDomainObject.getCaption() != null && !this.getCaption().equals(cmsDomainObject.getCaption())) {
            log.debug("CMSDomainObject: Caption not equal");
            return false;
        }
        if (this.getDescription() == null ^ cmsDomainObject.getDescription() == null || cmsDomainObject.getDescription() != null && !this.getDescription().equals(cmsDomainObject.getDescription())) {
            log.debug("CMSDomainObject: Description not equal");
            return false;
        }
        return true;
    }

    public void toLog(CmsLogger log) {
        log.debug("Domain Name: " + this.name);
        log.debug("Domain CMS Server Name: " + this.cmsservname);
        log.debug("Domain Transport Folder: " + this.transfolder);
        log.debug("Domain SLD URL: " + this.sldURL);
        log.debug("Domain Translation URL: " + this.translationURL);
        log.debug("Domain Caption: " + this.caption);
        log.debug("Domain Description: " + this.description);
        log.debug("Domain User Group: " + this.userGroup);
    }

    public void toInfo(CmsLogger log) {
        log.info("Domain Name: " + this.name);
        log.info("Domain CMS Server Name: " + this.cmsservname);
        log.info("Domain Transport Folder: " + this.transfolder);
        log.info("Domain SLD URL: " + this.sldURL);
        log.info("Domain Translation URL: " + this.translationURL);
        log.info("Domain Caption: " + this.caption);
        log.info("Domain Description: " + this.description);
        log.info("Domain User Group: " + this.userGroup);
    }

    public String getCaption() {
        return this.caption;
    }

    public String getCmsservname() {
        return this.cmsservname;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getSldURL() {
        return this.sldURL;
    }

    public String getTransfolder() {
        return this.transfolder;
    }

    public String getTranslationURL() {
        return this.translationURL;
    }

    public void setCaption(String caption) throws CMSCValidateException {
        ParameterValidator.validateParam("Domain Caption", ParameterValidator.CDOM_CAPTION, caption);
        this.caption = caption;
    }

    public void setCmsservname(String cmsservname) throws CMSCValidateException {
        ParameterValidator.validateParam("Domain CMS Server Name", ParameterValidator.CDOM_CMSSERVNAME, cmsservname);
        this.cmsservname = cmsservname;
    }

    public void setDescription(String description) throws CMSCValidateException {
        ParameterValidator.validateParam("Domain Description", ParameterValidator.CDOM_DESCRIPTION, description);
        this.description = description;
    }

    public void setName(String name) throws CMSCValidateException, CMSCExtValidateException {
        ParameterValidator.validateParam("Domain Name", ParameterValidator.CDOM_NAME, name);
        try {
            NameChecker.checkDevelopmentConfigurationName((String)name);
        }
        catch (NameCheckException e) {
            String[] args = new String[]{"Track Name", name, e.getMessage()};
            CMSCValidateException ex = new CMSCValidateException((Throwable)e);
            throw new CMSCExtValidateException((Throwable)ex);
        }
        this.name = name;
    }

    public void setSldURL(String sldURL) throws CMSCValidateException {
        ParameterValidator.validateParam("Domain SLD URL", ParameterValidator.CDOM_SLDURL, sldURL);
        this.sldURL = sldURL;
    }

    public void setTransfolder(String transfolder) throws CMSCValidateException {
        ParameterValidator.validateParam("Domain Transport Folder", ParameterValidator.CDOM_TRANSFOLDER, transfolder);
        this.transfolder = transfolder;
    }

    public void setTranslationURL(String translationURL) throws CMSCValidateException {
        ParameterValidator.validateParam("Domain Translation URL", ParameterValidator.CDOM_TRANSLATIONURL, translationURL);
        this.translationURL = translationURL;
    }

    public String getUserGroup() {
        return this.userGroup;
    }

    public void setUserGroup(String string) {
        this.userGroup = string;
    }
}

