/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.types.config;

import com.sap.cms.client.types.config.CompartmentObject;
import com.sap.cms.util.logging.CmsLogger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class CBSCompartmentObject
implements Serializable {
    public Vector devCompartmentVector = new Vector();
    public Vector depCompartmentVector = new Vector();
    public boolean finalAssemblyFlag = false;
    private String owner = null;

    public void toLog(CmsLogger log) {
        int i = 0;
        while (i < this.devCompartmentVector.size()) {
            log.debug("Used Comp. " + (i + 1) + ":");
            ((CompartmentObject)this.devCompartmentVector.get(i)).toLog(log);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.depCompartmentVector.size()) {
            log.debug("Mod. Comp. " + (i2 + 1) + ":");
            ((CompartmentObject)this.depCompartmentVector.get(i2)).toLog(log);
            ++i2;
        }
        log.debug("Final Assembly Flag: " + this.finalAssemblyFlag);
        log.debug("Owner: " + this.owner);
    }

    public void toInfo(CmsLogger log) {
        int i = 0;
        while (i < this.devCompartmentVector.size()) {
            log.info("Used Comp. " + (i + 1) + ":");
            ((CompartmentObject)this.devCompartmentVector.get(i)).toInfo(log);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.depCompartmentVector.size()) {
            log.info("Mod. Comp. " + (i2 + 1) + ":");
            ((CompartmentObject)this.depCompartmentVector.get(i2)).toInfo(log);
            ++i2;
        }
        log.debug("Final Assembly Flag: " + this.finalAssemblyFlag);
        log.info("Owner: " + this.owner);
    }

    public boolean equals(Object obj, CmsLogger log) {
        CBSCompartmentObject cbsCompartmentObject = (CBSCompartmentObject)obj;
        if (this.getDevCompartmentVector().size() != cbsCompartmentObject.getDevCompartmentVector().size()) {
            log.debug("CBSCompartmentObject: Dev. Compartment size not equal");
            return false;
        }
        if (this.getDepCompartmentVector().size() != cbsCompartmentObject.getDepCompartmentVector().size()) {
            log.debug("CBSCompartmentObject: Dep. Compartment size not equal");
            return false;
        }
        int i = 0;
        while (i < this.getDevCompartmentVector().size()) {
            if (!((CompartmentObject)this.getDevCompartmentVector().get(i)).equals((CompartmentObject)cbsCompartmentObject.getDevCompartmentVector().get(i), log)) {
                log.debug("CBSCompartmentObject: Dev. Compartment not equal");
                log.debug("Compartment 1: ");
                ((CompartmentObject)this.getDevCompartmentVector().get(i)).toLog(log);
                log.debug("Compartment 2: ");
                ((CompartmentObject)cbsCompartmentObject.getDevCompartmentVector().get(i)).toLog(log);
                return false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.getDepCompartmentVector().size()) {
            if (!((CompartmentObject)this.getDepCompartmentVector().get(i2)).equals((CompartmentObject)cbsCompartmentObject.getDepCompartmentVector().get(i2), log)) {
                log.debug("CBSCompartmentObject: Dep. Compartment not equal");
                log.debug("Compartment 1: ");
                ((CompartmentObject)this.getDepCompartmentVector().get(i2)).toLog(log);
                log.debug("Compartment 2: ");
                ((CompartmentObject)cbsCompartmentObject.getDepCompartmentVector().get(i2)).toLog(log);
                return false;
            }
            ++i2;
        }
        return true;
    }

    public Vector getDepCompartmentVector() {
        return this.depCompartmentVector;
    }

    public Vector getDevCompartmentVector() {
        return this.devCompartmentVector;
    }

    public void setDepCompartmentVector(Vector depCompartmentVector) {
        this.depCompartmentVector = depCompartmentVector;
    }

    public void setDevCompartmentVector(Vector devCompartmentVector) {
        this.devCompartmentVector = devCompartmentVector;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public HashMap getDepCompartmentHashMap() {
        HashMap<String, CompartmentObject> hashMap = new HashMap<String, CompartmentObject>();
        CompartmentObject compartmentObject = null;
        int i = 0;
        while (i < this.depCompartmentVector.size()) {
            compartmentObject = (CompartmentObject)this.depCompartmentVector.get(i);
            hashMap.put(compartmentObject.getVendor() + compartmentObject.getName(), compartmentObject);
            ++i;
        }
        return hashMap;
    }

    public HashMap getDevCompartmentHashMap() {
        HashMap<String, CompartmentObject> hashMap = new HashMap<String, CompartmentObject>();
        CompartmentObject compartmentObject = null;
        int i = 0;
        while (i < this.devCompartmentVector.size()) {
            compartmentObject = (CompartmentObject)this.devCompartmentVector.get(i);
            hashMap.put(compartmentObject.getVendor() + compartmentObject.getName(), compartmentObject);
            ++i;
        }
        return hashMap;
    }

    public void setDepCompartmentHashMap(HashMap map) {
        Iterator depCompHashMapIterator = map.values().iterator();
        this.depCompartmentVector = new Vector();
        CompartmentObject compartmentObject = null;
        while (depCompHashMapIterator.hasNext()) {
            compartmentObject = (CompartmentObject)depCompHashMapIterator.next();
            this.depCompartmentVector.add(compartmentObject);
        }
    }

    public void setDevCompartmentHashMap(HashMap map) {
        Iterator depCompHashMapIterator = map.values().iterator();
        this.devCompartmentVector = new Vector();
        CompartmentObject compartmentObject = null;
        while (depCompHashMapIterator.hasNext()) {
            compartmentObject = (CompartmentObject)depCompHashMapIterator.next();
            this.devCompartmentVector.add(compartmentObject);
        }
    }

    public boolean isFinalAssemblyFlag() {
        return this.finalAssemblyFlag;
    }

    public void setFinalAssemblyFlag(boolean b) {
        this.finalAssemblyFlag = b;
    }
}

