/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.types;

import com.sap.cms.client.types.ComponentID;
import com.sap.cms.client.types.Delivery;
import com.sap.cms.client.types.ExecState;
import com.sap.cms.client.types.RequestType;
import com.sap.cms.client.types.Sequence;
import com.sap.cms.client.types.VersionID;
import java.io.Serializable;

public class QueueItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NO_SOURCEPOINTER = "NO_SOURCEPOINTER";
    private ComponentID component;
    private VersionID version;
    private String compCaption;
    private String versCaption;
    private RequestType compType;
    private ComponentID softComp;
    private ExecState state;
    private Delivery delivery;
    private Sequence predecessor;
    private ComponentID sourceComp;
    private VersionID sourceVers;
    private String owner;
    private String procResultId;
    private String lCState;
    private String user;
    private String procTime;
    private String container;

    public QueueItem() {
    }

    public QueueItem(ComponentID component, VersionID version, String lCState, RequestType compType) {
        this.component = component;
        this.version = version;
        this.lCState = lCState;
        this.compType = compType;
    }

    public QueueItem(ComponentID _component, VersionID _version, ComponentID _srcComponent, VersionID _srcVersion, String _lCState, RequestType _compType) {
        this.component = _component;
        this.version = _version;
        this.sourceComp = _srcComponent;
        this.sourceVers = _srcVersion;
        this.lCState = _lCState;
        this.compType = _compType;
    }

    public ComponentID getComponent() {
        return this.component;
    }

    public VersionID getVersion() {
        return this.version;
    }

    public String getCompCaption() {
        if (this.compCaption == null) {
            this.setDefaultCompCaption();
        }
        return this.compCaption;
    }

    public String getVersCaption() {
        if (this.versCaption == null) {
            this.setDefaultVersCaption();
        }
        return this.versCaption;
    }

    public RequestType getCompType() {
        return this.compType;
    }

    public ComponentID getSoftComp() {
        return this.softComp;
    }

    public ExecState getState() {
        return this.state;
    }

    public Delivery getDelivery() {
        return this.delivery;
    }

    public Sequence getPredecessor() {
        return this.predecessor;
    }

    public ComponentID getSourceComp() {
        return this.sourceComp;
    }

    public VersionID getSourceVers() {
        return this.sourceVers;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getProcResultId() {
        return this.procResultId;
    }

    public String getLCState() {
        return this.lCState;
    }

    public String getUser() {
        return this.user;
    }

    public String getProcTime() {
        return this.procTime;
    }

    public String getContainer() {
        return this.container;
    }

    public void setComponent(ComponentID component) {
        this.component = component;
    }

    public void setVersion(VersionID version) {
        this.version = version;
    }

    public void setCompCaption(String compCaption) {
        this.compCaption = compCaption;
    }

    public void setVersCaption(String versCaption) {
        this.versCaption = versCaption;
    }

    public void setCompType(RequestType compType) {
        this.compType = compType;
    }

    public void setSoftComp(ComponentID softComp) {
        this.softComp = softComp;
    }

    public void setState(ExecState state) {
        this.state = state;
    }

    public void setDelivery(Delivery delivery) {
        this.delivery = delivery;
    }

    public void setPredecessor(Sequence predecessor) {
        this.predecessor = predecessor;
    }

    public void setSourceComp(ComponentID sourceComp) {
        this.sourceComp = sourceComp;
    }

    public void setSourceVers(VersionID sourceVers) {
        this.sourceVers = sourceVers;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setProcResultId(String procResultId) {
        this.procResultId = procResultId;
    }

    public void setLCState(String lCState) {
        this.lCState = lCState;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setProcTime(String procTime) {
        this.procTime = procTime;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String toString() {
        try {
            return "id=" + this.component.getCompId() + " vend=" + this.component.getVendor() + " name=" + this.component.getName() + " loc=" + this.version.getLocation() + " cnt=" + this.version.getCounter() + " cap=" + this.compCaption + " vers=" + this.versCaption + " typ=" + this.compType.toString() + " SCven=" + this.softComp.getVendor() + " SCnam=" + this.softComp.getName() + " state=" + this.state.getName() + " rel=" + this.delivery.getRelease() + " pat=" + this.delivery.getPatchLevel() + " delta=" + this.delivery.getDeltaVersion() + " expSeq=" + this.predecessor.getExpSequence() + " preCnt=" + this.predecessor.getpreCounter() + " srcVen=" + this.sourceComp.getVendor() + " srcNam=" + this.sourceComp.getName() + " srcLoc=" + this.sourceVers.getLocation() + " srcCnt=" + this.sourceVers.getCounter() + " own=" + this.owner + " result=" + this.procResultId + " LCstate=" + this.lCState + " usr=" + this.user + " tim=" + this.procTime + " cont=" + this.container;
        }
        catch (Exception e) {
            try {
                return "id=" + this.component.getCompId() + " vend=" + this.component.getVendor() + " name=" + this.component.getName() + " loc=" + this.version.getLocation() + " cnt=" + this.version.getCounter() + " typ=" + this.compType.toString();
            }
            catch (Exception e1) {
                return super.toString();
            }
        }
    }

    public String toLogString() {
        try {
            if ("".equalsIgnoreCase(this.component.getName())) {
                return this.compType.toString() + " " + this.component.getCompId() + " Version " + this.version.getLocation() + "." + this.version.getCounter();
            }
            return this.compType.toString() + " " + this.component.getVendor() + "." + this.component.getName() + " Version " + this.version.getLocation() + "." + this.version.getCounter();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public boolean equals(Object o) {
        QueueItem item = (QueueItem)o;
        return item.getComponent().getCompId().equals(this.component.getCompId()) && item.getVersion().getLocation().equals(this.version.getLocation()) && item.getVersion().getCounter() == this.version.getCounter();
    }

    public int hashCode() {
        return (this.component.getCompId() + this.version.getLocation() + this.version.getCounter()).hashCode();
    }

    public static final QueueItem copy(QueueItem _item) {
        QueueItem newItem = new QueueItem(_item.getComponent(), _item.getVersion(), _item.getSourceComp(), _item.getSourceVers(), _item.getLCState(), _item.getCompType());
        newItem.setCompCaption(_item.getCompCaption());
        newItem.setVersCaption(_item.getVersCaption());
        newItem.setSoftComp(_item.getSoftComp());
        newItem.setDelivery(_item.getDelivery());
        newItem.setPredecessor(_item.getPredecessor());
        newItem.setProcTime(_item.getProcTime());
        newItem.setOwner(_item.getOwner());
        newItem.setUser(_item.getUser());
        newItem.setProcResultId(_item.getProcResultId());
        newItem.setState(_item.getState());
        newItem.setContainer(_item.getContainer());
        return newItem;
    }

    private void setDefaultCompCaption() {
        this.compCaption = this.component.getVendor() + '_' + this.component.getName();
    }

    private void setDefaultVersCaption() {
        this.versCaption = this.version.getLocation() + '.' + this.version.getCounter();
        if (this.delivery != null) {
            if (this.compType.toString().equals(RequestType.SOFT_COMP_VERS.toString())) {
                this.versCaption = this.delivery.getRelease() + " Level " + this.delivery.getPatchLevel() + " Update " + this.delivery.getUpdateVersion();
            } else if (this.compType.toString().equals(RequestType.DEVEL_COMP_VERS.toString())) {
                this.versCaption = "Patch " + this.delivery.getRelease() + " Level " + this.delivery.getPatchLevel() + " Update " + this.delivery.getUpdateVersion();
            }
        }
    }

    public void setDefaultSourcePointer() {
        this.sourceComp = new ComponentID(NO_SOURCEPOINTER, NO_SOURCEPOINTER, NO_SOURCEPOINTER);
        this.sourceVers = new VersionID(NO_SOURCEPOINTER, 0L);
    }

    public void resetProcResultId() {
        this.procResultId = null;
    }
}

