/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.types;

import com.sap.cms.client.types.ComponentID;
import com.sap.cms.client.types.VersionID;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.logging.CmsLogger;
import java.io.Serializable;
import java.util.Date;

public class CMSChangeRequest
implements Serializable {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$client$types$CMSChangeRequest == null ? (class$com$sap$cms$client$types$CMSChangeRequest = CMSChangeRequest.class$("com.sap.cms.client.types.CMSChangeRequest")) : class$com$sap$cms$client$types$CMSChangeRequest).getName());
    public static final byte STATE_NEW = 0;
    public static final byte STATE_WAITING_FOR_EXPORT = 1;
    public static final byte STATE_EXPORT_FINISHED = 2;
    public static final byte MIN_STATE = 0;
    public static final byte MAX_STATE = 2;
    public static final String[] STATE_CAPTIONS = new String[]{"new", "waiting for export", "finished"};
    private ComponentID component;
    private VersionID version;
    private String caption;
    private String owner;
    private long creationDate;
    private long modificationDate;
    private long exportTimestamp;
    private byte state = 0;
    static /* synthetic */ Class class$com$sap$cms$client$types$CMSChangeRequest;

    public CMSChangeRequest() {
    }

    public CMSChangeRequest(ComponentID component, VersionID version, String caption, String owner, long creationDate, long modificationDate, long exportTimestamp, byte state) {
        log.entering("Constructor", new Object[]{component, version, caption, owner, new Date(creationDate), new Date(modificationDate), new Date(exportTimestamp), new Byte(state)});
        try {
            this.setComponent(component);
            this.setVersion(version);
            this.setCaption(caption);
            this.setOwner(owner);
            this.setCreationDate(creationDate);
            this.setModificationDate(modificationDate);
            this.setExportTimestamp(exportTimestamp);
            this.setState(state);
            Object var13_9 = null;
        }
        catch (Throwable throwable) {
            Object var13_10 = null;
            log.exiting("Constructor");
            throw throwable;
        }
        log.exiting("Constructor");
    }

    public String getCaption() {
        return this.caption;
    }

    public ComponentID getComponent() {
        return this.component;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public long getExportTimestamp() {
        return this.exportTimestamp;
    }

    public long getModificationDate() {
        return this.modificationDate;
    }

    public String getOwner() {
        return this.owner;
    }

    public byte getState() {
        return this.state;
    }

    public VersionID getVersion() {
        return this.version;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setComponent(ComponentID component) {
        this.component = component;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public void setExportTimestamp(long exportTimestamp) {
        this.exportTimestamp = exportTimestamp;
    }

    public void setModificationDate(long modificationDate) {
        this.modificationDate = modificationDate;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setState(byte state) {
        if (state < 0 || state > 2) {
            log.error("Undefined state '" + state + "'");
            throw new CMSUnexpectedException("Undefined state '" + state + "'");
        }
        this.state = state;
    }

    public void setVersion(VersionID version) {
        this.version = version;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CMSChangeRequest)) {
            return false;
        }
        ComponentID tmpComp = ((CMSChangeRequest)obj).getComponent();
        if (this.component == null ? tmpComp != null : !this.component.equals(tmpComp)) {
            return false;
        }
        VersionID tmpVers = ((CMSChangeRequest)obj).getVersion();
        return !(this.version == null ? tmpVers != null : !this.version.equals(tmpVers));
    }

    public int hashCode() {
        if (this.component == null) {
            if (this.version == null) {
                return 0;
            }
            return this.version.hashCode();
        }
        if (this.version == null) {
            return this.component.hashCode();
        }
        return this.component.hashCode() + this.version.hashCode();
    }

    public String toString() {
        return "component='" + this.component + "'" + " version='" + this.version + "'" + " caption='" + this.caption + "'" + " owner='" + this.owner + "'" + " state='" + this.state + "'" + " creationDate='" + this.creationDate + "'" + " modificationDate='" + this.modificationDate + "'" + " exportTimestamp='" + this.exportTimestamp + "'";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

