/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.release.impl;

import com.sap.cms.client.connection.ICMSConnectionIdentifier;
import com.sap.cms.client.connector.CMSConnectorException;
import com.sap.cms.client.managerAPI.CMSConfigurationManagerAPI;
import com.sap.cms.client.managerAPI.CMSConfigurationManagerIF;
import com.sap.cms.client.organizerAPI.CMSTransportOrganizerAPI;
import com.sap.cms.client.organizerAPI.CMSTransportOrganizerIF;
import com.sap.cms.client.release.ReleaseAPI;
import com.sap.cms.client.types.CMSChangeList;
import com.sap.cms.client.types.CMSChangeRequest;
import com.sap.cms.client.types.CMSComponentLocation;
import com.sap.cms.client.types.CmsUserPermissions;
import com.sap.cms.client.types.ComponentID;
import com.sap.cms.client.types.RequestID;
import com.sap.cms.client.types.SystemId;
import com.sap.cms.client.types.VersionID;
import com.sap.cms.client.types.config.CMSSystem;
import com.sap.cms.client.types.config.CMSSystemID;
import com.sap.cms.client.types.config.CMSSystemObject;
import com.sap.cms.client.types.config.CMSSystemRole;
import com.sap.cms.client.types.transport.Component;
import com.sap.cms.util.exception.CMSApplicationException;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.exception.PropMgr.CmsPropagationInvalidConfException;
import com.sap.cms.util.exception.PropMgr.CmsPropagationQueueItemExistsException;
import com.sap.cms.util.exception.client.CMSClientChangeRequestNotFoundException;
import com.sap.cms.util.exception.client.CMSClientChangelistNotAssignedException;
import com.sap.cms.util.exception.client.CMSClientChangelistsReorganizedException;
import com.sap.cms.util.exception.client.CMSClientDomainNotFoundException;
import com.sap.cms.util.exception.client.CMSClientSystemNotFoundException;
import com.sap.cms.util.exception.client.CMSClientTrackNotFoundException;
import com.sap.cms.util.exception.client.CMSClientVersionConflictException;
import com.sap.cms.util.exception.client.CMSClientWorkspaceNotFoundException;
import com.sap.cms.util.exception.client.CMSClientWrapperException;
import com.sap.cms.util.exception.conf.CMSCFinderException;
import com.sap.cms.util.exception.misc.CMSPermissionDeniedException;
import com.sap.cms.util.exception.misc.PCSTransactionException;
import com.sap.cms.util.exception.organizer.CMSOChangeListsReorganizedException;
import com.sap.cms.util.exception.organizer.CMSOExportFailedException;
import com.sap.cms.util.exception.organizer.CMSOFileAccessException;
import com.sap.cms.util.exception.organizer.CMSOInvalidParameterException;
import com.sap.cms.util.exception.request.CmsChangelistUpdateException;
import com.sap.cms.util.exception.request.CmsRequestNotFoundException;
import com.sap.cms.util.exception.request.CmsRequestUpdateException;
import com.sap.cms.util.logging.CmsLogger;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.URL;
import java.rmi.RemoteException;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Vector;
import javax.ejb.CreateException;

public class ReleaseAPIConnector
implements ReleaseAPI {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$client$release$impl$ReleaseAPIConnector == null ? (class$com$sap$cms$client$release$impl$ReleaseAPIConnector = ReleaseAPIConnector.class$("com.sap.cms.client.release.impl.ReleaseAPIConnector")) : class$com$sap$cms$client$release$impl$ReleaseAPIConnector).getName());
    private final CMSTransportOrganizerIF transportOrganizerAPI;
    private final CMSConfigurationManagerIF configurationManagerAPI;
    private final String user;
    static /* synthetic */ Class class$com$sap$cms$client$release$impl$ReleaseAPIConnector;

    public ReleaseAPIConnector(URL hostURL, String ticket, String user, String password, KeyStore truststore) throws CMSConnectorException {
        log.entering("ReleaseAPIConnector", new Object[]{hostURL, ticket, user, "***", truststore});
        try {
            try {
                this.user = user;
                this.transportOrganizerAPI = new CMSTransportOrganizerAPI(hostURL.toString(), ticket, user, password, truststore);
                this.configurationManagerAPI = new CMSConfigurationManagerAPI(hostURL.toString(), ticket, user, password, truststore);
            }
            catch (CMSConnectorException ex) {
                log.error("Error during creation of ReleaseAPI: " + (Object)((Object)ex));
                throw ex;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            log.exiting("ReleaseAPIConnector");
            throw throwable;
        }
        log.exiting("ReleaseAPIConnector");
    }

    public ReleaseAPIConnector(IConnectionTemplate connectionTemplate) throws CMSConnectorException {
        log.entering("ReleaseAPIConnector", new Object[]{connectionTemplate});
        try {
            if (connectionTemplate.getSessionContext() == null) {
                throw new CMSConnectorException("Connection template has no session context");
            }
            this.user = connectionTemplate.getSessionContext().getUser();
            this.transportOrganizerAPI = new CMSTransportOrganizerAPI(connectionTemplate);
            this.configurationManagerAPI = new CMSConfigurationManagerAPI(connectionTemplate);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            log.exiting("ReleaseAPIConnector");
            throw throwable;
        }
        log.exiting("ReleaseAPIConnector");
    }

    public ReleaseAPIConnector(ICMSConnectionIdentifier connectionIdentifier) throws CMSConnectorException {
        log.entering("ReleaseAPIConnector", new Object[]{connectionIdentifier});
        try {
            if (connectionIdentifier == null) {
                throw new CMSConnectorException("Connection identifier is null");
            }
            if (connectionIdentifier.getConnectionPrincipal() == null) {
                throw new CMSConnectorException("Connection identifier has no principal");
            }
            this.user = connectionIdentifier.getConnectionPrincipal().getUser();
            this.transportOrganizerAPI = new CMSTransportOrganizerAPI(connectionIdentifier);
            this.configurationManagerAPI = new CMSConfigurationManagerAPI(connectionIdentifier);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            log.exiting("ReleaseAPIConnector");
            throw throwable;
        }
        log.exiting("ReleaseAPIConnector");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestID releaseNewChangeRequest(String caption, String workspaceID, Component component, CMSChangeList[] activities) throws CMSApplicationException, CMSPermissionDeniedException, CMSClientVersionConflictException, CMSUnexpectedException {
        log.entering("releaseNewChangeRequest", new Object[]{caption, workspaceID, component, activities});
        RequestID returnValue = null;
        try {
            try {
                if (activities == null) {
                    throw new CMSUnexpectedException("Activities are null");
                }
                ComponentID compID = null;
                if (component != null) {
                    compID = new ComponentID(component.getVendor(), component.getName());
                }
                Vector<CMSChangeList> v = new Vector<CMSChangeList>();
                int i = 0;
                while (true) {
                    if (i >= activities.length) {
                        returnValue = this.transportOrganizerAPI.releaseChangelists002(this.user, caption, v, workspaceID, compID);
                        break;
                    }
                    v.add(activities[i]);
                    ++i;
                }
            }
            catch (CMSApplicationException e) {
                log.error("CMSApplicationException during release (" + ((Object)((Object)e)).getClass().getName() + ")", (Throwable)e);
                throw e;
            }
            catch (CreateException e) {
                Object var11_13 = null;
                log.exiting("releaseNewChangeRequest", returnValue);
                return returnValue;
            }
            catch (RemoteException e) {
                Object var11_14 = null;
                log.exiting("releaseNewChangeRequest", returnValue);
                return returnValue;
            }
            catch (CMSUnexpectedException e) {
                log.error("Unexpected exception during release (" + ((Object)((Object)e)).getClass().getName() + ")", (Throwable)e);
                throw e;
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            log.exiting("releaseNewChangeRequest", returnValue);
            throw throwable;
        }
        log.exiting("releaseNewChangeRequest", (Object)returnValue);
        return returnValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestID restartExport(String workspaceID, CMSChangeList[] changelists) throws CMSClientWorkspaceNotFoundException, CMSClientChangelistNotAssignedException, CMSClientChangelistsReorganizedException, CMSPermissionDeniedException, CMSClientVersionConflictException, CMSUnexpectedException {
        log.entering("restartExport", new Object[]{workspaceID, changelists});
        RequestID returnValue = null;
        try {
            try {
                if (workspaceID == null) {
                    log.error("WorkspaceID is null");
                    throw new NullPointerException("WorkspaceID is null");
                }
                if (changelists == null || changelists.length == 0) {
                    log.error("Changelists are null or empty");
                    throw new NullPointerException("Changelists are null or empty");
                }
                Vector<CMSChangeList> list = new Vector<CMSChangeList>(changelists.length);
                int i = 0;
                while (true) {
                    if (i >= changelists.length) {
                        returnValue = this.transportOrganizerAPI.restartExportByChangelists(list, workspaceID, null);
                        break;
                    }
                    if (changelists[i] == null) {
                        log.error("Changelist " + i + " is null");
                        throw new NullPointerException("Changelist " + i + " is null");
                    }
                    if (changelists[i].getName() == null || changelists[i].getName().length() == 0) {
                        log.error("Name of changelist " + i + " is null or empty");
                        throw new NullPointerException("Name of changelist " + i + " is null or empty");
                    }
                    list.add(changelists[i]);
                    ++i;
                }
            }
            catch (CmsPropagationQueueItemExistsException e) {
                log.error((Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CmsPropagationInvalidConfException e) {
                log.error((Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSOFileAccessException e) {
                log.error((Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSOExportFailedException e) {
                log.error((Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSOChangeListsReorganizedException e) {
                log.error((Throwable)e);
                throw new CMSClientChangelistsReorganizedException((Throwable)e);
            }
            catch (CMSConnectorException e) {
                log.error((Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (PCSTransactionException e) {
                log.error((Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CmsRequestNotFoundException e) {
                log.error((Throwable)e);
                throw new CMSClientChangelistNotAssignedException((Throwable)e);
            }
            catch (CmsRequestUpdateException e) {
                log.error((Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CmsChangelistUpdateException e) {
                log.error((Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSOInvalidParameterException e) {
                log.error((Throwable)e);
                throw new CMSClientWorkspaceNotFoundException((Throwable)e, workspaceID);
            }
            catch (CMSPermissionDeniedException e) {
                log.error((Throwable)e);
                throw e;
            }
            catch (CMSClientVersionConflictException e) {
                log.error((Throwable)e);
                throw e;
            }
            catch (CMSClientWrapperException e) {
                log.error("Client wrapper exception (" + e.getNestedException() + ")", (Throwable)e);
                if ("com.sap.cms.util.exception.conf.CMSCInvalidInputParameter".equals(e.getNestedException())) {
                    throw new CMSClientWorkspaceNotFoundException(workspaceID);
                }
                if ("com.sap.cms.util.exception.request.CmsRequestNotFoundException".equals(e.getNestedException())) {
                    throw new CMSClientChangelistNotAssignedException((Throwable)e);
                }
                if (!"com.sap.cms.util.exception.organizer.CMSOChangeListsReorganizedException".equals(e.getNestedException())) throw new CMSUnexpectedException((Throwable)e);
                throw new CMSClientChangelistsReorganizedException((Throwable)e);
            }
            catch (CreateException e) {
                Object var21_9 = null;
                log.exiting("restartExport", returnValue);
                return returnValue;
            }
            catch (RemoteException e) {
                Object var21_10 = null;
                log.exiting("restartExport", returnValue);
                return returnValue;
            }
            Object var21_8 = null;
        }
        catch (Throwable throwable) {
            Object var21_11 = null;
            log.exiting("restartExport", returnValue);
            throw throwable;
        }
        log.exiting("restartExport", (Object)returnValue);
        return returnValue;
    }

    public RequestID getRequestIDForWorkspace(String workspaceID) throws CMSPermissionDeniedException, CMSClientVersionConflictException {
        log.entering("getRequestIDForWorkspace", new Object[]{workspaceID});
        RequestID returnValue = null;
        try {
            try {
                if (workspaceID == null) {
                    throw new CMSUnexpectedException("Workspace ID is null");
                }
                returnValue = this.transportOrganizerAPI.getRequestMaskForWorkspace(workspaceID);
            }
            catch (CMSUnexpectedException e) {
                log.error("Unexpected exception during read of request ID (" + ((Object)((Object)e)).getClass().getName() + ")", (Throwable)e);
                throw e;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            log.exiting("getRequestIDForWorkspace", (Object)returnValue);
            throw throwable;
        }
        log.exiting("getRequestIDForWorkspace", (Object)returnValue);
        return returnValue;
    }

    public CMSChangeList[] getChangeListsOfChangeRequest(ComponentID component, VersionID version) throws CMSClientChangeRequestNotFoundException, CMSPermissionDeniedException, CMSClientVersionConflictException {
        log.entering("getChangeListsOfChangeRequest", new Object[]{component, version});
        CMSChangeList[] returnValues = null;
        try {
            block6: {
                try {
                    if (component == null || version == null) {
                        throw new CMSClientChangeRequestNotFoundException(new Object[]{component + ", " + version});
                    }
                    Collection c = this.transportOrganizerAPI.getChangeListsOfChangeRequest(component, version);
                    if (c == null) break block6;
                    returnValues = c.toArray(new CMSChangeList[c.size()]);
                }
                catch (CmsRequestNotFoundException e) {
                    log.error("Change request not found", (Throwable)e);
                    throw new CMSClientChangeRequestNotFoundException((Throwable)e, new Object[]{component + ", " + version});
                }
                catch (CMSUnexpectedException e) {
                    log.error("Unexpected exception during read of change lists (" + ((Object)((Object)e)).getClass().getName() + ")", (Throwable)e);
                    throw e;
                }
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            log.exiting("getChangeListsOfChangeRequest", returnValues);
            throw throwable;
        }
        log.exiting("getChangeListsOfChangeRequest", (Object)returnValues);
        return returnValues;
    }

    public CMSChangeRequest[] getFinishedChangeRequests(RequestID requestID, String owner, long minimumCreationDate) throws CMSPermissionDeniedException, CMSClientVersionConflictException {
        log.entering("getFinishedChangeRequests", new Object[]{requestID, owner, new Long(minimumCreationDate)});
        CMSChangeRequest[] returnValues = null;
        try {
            block5: {
                try {
                    if (requestID == null) {
                        throw new CMSUnexpectedException("Request id is null");
                    }
                    Collection c = this.transportOrganizerAPI.getFinishedChangeRequests(requestID, owner, minimumCreationDate);
                    if (c == null) break block5;
                    returnValues = c.toArray(new CMSChangeRequest[c.size()]);
                }
                catch (CMSUnexpectedException e) {
                    log.error("Unexpected exception during read of finished change requests (" + ((Object)((Object)e)).getClass().getName() + ")", (Throwable)e);
                    throw e;
                }
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            log.exiting("getFinishedChangeRequests", returnValues);
            throw throwable;
        }
        log.exiting("getFinishedChangeRequests", (Object)returnValues);
        return returnValues;
    }

    public CMSChangeRequest[] getFinishedChangeRequests(CMSSystem system, String owner, long minimumCreationDate) throws CMSClientDomainNotFoundException, CMSClientTrackNotFoundException, CMSClientSystemNotFoundException, CMSPermissionDeniedException, CMSClientVersionConflictException {
        log.entering("getFinishedChangeRequests", new Object[]{system, owner, new Long(minimumCreationDate)});
        CMSChangeRequest[] returnValues = null;
        try {
            block4: {
                try {
                    CMSSystemObject systemObject = this.cMSSystem2CMSSystemObject(system);
                    Collection c = this.transportOrganizerAPI.getFinishedChangeRequests(systemObject, owner, minimumCreationDate);
                    if (c == null) break block4;
                    returnValues = c.toArray(new CMSChangeRequest[c.size()]);
                }
                catch (CMSUnexpectedException e) {
                    log.error("Unexpected exception during read of finished change requests (" + ((Object)((Object)e)).getClass().getName() + ")", (Throwable)e);
                    throw e;
                }
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            log.exiting("getFinishedChangeRequests", returnValues);
            throw throwable;
        }
        log.exiting("getFinishedChangeRequests", (Object)returnValues);
        return returnValues;
    }

    public CMSChangeRequest[] getFinishedChangeRequests(CMSSystem system, ComponentID component, String owner, long minimumCreationDate) throws CMSClientDomainNotFoundException, CMSClientTrackNotFoundException, CMSClientSystemNotFoundException, CMSPermissionDeniedException, CMSClientVersionConflictException {
        log.entering("getFinishedChangeRequests", new Object[]{system, component, owner, new Long(minimumCreationDate)});
        CMSChangeRequest[] returnValues = null;
        try {
            block5: {
                try {
                    CMSSystemObject systemObject = this.cMSSystem2CMSSystemObject(system);
                    if (component == null) {
                        throw new NullPointerException("Component is null");
                    }
                    Collection c = this.transportOrganizerAPI.getFinishedChangeRequests(systemObject, component, owner, minimumCreationDate);
                    if (c == null) break block5;
                    returnValues = c.toArray(new CMSChangeRequest[c.size()]);
                }
                catch (CMSUnexpectedException e) {
                    log.error("Unexpected exception during read of finished change requests (" + ((Object)((Object)e)).getClass().getName() + ")", (Throwable)e);
                    throw e;
                }
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            log.exiting("getFinishedChangeRequests", returnValues);
            throw throwable;
        }
        log.exiting("getFinishedChangeRequests", (Object)returnValues);
        return returnValues;
    }

    public CMSChangeRequest[] getUnfinishedChangeRequests(RequestID requestID, String owner) throws CMSPermissionDeniedException, CMSClientVersionConflictException {
        log.entering("getUnfinishedChangeRequests", new Object[]{requestID, owner});
        CMSChangeRequest[] returnValues = null;
        try {
            block5: {
                try {
                    if (requestID == null) {
                        throw new CMSUnexpectedException("Request id is null");
                    }
                    Collection c = this.transportOrganizerAPI.getUnfinishedChangeRequests(requestID, owner);
                    if (c == null) break block5;
                    returnValues = c.toArray(new CMSChangeRequest[c.size()]);
                }
                catch (CMSUnexpectedException e) {
                    log.error("Unexpected exception during read of unfinished change requests (" + ((Object)((Object)e)).getClass().getName() + ")", (Throwable)e);
                    throw e;
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            log.exiting("getUnfinishedChangeRequests", returnValues);
            throw throwable;
        }
        log.exiting("getUnfinishedChangeRequests", (Object)returnValues);
        return returnValues;
    }

    public CMSChangeRequest[] getUnfinishedChangeRequests(CMSSystem system, String owner) throws CMSClientDomainNotFoundException, CMSClientTrackNotFoundException, CMSClientSystemNotFoundException, CMSPermissionDeniedException, CMSClientVersionConflictException {
        log.entering("getUnfinishedChangeRequests", new Object[]{system, owner});
        CMSChangeRequest[] returnValues = null;
        try {
            block4: {
                try {
                    CMSSystemObject systemObject = this.cMSSystem2CMSSystemObject(system);
                    Collection c = this.transportOrganizerAPI.getUnfinishedChangeRequests(systemObject, owner);
                    if (c == null) break block4;
                    returnValues = c.toArray(new CMSChangeRequest[c.size()]);
                }
                catch (CMSUnexpectedException e) {
                    log.error("Unexpected exception during read of unfinished change requests (" + ((Object)((Object)e)).getClass().getName() + ")", (Throwable)e);
                    throw e;
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            log.exiting("getUnfinishedChangeRequests", returnValues);
            throw throwable;
        }
        log.exiting("getUnfinishedChangeRequests", (Object)returnValues);
        return returnValues;
    }

    public CMSChangeRequest[] getUnfinishedChangeRequests(CMSSystem system, ComponentID component, String owner) throws CMSClientDomainNotFoundException, CMSClientTrackNotFoundException, CMSClientSystemNotFoundException, CMSPermissionDeniedException, CMSClientVersionConflictException {
        log.entering("getUnfinishedChangeRequests", new Object[]{system, component, owner});
        CMSChangeRequest[] returnValues = null;
        try {
            block4: {
                try {
                    CMSSystemObject systemObject = this.cMSSystem2CMSSystemObject(system);
                    Collection c = this.transportOrganizerAPI.getUnfinishedChangeRequests(systemObject, component, owner);
                    if (c == null) break block4;
                    returnValues = c.toArray(new CMSChangeRequest[c.size()]);
                }
                catch (CMSUnexpectedException e) {
                    log.error("Unexpected exception during read of unfinished change requests (" + ((Object)((Object)e)).getClass().getName() + ")", (Throwable)e);
                    throw e;
                }
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            log.exiting("getUnfinishedChangeRequests", returnValues);
            throw throwable;
        }
        log.exiting("getUnfinishedChangeRequests", (Object)returnValues);
        return returnValues;
    }

    public CMSChangeRequest getChangeRequest(ComponentID component, VersionID version) throws CMSClientChangeRequestNotFoundException, CMSPermissionDeniedException, CMSClientVersionConflictException {
        log.entering("getChangeRequest", new Object[]{component, version});
        CMSChangeRequest returnValue = null;
        try {
            try {
                if (component == null || version == null) {
                    throw new CMSClientChangeRequestNotFoundException(new Object[]{component + ", " + version});
                }
                if (version.getLocation() == null) {
                    throw new CMSClientChangeRequestNotFoundException(new Object[]{component + ", " + version});
                }
                returnValue = this.transportOrganizerAPI.getChangeRequest(component, version);
            }
            catch (CmsRequestNotFoundException e) {
                log.error("Change request not found", (Throwable)e);
                throw new CMSClientChangeRequestNotFoundException((Throwable)e, new Object[]{component + ", " + version});
            }
            catch (CMSUnexpectedException e) {
                log.error("Unexpected exception during read of change request (" + ((Object)((Object)e)).getClass().getName() + ")", (Throwable)e);
                throw e;
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            log.exiting("getChangeRequest", returnValue);
            throw throwable;
        }
        log.exiting("getChangeRequest", (Object)returnValue);
        return returnValue;
    }

    public boolean isForeignReleaseAllowed(String workspaceID) throws CMSClientWorkspaceNotFoundException, CMSPermissionDeniedException, CMSClientVersionConflictException {
        log.entering("isForeignReleaseAllowed", new Object[]{workspaceID});
        boolean isAllowed = false;
        try {
            try {
                CMSComponentLocation location = this.transportOrganizerAPI.getComponentLocation(workspaceID);
                SystemId system = new SystemId(location.getSysName(), location.getDomain());
                CmsUserPermissions userPermissions = this.configurationManagerAPI.getUserPermissions(system);
                isAllowed = userPermissions.isExportForeign();
            }
            catch (CMSCFinderException e) {
                log.error("Workspace not found", (Throwable)e);
                throw new CMSClientWorkspaceNotFoundException(workspaceID);
            }
            catch (CMSUnexpectedException e) {
                log.error("Unexpected exception during isForeignReleaseAllowed (" + ((Object)((Object)e)).getClass().getName() + ")", (Throwable)e);
                throw e;
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            log.exiting("isForeignReleaseAllowed", (Object)new Boolean(isAllowed));
            throw throwable;
        }
        log.exiting("isForeignReleaseAllowed", (Object)new Boolean(isAllowed));
        return isAllowed;
    }

    protected CMSSystemObject cMSSystem2CMSSystemObject(CMSSystem system) throws CMSClientSystemNotFoundException, CMSClientTrackNotFoundException, CMSClientDomainNotFoundException {
        if (system == null) {
            throw new NullPointerException("System is null");
        }
        CMSSystemObject sysObj = new CMSSystemObject();
        String domainID = system.getDomainID();
        if (domainID == null) {
            throw new CMSClientDomainNotFoundException(null);
        }
        sysObj.setDomname(domainID);
        String trackID = system.getTrackID();
        if (trackID == null) {
            throw new CMSClientTrackNotFoundException(domainID, null, null);
        }
        sysObj.setTrackName(trackID);
        CMSSystemRole role = system.getSystemRole();
        if (role == null) {
            throw new CMSClientSystemNotFoundException(domainID, trackID, null);
        }
        sysObj.setRole(role.getName());
        sysObj.setName(CMSSystemID.getCMSSystemID(trackID, role.getName()));
        return sysObj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

