/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.organizerAPI;

import com.sap.cms.client.connection.ICMSConnectionIdentifier;
import com.sap.cms.client.connector.CMSConnector;
import com.sap.cms.client.connector.CMSConnectorException;
import com.sap.cms.client.connector.CMSParserException;
import com.sap.cms.client.organizerAPI.CMSTransportOrganizerIF;
import com.sap.cms.client.types.CMSChangeRequest;
import com.sap.cms.client.types.CMSComponentLocation;
import com.sap.cms.client.types.ComponentID;
import com.sap.cms.client.types.RequestID;
import com.sap.cms.client.types.VersionID;
import com.sap.cms.client.types.config.CMSSystemObject;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.exception.PropMgr.CmsPropagationInvalidConfException;
import com.sap.cms.util.exception.PropMgr.CmsPropagationQueueItemExistsException;
import com.sap.cms.util.exception.client.CMSClientDTCDeletedException;
import com.sap.cms.util.exception.client.CMSClientDTCInvalidVersionException;
import com.sap.cms.util.exception.client.CMSClientDTCNotFoundException;
import com.sap.cms.util.exception.client.CMSClientVersionConflictException;
import com.sap.cms.util.exception.client.CMSClientWrapperException;
import com.sap.cms.util.exception.conf.CMSCDTCDeletedException;
import com.sap.cms.util.exception.conf.CMSCDTCInvalidVersionException;
import com.sap.cms.util.exception.conf.CMSCDTCNotFoundException;
import com.sap.cms.util.exception.conf.CMSCFinderException;
import com.sap.cms.util.exception.conf.CMSCNoConfigurationException;
import com.sap.cms.util.exception.conf.CMSConfigurationException;
import com.sap.cms.util.exception.misc.CMSPermissionDeniedException;
import com.sap.cms.util.exception.misc.PCSTransactionException;
import com.sap.cms.util.exception.organizer.CMSOChangeListsReorganizedException;
import com.sap.cms.util.exception.organizer.CMSOExportFailedException;
import com.sap.cms.util.exception.organizer.CMSOFileAccessException;
import com.sap.cms.util.exception.organizer.CMSOGetRequestCounterException;
import com.sap.cms.util.exception.organizer.CMSOGetResultException;
import com.sap.cms.util.exception.organizer.CMSOInvalidParameterException;
import com.sap.cms.util.exception.organizer.CMSOrganizerException;
import com.sap.cms.util.exception.request.CmsChangelistCreateException;
import com.sap.cms.util.exception.request.CmsChangelistUpdateException;
import com.sap.cms.util.exception.request.CmsRequestCreateException;
import com.sap.cms.util.exception.request.CmsRequestNotFoundException;
import com.sap.cms.util.exception.request.CmsRequestUpdateException;
import com.sap.cms.util.logging.CmsLogger;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Vector;

public class CMSTransportOrganizerAPI
implements CMSTransportOrganizerIF {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$client$organizerAPI$CMSTransportOrganizerAPI == null ? (class$com$sap$cms$client$organizerAPI$CMSTransportOrganizerAPI = CMSTransportOrganizerAPI.class$("com.sap.cms.client.organizerAPI.CMSTransportOrganizerAPI")) : class$com$sap$cms$client$organizerAPI$CMSTransportOrganizerAPI).getName());
    private static String service = "organizer";
    private CMSConnector connector;
    private String versionRelease = "0.00";
    private String versionSP = "00";
    private String versionPatch = "00";
    private boolean versionInitialized = false;
    static /* synthetic */ Class class$com$sap$cms$client$organizerAPI$CMSTransportOrganizerAPI;

    public CMSTransportOrganizerAPI(URL cmsServer) throws CMSConnectorException {
        this(cmsServer.toString());
    }

    public CMSTransportOrganizerAPI(String cmsServer) throws CMSConnectorException {
        try {
            URL url = new URL(cmsServer);
            log.info("You use an old version of the NetWeaver Developer Studio which does not support CMS user authentication. You will be authenticated as user guest. Please update your NetWeaver Developer Studio or make sure the guest user has sufficient access rights on CMS.");
            if ("https".equalsIgnoreCase(url.getProtocol())) {
                throw new CMSUnexpectedException("Your installation of NetWeaver Developer Studio does not support HTTPS. Please update your Developer Studio.");
            }
            this.connector = new CMSConnector(cmsServer, service, null, null, null);
        }
        catch (MalformedURLException ex) {
            throw new CMSConnectorException("CMSConnectorException_MalformedCMSURL", new Object[]{cmsServer}, ex);
        }
    }

    public CMSTransportOrganizerAPI(String cmsServer, String user, String password, KeyStore truststore) throws CMSConnectorException {
        this.connector = new CMSConnector(cmsServer, service, user, password, truststore);
    }

    public CMSTransportOrganizerAPI(String cmsServer, String ticket, String user, String password, KeyStore truststore) throws CMSConnectorException {
        this.connector = new CMSConnector(cmsServer, service, ticket, user, password, truststore);
    }

    public CMSTransportOrganizerAPI(IConnectionTemplate connectionTemplate) throws CMSConnectorException {
        this.connector = new CMSConnector(service, connectionTemplate);
    }

    public CMSTransportOrganizerAPI(ICMSConnectionIdentifier connectionIdentifier) throws CMSConnectorException {
        this.connector = new CMSConnector(service, connectionIdentifier);
    }

    public void startRecording(String logFile) throws CMSConnectorException {
        this.connector.startLogToFile(logFile);
    }

    public int stopRecording() {
        return this.connector.endLogToFile();
    }

    public void replay(String logFile, int lastNo) throws CMSConnectorException {
        this.connector.replayFromFile(logFile, 0, lastNo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestID releaseChangelists(String owner, String caption, Vector changelist, String workspaceId, ComponentID devComp) throws CMSConnectorException, CMSOrganizerException {
        RequestID requestID;
        log.entering("releaseChangelists");
        this.connector.encodeObject(owner, "owner");
        this.connector.encodeObject(caption, "caption");
        this.connector.encodeObject(changelist, "changelist");
        this.connector.encodeObject(workspaceId, "workspaceId");
        this.connector.encodeObject(devComp, "devComp");
        try {
            try {
                this.connector.callMethod("releaseChangelists");
                requestID = (RequestID)this.connector.getObject("requestID");
                Object var11_8 = null;
            }
            catch (CMSConnectorException e) {
                throw e;
            }
            catch (CMSOrganizerException e) {
                throw e;
            }
            catch (CMSPermissionDeniedException e) {
                throw new CMSOrganizerException(e.getMessage());
            }
            catch (Exception e) {
                log.error("unknown exception", (Throwable)e);
                throw new CMSConnectorException("unknown exception: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            log.exiting("releaseChangelists");
            throw throwable;
        }
        log.exiting("releaseChangelists");
        return requestID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestID releaseChangelists002(String owner, String caption, Vector changelist, String workspaceId, ComponentID devComp) throws CMSConnectorException, CMSPermissionDeniedException, PCSTransactionException, CmsRequestCreateException, CmsRequestUpdateException, CmsChangelistCreateException, CmsChangelistUpdateException, CMSOFileAccessException, CMSOExportFailedException, CMSClientVersionConflictException {
        RequestID requestID;
        log.entering("releaseChangelists002");
        try {
            try {
                this.versionCheck("releaseChangelists002", "0.00", "00", "00");
                this.connector.encodeObject(owner, "owner");
                this.connector.encodeObject(caption, "caption");
                this.connector.encodeObject(changelist, "changelist");
                this.connector.encodeObject(workspaceId, "workspaceId");
                this.connector.encodeObject(devComp, "devComp");
                this.connector.callMethod("releaseChangelists002");
                requestID = (RequestID)this.connector.getObject("requestID");
                Object var18_8 = null;
            }
            catch (CMSConnectorException e) {
                throw e;
            }
            catch (CMSPermissionDeniedException e) {
                throw e;
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (PCSTransactionException e) {
                throw e;
            }
            catch (CmsRequestCreateException e) {
                throw e;
            }
            catch (CmsRequestUpdateException e) {
                throw e;
            }
            catch (CmsChangelistCreateException e) {
                throw e;
            }
            catch (CmsChangelistUpdateException e) {
                throw e;
            }
            catch (CMSOFileAccessException e) {
                throw e;
            }
            catch (CMSOExportFailedException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("unknown exception", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var18_9 = null;
            log.exiting("releaseChangelists002");
            throw throwable;
        }
        log.exiting("releaseChangelists002");
        return requestID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestID releaseTranslationChangelists(String owner, String caption, Vector changelist, String workspaceId, ComponentID devComp) throws CMSConnectorException, CMSOrganizerException {
        RequestID requestID;
        log.entering("releaseTranslationChangelists");
        this.connector.encodeObject(owner, "owner");
        this.connector.encodeObject(caption, "caption");
        this.connector.encodeObject(changelist, "changelist");
        this.connector.encodeObject(workspaceId, "workspaceId");
        this.connector.encodeObject(devComp, "devComp");
        try {
            try {
                this.connector.callMethod("releaseTranslationChangelists");
                requestID = (RequestID)this.connector.getObject("requestID");
                Object var11_8 = null;
            }
            catch (CMSConnectorException e) {
                throw e;
            }
            catch (CMSOrganizerException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("unknown exception", (Throwable)e);
                throw new CMSConnectorException("unknown exception: " + e.getMessage());
            }
            catch (Throwable e) {
                log.error("unknown Throwable", e);
                throw new CMSConnectorException("unknown Throwable: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            log.exiting("releaseTranslationChangelists");
            throw throwable;
        }
        log.exiting("releaseTranslationChangelists");
        return requestID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestID releaseTranslationChangelists002(String owner, String caption, Vector changelist, String workspaceId, ComponentID devComp) throws CMSConnectorException, CMSPermissionDeniedException, PCSTransactionException, CMSPermissionDeniedException, CmsRequestCreateException, CmsRequestUpdateException, CmsChangelistCreateException, CmsChangelistUpdateException, CMSOFileAccessException, CMSOExportFailedException, CMSClientVersionConflictException {
        RequestID requestID;
        log.entering("releaseTranslationChangelists002");
        try {
            try {
                this.versionCheck("releaseTranslationChangelists002", "0.00", "00", "00");
                this.connector.encodeObject(owner, "owner");
                this.connector.encodeObject(caption, "caption");
                this.connector.encodeObject(changelist, "changelist");
                this.connector.encodeObject(workspaceId, "workspaceId");
                this.connector.encodeObject(devComp, "devComp");
                this.connector.callMethod("releaseTranslationChangelists002");
                requestID = (RequestID)this.connector.getObject("requestID");
                Object var18_8 = null;
            }
            catch (CMSConnectorException e) {
                throw e;
            }
            catch (CMSPermissionDeniedException e) {
                throw e;
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (PCSTransactionException e) {
                throw e;
            }
            catch (CmsRequestCreateException e) {
                throw e;
            }
            catch (CmsRequestUpdateException e) {
                throw e;
            }
            catch (CmsChangelistUpdateException e) {
                throw e;
            }
            catch (CmsChangelistCreateException e) {
                throw e;
            }
            catch (CMSOFileAccessException e) {
                throw e;
            }
            catch (CMSOExportFailedException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("unknown exception", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var18_9 = null;
            log.exiting("releaseTranslationChangelists002");
            throw throwable;
        }
        log.exiting("releaseTranslationChangelists002");
        return requestID;
    }

    public void restartExport(String request, String workspaceId, ComponentID devComp) throws CMSConnectorException, CMSOrganizerException {
        log.entering("restartExport");
        this.connector.encodeObject(request, "request");
        this.connector.encodeObject(workspaceId, "workspaceId");
        this.connector.encodeObject(devComp, "devComp");
        try {
            try {
                this.connector.callMethod("restartExport");
            }
            catch (CMSConnectorException e) {
                throw e;
            }
            catch (CMSOrganizerException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("unknown exception", (Throwable)e);
                throw new CMSConnectorException("unknown exception: " + e.getMessage());
            }
            catch (Throwable e) {
                log.error("unknown Throwable", e);
                throw new CMSConnectorException("unknown Throwable: " + e.getMessage());
            }
            Object var9_4 = null;
        }
        catch (Throwable throwable) {
            Object var9_5 = null;
            log.exiting("restartExport");
            throw throwable;
        }
        log.exiting("restartExport");
    }

    public void restartExport002(String request, String workspaceId, ComponentID devComp) throws CMSConnectorException, CMSPermissionDeniedException, PCSTransactionException, CmsPropagationQueueItemExistsException, CmsPropagationInvalidConfException, CMSOFileAccessException, CMSOInvalidParameterException, CmsRequestNotFoundException, CmsRequestUpdateException, CmsChangelistUpdateException, CMSOExportFailedException, CMSClientVersionConflictException {
        log.entering("restartExport002");
        try {
            try {
                this.versionCheck("restartExport002", "0.00", "00", "00");
                this.connector.encodeObject(request, "request");
                this.connector.encodeObject(workspaceId, "workspaceId");
                this.connector.encodeObject(devComp, "devComp");
                this.connector.callMethod("restartExport002");
            }
            catch (CMSConnectorException e) {
                throw e;
            }
            catch (CMSPermissionDeniedException e) {
                throw e;
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (PCSTransactionException e) {
                throw e;
            }
            catch (CmsPropagationQueueItemExistsException e) {
                throw e;
            }
            catch (CmsPropagationInvalidConfException e) {
                throw e;
            }
            catch (CMSOFileAccessException e) {
                throw e;
            }
            catch (CMSOInvalidParameterException e) {
                throw e;
            }
            catch (CmsRequestNotFoundException e) {
                throw e;
            }
            catch (CmsRequestUpdateException e) {
                throw e;
            }
            catch (CmsChangelistUpdateException e) {
                throw e;
            }
            catch (CMSOExportFailedException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("unknown exception", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            Object var18_4 = null;
        }
        catch (Throwable throwable) {
            Object var18_5 = null;
            log.exiting("restartExport002");
            throw throwable;
        }
        log.exiting("restartExport002");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestID restartExportByChangelists(Collection changeList, String workspaceId, ComponentID devComp) throws CMSConnectorException, CMSPermissionDeniedException, PCSTransactionException, CmsPropagationQueueItemExistsException, CmsPropagationInvalidConfException, CMSOFileAccessException, CMSOInvalidParameterException, CmsRequestNotFoundException, CmsRequestUpdateException, CmsChangelistUpdateException, CMSOExportFailedException, CMSClientVersionConflictException, CMSOChangeListsReorganizedException {
        RequestID requestID;
        log.entering("restartExportByChangelists");
        try {
            try {
                this.versionCheck("restartExportByChangelists", "6.40", "11", "00");
                this.connector.encodeObject(changeList, "changeLists");
                this.connector.encodeObject(workspaceId, "workspaceId");
                this.connector.encodeObject(devComp, "devComp");
                this.connector.callMethod("restartExportByChangelists");
                requestID = (RequestID)this.connector.getObject("requestID");
                Object var20_6 = null;
            }
            catch (CMSConnectorException e) {
                throw e;
            }
            catch (CMSPermissionDeniedException e) {
                throw e;
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (PCSTransactionException e) {
                throw e;
            }
            catch (CmsPropagationQueueItemExistsException e) {
                throw e;
            }
            catch (CmsPropagationInvalidConfException e) {
                throw e;
            }
            catch (CMSOFileAccessException e) {
                throw e;
            }
            catch (CMSOInvalidParameterException e) {
                throw e;
            }
            catch (CmsRequestNotFoundException e) {
                throw e;
            }
            catch (CmsRequestUpdateException e) {
                throw e;
            }
            catch (CmsChangelistUpdateException e) {
                throw e;
            }
            catch (CMSOExportFailedException e) {
                throw e;
            }
            catch (CMSOChangeListsReorganizedException e) {
                throw e;
            }
            catch (CMSClientWrapperException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("unknown exception", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var20_7 = null;
            log.exiting("restartExportByChangelists");
            throw throwable;
        }
        log.exiting("restartExportByChangelists");
        return requestID;
    }

    public String getExportLog(String request, String workspaceId, ComponentID devComp) throws CMSConnectorException, CMSOrganizerException {
        log.entering("getExportLog");
        this.connector.encodeObject(request, "request");
        this.connector.encodeObject(workspaceId, "workspaceId");
        this.connector.encodeObject(devComp, "devComp");
        try {
            this.connector.callMethod("getExportLog");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSOrganizerException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown Throwable", e);
            throw new CMSConnectorException("unknown Throwable: " + e.getMessage());
        }
        String logFile = (String)this.connector.getObject("logFile");
        log.debug("export log file: " + logFile);
        log.exiting("getExportLog");
        return logFile;
    }

    public String getExportLog002(String request, String workspaceId, ComponentID devComp) throws CMSConnectorException, CMSPermissionDeniedException, CmsRequestNotFoundException, CMSOGetResultException, CMSOGetRequestCounterException, CMSClientVersionConflictException {
        log.entering("getExportLog002");
        try {
            this.versionCheck("getExportLog002", "0.00", "00", "00");
            this.connector.encodeObject(request, "request");
            this.connector.encodeObject(workspaceId, "workspaceId");
            this.connector.encodeObject(devComp, "devComp");
            this.connector.callMethod("getExportLog002");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSPermissionDeniedException e) {
            throw e;
        }
        catch (CMSClientVersionConflictException e) {
            throw e;
        }
        catch (CmsRequestNotFoundException e) {
            throw e;
        }
        catch (CMSOGetResultException e) {
            throw e;
        }
        catch (CMSOGetRequestCounterException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSUnexpectedException((Throwable)e);
        }
        String logFile = (String)this.connector.getObject("logFile");
        log.debug("export log file: " + logFile);
        log.exiting("getExportLog002");
        return logFile;
    }

    public String getConfiguration(String user, String configurationId) throws CMSConnectorException, CMSConfigurationException, CMSPermissionDeniedException, CMSClientVersionConflictException {
        log.entering("getConfiguration");
        try {
            this.versionCheck("getConfiguration", "0.00", "00", "00");
            this.connector.encodeObject(user, "user");
            this.connector.encodeObject(configurationId, "configurationId");
            this.connector.callMethod("getConfiguration");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (CMSClientVersionConflictException e) {
            throw e;
        }
        catch (CMSPermissionDeniedException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            log.error("Unexpected exception", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSUnexpectedException((Throwable)e);
        }
        String config = (String)this.connector.getObject("config");
        log.debug("configuration: " + config);
        log.exiting("getConfiguration");
        return config;
    }

    public String getActualDTCVersion(String configurationId) throws CMSClientDTCNotFoundException, CMSClientDTCDeletedException, CMSPermissionDeniedException, CMSClientVersionConflictException {
        log.entering("getActualDTCVersion(" + configurationId + ")");
        String version = null;
        try {
            try {
                this.versionCheck("getActualDTCVersion", "6.40", "08", "00");
                this.connector.encodeObject(configurationId, "configurationId");
                this.connector.callMethod("getActualDTCVersion");
                version = (String)this.connector.getObject("version");
            }
            catch (CMSParserException e) {
                log.error("Error during parse of answer", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSConnectorException e) {
                log.error("Error during XML communication", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSCDTCNotFoundException e) {
                log.error("DTC not found", (Throwable)e);
                throw new CMSClientDTCNotFoundException((Throwable)e, configurationId);
            }
            catch (CMSCDTCDeletedException e) {
                log.error("DTC deleted", (Throwable)e);
                throw new CMSClientDTCDeletedException((Throwable)e, configurationId);
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (RemoteException e) {
                log.error("Error during bean communication", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSPermissionDeniedException e) {
                log.error("Permission denied", (Throwable)e);
                throw e;
            }
            catch (CMSUnexpectedException e) {
                log.error("Unexpected exception", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Unexpected exception", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            Object var13_3 = null;
        }
        catch (Throwable throwable) {
            Object var13_4 = null;
            log.exiting("getActualDTCVersion: " + version);
            throw throwable;
        }
        log.exiting("getActualDTCVersion: " + version);
        return version;
    }

    public boolean isDTCVersionActual(String configurationId, String currentDTCVersion) throws CMSClientDTCNotFoundException, CMSClientDTCInvalidVersionException, CMSClientDTCDeletedException, CMSPermissionDeniedException, CMSClientVersionConflictException {
        log.entering("isDTCVersionActual(" + configurationId + ")");
        boolean isActual = false;
        try {
            try {
                this.versionCheck("isDTCVersionActual", "6.40", "08", "00");
                this.connector.encodeObject(configurationId, "configurationId");
                this.connector.encodeObject(currentDTCVersion, "currentDTCVersion");
                this.connector.callMethod("isDTCVersionActual");
                isActual = (Boolean)this.connector.getObject("isActual");
            }
            catch (CMSParserException e) {
                log.error("Error during parse of answer", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSConnectorException e) {
                log.error("Error during XML communication", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSCDTCNotFoundException e) {
                log.error("DTC not found", (Throwable)e);
                throw new CMSClientDTCNotFoundException((Throwable)e, configurationId);
            }
            catch (CMSCDTCDeletedException e) {
                log.error("DTC deleted", (Throwable)e);
                throw new CMSClientDTCDeletedException((Throwable)e, configurationId);
            }
            catch (CMSCDTCInvalidVersionException e) {
                log.error("DTC invalid version", (Throwable)e);
                throw new CMSClientDTCInvalidVersionException((Throwable)e, configurationId, currentDTCVersion);
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (RemoteException e) {
                log.error("Error during bean communication", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSPermissionDeniedException e) {
                log.error("Permission denied", (Throwable)e);
                throw e;
            }
            catch (CMSUnexpectedException e) {
                log.error("Unexpected exception", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Unexpected exception", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            Object var15_4 = null;
        }
        catch (Throwable throwable) {
            Object var15_5 = null;
            log.exiting("isDTCVersionActual: " + isActual);
            throw throwable;
        }
        log.exiting("isDTCVersionActual: " + isActual);
        return isActual;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getVersion() {
        log.entering("getVersion");
        String[] version = null;
        try {
            try {
                this.connector.callMethod("getVersion");
                Collection v = (Collection)this.connector.getObject("version");
                version = v.toArray(new String[v.size()]);
            }
            catch (CMSConnectorException e) {
                String message = e.getMessage();
                if (message != null && message.indexOf("invalid method") >= 0) {
                    log.debug("Server has no versioning, setting version to Release 0.00 SP00 Patch level 00");
                    version = new String[]{"0.00", "00", "00"};
                    Object var5_5 = null;
                    log.exiting("initServerVersion");
                    return version;
                }
                log.warning("Error during load of server version", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (Exception e) {
                log.warning("Error during load of server version", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            log.exiting("initServerVersion");
            throw throwable;
        }
        log.exiting("initServerVersion");
        return version;
    }

    private void initServerVersion() {
        log.entering("initServerVersion");
        try {
            String[] version = this.getVersion();
            if (version.length != 3) {
                log.error("Unknown version format length " + version.length);
            } else {
                this.versionRelease = version[0];
                this.versionSP = version[1];
                this.versionPatch = version[2];
                this.versionInitialized = true;
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            log.exiting("initServerVersion");
            throw throwable;
        }
        log.exiting("initServerVersion");
    }

    public RequestID getRequestMaskForWorkspace(String workspaceId) throws CMSPermissionDeniedException, CMSClientVersionConflictException {
        log.entering("getRequestMaskForWorkspace", new Object[]{workspaceId});
        RequestID requestID = null;
        try {
            try {
                this.versionCheck("getRequestMaskForWorkspace", "6.40", "10", "00");
                this.connector.encodeObject(workspaceId, "workspaceId");
                this.connector.callMethod("getRequestMaskForWorkspace");
                requestID = (RequestID)this.connector.getObject("requestID");
            }
            catch (CMSParserException e) {
                log.error("Error during parse of answer", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSConnectorException e) {
                log.error("Error during XML communication", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (RemoteException e) {
                log.error("Error during bean communication", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSPermissionDeniedException e) {
                log.error("Permission denied", (Throwable)e);
                throw e;
            }
            catch (CMSUnexpectedException e) {
                log.error("Unexpected exception", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Unexpected exception", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            Object var11_3 = null;
        }
        catch (Throwable throwable) {
            Object var11_4 = null;
            log.exiting("getRequestMaskForWorkspace", requestID);
            throw throwable;
        }
        log.exiting("getRequestMaskForWorkspace", (Object)requestID);
        return requestID;
    }

    public Collection getFinishedChangeRequests(RequestID reqId, String owner, long minimumCreation) throws CMSPermissionDeniedException, CMSClientVersionConflictException {
        log.entering("getFinishedChangeRequests", new Object[]{reqId, owner, new Long(minimumCreation)});
        Collection changeRequests = null;
        try {
            try {
                this.versionCheck("getFinishedChangeRequests", "6.40", "10", "00");
                this.connector.encodeObject(reqId, "requestID");
                this.connector.encodeObject(owner, "owner");
                this.connector.encodeObject(new Long(minimumCreation), "minimumCreation");
                this.connector.callMethod("getFinishedChangeRequests");
                changeRequests = (Collection)this.connector.getObject("changeRequests");
            }
            catch (CMSParserException e) {
                log.error("Error during parse of answer", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSConnectorException e) {
                log.error("Error during XML communication", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (RemoteException e) {
                log.error("Error during bean communication", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSPermissionDeniedException e) {
                log.error("Permission denied", (Throwable)e);
                throw e;
            }
            catch (CMSUnexpectedException e) {
                log.error("Unexpected exception", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Unexpected exception", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            Object var14_5 = null;
        }
        catch (Throwable throwable) {
            Object var14_6 = null;
            log.exiting("getFinishedChangeRequests", changeRequests);
            throw throwable;
        }
        log.exiting("getFinishedChangeRequests", (Object)changeRequests);
        return changeRequests;
    }

    public Collection getUnfinishedChangeRequests(RequestID reqId, String owner) throws CMSPermissionDeniedException, CMSClientVersionConflictException {
        log.entering("getUnfinishedChangeRequests", new Object[]{reqId, owner});
        Collection changeRequests = null;
        try {
            try {
                this.versionCheck("getUnfinishedChangeRequests", "6.40", "10", "00");
                this.connector.encodeObject(reqId, "requestID");
                this.connector.encodeObject(owner, "owner");
                this.connector.callMethod("getUnfinishedChangeRequests");
                changeRequests = (Collection)this.connector.getObject("changeRequests");
            }
            catch (CMSParserException e) {
                log.error("Error during parse of answer", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSConnectorException e) {
                log.error("Error during XML communication", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (RemoteException e) {
                log.error("Error during bean communication", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSPermissionDeniedException e) {
                log.error("Permission denied", (Throwable)e);
                throw e;
            }
            catch (CMSUnexpectedException e) {
                log.error("Unexpected exception", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Unexpected exception", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            Object var12_4 = null;
        }
        catch (Throwable throwable) {
            Object var12_5 = null;
            log.exiting("getUnfinishedChangeRequests", changeRequests);
            throw throwable;
        }
        log.exiting("getUnfinishedChangeRequests", (Object)changeRequests);
        return changeRequests;
    }

    public Collection getChangeListsOfChangeRequest(ComponentID comp, VersionID vers) throws CmsRequestNotFoundException, CMSPermissionDeniedException, CMSClientVersionConflictException {
        log.entering("getChangeListsOfChangeRequest", new Object[]{comp, vers});
        Collection changeLists = null;
        try {
            try {
                this.versionCheck("getChangeListsOfChangeRequest", "6.40", "10", "00");
                this.connector.encodeObject(comp, "componentID");
                this.connector.encodeObject(vers, "versionID");
                this.connector.callMethod("getChangeListsOfChangeRequest");
                changeLists = (Collection)this.connector.getObject("changeLists");
            }
            catch (CMSParserException e) {
                log.error("Error during parse of answer", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSConnectorException e) {
                log.error("Error during XML communication", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (CmsRequestNotFoundException e) {
                throw e;
            }
            catch (RemoteException e) {
                log.error("Error during bean communication", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSPermissionDeniedException e) {
                log.error("Permission denied", (Throwable)e);
                throw e;
            }
            catch (CMSUnexpectedException e) {
                log.error("Unexpected exception", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Unexpected exception", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            Object var13_4 = null;
        }
        catch (Throwable throwable) {
            Object var13_5 = null;
            log.exiting("getChangeListsOfChangeRequest", changeLists);
            throw throwable;
        }
        log.exiting("getChangeListsOfChangeRequest", (Object)changeLists);
        return changeLists;
    }

    public CMSChangeRequest getChangeRequest(ComponentID component, VersionID version) throws CmsRequestNotFoundException {
        log.entering("getChangeRequest", new Object[]{component, version});
        CMSChangeRequest changeRequest = null;
        try {
            try {
                this.versionCheck("getChangeRequest", "6.40", "11", "00");
                this.connector.encodeObject(component, "componentID");
                this.connector.encodeObject(version, "versionID");
                this.connector.callMethod("getChangeRequest");
                changeRequest = (CMSChangeRequest)this.connector.getObject("changeRequest");
            }
            catch (CMSParserException e) {
                log.error("Error during parse of answer", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSConnectorException e) {
                log.error("Error during XML communication", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (CmsRequestNotFoundException e) {
                throw e;
            }
            catch (CMSClientWrapperException e) {
                if ("com.sap.cms.util.exception.request.CmsRequestNotFoundException".equals(e.getNestedException())) {
                    log.error("Change request not found", (Throwable)e);
                    throw new CmsRequestNotFoundException(new Object[]{component + ", " + version});
                }
                log.error("Unexpected exception during read of change request (" + e.getNestedException() + ")", (Throwable)e);
                throw e;
            }
            catch (RemoteException e) {
                log.error("Error during bean communication", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSPermissionDeniedException e) {
                log.error("Permission denied", (Throwable)e);
                throw e;
            }
            catch (CMSUnexpectedException e) {
                log.error("Unexpected exception", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Unexpected exception", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            Object var14_4 = null;
        }
        catch (Throwable throwable) {
            Object var14_5 = null;
            log.exiting("getChangeRequest", changeRequest);
            throw throwable;
        }
        log.exiting("getChangeRequest", (Object)changeRequest);
        return changeRequest;
    }

    public Collection getFinishedChangeRequests(CMSSystemObject systemObject, ComponentID component, String owner, long minimumCreationDate) {
        log.entering("getFinishedChangeRequests", new Object[]{systemObject, component, owner, new Long(minimumCreationDate)});
        Collection changeRequests = null;
        try {
            try {
                this.versionCheck("getFinishedChangeRequestsFromSystemAndComponent", "6.40", "11", "00");
                this.connector.encodeObject(systemObject, "systemObject");
                this.connector.encodeObject(component, "component");
                this.connector.encodeObject(owner, "owner");
                this.connector.encodeObject(new Long(minimumCreationDate), "minimumCreation");
                this.connector.callMethod("getFinishedChangeRequestsFromSystemAndComponent");
                changeRequests = (Collection)this.connector.getObject("changeRequests");
            }
            catch (CMSParserException e) {
                log.error("Error during parse of answer", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSConnectorException e) {
                log.error("Error during XML communication", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (RemoteException e) {
                log.error("Error during bean communication", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSPermissionDeniedException e) {
                log.error("Permission denied", (Throwable)e);
                throw e;
            }
            catch (CMSUnexpectedException e) {
                log.error("Unexpected exception", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Unexpected exception", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            Object var15_6 = null;
        }
        catch (Throwable throwable) {
            Object var15_7 = null;
            log.exiting("getFinishedChangeRequests", changeRequests);
            throw throwable;
        }
        log.exiting("getFinishedChangeRequests", (Object)changeRequests);
        return changeRequests;
    }

    public Collection getFinishedChangeRequests(CMSSystemObject systemObject, String owner, long minimumCreationDate) {
        log.entering("getFinishedChangeRequests", new Object[]{systemObject, owner, new Long(minimumCreationDate)});
        Collection changeRequests = null;
        try {
            try {
                this.versionCheck("getFinishedChangeRequestsFromSystem", "6.40", "11", "00");
                this.connector.encodeObject(systemObject, "systemObject");
                this.connector.encodeObject(owner, "owner");
                this.connector.encodeObject(new Long(minimumCreationDate), "minimumCreation");
                this.connector.callMethod("getFinishedChangeRequestsFromSystem");
                changeRequests = (Collection)this.connector.getObject("changeRequests");
            }
            catch (CMSParserException e) {
                log.error("Error during parse of answer", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSConnectorException e) {
                log.error("Error during XML communication", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (RemoteException e) {
                log.error("Error during bean communication", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSPermissionDeniedException e) {
                log.error("Permission denied", (Throwable)e);
                throw e;
            }
            catch (CMSUnexpectedException e) {
                log.error("Unexpected exception", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Unexpected exception", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            Object var14_5 = null;
        }
        catch (Throwable throwable) {
            Object var14_6 = null;
            log.exiting("getFinishedChangeRequests", changeRequests);
            throw throwable;
        }
        log.exiting("getFinishedChangeRequests", (Object)changeRequests);
        return changeRequests;
    }

    public Collection getUnfinishedChangeRequests(CMSSystemObject systemObject, ComponentID component, String owner) {
        log.entering("getUnfinishedChangeRequests", new Object[]{systemObject, component, owner});
        Collection changeRequests = null;
        try {
            try {
                this.versionCheck("getUnfinishedChangeRequestsFromSystemAndComponent", "6.40", "11", "00");
                this.connector.encodeObject(systemObject, "systemObject");
                this.connector.encodeObject(component, "component");
                this.connector.encodeObject(owner, "owner");
                this.connector.callMethod("getUnfinishedChangeRequestsFromSystemAndComponent");
                changeRequests = (Collection)this.connector.getObject("changeRequests");
            }
            catch (CMSParserException e) {
                log.error("Error during parse of answer", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSConnectorException e) {
                log.error("Error during XML communication", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (RemoteException e) {
                log.error("Error during bean communication", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSPermissionDeniedException e) {
                log.error("Permission denied", (Throwable)e);
                throw e;
            }
            catch (CMSUnexpectedException e) {
                log.error("Unexpected exception", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Unexpected exception", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            Object var13_5 = null;
        }
        catch (Throwable throwable) {
            Object var13_6 = null;
            log.exiting("getUnfinishedChangeRequests", changeRequests);
            throw throwable;
        }
        log.exiting("getUnfinishedChangeRequests", (Object)changeRequests);
        return changeRequests;
    }

    public Collection getUnfinishedChangeRequests(CMSSystemObject systemObject, String owner) {
        log.entering("getUnfinishedChangeRequests", new Object[]{systemObject, owner});
        Collection changeRequests = null;
        try {
            try {
                this.versionCheck("getUnfinishedChangeRequestsFromSystem", "6.40", "11", "00");
                this.connector.encodeObject(systemObject, "systemObject");
                this.connector.encodeObject(owner, "owner");
                this.connector.callMethod("getUnfinishedChangeRequestsFromSystem");
                changeRequests = (Collection)this.connector.getObject("changeRequests");
            }
            catch (CMSParserException e) {
                log.error("Error during parse of answer", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSConnectorException e) {
                log.error("Error during XML communication", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (RemoteException e) {
                log.error("Error during bean communication", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSPermissionDeniedException e) {
                log.error("Permission denied", (Throwable)e);
                throw e;
            }
            catch (CMSUnexpectedException e) {
                log.error("Unexpected exception", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Unexpected exception", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            Object var12_4 = null;
        }
        catch (Throwable throwable) {
            Object var12_5 = null;
            log.exiting("getUnfinishedChangeRequests", changeRequests);
            throw throwable;
        }
        log.exiting("getUnfinishedChangeRequests", (Object)changeRequests);
        return changeRequests;
    }

    public CMSComponentLocation getComponentLocation(String workspaceID) throws CMSCNoConfigurationException, CMSCFinderException {
        log.entering("getComponentLocation", new Object[]{workspaceID});
        CMSComponentLocation componentLocation = null;
        try {
            try {
                this.versionCheck("getComponentLocation", "6.40", "11", "00");
                this.connector.encodeObject(workspaceID, "workspaceID");
                this.connector.callMethod("getComponentLocation");
                componentLocation = (CMSComponentLocation)this.connector.getObject("componentLocation");
            }
            catch (CMSParserException e) {
                log.error("Error during parse of answer", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSConnectorException e) {
                log.error("Error during XML communication", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (CMSCFinderException e) {
                throw e;
            }
            catch (CMSClientWrapperException e) {
                if ("com.sap.cms.util.exception.conf.CMSCNoConfigurationException".equals(e.getNestedException())) {
                    log.error("CMS not configured", (Throwable)e);
                    throw new CMSCNoConfigurationException();
                }
                log.error("Unexpected exception during translation of workspace (" + e.getNestedException() + ")", (Throwable)e);
                throw e;
            }
            catch (RemoteException e) {
                log.error("Error during bean communication", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSPermissionDeniedException e) {
                log.error("Permission denied", (Throwable)e);
                throw e;
            }
            catch (CMSUnexpectedException e) {
                log.error("Unexpected exception", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Unexpected exception", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            Object var13_3 = null;
        }
        catch (Throwable throwable) {
            Object var13_4 = null;
            log.exiting("getComponentLocation", componentLocation);
            throw throwable;
        }
        log.exiting("getComponentLocation", (Object)componentLocation);
        return componentLocation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void versionCheck(String method, String minRelease, String minSP, String minPatch) throws CMSClientVersionConflictException {
        log.entering("versionCheck(" + method + ", " + minRelease + ", " + minSP + ", " + minPatch + ")");
        try {
            try {
                if (!this.versionInitialized) {
                    this.initServerVersion();
                }
                if (minRelease.compareTo(this.versionRelease) > 0 || minRelease.equals(this.versionRelease) && minSP.compareTo(this.versionSP) > 0 || minRelease.equals(this.versionRelease) && minSP.equals(this.versionSP) && minPatch.compareTo(this.versionPatch) > 0) {
                    if (this.versionRelease.equals("0.00") && this.versionPatch.equals("00") && this.versionSP.equals("00")) {
                        log.warning("Release 6.30 SP07 Patch level 00 or less", "Release " + minRelease + " SP" + minSP + " Patch level " + minPatch);
                        throw new CMSClientVersionConflictException(method, "Release 6.30 SP07 Patch level 00 or less", "Release " + minRelease + " SP" + minSP + " Patch level " + minPatch);
                    }
                    log.warning("Release " + this.versionRelease + " SP" + this.versionSP + " Patch level " + this.versionPatch, "Release" + minRelease + " SP" + minSP + " Patch level " + minPatch);
                    throw new CMSClientVersionConflictException(method, "Release " + this.versionRelease + " SP" + this.versionSP + " Patch level " + this.versionPatch, "Release" + minRelease + " SP" + minSP + " Patch level " + minPatch);
                }
                Object var7_5 = null;
            }
            catch (CMSUnexpectedException ex) {
                log.error("Unexpected error during initialization of server version", (Throwable)ex);
                Object var7_6 = null;
                log.exiting("versionCheck");
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            log.exiting("versionCheck");
            throw throwable;
        }
        log.exiting("versionCheck");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

