/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.managerAPI;

import com.sap.cms.client.connector.CMSConnector;
import com.sap.cms.client.connector.CMSConnectorException;
import com.sap.cms.client.managerAPI.CMSTransportManagerIF;
import com.sap.cms.client.types.AssemblyOptions;
import com.sap.cms.client.types.QueueItem;
import com.sap.cms.client.types.QueueType;
import com.sap.cms.client.types.RequestID;
import com.sap.cms.client.types.SystemId;
import com.sap.cms.client.types.TrackId;
import com.sap.cms.util.PCSTime;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.exception.assembly.CMSAssemblyException;
import com.sap.cms.util.exception.checkin.CMSKInvalidComponentException;
import com.sap.cms.util.exception.checkin.CMSKPropArchiveHandlingException;
import com.sap.cms.util.exception.checkin.CheckInException;
import com.sap.cms.util.exception.conf.CMSCInvalidInputParameter;
import com.sap.cms.util.exception.conf.CMSCNoConfigurationException;
import com.sap.cms.util.exception.transport.CMSForwardRefusedException;
import com.sap.cms.util.exception.transport.CMSTImportFailedException;
import com.sap.cms.util.exception.transport.CMSTImportRefusedException;
import com.sap.cms.util.exception.transport.CMSTInvalidComponentException;
import com.sap.cms.util.exception.transport.CMSTMissingDevSystemException;
import com.sap.cms.util.exception.transport.CMSTQueueDuplicateKeyException;
import com.sap.cms.util.exception.transport.CMSTQueueGetHandlerException;
import com.sap.cms.util.exception.transport.CMSTransportException;
import com.sap.cms.util.logging.CmsLogger;
import java.net.URL;
import java.util.Collection;
import java.util.Vector;

public class CMSTransportManagerAPI
implements CMSTransportManagerIF {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$client$managerAPI$CMSTransportManagerAPI == null ? (class$com$sap$cms$client$managerAPI$CMSTransportManagerAPI = CMSTransportManagerAPI.class$("com.sap.cms.client.managerAPI.CMSTransportManagerAPI")) : class$com$sap$cms$client$managerAPI$CMSTransportManagerAPI).getName());
    private static String service = "transport";
    private CMSConnector connector;
    private long startTime;
    static /* synthetic */ Class class$com$sap$cms$client$managerAPI$CMSTransportManagerAPI;

    public CMSTransportManagerAPI(URL cmsServer) throws CMSConnectorException {
        this.connector = new CMSConnector(cmsServer.toString(), service);
    }

    public CMSTransportManagerAPI(String cmsServer) throws CMSConnectorException {
        this.connector = new CMSConnector(cmsServer, service);
    }

    public void startRecording(String logFile) throws CMSConnectorException {
        this.connector.startLogToFile(logFile);
    }

    public int stopRecording() {
        return this.connector.endLogToFile();
    }

    public void replay(String logFile, int lastNo) throws CMSConnectorException {
        this.connector.replayFromFile(logFile, 0, lastNo);
    }

    public void createQueueHandler(SystemId system, QueueType type) throws CMSConnectorException, CMSTransportException, CMSTQueueGetHandlerException {
        log.entering("createQueueHandler");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(type, "type");
        try {
            this.connector.callMethod("createQueueHandler");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTQueueGetHandlerException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        log.exiting("createQueueHandler", this.getRuntime());
    }

    public Vector getQueue(SystemId system, QueueType type) throws CMSConnectorException, CMSTransportException {
        log.entering("getQueue");
        this.startTime = System.currentTimeMillis();
        log.debug("get queue from " + type.getName() + "QueueHandler " + system.toString());
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(type, "type");
        try {
            this.connector.callMethod("getQueue");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        Vector queue = (Vector)this.connector.getObject("queue");
        log.exiting("getQueue", this.getRuntime());
        return queue;
    }

    public Vector getHistory(SystemId system, QueueType type) throws CMSConnectorException, CMSTransportException {
        log.entering("getHistory");
        this.startTime = System.currentTimeMillis();
        log.debug("get history from " + type.getName() + "QueueHandler " + system.toString());
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(type, "type");
        try {
            this.connector.callMethod("getHistory1");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        Vector history = (Vector)this.connector.getObject("history");
        log.exiting("getHistory", this.getRuntime());
        return history;
    }

    public Vector getHistory(SystemId system, QueueType type, String fromTime, String toTime) throws CMSConnectorException, CMSTransportException {
        log.entering("getHistory");
        this.startTime = System.currentTimeMillis();
        PCSTime timeStamp = new PCSTime();
        log.debug("get history from " + type.getName() + "QueueHandler " + system.toString() + " between " + PCSTime.getFormattedTimeStamp((String)fromTime) + " and " + PCSTime.getFormattedTimeStamp((String)toTime));
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(type, "type");
        this.connector.encodeObject(fromTime, "fromTime");
        this.connector.encodeObject(toTime, "toTime");
        try {
            this.connector.callMethod("getHistory2");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        Vector history = (Vector)this.connector.getObject("history");
        log.exiting("getHistory", this.getRuntime());
        return history;
    }

    public Vector getRefusedItems(SystemId system, QueueType type) throws CMSConnectorException, CMSTransportException {
        log.entering("getRefusedItems");
        this.startTime = System.currentTimeMillis();
        log.debug("get refused items of " + type.getName() + "queue of system " + system.toString());
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(type, "type");
        try {
            this.connector.callMethod("getRefusedItems");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        Vector refItems = (Vector)this.connector.getObject("refItems");
        log.exiting("getRefusedItems", this.getRuntime());
        return refItems;
    }

    public Collection startImport(SystemId system, boolean force) throws CMSConnectorException, CMSTransportException, CMSTImportFailedException, CMSTImportRefusedException {
        log.entering("startImport");
        this.startTime = System.currentTimeMillis();
        if (force) {
            log.debug("start import of all requests for system " + system.toString() + " in force mode");
        } else {
            log.debug("start import of all requests for system " + system.toString());
        }
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(force, "force");
        try {
            this.connector.callMethod("startImport1");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTImportFailedException e) {
            throw e;
        }
        catch (CMSTImportRefusedException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        Collection impItems = (Collection)this.connector.getObject("impItems");
        log.exiting("startImport", this.getRuntime());
        return impItems;
    }

    public Collection startImport(SystemId system, Vector items, boolean force) throws CMSConnectorException, CMSTransportException, CMSTImportFailedException, CMSTImportRefusedException {
        log.entering("startImport");
        this.startTime = System.currentTimeMillis();
        if (force) {
            log.debug("start import of " + items.size() + " requests for system " + system.toString() + " in force mode");
        } else {
            log.debug("start import of " + items.size() + " requests for system " + system.toString());
        }
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(items, "items");
        this.connector.encodeObject(force, "force");
        try {
            this.connector.callMethod("startImport2");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTImportFailedException e) {
            throw e;
        }
        catch (CMSTImportRefusedException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        Collection impItems = (Collection)this.connector.getObject("impItems");
        log.exiting("startImport", this.getRuntime());
        return impItems;
    }

    public Collection startAssembly(SystemId system, AssemblyOptions options) throws CMSConnectorException, CMSAssemblyException {
        log.entering("startAssembly");
        this.startTime = System.currentTimeMillis();
        log.debug("start assembly for system " + system.toString());
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(options, "options");
        try {
            this.connector.callMethod("startAssembly1");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSAssemblyException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        Collection assItems = (Collection)this.connector.getObject("assItems");
        log.exiting("startAssembly", this.getRuntime());
        return assItems;
    }

    public Collection startAssembly(SystemId system, Vector components, AssemblyOptions options) throws CMSConnectorException, CMSAssemblyException {
        log.entering("startAssembly");
        this.startTime = System.currentTimeMillis();
        log.debug("start assembly of selected components for system " + system.toString());
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(components, "components");
        this.connector.encodeObject(options, "options");
        try {
            this.connector.callMethod("startAssembly2");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSAssemblyException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        Collection assItems = (Collection)this.connector.getObject("assItems");
        log.exiting("startAssembly", this.getRuntime());
        return assItems;
    }

    public void startAssembly(SystemId system, String scaName) throws CMSConnectorException, CMSAssemblyException {
        log.entering("startSCAAssembly");
        this.startTime = System.currentTimeMillis();
        log.debug("start SCA assembly for system " + system.toString());
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(scaName, "scaName");
        try {
            this.connector.callMethod("startAssembly3");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSAssemblyException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        log.exiting("startSCAAssembly", this.getRuntime());
    }

    public void approveItems(SystemId system, QueueType type) throws CMSConnectorException, CMSTransportException {
        log.entering("approveItems");
        this.startTime = System.currentTimeMillis();
        log.debug("approve all requests of queue " + type.getName() + " system " + system.toString());
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(type, "type");
        try {
            this.connector.callMethod("approveItems1");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        log.exiting("approveItems", this.getRuntime());
    }

    public void approveItems(SystemId system, QueueType type, Vector items) throws CMSConnectorException, CMSTransportException {
        log.entering("approveItems");
        this.startTime = System.currentTimeMillis();
        log.debug("approve " + items.size() + " requests of queue " + type.getName() + " system " + system.toString());
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(type, "type");
        this.connector.encodeObject(items, "items");
        try {
            this.connector.callMethod("approveItems2");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        log.exiting("approveItems", this.getRuntime());
    }

    public void rejectItems(SystemId system, QueueType type) throws CMSConnectorException, CMSTransportException {
        log.entering("rejectItems");
        this.startTime = System.currentTimeMillis();
        log.debug("reject all requests of queue " + type.getName() + " system " + system.toString());
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(type, "type");
        try {
            this.connector.callMethod("rejectItems1");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        log.exiting("rejectItems", this.getRuntime());
    }

    public void rejectItems(SystemId system, QueueType type, Vector items) throws CMSConnectorException, CMSTransportException {
        log.entering("rejectItems");
        this.startTime = System.currentTimeMillis();
        log.debug("reject " + items.size() + " requests of queue " + type.getName() + " system " + system.toString());
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(type, "type");
        this.connector.encodeObject(items, "items");
        try {
            this.connector.callMethod("rejectItems2");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        log.exiting("rejectItems", this.getRuntime());
    }

    public void removeObsoleteItems(SystemId system, QueueType type) throws CMSConnectorException, CMSTransportException {
        log.entering("removeObsoleteItems");
        this.startTime = System.currentTimeMillis();
        log.debug("remove obsolete requests of queue " + type.getName() + " system " + system.toString());
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(type, "type");
        try {
            this.connector.callMethod("removeObsoleteItems");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        log.exiting("removeObsoleteItems", this.getRuntime());
    }

    public void deleteItems(SystemId system, QueueType type, Vector items) throws CMSConnectorException, CMSTransportException {
        log.entering("deleteItems");
        this.startTime = System.currentTimeMillis();
        log.debug("delete " + items.size() + " requests of queue " + type.getName() + " system " + system.toString());
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(type, "type");
        this.connector.encodeObject(items, "items");
        try {
            this.connector.callMethod("deleteItems");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        log.exiting("deleteItems", this.getRuntime());
    }

    public void unlockItems(SystemId system, QueueType type, Vector items) throws CMSConnectorException, CMSTransportException {
        log.entering("unlockItems");
        this.startTime = System.currentTimeMillis();
        log.debug("unlock " + items.size() + " requests of queue " + type.getName() + " system " + system.toString());
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(type, "type");
        this.connector.encodeObject(items, "items");
        try {
            this.connector.callMethod("unlockItems");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        log.exiting("unlockItems", this.getRuntime());
    }

    public void addQueueItems(SystemId system, QueueType type, Vector items) throws CMSConnectorException, CMSTransportException {
        log.entering("addQueueItems");
        this.startTime = System.currentTimeMillis();
        log.debug("add " + items.size() + " requests to queue " + type.getName() + " system " + system.toString());
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(type, "type");
        this.connector.encodeObject(items, "items");
        try {
            this.connector.callMethod("addQueueItems");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        log.exiting("addQueueItems", this.getRuntime());
    }

    public Collection getProcessResult(SystemId system, String procResultId, RequestID request) throws CMSConnectorException, CMSTransportException {
        log.entering("getProcessResult");
        this.startTime = System.currentTimeMillis();
        if (request == null) {
            log.debug("get process result for ALL requests of system " + system.toString() + " with resultId " + procResultId);
        } else {
            log.debug("get process result for request " + request.toString() + " of system " + system.toString() + " with resultId " + procResultId);
        }
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(procResultId, "procResultId");
        this.connector.encodeObject(request, "request");
        try {
            this.connector.callMethod("getProcessResult");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        Collection processResult = (Collection)this.connector.getObject("processResult");
        log.exiting("getProcessResult", this.getRuntime());
        return processResult;
    }

    public void forwardItems(SystemId system, QueueType type, Vector items, boolean force) throws CMSConnectorException, CMSTransportException, CMSForwardRefusedException, CMSTInvalidComponentException, CMSTQueueDuplicateKeyException {
        log.entering("forwardItems to system");
        this.startTime = System.currentTimeMillis();
        log.debug("forward " + items.size() + " requests to queue " + type.getName() + " system " + system.toString() + "(forceMode: " + force + ")");
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(type, "type");
        this.connector.encodeObject(items, "items");
        this.connector.encodeObject(force, "force");
        try {
            this.connector.callMethod("forwardItems1");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSForwardRefusedException e) {
            throw e;
        }
        catch (CMSTQueueDuplicateKeyException e) {
            throw e;
        }
        catch (CMSTInvalidComponentException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        log.exiting("forwardItems to system", this.getRuntime());
    }

    public void forwardItems(TrackId track, Vector items, boolean force) throws CMSConnectorException, CMSTransportException, CMSForwardRefusedException, CMSTInvalidComponentException, CMSTMissingDevSystemException, CMSTQueueDuplicateKeyException {
        log.entering("forwardItems to track");
        this.startTime = System.currentTimeMillis();
        log.debug("forward " + items.size() + " requests to track " + track.toString() + "(forceMode: " + force + ")");
        this.connector.encodeObject(track, "track");
        this.connector.encodeObject(items, "items");
        this.connector.encodeObject(force, "force");
        try {
            this.connector.callMethod("forwardItems2");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSForwardRefusedException e) {
            throw e;
        }
        catch (CMSTQueueDuplicateKeyException e) {
            throw e;
        }
        catch (CMSTMissingDevSystemException e) {
            throw e;
        }
        catch (CMSTInvalidComponentException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        log.exiting("forwardItems to track", this.getRuntime());
    }

    public Vector getImportedItems(SystemId system, Vector items) throws CMSConnectorException, CMSTransportException {
        log.entering("getImportedItems (system)");
        this.startTime = System.currentTimeMillis();
        log.debug("get imported items of system " + system.toString());
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(items, "items");
        try {
            this.connector.callMethod("getImportedItems1");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        Vector importedItems = (Vector)this.connector.getObject("importedItems");
        log.exiting("getImportedItems (system)", this.getRuntime());
        return importedItems;
    }

    public Vector getImportedItems(TrackId track, Vector items) throws CMSConnectorException, CMSTransportException {
        log.entering("getImportedItems (track)");
        this.startTime = System.currentTimeMillis();
        log.debug("get imported items of development system of track" + track.toString());
        this.connector.encodeObject(track, "track");
        this.connector.encodeObject(items, "items");
        try {
            this.connector.callMethod("getImportedItems2");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        Vector importedItems = (Vector)this.connector.getObject("importedItems");
        log.exiting("getImportedItems (track)", this.getRuntime());
        return importedItems;
    }

    public void restoreSystemState(SystemId system, Collection sysState) throws CMSConnectorException, CMSTransportException {
        log.entering("restoreSystemState");
        this.startTime = System.currentTimeMillis();
        log.debug("restore state of system " + system.toString());
        this.connector.encodeObject(system, "system");
        this.connector.encodeObject(sysState, "sysState");
        try {
            this.connector.callMethod("restoreSystemState");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        log.exiting("restoreSystemState", this.getRuntime());
    }

    public void checkIn(String domName, String trackName, String fileName) throws CMSConnectorException, CMSTransportException {
        log.entering("check-In");
        this.startTime = System.currentTimeMillis();
        log.debug("checkIn of file " + fileName + " into track " + trackName + " of domain " + domName);
        this.connector.encodeObject(domName, "domName");
        this.connector.encodeObject(trackName, "trackName");
        this.connector.encodeObject(fileName, "fileName");
        try {
            this.connector.callMethod("checkIn");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSCInvalidInputParameter e) {
            throw e;
        }
        catch (CMSCNoConfigurationException e) {
            throw e;
        }
        catch (CMSKInvalidComponentException e) {
            throw e;
        }
        catch (CMSKPropArchiveHandlingException e) {
            throw e;
        }
        catch (CheckInException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        log.exiting("check-In", this.getRuntime());
    }

    public void checkIn(String domName, String trackName, String fileName, boolean fromInbox) throws CMSConnectorException, CMSTransportException {
        log.entering("checkIn");
        this.startTime = System.currentTimeMillis();
        log.debug("checkIn of file " + fileName + " into track " + trackName + " of domain " + domName + " (fromInbox=" + fromInbox + ")");
        this.connector.encodeObject(domName, "domName");
        this.connector.encodeObject(trackName, "trackName");
        this.connector.encodeObject(fileName, "fileName");
        this.connector.encodeObject(fromInbox, "fromInbox");
        try {
            this.connector.callMethod("checkIn2");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSCInvalidInputParameter e) {
            throw e;
        }
        catch (CMSCNoConfigurationException e) {
            throw e;
        }
        catch (CMSKInvalidComponentException e) {
            throw e;
        }
        catch (CMSKPropArchiveHandlingException e) {
            throw e;
        }
        catch (CheckInException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        log.exiting("check-In", this.getRuntime());
    }

    public QueueItem getPropagationRequest(String domName, String trackName, String fileName) throws CMSConnectorException, CMSTransportException {
        log.entering("getPropagationRequest");
        this.startTime = System.currentTimeMillis();
        log.debug("get propagation request header of file " + fileName + " (track = " + trackName + ", domain = " + domName + ")");
        this.connector.encodeObject(domName, "domName");
        this.connector.encodeObject(trackName, "trackName");
        this.connector.encodeObject(fileName, "fileName");
        try {
            this.connector.callMethod("getPropagationRequest");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSCInvalidInputParameter e) {
            throw e;
        }
        catch (CMSKInvalidComponentException e) {
            throw e;
        }
        catch (CMSKPropArchiveHandlingException e) {
            throw e;
        }
        catch (CheckInException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        QueueItem item = (QueueItem)this.connector.getObject("item");
        log.exiting("getPropagationRequest", this.getRuntime());
        return item;
    }

    public QueueItem getPropagationRequest(String domName, String trackName, String fileName, boolean fromInbox) throws CMSConnectorException, CMSTransportException {
        log.entering("getPropagationRequest");
        this.startTime = System.currentTimeMillis();
        log.debug("get propagation request header of file " + fileName + " (track = " + trackName + ", domain = " + domName + ", fromInbox = " + fromInbox + ")");
        this.connector.encodeObject(domName, "domName");
        this.connector.encodeObject(trackName, "trackName");
        this.connector.encodeObject(fileName, "fileName");
        this.connector.encodeObject(fromInbox, "fromInbox");
        try {
            this.connector.callMethod("getPropagationRequest2");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSCInvalidInputParameter e) {
            throw e;
        }
        catch (CMSKInvalidComponentException e) {
            throw e;
        }
        catch (CMSKPropArchiveHandlingException e) {
            throw e;
        }
        catch (CheckInException e) {
            throw e;
        }
        catch (CMSTransportException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        QueueItem item = (QueueItem)this.connector.getObject("item");
        log.exiting("getPropagationRequest", this.getRuntime());
        return item;
    }

    public Collection getSystemStatus(SystemId _system) throws CMSConnectorException {
        log.entering("getSystemStatus");
        this.startTime = System.currentTimeMillis();
        log.debug("get system state of system " + _system.toString());
        this.connector.encodeObject(_system, "_system");
        try {
            this.connector.callMethod("getSystemStatus");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        Collection sysStat = (Collection)this.connector.getObject("sysStat");
        log.exiting("getSystemStatus");
        return sysStat;
    }

    public Collection getSystemStatusWithCaption(SystemId _system, String _reqType) throws CMSConnectorException {
        log.entering("getSystemStatus");
        this.startTime = System.currentTimeMillis();
        log.debug("get system state of system " + _system.toString() + " for request type " + _reqType.toString());
        this.connector.encodeObject(_system, "_system");
        this.connector.encodeObject(_reqType, "_reqType");
        try {
            this.connector.callMethod("getSystemStatusWithCaption");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSUnexpectedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        catch (Throwable e) {
            log.error("unknown throwable", e);
            throw new CMSConnectorException("unknown throwable: " + e.getMessage());
        }
        Collection sysStat = (Collection)this.connector.getObject("sysStat");
        log.exiting("getSystemStatus");
        return sysStat;
    }

    private String getRuntime() {
        return "runtime = " + (System.currentTimeMillis() - this.startTime) + " ms";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

